/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.sharedobject;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.AbstractContainerAdapterFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.core.sharedobject.ISharedObjectManager;
import org.eclipse.ecf.core.sharedobject.SharedObjectAddException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.core.sharedobject.Activator;
import org.eclipse.ecf.internal.core.sharedobject.Messages;

public abstract class AbstractSharedObjectContainerAdapterFactory
extends AbstractContainerAdapterFactory {
    protected static final int ADD_ADAPTER_ERROR_CODE = 300001;
    protected static final String ADD_ADAPTER_ERROR_MESSAGE = Messages.AbstractSharedObjectContainerAdapterFactory_Exception_Adding_Adapter;
    private static final int CREATE_ADAPTER_ID_ERROR_CODE = 300002;
    private static final String CREATE_ADAPTER_ID_ERROR_MESSAGE = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Object getContainerAdapter(IContainer container, Class adapterType) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.sharedobject.ISharedObjectContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isInstance(container)) {
            return this.getSharedObjectAdapter((ISharedObjectContainer)container, adapterType);
        }
        return null;
    }

    protected synchronized ISharedObject getSharedObjectAdapter(ISharedObjectContainer container, Class adapterType) {
        ID adapterID = this.createAdapterID(container, adapterType);
        if (adapterID == null) {
            return null;
        }
        ISharedObjectManager manager = container.getSharedObjectManager();
        ISharedObject so = manager.getSharedObject(adapterID);
        if (so != null) {
            return so;
        }
        ISharedObject adapter = this.createAdapter(container, adapterType, adapterID);
        if (adapter == null) {
            return null;
        }
        Map adapterProperties = this.createAdapterProperties(container, adapterType, adapterID, adapter);
        try {
            manager.addSharedObject(adapterID, adapter, adapterProperties);
        }
        catch (SharedObjectAddException e) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ecf.core.sharedobject.AbstractSharedObjectContainerAdapterFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((String)"org.eclipse.ecf.sharedobject", (String)"org.eclipse.ecf.sharedobject/debug/exceptions/catching", (Class)clazz, (String)"getSharedObjectAdapter", (Throwable)((Object)e));
            Activator.getDefault().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 300001, ADD_ADAPTER_ERROR_MESSAGE, (Throwable)((Object)e)));
            return null;
        }
        return adapter;
    }

    protected Map createAdapterProperties(ISharedObjectContainer container, Class adapterType, ID sharedObjectID, ISharedObject sharedObjectAdapter) {
        return null;
    }

    protected ID createAdapterID(ISharedObjectContainer container, Class adapterType) {
        String singletonName = adapterType.getName();
        try {
            return IDFactory.getDefault().createStringID(singletonName);
        }
        catch (IDCreateException e) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ecf.core.sharedobject.AbstractSharedObjectContainerAdapterFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.catching((String)"org.eclipse.ecf.sharedobject", (String)"org.eclipse.ecf.sharedobject/debug/exceptions/catching", (Class)clazz, (String)"getAdapterID", (Throwable)e);
            Activator.getDefault().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 300002, CREATE_ADAPTER_ID_ERROR_MESSAGE, (Throwable)e));
            return null;
        }
    }

    protected abstract ISharedObject createAdapter(ISharedObjectContainer var1, Class var2, ID var3);

    public abstract Class[] getAdapterList();
}

