/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.docshare.cola;

import org.eclipse.ecf.docshare.cola.ColaDeletion;
import org.eclipse.ecf.docshare.cola.ColaInsertion;
import org.eclipse.ecf.docshare.cola.ColaReplacement;
import org.eclipse.ecf.docshare.cola.TransformationStrategy;
import org.eclipse.ecf.docshare.messages.UpdateMessage;

public class ColaUpdateMessage
extends UpdateMessage {
    private static final long serialVersionUID = 2038025022180647210L;
    final double localOperationsCount;
    final double remoteOperationsCount;
    final TransformationStrategy trafoStrat;

    public ColaUpdateMessage(UpdateMessage msg, double localOperationsCount, double remoteOperationsCount) {
        super(msg.getOffset(), msg.getLength(), msg.getText());
        this.localOperationsCount = localOperationsCount;
        this.remoteOperationsCount = remoteOperationsCount;
        this.trafoStrat = super.getLength() == 0 ? new ColaInsertion() : (super.getText().length() == 0 ? new ColaDeletion() : new ColaReplacement());
    }

    public double getLocalOperationsCount() {
        return this.localOperationsCount;
    }

    public double getRemoteOperationsCount() {
        return this.remoteOperationsCount;
    }

    public ColaUpdateMessage transformForApplicationAtOwnerAgainst(ColaUpdateMessage msg) {
        ColaUpdateMessage transformedMsg = this.trafoStrat.getForOwner(this, msg);
        return transformedMsg;
    }

    public ColaUpdateMessage transformForApplicationAtParticipantAgainst(ColaUpdateMessage msg) {
        ColaUpdateMessage transformedMsg = this.trafoStrat.getForParticipant(this, msg);
        return transformedMsg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(";").append("originationCount.local=").append(this.localOperationsCount).append(";");
        sb.append("originationCount.remote=").append(this.remoteOperationsCount);
        return sb.toString();
    }
}

