/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.xmpp.identity;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.internal.provider.xmpp.Messages;
import org.eclipse.ecf.presence.im.IChatID;

public class XMPPID
extends BaseID
implements IChatID {
    private static final long serialVersionUID = 3257289140701049140L;
    public static final char USER_HOST_DELIMITER = '@';
    public static final char PORT_DELIMITER = ':';
    public static final char PATH_DELIMITER = '/';
    URI uri;
    String username;
    String hostname;
    String resourcename = "ECF_XMPP";
    int port = -1;

    protected static String fixEscape(String src) {
        if (src == null) {
            return null;
        }
        return src.replaceAll("%", "%25");
    }

    public XMPPID(Namespace namespace, String unamehost) throws URISyntaxException {
        super(namespace);
        unamehost = XMPPID.fixEscape(unamehost);
        if (unamehost == null) {
            throw new URISyntaxException(unamehost, Messages.XMPPID_EXCEPTION_XMPPID_USERNAME_NOT_NULL);
        }
        int atIndex = unamehost.lastIndexOf(64);
        if (atIndex == -1) {
            throw new URISyntaxException(unamehost, Messages.XMPPID_EXCEPTION_HOST_PORT_NOT_VALID);
        }
        this.username = unamehost.substring(0, atIndex);
        String remainder = unamehost.substring(atIndex + 1);
        if ((atIndex = remainder.lastIndexOf(58)) != -1) {
            try {
                int slashLoc = remainder.indexOf(47);
                this.port = slashLoc != -1 ? Integer.parseInt(remainder.substring(atIndex + 1, slashLoc)) : Integer.parseInt(remainder.substring(atIndex + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new URISyntaxException(unamehost, Messages.XMPPID_EXCEPTION_INVALID_PORT);
            }
            this.hostname = remainder.substring(0, atIndex);
        }
        if ((atIndex = remainder.indexOf(47)) != -1) {
            if (this.hostname == null) {
                this.hostname = remainder.substring(0, atIndex);
            }
            this.resourcename = String.valueOf('/') + remainder.substring(atIndex + 1);
        } else {
            this.resourcename = "/ECF_XMPP";
        }
        if (this.hostname == null) {
            this.hostname = remainder;
        }
        this.uri = new URI(namespace.getScheme(), this.username, this.hostname, this.port, this.resourcename, null, null);
    }

    protected int namespaceCompareTo(BaseID o) {
        return this.getName().compareTo(o.getName());
    }

    protected boolean namespaceEquals(BaseID o) {
        if (!(o instanceof XMPPID)) {
            return false;
        }
        XMPPID other = (XMPPID)o;
        return this.getUsernameAtHost().equals(other.getUsernameAtHost());
    }

    protected String namespaceGetName() {
        return this.getUsernameAtHost();
    }

    protected int namespaceHashCode() {
        return this.getUsernameAtHost().hashCode();
    }

    public String getUsername() {
        return this.username;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getResourceName() {
        return this.resourcename;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsernameAtHost() {
        return String.valueOf(this.getUsername()) + "@" + this.getHostname();
    }

    public String getFQName() {
        return String.valueOf(this.getUsernameAtHost()) + this.getResourceName();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("XMPPID[");
        sb.append(this.uri.toString()).append("]");
        return sb.toString();
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isInstance((Object)this)) {
            return this;
        }
        return super.getAdapter(clazz);
    }
}

