/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.xmpp.identity;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.BaseID;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.xmpp.Messages;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;

public class XMPPFileID
extends BaseID
implements IFileID {
    private static final long serialVersionUID = 9052434567658554404L;
    XMPPID xmppid;
    String filename;

    public XMPPFileID(XMPPID id, String fn) {
        Assert.isNotNull((Object)((Object)id));
        Assert.isNotNull((Object)fn);
        this.xmppid = id;
        this.filename = fn;
    }

    public XMPPID getXMPPID() {
        return this.xmppid;
    }

    protected String namespaceToExternalForm() {
        return String.valueOf(this.namespace.getScheme()) + ":" + this.xmppid.toExternalForm() + "*" + this.filename;
    }

    protected int namespaceCompareTo(BaseID o) {
        return this.getName().compareTo(o.getName());
    }

    protected boolean namespaceEquals(BaseID o) {
        if (!(o instanceof XMPPFileID)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        XMPPFileID other = (XMPPFileID)o;
        return this.xmppid.equals((Object)other.xmppid) && this.filename.equals(other.filename);
    }

    protected String namespaceGetName() {
        return String.valueOf(this.xmppid.getName()) + "/" + this.filename;
    }

    protected int namespaceHashCode() {
        return this.xmppid.hashCode() ^ this.filename.hashCode();
    }

    public String getFilename() {
        return this.filename;
    }

    public URL getURL() throws MalformedURLException {
        throw new MalformedURLException(Messages.XMPPFileID_EXCEPTION_FILE_IDS_NOT_URLS);
    }
}

