/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.ServiceLocationException;
import ch.ethz.iks.slp.impl.AuthenticationBlock;
import ch.ethz.iks.slp.impl.SLPUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public abstract class AuthenticatedURL {
    int lifetime;
    protected AuthenticationBlock[] authBlocks = new AuthenticationBlock[0];

    protected final void sign(List list) throws ServiceLocationException {
        this.authBlocks = new AuthenticationBlock[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            int n = SLPUtils.getTimestamp();
            String string = (String)list.get(i);
            byte[] byArray = this.getAuthData(string, n += this.lifetime);
            this.authBlocks[i] = new AuthenticationBlock(2, string, n, byArray, null);
        }
    }

    protected final boolean verify() throws ServiceLocationException {
        for (int i = 0; i < this.authBlocks.length; ++i) {
            byte[] byArray = this.getAuthData(this.authBlocks[i].getSPI(), this.authBlocks[i].getTimestamp());
            if (!this.authBlocks[i].verify(byArray)) continue;
            return true;
        }
        return false;
    }

    private byte[] getAuthData(String string, int n) throws ServiceLocationException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            byte[] byArray = string.getBytes();
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
            byArray = this.toString().getBytes();
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
            dataOutputStream.writeInt(n);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ServiceLocationException(20, iOException.getMessage());
        }
    }

    protected void writeAuthBlock(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.authBlocks.length);
        for (int i = 0; i < this.authBlocks.length; ++i) {
            this.authBlocks[i].write(dataOutputStream);
        }
    }

    protected final int getAuthBlockLength() {
        int n = 1;
        for (int i = 0; i < this.authBlocks.length; ++i) {
            n += this.authBlocks[i].getLength();
        }
        return n;
    }

    protected static final AuthenticationBlock[] parseAuthBlock(DataInputStream dataInputStream) throws ServiceLocationException, IOException {
        return AuthenticationBlock.parse(dataInputStream);
    }
}

