/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.docshare.cola;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.docshare.SynchronizationStrategy;
import org.eclipse.ecf.docshare.cola.ColaUpdateMessage;
import org.eclipse.ecf.docshare.messages.UpdateMessage;
import org.eclipse.ecf.internal.docshare.Activator;

public class ColaSynchronizer
implements SynchronizationStrategy {
    private List unacknowledgedLocalOperations;
    private final boolean isInitiator;
    private double localOperationsCount;
    private double remoteOperationsCount;
    private static Map sessionStrategies = new HashMap();

    private ColaSynchronizer(ID docshareID) {
        this.isInitiator = Activator.getDefault().getDocShare(docshareID).isInitiator();
        this.unacknowledgedLocalOperations = new LinkedList();
        this.localOperationsCount = 0.0;
        this.remoteOperationsCount = 0.0;
    }

    public static ColaSynchronizer getInstanceFor(ID docshareID) {
        if (sessionStrategies.get(docshareID) == null) {
            sessionStrategies.put(docshareID, new ColaSynchronizer(docshareID));
        }
        return (ColaSynchronizer)sessionStrategies.get(docshareID);
    }

    public static void cleanUpFor(ID docshareID) {
        sessionStrategies.remove(docshareID);
    }

    public UpdateMessage registerOutgoingMessage(UpdateMessage localMsg) {
        ColaUpdateMessage colaMsg = new ColaUpdateMessage(localMsg, this.localOperationsCount, this.remoteOperationsCount);
        this.unacknowledgedLocalOperations.add(colaMsg);
        this.localOperationsCount += 1.0;
        return colaMsg;
    }

    public UpdateMessage transformIncomingMessage(UpdateMessage remoteMsg) {
        if (!(remoteMsg instanceof ColaUpdateMessage)) {
            throw new IllegalArgumentException("UpdateMessage is incompatible with Cola SynchronizationStrategy");
        }
        ColaUpdateMessage transformedRemote = (ColaUpdateMessage)remoteMsg;
        if (!this.unacknowledgedLocalOperations.isEmpty()) {
            Iterator queueIterator = this.unacknowledgedLocalOperations.iterator();
            ColaUpdateMessage localOperation = (ColaUpdateMessage)queueIterator.next();
            while (!this.unacknowledgedLocalOperations.isEmpty() && transformedRemote.getRemoteOperationsCount() > localOperation.getLocalOperationsCount()) {
                queueIterator.remove();
                if (!queueIterator.hasNext()) continue;
                localOperation = (ColaUpdateMessage)queueIterator.next();
            }
            if (!this.unacknowledgedLocalOperations.isEmpty()) {
                Iterator queueModIterator = this.unacknowledgedLocalOperations.iterator();
                while (queueModIterator.hasNext()) {
                    transformedRemote = this.isInitiator ? transformedRemote.transformForApplicationAtOwnerAgainst(localOperation) : transformedRemote.transformForApplicationAtParticipantAgainst(localOperation);
                    localOperation = (ColaUpdateMessage)queueModIterator.next();
                }
                transformedRemote = this.isInitiator ? transformedRemote.transformForApplicationAtOwnerAgainst(localOperation) : transformedRemote.transformForApplicationAtParticipantAgainst(localOperation);
            }
        }
        return transformedRemote;
    }
}

