/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.docshare.menu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.docshare.DocShare;
import org.eclipse.ecf.docshare.menu.DocShareRosterMenuHandler;
import org.eclipse.ecf.internal.docshare.Activator;
import org.eclipse.ecf.internal.docshare.Messages;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.ui.menu.AbstractRosterMenuContributionItem;
import org.eclipse.ecf.presence.ui.menu.AbstractRosterMenuHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class DocShareRosterMenuContributionItem
extends AbstractRosterMenuContributionItem {
    static /* synthetic */ Class class$0;

    public DocShareRosterMenuContributionItem() {
        this.setTopMenuName(Messages.DocShareRosterMenuContributionItem_SHARE_EDITOR_MENU_TEXT);
    }

    public DocShareRosterMenuContributionItem(String id) {
        super(id);
        this.setTopMenuName(Messages.DocShareRosterMenuContributionItem_SHARE_EDITOR_MENU_TEXT);
    }

    protected IEditorPart getEditorPart() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
        if (ww == null) {
            return null;
        }
        IWorkbenchPage wp = ww.getActivePage();
        if (wp == null) {
            return null;
        }
        return wp.getActiveEditor();
    }

    protected DocShare getDocShareForPresenceContainerAdapter(IPresenceContainerAdapter presenceContainerAdapter) {
        IContainer container;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((container = (IContainer)presenceContainerAdapter.getAdapter((Class)clazz)) == null) {
            return null;
        }
        return Activator.getDefault().getDocShare(container.getID());
    }

    protected IContributionItem[] getContributionItems() {
        this.clearOldContributions();
        IEditorPart editorPart = this.getEditorPart();
        if (editorPart == null || !(editorPart instanceof ITextEditor)) {
            return NO_CONTRIBUTIONS;
        }
        List presenceContainerAdapters = this.getPresenceContainerAdapters();
        Iterator i = presenceContainerAdapters.iterator();
        while (i.hasNext()) {
            IPresenceContainerAdapter pca = (IPresenceContainerAdapter)i.next();
            DocShare docShare = this.getDocShareForPresenceContainerAdapter(pca);
            if (docShare == null || !docShare.isSharing() || !docShare.getTextEditor().equals(editorPart)) continue;
            return this.getMenuContributionsDuringShare(docShare);
        }
        return super.getContributionItems();
    }

    protected IContributionItem[] createContributionItemsForPresenceContainer(IPresenceContainerAdapter presenceContainerAdapter) {
        IContainer container;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((container = (IContainer)presenceContainerAdapter.getAdapter((Class)clazz)) == null) {
            return NO_CONTRIBUTIONS;
        }
        DocShare docShare = Activator.getDefault().getDocShare(container.getID());
        if (docShare == null) {
            return NO_CONTRIBUTIONS;
        }
        IRoster roster = presenceContainerAdapter.getRosterManager().getRoster();
        IContributionItem[] contributions = this.createContributionItemsForRoster(roster);
        if (contributions == null || contributions.length == 0) {
            return NO_CONTRIBUTIONS;
        }
        MenuManager menuManager = this.createMenuManagerForRoster(roster);
        int i = 0;
        while (i < contributions.length) {
            menuManager.add(contributions[i]);
            ++i;
        }
        return new IContributionItem[]{menuManager};
    }

    protected IContributionItem[] getMenuContributionsDuringShare(final DocShare docShare) {
        ArrayList<Object> items = new ArrayList<Object>();
        if (docShare.isInitiator()) {
            items.add(new Separator());
        }
        Action sendSelection = new Action(){

            public void run() {
                docShare.sendSelection();
            }
        };
        sendSelection.setText(NLS.bind((String)Messages.DocShareRosterMenuContributionItem_SELECTION_SEND_EDITOR_MENU_TEXT, (Object)this.trimIDNameForMenu(docShare.getOtherID())));
        items.add(new ActionContributionItem((IAction)sendSelection));
        Action stopEditorShare = new Action(){

            public void run() {
                docShare.stopShare();
            }
        };
        stopEditorShare.setText(NLS.bind((String)Messages.DocShareRosterMenuContributionItem_STOP_SHARE_EDITOR_MENU_TEXT, (Object)this.trimIDNameForMenu(docShare.getOtherID())));
        items.add(new ActionContributionItem((IAction)stopEditorShare));
        return items.toArray(new IContributionItem[0]);
    }

    protected AbstractRosterMenuHandler createRosterEntryHandler(IRosterEntry rosterEntry) {
        return new DocShareRosterMenuHandler(rosterEntry);
    }

    protected String trimIDNameForMenu(ID id) {
        String idName = id.getName();
        int indexAt = idName.indexOf("@");
        if (indexAt == -1) {
            return idName;
        }
        return idName.substring(0, indexAt);
    }
}

