/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.share.url;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConfig;
import org.eclipse.ecf.core.sharedobject.ReplicaSharedObjectDescription;
import org.eclipse.ecf.core.sharedobject.SharedObjectInitException;
import org.eclipse.ecf.example.collab.share.GenericSharedObject;
import org.eclipse.ecf.internal.example.collab.Trace;

public class StartProgramSharedObject
extends GenericSharedObject {
    public static Trace myDebug = Trace.create("progsharedobject");
    public static final Boolean DEFAULT_INCLUDE_SERVER = Boolean.FALSE;
    protected String[] cmds;
    protected String[] env;
    protected String[] replicaCmds;
    protected String[] replicaEnv;
    protected ID receiver;
    protected Process proc = null;
    public Boolean includeHost;
    protected Boolean includeServer;

    public StartProgramSharedObject() {
    }

    public StartProgramSharedObject(ID rcvr, String[] cmds, String[] env, Boolean includeHost, Boolean includeServer) throws Exception {
        this.receiver = rcvr;
        this.cmds = cmds;
        this.env = env == null ? new String[]{} : env;
        this.includeHost = includeHost;
        this.includeServer = includeServer == null ? DEFAULT_INCLUDE_SERVER : includeServer;
    }

    protected void debug(String msg) {
        if (Trace.ON && myDebug != null) {
            myDebug.msg(msg);
        }
    }

    protected void debug(Throwable t, String msg) {
        if (Trace.ON && myDebug != null) {
            myDebug.dumpStack(t, msg);
        }
    }

    public StartProgramSharedObject(ID rcvr, String[] hostCmds, String[] hostEnv, String[] replicaCmds, String[] replicaEnv, Boolean includeHost, Boolean includeServer) throws Exception {
        this(rcvr, hostCmds, hostEnv, includeHost, includeServer);
        this.replicaCmds = replicaCmds;
        this.replicaEnv = replicaEnv;
    }

    public StartProgramSharedObject(ID rcvr, String[] cmds, String[] env) throws Exception {
        this(rcvr, cmds, env, Boolean.FALSE, null);
    }

    protected void replicate(ID remoteMember) {
        this.debug("replicateSelf(" + remoteMember + ")");
        if (this.receiver == null) {
            super.replicate(remoteMember);
            return;
        }
        if (remoteMember == null) {
            try {
                ReplicaSharedObjectDescription createInfo = this.getReplicaDescription(this.receiver);
                if (createInfo != null) {
                    this.getContext().sendCreate(this.receiver, createInfo);
                }
            }
            catch (IOException e) {
                this.log("Exception in replicateSelf", e);
                return;
            }
        }
    }

    public void init(ISharedObjectConfig config) throws SharedObjectInitException {
        super.init(config);
        Map props = config.getProperties();
        this.debug("props is " + props);
        Object[] args = (Object[])props.get("args");
        this.debug("args is " + args);
        if (args != null && args.length > 4) {
            this.receiver = (ID)args[0];
            this.cmds = (String[])args[1];
            this.env = (String[])args[2];
            this.includeHost = (Boolean)args[3];
            this.includeServer = (Boolean)args[4];
        }
    }

    protected ReplicaSharedObjectDescription getReplicaDescription(ID remoteMember) {
        Object[] args = new Object[]{this.receiver, this.replicaCmds == null ? this.cmds : this.replicaCmds, this.replicaEnv == null ? this.env : this.replicaEnv, this.includeHost, this.includeServer};
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.put("args", args);
        return new ReplicaSharedObjectDescription(this.getClass(), this.getID(), this.getHomeContainerID(), map, StartProgramSharedObject.getNextReplicateID());
    }

    public void activated(ID[] others) {
        this.debug("activated()");
        try {
            if (!this.getContext().isGroupManager() || this.includeServer.equals(Boolean.TRUE)) {
                this.startup();
            } else {
                this.debug("Not executing commands because is server");
            }
        }
        catch (Exception e) {
            this.debug(e, "Exception on startup()");
        }
        super.activated(others);
        this.postActivated();
    }

    protected void postActivated() {
        this.debug("postActivated()");
    }

    protected void startup() throws Exception {
        this.debug("startup()");
        if (this.cmds != null) {
            if (Trace.ON && myDebug != null) {
                int i;
                myDebug.msg("Executing command line:");
                if (this.cmds != null) {
                    i = 0;
                    while (i < this.cmds.length) {
                        myDebug.msg("  " + this.cmds[i] + " ");
                        ++i;
                    }
                }
                myDebug.msg("With enviromnent:");
                if (this.env != null) {
                    i = 0;
                    while (i < this.env.length) {
                        myDebug.msg("  " + this.env[i] + " ");
                        ++i;
                    }
                }
            }
            this.proc = this.env == null || this.env.length == 0 ? (this.cmds.length == 1 ? Runtime.getRuntime().exec(this.cmds[0]) : Runtime.getRuntime().exec(this.cmds)) : Runtime.getRuntime().exec(this.cmds, this.env.length == 0 ? null : this.env);
        }
    }
}

