/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.examples.remoteservices.server;

import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.discovery.service.IDiscoveryService;
import org.eclipse.ecf.internal.examples.remoteservices.server.Activator;
import org.eclipse.ecf.internal.examples.remoteservices.server.RemoteEnvironmentInfoImpl;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.util.DiscoveryProperties;
import org.eclipse.ecf.remoteservice.util.RemoteServiceProperties;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class DiscoverableServer
implements IApplication {
    private static final String ECF_GENERIC_CLIENT = "ecf.generic.client";
    private static final String ECF_GENERIC_SERVER = "ecf.generic.server";
    private static final String ECF_GENERIC_SERVER_ID_NAMESPACE;
    private static final String ECF_GENERIC_SERVER_ID = "ecftcp://localhost:3285/server";
    private IContainer serviceHostContainer;
    private IServiceInfo serviceInfo;
    private IDiscoveryService discoveryService;
    private String serviceHostContainerType = "ecf.generic.server";
    private String serviceHostNamespace = ECF_GENERIC_SERVER_ID_NAMESPACE;
    private String serviceHostID = "ecftcp://localhost:3285/server";
    private String clientContainerType = "ecf.generic.client";
    private String clientConnectTarget = "ecftcp://localhost:3285/server";
    private String serviceType = "remotesvcs";
    private boolean done = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.identity.StringID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ECF_GENERIC_SERVER_ID_NAMESPACE = clazz.getName();
    }

    private String getCompleteServiceType() {
        return "_" + this.serviceType + "._tcp.local.";
    }

    protected IContainer createServiceHostContainer() throws IDCreateException, ContainerCreateException {
        return ContainerFactory.getDefault().createContainer(this.serviceHostContainerType, IDFactory.getDefault().createID(this.serviceHostNamespace, this.serviceHostID));
    }

    protected Properties createServiceDiscoveryProperties() {
        RemoteServiceProperties props = new RemoteServiceProperties(this.serviceHostContainerType, this.serviceHostContainer);
        props.put("org.eclipse.ecf.serviceRegistrationRemote", "true");
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start(IApplicationContext ctxt) throws Exception {
        this.initializeFromArguments((String[])ctxt.getArguments().get("application.args"));
        this.serviceHostContainer = this.createServiceHostContainer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IRemoteServiceContainerAdapter containerAdapter = (IRemoteServiceContainerAdapter)this.serviceHostContainer.getAdapter((Class)clazz);
        Assert.isNotNull((Object)containerAdapter);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ecf.examples.remoteservices.common.IRemoteEnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String serviceClassName = clazz2.getName();
        containerAdapter.registerRemoteService(new String[]{serviceClassName}, (Object)new RemoteEnvironmentInfoImpl(), (Dictionary)this.createServiceDiscoveryProperties());
        System.out.println("Registered remote service " + serviceClassName + " with " + this.serviceHostContainer + ",ID=" + this.serviceHostContainer.getID());
        this.discoveryService = Activator.getDefault().getDiscoveryService(5000);
        String serviceName = String.valueOf(System.getProperty("user.name")) + System.currentTimeMillis();
        IServiceID serviceID = ServiceIDFactory.getDefault().createServiceID(this.discoveryService.getServicesNamespace(), this.getCompleteServiceType(), serviceName);
        Properties serviceProperties = this.createServicePropertiesForDiscovery(serviceClassName);
        this.serviceInfo = new ServiceInfo(this.serviceType, null, 80, serviceID, (IServiceProperties)new ServiceProperties(serviceProperties));
        this.discoveryService.registerService(this.serviceInfo);
        System.out.println("service published for discovery\n\tserviceName=" + serviceID.getServiceName() + "\n\tserviceTypeID=" + serviceID.getServiceTypeID());
        System.out.println("\tserviceProperties=" + serviceProperties);
        DiscoverableServer discoverableServer = this;
        synchronized (discoverableServer) {
            while (!this.done) {
                this.wait();
            }
        }
        return new Integer(0);
    }

    protected Properties createServicePropertiesForDiscovery(String className) {
        return new DiscoveryProperties(className, this.clientContainerType, this.serviceHostNamespace, this.clientConnectTarget, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.serviceInfo != null && this.discoveryService != null) {
            IContainer container;
            try {
                this.discoveryService.unregisterService(this.serviceInfo);
            }
            catch (ECFException e) {
                e.printStackTrace();
            }
            this.serviceInfo = null;
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.ecf.core.IContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((container = (IContainer)this.discoveryService.getAdapter((Class)clazz)) != null) {
                container.disconnect();
            }
            this.discoveryService = null;
        }
        if (this.serviceHostContainer != null) {
            this.serviceHostContainer.disconnect();
            this.serviceHostContainer = null;
        }
        DiscoverableServer discoverableServer = this;
        synchronized (discoverableServer) {
            this.done = true;
            this.notifyAll();
        }
    }

    private void initializeFromArguments(String[] args) throws Exception {
        if (args == null) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-serviceHostContainerType")) {
                this.serviceHostContainerType = args[++i];
            } else if (args[i].equalsIgnoreCase("-serviceHostNamespace")) {
                this.serviceHostNamespace = args[++i];
            } else if (args[i].equalsIgnoreCase("-serviceHostID")) {
                this.serviceHostID = args[++i];
            } else if (args[i].equalsIgnoreCase("-clientContainerType")) {
                this.clientContainerType = args[++i];
            } else if (args[i].equalsIgnoreCase("-clientConnectTarget")) {
                this.clientConnectTarget = args[++i];
            } else if (args[i].equalsIgnoreCase("-serviceType")) {
                this.serviceType = args[++i];
            } else {
                this.usage();
                throw new IllegalArgumentException("Invalid argument");
            }
            ++i;
        }
    }

    private void usage() {
        System.out.println("usage: eclipse -console [options] -application org.eclipse.ecf.examples.remoteservices.server.remoteServicesServer");
        System.out.println("   options: [-serviceHostContainerType <typename>] default=ecf.generic.server");
        System.out.println("            [-serviceHostID <hostID>] default=ecftcp://localhost:3285/server");
        System.out.println("            [-clientContainerType <typename>] default=ecf.generic.client");
        System.out.println("            [-clientConnectTarget <target>] default=<serviceHostID>");
        System.out.println("            [-serviceType <serviceType>] default=remotesvcs");
    }
}

