/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jslp.identity;

import ch.ethz.iks.slp.ServiceType;
import ch.ethz.iks.slp.ServiceURL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.StringUtils;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceTypeID;
import org.eclipse.ecf.internal.provider.jslp.Messages;
import org.eclipse.osgi.util.NLS;

public class JSLPServiceTypeID
extends ServiceTypeID {
    private static final String JSLP_DELIM = ":";
    private static final long serialVersionUID = -4558132760112793805L;
    private final ServiceType st;

    protected JSLPServiceTypeID(Namespace namespace, String type) throws IDCreateException {
        super(namespace);
        try {
            this.st = new ServiceType(type);
            Assert.isNotNull((Object)this.st.toString());
            Assert.isTrue((!this.st.toString().equals("") ? 1 : 0) != 0);
            String na = this.st.getNamingAuthority();
            String str = this.st.toString();
            if (na.equals("")) {
                this.namingAuthority = "IANA";
            } else {
                this.namingAuthority = na;
                str = JSLPServiceTypeID.replaceAllIgnoreCase(str, "." + na, "");
            }
            this.services = StringUtils.split((String)str, (String)JSLP_DELIM);
            this.scopes = DEFAULT_SCOPE;
            this.protocols = DEFAULT_PROTO;
            this.createType();
        }
        catch (Exception exception) {
            throw new IDCreateException(NLS.bind((String)Messages.JSLPServiceTypeID_4, (Object)type));
        }
    }

    JSLPServiceTypeID(Namespace namespace, ServiceURL anURL, String[] scopes) throws IDCreateException {
        this(namespace, anURL.getServiceType());
        String protocol;
        if (scopes != null && scopes.length > 0) {
            this.scopes = scopes;
        }
        if ((protocol = anURL.getProtocol()) != null) {
            this.protocols = new String[]{protocol};
            this.createType();
        }
    }

    JSLPServiceTypeID(Namespace namespace, IServiceTypeID type) {
        super(namespace, type);
        StringBuffer buf = new StringBuffer("service:");
        int i = 0;
        while (i < this.services.length) {
            buf.append(this.services[i]);
            if (!this.namingAuthority.equalsIgnoreCase("IANA") && i == 1) {
                buf.append(".");
                buf.append(this.namingAuthority);
            }
            buf.append(JSLP_DELIM);
            ++i;
        }
        String string = buf.toString();
        this.st = new ServiceType(string.substring(0, string.length() - 1));
    }

    JSLPServiceTypeID(Namespace namespace, ServiceType aServiceType) throws IDCreateException {
        this(namespace, aServiceType.toString());
        String[] newServices = new String[this.services.length - 1];
        int i = 0;
        while (i < this.services.length - 1) {
            newServices[i] = this.services[i + 1];
            ++i;
        }
        this.services = newServices;
        this.createType();
    }

    public ServiceType getServiceType() {
        return this.st;
    }

    public String getInternal() {
        String str = this.st.toString();
        Assert.isNotNull((Object)str);
        if (str.endsWith(JSLP_DELIM)) {
            Assert.isTrue((str.length() > 1 ? 1 : 0) != 0);
            return str.substring(0, str.length() - 1);
        }
        return JSLPServiceTypeID.replaceAllIgnoreCase(str, ".IANA", "");
    }

    public static String replaceAllIgnoreCase(String string, String target, String replace) {
        int index = string.toLowerCase().indexOf(target.toLowerCase());
        if (index == -1) {
            return string;
        }
        return String.valueOf(string.substring(0, index)) + replace + JSLPServiceTypeID.replaceAllIgnoreCase(string.substring(index + target.length()), target, replace);
    }
}

