/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.util;

import ch.ethz.iks.util.ScheduleListener;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class Scheduler {
    private SortedMap expirationQueue = new TreeMap();
    private Map expirationDataIndex = new HashMap(0);
    private ScheduleListener listener;
    private ScheduleThread thread;
    private boolean running;

    public Scheduler(ScheduleListener listener) {
        this.listener = listener;
        this.thread = new ScheduleThread();
        this.start();
    }

    public void start() {
        this.running = true;
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        SortedMap sortedMap = this.expirationQueue;
        synchronized (sortedMap) {
            this.expirationQueue.clear();
            this.expirationDataIndex.clear();
            this.expirationQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScheduled(Object object) {
        SortedMap sortedMap = this.expirationQueue;
        synchronized (sortedMap) {
            Long scheduled = (Long)this.expirationDataIndex.get(object);
            return scheduled != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(Object object, long timestamp) throws IllegalStateException {
        SortedMap sortedMap = this.expirationQueue;
        synchronized (sortedMap) {
            if (this.isScheduled(object)) {
                throw new IllegalStateException("Object " + object + " is already scheduled.");
            }
            Long ts = new Long(timestamp);
            this.expirationQueue.put(ts, object);
            this.expirationDataIndex.put(object, ts);
            this.expirationQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reschedule(Object object, long newTimestamp) {
        SortedMap sortedMap = this.expirationQueue;
        synchronized (sortedMap) {
            this.unschedule(object);
            this.schedule(object, newTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unschedule(Object object) {
        SortedMap sortedMap = this.expirationQueue;
        synchronized (sortedMap) {
            Long scheduled = (Long)this.expirationDataIndex.remove(object);
            this.expirationQueue.remove(scheduled);
        }
    }

    static /* synthetic */ boolean access$0(Scheduler scheduler) {
        return scheduler.running;
    }

    static /* synthetic */ SortedMap access$1(Scheduler scheduler) {
        return scheduler.expirationQueue;
    }

    static /* synthetic */ ScheduleListener access$2(Scheduler scheduler) {
        return scheduler.listener;
    }

    private class ScheduleThread
    extends Thread {
        ScheduleThread() {
            this.setDaemon(true);
            this.setName("Scheduler");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
lbl1:
            // 2 sources

            try {
                while (Scheduler.access$0(Scheduler.this)) {
                    var1_1 = Scheduler.access$1(Scheduler.this);
                    synchronized (var1_1) {
                        if (!Scheduler.access$1(Scheduler.this).isEmpty()) ** GOTO lbl11
                        Scheduler.access$1(Scheduler.this).wait();
                        ** GOTO lbl1
lbl-1000:
                        // 1 sources

                        {
                            object = Scheduler.access$1(Scheduler.this).remove(nextActivity);
                            Scheduler.access$2(Scheduler.this).due(Scheduler.this, nextActivity, object);
lbl11:
                            // 2 sources

                            ** while (!Scheduler.access$1((Scheduler)Scheduler.this).isEmpty() && (nextActivity = (Long)Scheduler.access$1((Scheduler)Scheduler.this).firstKey()).longValue() <= System.currentTimeMillis() + 10L)
                        }
lbl12:
                        // 1 sources

                        if (!Scheduler.access$1(Scheduler.this).isEmpty() && (next = (nextActivity = (Long)Scheduler.access$1(Scheduler.this).firstKey()) - System.currentTimeMillis() - 10L) > 0L) {
                            Scheduler.access$1(Scheduler.this).wait(next);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

