/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.util;

import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;

public class DiscoveryProperties
extends Properties {
    private static final long serialVersionUID = -6293580853756989675L;

    public DiscoveryProperties(String clazz, String containerFactory, IContainer container) {
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)clazz);
        ID connectedID = container.getConnectedID();
        String connectNamespace = connectedID == null ? container.getConnectNamespace().getName() : connectedID.getNamespace().getName();
        String connectID = connectedID == null ? null : connectedID.getName();
        ID containerID = container.getID();
        String targetNamespace = containerID == null ? null : containerID.getNamespace().getName();
        String targetID = containerID == null ? null : containerID.getName();
        this.put("cls", clazz);
        Assert.isNotNull((Object)containerFactory);
        this.put("cft", containerFactory);
        if (connectNamespace != null) {
            this.put("cns", connectNamespace);
        }
        if (connectID != null) {
            this.put("cid", connectID);
        }
        if (targetNamespace != null) {
            this.put("sns", targetNamespace);
        }
        if (targetID != null) {
            this.put("sid", targetID);
        }
    }

    public DiscoveryProperties(String clazz, String containerFactory, String connectNamespace, String connectID, String targetNamespace, String targetID) {
        Assert.isNotNull((Object)clazz);
        this.put("cls", clazz);
        Assert.isNotNull((Object)containerFactory);
        this.put("cft", containerFactory);
        if (connectNamespace != null) {
            this.put("cns", connectNamespace);
        }
        if (connectID != null) {
            this.put("cid", connectID);
        }
        if (targetNamespace != null) {
            this.put("sns", targetNamespace);
        }
        if (targetID != null) {
            this.put("sid", targetID);
        }
    }
}

