/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.impl.RequestMessage;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.SLPMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

class ServiceTypeRequest
extends RequestMessage {
    String namingAuthority;
    private static final String NA_ALL = "*";
    private static final String NA_DEFAULT = "";

    ServiceTypeRequest(String string, List list, Locale locale) {
        this.funcID = (byte)9;
        this.prevRespList = new ArrayList();
        this.namingAuthority = string != null ? string : NA_ALL;
        this.scopeList = list;
        if (this.scopeList == null) {
            this.scopeList = new ArrayList();
            this.scopeList.add("default");
        }
        this.locale = locale == null ? SLPCore.DEFAULT_LOCALE : locale;
    }

    ServiceTypeRequest(DataInputStream dataInputStream) throws IOException {
        this.prevRespList = SLPMessage.stringToList(dataInputStream.readUTF(), ",");
        int n = dataInputStream.readUnsignedShort();
        if (n == 65535) {
            this.namingAuthority = NA_ALL;
        } else if (n == -1) {
            this.namingAuthority = NA_DEFAULT;
        } else {
            byte[] byArray = new byte[n];
            dataInputStream.readFully(byArray);
            this.namingAuthority = new String(byArray);
        }
        this.scopeList = SLPMessage.stringToList(dataInputStream.readUTF(), ",");
    }

    protected void writeTo(DataOutputStream dataOutputStream) throws IOException {
        super.writeHeader(dataOutputStream, this.getSize());
        dataOutputStream.writeUTF(SLPMessage.listToString(this.prevRespList, ","));
        if (this.namingAuthority.equals(NA_ALL)) {
            dataOutputStream.writeShort(65535);
        } else if (this.namingAuthority.equals(NA_DEFAULT)) {
            dataOutputStream.writeUTF(NA_DEFAULT);
        } else {
            dataOutputStream.writeUTF(this.namingAuthority);
        }
        dataOutputStream.writeUTF(SLPMessage.listToString(this.scopeList, ","));
    }

    int getSize() {
        int n = this.getHeaderSize() + 2 + SLPMessage.listToString(this.prevRespList, ",").length();
        n = this.namingAuthority.equals(NA_DEFAULT) || this.namingAuthority.equals(NA_ALL) ? (n += 2) : (n += 2 + this.namingAuthority.length());
        return n += 2 + SLPMessage.listToString(this.scopeList, ",").length();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(", prevRespList: " + this.prevRespList);
        if (this.namingAuthority.equals(NA_ALL)) {
            stringBuffer.append(", namingAuthority: ALL (NA_ALL)");
        } else if (this.namingAuthority.equals(NA_DEFAULT)) {
            stringBuffer.append(", namingAuthority: IANA (NA_DEFAULT)");
        } else {
            stringBuffer.append(", namingAuthority: " + this.namingAuthority);
        }
        stringBuffer.append(", scopeList: " + this.scopeList);
        return stringBuffer.toString();
    }
}

