/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.jslp;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.util.StringUtils;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceProperties;

public class ServicePropertiesAdapter {
    private static final String SLP_BYTE_PREFIX = "\\FF";
    private IServiceProperties serviceProperties;

    public ServicePropertiesAdapter(List aList) {
        Assert.isNotNull((Object)aList);
        this.serviceProperties = new ServiceProperties();
        Iterator itr = aList.iterator();
        while (itr.hasNext()) {
            String[] str = StringUtils.split((String)((String)itr.next()), (String)"=");
            String key = str[0].substring(1);
            String value = str[1].substring(0, str[1].length() - 1);
            if (value.startsWith(SLP_BYTE_PREFIX)) {
                String[] strs = StringUtils.split((String)value.substring(4), (String)"\\");
                byte[] b = new byte[strs.length];
                int i = 0;
                while (i < strs.length) {
                    b[i] = new Byte(strs[i]);
                    ++i;
                }
                this.serviceProperties.setPropertyBytes(key, b);
                continue;
            }
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                this.serviceProperties.setProperty(key, (Object)new Boolean(value));
                continue;
            }
            if (this.isInteger(value)) {
                this.serviceProperties.setProperty(key, (Object)new Integer(value));
                continue;
            }
            this.serviceProperties.setProperty(key, (Object)value);
        }
    }

    public ServicePropertiesAdapter(IServiceProperties aServiceProperties) {
        Assert.isNotNull((Object)aServiceProperties);
        this.serviceProperties = aServiceProperties;
    }

    private boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public IServiceProperties toServiceProperties() {
        return this.serviceProperties;
    }

    public Dictionary toProperties() {
        Properties dict = new Properties();
        Enumeration propertyNames = this.serviceProperties.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            byte[] propertyBytes = this.serviceProperties.getPropertyBytes(key);
            if (propertyBytes != null) {
                StringBuffer buf = new StringBuffer();
                buf.append(SLP_BYTE_PREFIX);
                int i = 0;
                while (i < propertyBytes.length) {
                    buf.append("\\");
                    buf.append(propertyBytes[i]);
                    ++i;
                }
                ((Dictionary)dict).put(key, buf.toString());
                continue;
            }
            ((Dictionary)dict).put(key, this.serviceProperties.getProperty(key).toString());
        }
        return dict;
    }
}

