/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ui.deprecated.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SimpleLinkTextViewer
implements ISelectionProvider {
    private Color hyperlinkColor = null;
    private Cursor cursor;
    private List links = new ArrayList();
    private StyledText styledText;
    private List listeners = new ArrayList();
    static /* synthetic */ Class class$0;

    private Color getHyperlinkColor() {
        if (this.hyperlinkColor == null) {
            this.hyperlinkColor = JFaceColors.getActiveHyperlinkText((Display)Display.getDefault());
            if (this.hyperlinkColor == null) {
                this.hyperlinkColor = new Color((Device)Display.getDefault(), 0, 0, 255);
            }
        }
        return this.hyperlinkColor;
    }

    public SimpleLinkTextViewer(Composite composite, int style) {
        this.styledText = new StyledText(composite, style);
        this.styledText.addMouseListener((MouseListener)new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseUp(MouseEvent e) {
                LinkInfo linkInfo = null;
                SimpleLinkTextViewer simpleLinkTextViewer = SimpleLinkTextViewer.this;
                synchronized (simpleLinkTextViewer) {
                    if (SimpleLinkTextViewer.this.styledText.isDisposed()) {
                        return;
                    }
                    linkInfo = SimpleLinkTextViewer.this.findLinkInfo(e);
                }
                if (linkInfo != null) {
                    linkInfo.runnable.run();
                }
            }
        });
        this.styledText.addMouseMoveListener(new MouseMoveListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseMove(MouseEvent e) {
                SimpleLinkTextViewer simpleLinkTextViewer = SimpleLinkTextViewer.this;
                synchronized (simpleLinkTextViewer) {
                    if (SimpleLinkTextViewer.this.styledText.isDisposed()) {
                        return;
                    }
                    LinkInfo linkInfo = SimpleLinkTextViewer.this.findLinkInfo(e);
                    if (linkInfo != null) {
                        SimpleLinkTextViewer.this.setHandCursor();
                    } else {
                        SimpleLinkTextViewer.this.resetCursor();
                    }
                }
            }
        });
    }

    public synchronized void append(String text) {
        if (this.styledText.isDisposed()) {
            return;
        }
        this.styledText.append(text);
    }

    public synchronized void appendLink(String text, Runnable onClick) {
        if (this.styledText.isDisposed()) {
            return;
        }
        int start = this.styledText.getCharCount();
        this.styledText.replaceTextRange(start, 0, text);
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = text.length();
        styleRange.foreground = this.getHyperlinkColor();
        styleRange.underline = true;
        this.styledText.setStyleRange(styleRange);
        this.links.add(new LinkInfo(start, text.length(), onClick));
    }

    private LinkInfo findLinkInfoFromOffset(int offset) {
        int low = -1;
        int high = this.links.size();
        while (high - low > 1) {
            int index = (high + low) / 2;
            LinkInfo linkInfo = (LinkInfo)this.links.get(index);
            if (offset < linkInfo.start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (low == -1) {
            return null;
        }
        LinkInfo result = (LinkInfo)this.links.get(low);
        if (result.start <= offset && offset < result.start + result.length) {
            return result;
        }
        return null;
    }

    private LinkInfo findLinkInfo(MouseEvent e) {
        Point point = new Point(e.x, e.y);
        LinkInfo linkInfo = null;
        if (this.styledText.getBounds().contains(point) && this.styledText.getCharCount() > 0) {
            try {
                int offset = this.styledText.getOffsetAtLocation(point);
                linkInfo = this.findLinkInfoFromOffset(offset);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return linkInfo;
    }

    private void resetCursor() {
        this.styledText.setCursor(null);
        if (this.cursor != null) {
            this.cursor.dispose();
            this.cursor = null;
        }
    }

    private void setHandCursor() {
        Display display = this.styledText.getDisplay();
        if (this.cursor == null) {
            this.cursor = new Cursor((Device)display, 21);
        }
        this.styledText.setCursor(this.cursor);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.internal.ui.deprecated.views.SimpleLinkTextViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        shell.setText(clazz.getName());
        shell.setLayout((Layout)new FillLayout());
        SimpleLinkTextViewer chatTextViewer = new SimpleLinkTextViewer((Composite)shell, 2888);
        chatTextViewer.append("Hello world\n");
        chatTextViewer.append("Hello ");
        chatTextViewer.appendLink("linked", new Runnable(){

            public void run() {
                System.out.println("clicked!");
            }
        });
        chatTextViewer.append(" world\n");
        chatTextViewer.append("Hello world\n");
        Text secondText = new Text((Composite)shell, 2048);
        secondText.setText("some other focusable text");
        secondText.forceFocus();
        shell.layout();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public StyledText getTextWidget() {
        return this.styledText;
    }

    public Control getControl() {
        return this.getTextWidget();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public ISelection getSelection() {
        TextSelection selection = new TextSelection(this.styledText.getSelectionRange().x, this.styledText.getSelectionRange().y);
        return selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            this.styledText.setSelection(textSelection.getOffset(), textSelection.getOffset() + textSelection.getLength());
        }
    }

    private static class LinkInfo {
        private final int start;
        private final int length;
        private final Runnable runnable;

        private LinkInfo(int start, int length, Runnable runnable) {
            this.start = start;
            this.length = length;
            this.runnable = runnable;
        }
    }
}

