/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.impl;

import ch.ethz.iks.r_osgi.RemoteOSGiException;
import ch.ethz.iks.r_osgi.RemoteServiceEvent;
import ch.ethz.iks.r_osgi.RemoteServiceReference;
import ch.ethz.iks.r_osgi.URI;
import ch.ethz.iks.r_osgi.channels.ChannelEndpoint;
import ch.ethz.iks.r_osgi.channels.NetworkChannel;
import ch.ethz.iks.r_osgi.channels.NetworkChannelFactory;
import ch.ethz.iks.r_osgi.impl.ProxyGenerator;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiActivator;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiServiceImpl;
import ch.ethz.iks.r_osgi.impl.RemoteServiceReferenceImpl;
import ch.ethz.iks.r_osgi.impl.RemoteServiceRegistration;
import ch.ethz.iks.r_osgi.impl.TimeOffset;
import ch.ethz.iks.r_osgi.messages.DeliverServiceMessage;
import ch.ethz.iks.r_osgi.messages.FetchServiceMessage;
import ch.ethz.iks.r_osgi.messages.InvokeMethodMessage;
import ch.ethz.iks.r_osgi.messages.LeaseMessage;
import ch.ethz.iks.r_osgi.messages.LeaseUpdateMessage;
import ch.ethz.iks.r_osgi.messages.MethodResultMessage;
import ch.ethz.iks.r_osgi.messages.RemoteEventMessage;
import ch.ethz.iks.r_osgi.messages.RemoteOSGiMessage;
import ch.ethz.iks.r_osgi.messages.StreamRequestMessage;
import ch.ethz.iks.r_osgi.messages.StreamResultMessage;
import ch.ethz.iks.r_osgi.messages.TimeOffsetMessage;
import ch.ethz.iks.r_osgi.streams.InputStreamHandle;
import ch.ethz.iks.r_osgi.streams.InputStreamProxy;
import ch.ethz.iks.r_osgi.streams.OutputStreamHandle;
import ch.ethz.iks.r_osgi.streams.OutputStreamProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public final class ChannelEndpointImpl
implements ChannelEndpoint {
    int usageCounter = 1;
    private NetworkChannel networkChannel;
    private Map remoteServices = new HashMap(0);
    private List remoteTopics = new ArrayList(0);
    private TimeOffset timeOffset;
    private static final int TIMEOUT = 120000;
    private final Map receiveQueue = new HashMap(0);
    private final HashMap localServices = new HashMap(2);
    private final HashMap proxiedServices = new HashMap(0);
    final HashMap proxyBundles = new HashMap(0);
    private final HashMap streams = new HashMap(0);
    private short nextStreamID = 0;
    private ServiceRegistration handlerReg = null;
    private static final Object WAITING = new Object();
    private static final String NO_LOOPS = "(!(sender.uri=*))";
    boolean hasRedundantLinks = false;
    static /* synthetic */ Class class$0;

    ChannelEndpointImpl(NetworkChannelFactory factory, URI endpointAddress) throws RemoteOSGiException, IOException {
        this.networkChannel = factory.getConnection(this, endpointAddress);
        if (RemoteOSGiServiceImpl.DEBUG) {
            RemoteOSGiServiceImpl.log.log(4, "opening new channel " + this.getRemoteAddress());
        }
        RemoteOSGiServiceImpl.registerChannelEndpoint(this);
    }

    ChannelEndpointImpl(NetworkChannel channel) {
        this.networkChannel = channel;
        channel.bind(this);
        RemoteOSGiServiceImpl.registerChannelEndpoint(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedMessage(final RemoteOSGiMessage msg) {
        if (msg == null) {
            this.dispose();
            return;
        }
        Integer xid = new Integer(msg.getXID());
        Map map = this.receiveQueue;
        synchronized (map) {
            Object state = this.receiveQueue.get(xid);
            if (state == WAITING) {
                this.receiveQueue.put(xid, msg);
                this.receiveQueue.notifyAll();
                return;
            }
            new Thread(){

                public void run() {
                    RemoteOSGiMessage reply = ChannelEndpointImpl.this.handleMessage(msg);
                    if (reply != null) {
                        try {
                            ChannelEndpointImpl.this.networkChannel.sendMessage(reply);
                        }
                        catch (NotSerializableException nse) {
                            throw new RemoteOSGiException("Error sending " + reply, nse);
                        }
                        catch (IOException iOException) {
                            ChannelEndpointImpl.this.dispose();
                        }
                    }
                }
            }.start();
        }
    }

    public Object invokeMethod(String service, String methodSignature, Object[] args) throws Throwable {
        if (this.networkChannel == null) {
            throw new RemoteOSGiException("Network channel went down");
        }
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof InputStream) {
                args[i] = this.getInputStreamPlaceholder((InputStream)args[i]);
            } else if (args[i] instanceof OutputStream) {
                args[i] = this.getOutputStreamPlaceholder((OutputStream)args[i]);
            }
            ++i;
        }
        InvokeMethodMessage invokeMsg = new InvokeMethodMessage();
        invokeMsg.setServiceID(URI.create(service).getFragment());
        invokeMsg.setMethodSignature(methodSignature);
        invokeMsg.setArgs(args);
        try {
            MethodResultMessage result = (MethodResultMessage)this.sendMessage(invokeMsg);
            if (result.causedException()) {
                result.getException().printStackTrace();
                throw result.getException();
            }
            Object resultObj = result.getResult();
            if (resultObj instanceof InputStreamHandle) {
                resultObj = this.getInputStreamProxy((InputStreamHandle)resultObj);
            }
            if (resultObj instanceof OutputStreamHandle) {
                resultObj = this.getOutputStreamProxy((OutputStreamHandle)resultObj);
            }
            return resultObj;
        }
        catch (RemoteOSGiException e) {
            throw new RemoteOSGiException("Method invocation of " + methodSignature + " failed.", e);
        }
    }

    public Dictionary getProperties(String serviceID) {
        return this.getRemoteReference(serviceID).getProperties();
    }

    public Dictionary getPresentationProperties(String serviceID) {
        Hashtable<String, Object> attribs = new Hashtable<String, Object>();
        ((Dictionary)attribs).put("service.uri", serviceID);
        ((Dictionary)attribs).put("service.presentation", this.getRemoteReference(serviceID).getProperty("service.presentation"));
        return attribs;
    }

    public void trackRegistration(String serviceID, ServiceRegistration reg) {
        this.proxiedServices.put(serviceID, reg);
    }

    public void untrackRegistration(String serviceID) {
        this.proxiedServices.remove(serviceID);
    }

    public TimeOffset getOffset() throws RemoteOSGiException {
        if (this.timeOffset == null) {
            TimeOffsetMessage timeMsg = new TimeOffsetMessage();
            int i = 0;
            while (i < 4) {
                timeMsg.timestamp();
                timeMsg = (TimeOffsetMessage)this.sendMessage(timeMsg);
                ++i;
            }
            this.timeOffset = new TimeOffset(timeMsg.getTimeSeries());
        } else if (this.timeOffset.isExpired()) {
            TimeOffsetMessage timeMsg = new TimeOffsetMessage();
            int i = 0;
            while (i < this.timeOffset.seriesLength()) {
                timeMsg.timestamp();
                timeMsg = (TimeOffsetMessage)this.sendMessage(timeMsg);
                i += 2;
            }
            this.timeOffset.update(timeMsg.getTimeSeries());
        }
        return this.timeOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.networkChannel == null) {
            return;
        }
        if (RemoteOSGiServiceImpl.DEBUG) {
            RemoteOSGiServiceImpl.log.log(4, "DISPOSING ENDPOINT " + this.getRemoteAddress());
        }
        RemoteOSGiServiceImpl.unregisterChannelEndpoint(this.getRemoteAddress().toString());
        if (this.handlerReg != null) {
            this.handlerReg.unregister();
        }
        NetworkChannel oldchannel = this.networkChannel;
        this.networkChannel = null;
        try {
            oldchannel.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (!this.hasRedundantLinks) {
            RemoteServiceReference[] refs = this.remoteServices.values().toArray(new RemoteServiceReference[this.remoteServices.size()]);
            int i = 0;
            while (i < refs.length) {
                RemoteOSGiServiceImpl.notifyRemoteServiceListeners(new RemoteServiceEvent(4, refs[i]));
                ++i;
            }
            Bundle[] proxies = this.proxyBundles.values().toArray(new Bundle[this.proxyBundles.size()]);
            int i2 = 0;
            while (i2 < proxies.length) {
                try {
                    if (proxies[i2].getState() != 1) {
                        proxies[i2].uninstall();
                    }
                }
                catch (Throwable throwable) {}
                ++i2;
            }
        }
        this.remoteServices = null;
        this.remoteTopics = null;
        this.timeOffset = null;
        this.receiveQueue.clear();
        this.localServices.clear();
        this.proxiedServices.clear();
        this.closeStreams();
        this.streams.clear();
        this.handlerReg = null;
        Map map = this.receiveQueue;
        synchronized (map) {
            this.receiveQueue.notifyAll();
        }
    }

    public boolean isConnected() {
        return this.networkChannel != null;
    }

    public String toString() {
        return "ChannelEndpoint(" + this.networkChannel.toString() + ")";
    }

    public int readStream(short streamID) throws IOException {
        StreamRequestMessage requestMsg = new StreamRequestMessage();
        requestMsg.setOp((byte)0);
        requestMsg.setStreamID(streamID);
        StreamResultMessage resultMsg = this.doStreamOp(requestMsg);
        return resultMsg.getResult();
    }

    public int readStream(short streamID, byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len + off > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        StreamRequestMessage requestMsg = new StreamRequestMessage();
        requestMsg.setOp((byte)1);
        requestMsg.setStreamID(streamID);
        requestMsg.setLenOrVal(len);
        StreamResultMessage resultMsg = this.doStreamOp(requestMsg);
        int length = resultMsg.getLen();
        if (length > 0) {
            byte[] readdata = resultMsg.getData();
            System.arraycopy(readdata, 0, b, off, length);
        }
        return length;
    }

    public void writeStream(short streamID, int b) throws IOException {
        StreamRequestMessage requestMsg = new StreamRequestMessage();
        requestMsg.setOp((byte)2);
        requestMsg.setStreamID(streamID);
        requestMsg.setLenOrVal(b);
        this.doStreamOp(requestMsg);
    }

    public void writeStream(short streamID, byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len + off > b.length) {
            throw new IndexOutOfBoundsException();
        }
        byte[] data = new byte[len];
        System.arraycopy(b, off, data, 0, len);
        StreamRequestMessage requestMsg = new StreamRequestMessage();
        requestMsg.setOp((byte)3);
        requestMsg.setStreamID(streamID);
        requestMsg.setData(data);
        requestMsg.setLenOrVal(len);
        this.doStreamOp(requestMsg);
    }

    public URI getRemoteAddress() {
        if (this.networkChannel == null) {
            throw new RuntimeException("CHANNEL IS NULL");
        }
        return this.networkChannel.getRemoteAddress();
    }

    URI getLocalAddress() {
        if (this.networkChannel == null) {
            throw new RuntimeException("CHANNEL IS NULL");
        }
        return this.networkChannel.getLocalAddress();
    }

    RemoteServiceReference[] sendLease(RemoteServiceRegistration[] myServices, String[] myTopics) {
        LeaseMessage l = new LeaseMessage();
        this.populateLease(l, myServices, myTopics);
        LeaseMessage lease = (LeaseMessage)this.sendMessage(l);
        return this.processLease(lease);
    }

    void sendLeaseUpdate(LeaseUpdateMessage msg) {
        this.send(msg);
    }

    boolean isActive(String uri) {
        return this.remoteServices.get(uri) != null;
    }

    void fetchService(RemoteServiceReference ref) throws IOException, RemoteOSGiException {
        if (this.networkChannel == null) {
            throw new RuntimeException("CHANNEL IS NULL");
        }
        FetchServiceMessage fetchReq = new FetchServiceMessage();
        fetchReq.setServiceID(ref.getURI().getFragment());
        RemoteOSGiMessage msg = this.sendMessage(fetchReq);
        String bundleLocation = null;
        try {
            DeliverServiceMessage deliv = (DeliverServiceMessage)msg;
            URI service = this.networkChannel.getRemoteAddress().resolve("#" + deliv.getServiceID());
            InputStream in = new ProxyGenerator().generateProxyBundle(service, deliv);
            Bundle bundle = RemoteOSGiActivator.context.installBundle(service.toString(), in);
            this.proxyBundles.put(service.getFragment(), bundle);
            bundle.start();
        }
        catch (BundleException e) {
            Throwable nested = e.getNestedException() == null ? e : e.getNestedException();
            throw new RemoteOSGiException("Could not install the generated bundle " + bundleLocation, nested);
        }
    }

    RemoteServiceReferenceImpl getRemoteReference(String uri) {
        return (RemoteServiceReferenceImpl)this.remoteServices.get(uri);
    }

    RemoteServiceReference[] getAllRemoteReferences(Filter filter) {
        ArrayList<RemoteServiceReference> result = new ArrayList<RemoteServiceReference>();
        RemoteServiceReference[] refs = this.remoteServices.values().toArray(new RemoteServiceReferenceImpl[this.remoteServices.size()]);
        if (filter == null) {
            return refs.length > 0 ? refs : null;
        }
        int i = 0;
        while (i < refs.length) {
            if (filter.match(((RemoteServiceReferenceImpl)refs[i]).getProperties())) {
                result.add(refs[i]);
            }
            ++i;
        }
        RemoteServiceReference[] refs2 = result.toArray(new RemoteServiceReferenceImpl[result.size()]);
        return refs2.length > 0 ? refs2 : null;
    }

    void ungetRemoteService(URI uri) {
        try {
            ((Bundle)this.proxyBundles.remove(uri.getFragment())).uninstall();
        }
        catch (BundleException bundleException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void send(RemoteOSGiMessage msg) {
        if (this.networkChannel == null) {
            throw new RemoteOSGiException("Network channel went down.");
        }
        if (msg.getXID() == 0) {
            msg.setXID(RemoteOSGiServiceImpl.nextXid());
        }
        try {
            try {
                this.networkChannel.sendMessage(msg);
                return;
            }
            catch (IOException iOException) {
                try {
                    if (msg instanceof TimeOffsetMessage) {
                        ((TimeOffsetMessage)msg).restamp(RemoteOSGiServiceImpl.nextXid());
                        this.networkChannel.sendMessage(msg);
                        return;
                    }
                    this.networkChannel.sendMessage(msg);
                    return;
                }
                catch (IOException ioe) {
                    this.dispose();
                    throw new RemoteOSGiException("Network error", ioe);
                }
            }
        }
        catch (NotSerializableException nse) {
            throw new RemoteOSGiException("Error sending " + msg, nse);
        }
        catch (ObjectStreamException ose) {
            throw new RemoteOSGiException("Error during serializing arguments of " + msg, ose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteOSGiMessage sendMessage(RemoteOSGiMessage msg) {
        if (msg.getXID() == 0) {
            msg.setXID(RemoteOSGiServiceImpl.nextXid());
        }
        Integer xid = new Integer(msg.getXID());
        Map map = this.receiveQueue;
        synchronized (map) {
            this.receiveQueue.put(xid, WAITING);
        }
        this.send(msg);
        Map map2 = this.receiveQueue;
        synchronized (map2) {
            Object reply = this.receiveQueue.get(xid);
            long timeout = System.currentTimeMillis() + 120000L;
            try {
                while (this.networkChannel != null && reply == WAITING && System.currentTimeMillis() < timeout) {
                    this.receiveQueue.wait(120000L);
                    reply = this.receiveQueue.get(xid);
                }
                this.receiveQueue.remove(xid);
                if (this.networkChannel == null) {
                    throw new RemoteOSGiException("Lost connection");
                }
                if (reply == WAITING) {
                    throw new RemoteOSGiException("Method Invocation failed, timeout exceeded.");
                }
                return (RemoteOSGiMessage)reply;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private RemoteServiceRegistration getServiceRegistration(String serviceID) {
        RemoteServiceRegistration reg = RemoteOSGiServiceImpl.getServiceRegistration(serviceID);
        this.localServices.put(serviceID, reg);
        return reg;
    }

    private void populateLease(LeaseMessage lease, RemoteServiceRegistration[] regs, String[] topics) {
        String[] serviceIDs = new String[regs.length];
        String[][] serviceInterfaces = new String[regs.length][];
        Dictionary[] serviceProperties = new Dictionary[regs.length];
        int i = 0;
        while (i < regs.length) {
            serviceIDs[i] = String.valueOf(regs[i].getServiceID());
            serviceInterfaces[i] = regs[i].getInterfaceNames();
            serviceProperties[i] = regs[i].getProperties();
            i = (short)(i + 1);
        }
        lease.setServiceIDs(serviceIDs);
        lease.setServiceInterfaces(serviceInterfaces);
        lease.setServiceProperties(serviceProperties);
        lease.setTopics(topics);
    }

    private RemoteServiceReference[] processLease(LeaseMessage lease) {
        String[] serviceIDs = lease.getServiceIDs();
        String[][] serviceInterfaces = lease.getServiceInterfaces();
        Dictionary[] serviceProperties = lease.getServiceProperties();
        RemoteServiceReference[] refs = new RemoteServiceReferenceImpl[serviceIDs.length];
        int i = 0;
        while (i < serviceIDs.length) {
            refs[i] = new RemoteServiceReferenceImpl(serviceInterfaces[i], serviceIDs[i], serviceProperties[i], this);
            this.remoteServices.put(((RemoteServiceReferenceImpl)refs[i]).getURI().toString(), refs[i]);
            RemoteOSGiServiceImpl.notifyRemoteServiceListeners(new RemoteServiceEvent(1, refs[i]));
            i = (short)(i + 1);
        }
        this.updateTopics(lease.getTopics(), new String[0]);
        return refs;
    }

    private StreamResultMessage doStreamOp(StreamRequestMessage requestMsg) throws IOException {
        try {
            StreamResultMessage result = (StreamResultMessage)this.sendMessage(requestMsg);
            if (result.causedException()) {
                throw result.getException();
            }
            return result;
        }
        catch (RemoteOSGiException e) {
            throw new RemoteOSGiException("Invocation of operation " + requestMsg.getOp() + " on stream " + requestMsg.getStreamID() + " failed.", e);
        }
    }

    private void updateTopics(String[] topicsAdded, String[] topicsRemoved) {
        if (this.handlerReg == null) {
            if (topicsAdded.length > 0) {
                Hashtable<String, Object> properties = new Hashtable<String, Object>();
                ((Dictionary)properties).put("event.topics", topicsAdded);
                ((Dictionary)properties).put("event.filter", NO_LOOPS);
                ((Dictionary)properties).put("internal", Boolean.TRUE);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.osgi.service.event.EventHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.handlerReg = RemoteOSGiActivator.context.registerService(clazz.getName(), (Object)new EventForwarder(), properties);
                this.remoteTopics.addAll(Arrays.asList(topicsAdded));
            }
        } else {
            if (topicsRemoved != null) {
                this.remoteTopics.removeAll(Arrays.asList(topicsRemoved));
            }
            if (topicsAdded != null) {
                this.remoteTopics.addAll(Arrays.asList(topicsAdded));
            }
            if (this.remoteTopics.size() == 0) {
                this.handlerReg.unregister();
                this.handlerReg = null;
            } else {
                Hashtable<String, Object> properties = new Hashtable<String, Object>();
                ((Dictionary)properties).put("event.topics", this.remoteTopics.toArray(new String[this.remoteTopics.size()]));
                ((Dictionary)properties).put("event.filter", NO_LOOPS);
                ((Dictionary)properties).put("internal", Boolean.TRUE);
                this.handlerReg.setProperties(properties);
            }
        }
        if (RemoteOSGiServiceImpl.MSG_DEBUG) {
            RemoteOSGiServiceImpl.log.log(4, "NEW REMOTE TOPIC SPACE for " + this.getRemoteAddress() + " is " + this.remoteTopics);
        }
    }

    private RemoteOSGiMessage handleMessage(RemoteOSGiMessage msg) throws RemoteOSGiException {
        switch (msg.getFuncID()) {
            case 1: {
                LeaseMessage lease = (LeaseMessage)msg;
                this.processLease(lease);
                this.populateLease(lease, RemoteOSGiServiceImpl.getServices(), RemoteOSGiServiceImpl.getTopics());
                return lease;
            }
            case 2: {
                FetchServiceMessage fetchReq = (FetchServiceMessage)msg;
                String serviceID = fetchReq.getServiceID();
                RemoteServiceRegistration reg = this.getServiceRegistration(serviceID);
                DeliverServiceMessage m = reg.getDeliverServiceMessage();
                m.setXID(fetchReq.getXID());
                m.setServiceID(fetchReq.getServiceID());
                return m;
            }
            case 9: {
                LeaseUpdateMessage suMsg = (LeaseUpdateMessage)msg;
                String serviceID = suMsg.getServiceID();
                short stateUpdate = suMsg.getType();
                switch (stateUpdate) {
                    case 0: {
                        this.updateTopics((String[])suMsg.getPayload()[0], (String[])suMsg.getPayload()[1]);
                        return null;
                    }
                    case 1: {
                        RemoteServiceReferenceImpl ref = new RemoteServiceReferenceImpl((String[])suMsg.getPayload()[0], serviceID, (Dictionary)suMsg.getPayload()[1], this);
                        this.remoteServices.put(this.getRemoteAddress().resolve("#" + serviceID).toString(), ref);
                        RemoteOSGiServiceImpl.notifyRemoteServiceListeners(new RemoteServiceEvent(1, ref));
                        return null;
                    }
                    case 2: {
                        Dictionary newProps = (Dictionary)suMsg.getPayload()[1];
                        ServiceRegistration reg = (ServiceRegistration)this.proxiedServices.get(serviceID);
                        if (reg != null) {
                            reg.setProperties(newProps);
                        }
                        RemoteServiceReferenceImpl ref = this.getRemoteReference(this.getRemoteAddress().resolve("#" + serviceID).toString());
                        ref.setProperties(newProps);
                        RemoteOSGiServiceImpl.notifyRemoteServiceListeners(new RemoteServiceEvent(2, ref));
                        return null;
                    }
                    case 3: {
                        Bundle bundle;
                        if (this.networkChannel == null) {
                            return null;
                        }
                        RemoteServiceReference ref = (RemoteServiceReference)this.remoteServices.remove(this.getRemoteAddress().resolve("#" + serviceID).toString());
                        if (ref != null) {
                            RemoteOSGiServiceImpl.notifyRemoteServiceListeners(new RemoteServiceEvent(4, ref));
                        }
                        if ((bundle = (Bundle)this.proxyBundles.remove(serviceID)) != null) {
                            try {
                                bundle.uninstall();
                            }
                            catch (BundleException be) {
                                be.printStackTrace();
                            }
                            this.proxiedServices.remove(serviceID);
                            this.remoteServices.remove(this.getRemoteAddress().resolve("#" + serviceID).toString());
                        }
                        return null;
                    }
                }
            }
            case 5: {
                InvokeMethodMessage invMsg = (InvokeMethodMessage)msg;
                try {
                    RemoteServiceRegistration serv = (RemoteServiceRegistration)this.localServices.get(invMsg.getServiceID());
                    if (serv == null) {
                        RemoteServiceRegistration reg = this.getServiceRegistration(invMsg.getServiceID());
                        if (reg == null) {
                            throw new IllegalStateException(String.valueOf(this.toString()) + "Could not get " + invMsg.getServiceID() + ", known services " + this.localServices);
                        }
                        serv = reg;
                    }
                    Object[] arguments = invMsg.getArgs();
                    int i = 0;
                    while (i < arguments.length) {
                        if (arguments[i] instanceof InputStreamHandle) {
                            arguments[i] = this.getInputStreamProxy((InputStreamHandle)arguments[i]);
                        } else if (arguments[i] instanceof OutputStreamHandle) {
                            arguments[i] = this.getOutputStreamProxy((OutputStreamHandle)arguments[i]);
                        }
                        ++i;
                    }
                    Method method = serv.getMethod(invMsg.getMethodSignature());
                    try {
                        Object result = method.invoke(serv.getServiceObject(), arguments);
                        if (result instanceof InputStream) {
                            result = this.getInputStreamPlaceholder((InputStream)result);
                        } else if (result instanceof OutputStream) {
                            result = this.getOutputStreamPlaceholder((OutputStream)result);
                        }
                        MethodResultMessage m = new MethodResultMessage();
                        m.setXID(invMsg.getXID());
                        m.setResult(result);
                        return m;
                    }
                    catch (InvocationTargetException t) {
                        t.printStackTrace();
                        throw t.getTargetException();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    MethodResultMessage m = new MethodResultMessage();
                    m.setXID(invMsg.getXID());
                    m.setException(t);
                    return m;
                }
            }
            case 7: {
                RemoteEventMessage eventMsg = (RemoteEventMessage)msg;
                Dictionary properties = eventMsg.getProperties();
                Long remoteTs = (Long)properties.get("timestamp");
                if (remoteTs != null) {
                    properties.put("timestamp", this.getOffset().transform(remoteTs));
                }
                Event event = new Event(eventMsg.getTopic(), properties);
                if (RemoteOSGiServiceImpl.eventAdminTracker.getTrackingCount() > 0) {
                    ((EventAdmin)RemoteOSGiServiceImpl.eventAdminTracker.getService()).postEvent(event);
                } else {
                    System.err.println("Could not deliver received event: " + event + ". No EventAdmin available.");
                }
                return null;
            }
            case 8: {
                ((TimeOffsetMessage)msg).timestamp();
                return msg;
            }
            case 10: {
                StreamRequestMessage reqMsg = (StreamRequestMessage)msg;
                try {
                    Object stream = this.streams.get(new Integer(reqMsg.getStreamID()));
                    if (stream == null) {
                        throw new IllegalStateException("Could not get stream with ID " + reqMsg.getStreamID());
                    }
                    switch (reqMsg.getOp()) {
                        case 0: {
                            int result = ((InputStream)stream).read();
                            StreamResultMessage m = new StreamResultMessage();
                            m.setXID(reqMsg.getXID());
                            m.setResult((short)result);
                            return m;
                        }
                        case 1: {
                            byte[] b = new byte[reqMsg.getLenOrVal()];
                            int len = ((InputStream)stream).read(b, 0, reqMsg.getLenOrVal());
                            StreamResultMessage m = new StreamResultMessage();
                            m.setXID(reqMsg.getXID());
                            m.setResult((short)-2);
                            m.setLen(len);
                            if (len > 0) {
                                m.setData(b);
                            }
                            return m;
                        }
                        case 2: {
                            ((OutputStream)stream).write(reqMsg.getLenOrVal());
                            StreamResultMessage m = new StreamResultMessage();
                            m.setXID(reqMsg.getXID());
                            m.setResult((short)-4);
                            return m;
                        }
                        case 3: {
                            ((OutputStream)stream).write(reqMsg.getData());
                            StreamResultMessage m = new StreamResultMessage();
                            m.setXID(reqMsg.getXID());
                            m.setResult((short)-4);
                            return m;
                        }
                    }
                    throw new RemoteOSGiException("Unimplemented op code for stream request " + msg);
                }
                catch (IOException e) {
                    StreamResultMessage m = new StreamResultMessage();
                    m.setXID(reqMsg.getXID());
                    m.setResult((short)-3);
                    m.setException(e);
                    return m;
                }
            }
        }
        throw new RemoteOSGiException("Unimplemented message " + msg);
    }

    private InputStreamHandle getInputStreamPlaceholder(InputStream origIS) {
        InputStreamHandle sp = new InputStreamHandle(this.nextStreamID());
        this.streams.put(new Integer(sp.getStreamID()), origIS);
        return sp;
    }

    private InputStream getInputStreamProxy(InputStreamHandle placeholder) {
        return new InputStreamProxy(placeholder.getStreamID(), this);
    }

    private OutputStreamHandle getOutputStreamPlaceholder(OutputStream origOS) {
        OutputStreamHandle sp = new OutputStreamHandle(this.nextStreamID());
        this.streams.put(new Integer(sp.getStreamID()), origOS);
        return sp;
    }

    private OutputStream getOutputStreamProxy(OutputStreamHandle placeholder) {
        return new OutputStreamProxy(placeholder.getStreamID(), this);
    }

    private synchronized short nextStreamID() {
        if (this.nextStreamID == -1) {
            this.nextStreamID = 0;
        }
        this.nextStreamID = (short)(this.nextStreamID + 1);
        return this.nextStreamID;
    }

    private void closeStreams() {
        Object[] s = this.streams.values().toArray();
        try {
            int i = 0;
            while (i < s.length) {
                if (s[i] instanceof InputStream) {
                    ((InputStream)s[i]).close();
                } else if (s[i] instanceof OutputStream) {
                    ((OutputStream)s[i]).close();
                } else {
                    RemoteOSGiServiceImpl.log.log(2, "Object in input streams map was not an instance of a stream.");
                }
                ++i;
            }
        }
        catch (IOException iOException) {}
    }

    private final class EventForwarder
    implements EventHandler {
        private EventForwarder() {
        }

        public void handleEvent(Event event) {
            try {
                RemoteEventMessage msg = new RemoteEventMessage();
                msg.setTopic(event.getTopic());
                String[] propertyNames = event.getPropertyNames();
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                int i = 0;
                while (i < propertyNames.length) {
                    ((Dictionary)props).put(propertyNames[i], event.getProperty(propertyNames[i]));
                    ++i;
                }
                ((Dictionary)props).put("sender.uri", ChannelEndpointImpl.this.networkChannel.getLocalAddress());
                msg.setProperties(props);
                ChannelEndpointImpl.this.send(msg);
                if (RemoteOSGiServiceImpl.MSG_DEBUG) {
                    RemoteOSGiServiceImpl.log.log(4, "Forwarding Event " + event);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

