/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.impl;

import ch.ethz.iks.r_osgi.Remoting;
import ch.ethz.iks.r_osgi.URI;
import ch.ethz.iks.r_osgi.channels.ChannelEndpoint;
import ch.ethz.iks.r_osgi.channels.NetworkChannel;
import ch.ethz.iks.r_osgi.channels.NetworkChannelFactory;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiServiceImpl;
import ch.ethz.iks.r_osgi.messages.RemoteOSGiMessage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;

final class TCPChannelFactory
implements NetworkChannelFactory {
    static final String PROTOCOL = "r-osgi";
    private Remoting remoting;
    private TCPThread thread;

    TCPChannelFactory() {
    }

    public NetworkChannel getConnection(ChannelEndpoint endpoint, URI endpointURI) throws IOException {
        return new TCPChannel(endpoint, endpointURI);
    }

    public void activate(Remoting remoting) throws IOException {
        this.remoting = remoting;
        this.thread = new TCPThread();
        this.thread.start();
    }

    public void deactivate(Remoting remoting) throws IOException {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.remoting = null;
    }

    private static final class TCPChannel
    implements NetworkChannel {
        private Socket socket;
        private final URI remoteEndpointAddress;
        private URI localEndpointAddress;
        private ObjectInputStream input;
        private ObjectOutputStream output;
        private ChannelEndpoint endpoint;
        private boolean connected = true;

        TCPChannel(ChannelEndpoint endpoint, URI endpointAddress) throws IOException {
            int port = endpointAddress.getPort();
            if (port == -1) {
                port = 9278;
            }
            this.endpoint = endpoint;
            this.remoteEndpointAddress = endpointAddress;
            this.open(new Socket(endpointAddress.getHost(), port));
            new ReceiverThread().start();
        }

        public TCPChannel(Socket socket) throws IOException {
            this.remoteEndpointAddress = URI.create(String.valueOf(this.getProtocol()) + "://" + socket.getInetAddress().getHostName() + ":" + socket.getPort());
            this.open(socket);
        }

        public void bind(ChannelEndpoint endpoint) {
            this.endpoint = endpoint;
            new ReceiverThread().start();
        }

        private void open(Socket socket) throws IOException {
            this.socket = socket;
            this.localEndpointAddress = URI.create(String.valueOf(this.getProtocol()) + "://" + socket.getLocalAddress().getHostName() + ":" + socket.getLocalPort());
            try {
                this.socket.setKeepAlive(true);
            }
            catch (Throwable throwable) {}
            this.socket.setTcpNoDelay(true);
            this.output = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            this.output.flush();
            this.input = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        }

        public String toString() {
            return "TCPChannel (" + this.getRemoteAddress() + ")";
        }

        public void close() throws IOException {
            this.socket.close();
            this.connected = false;
        }

        public String getProtocol() {
            return TCPChannelFactory.PROTOCOL;
        }

        public URI getRemoteAddress() {
            return this.remoteEndpointAddress;
        }

        public URI getLocalAddress() {
            return this.localEndpointAddress;
        }

        public void sendMessage(RemoteOSGiMessage message) throws IOException {
            if (RemoteOSGiServiceImpl.MSG_DEBUG) {
                RemoteOSGiServiceImpl.log.log(4, "{TCP Channel} sending " + message);
            }
            message.send(this.output);
        }

        private class ReceiverThread
        extends Thread {
            private ReceiverThread() {
                this.setName("TCPChannel:ReceiverThread:" + TCPChannel.this.getRemoteAddress());
                this.setDaemon(true);
            }

            public void run() {
                while (TCPChannel.this.connected) {
                    try {
                        RemoteOSGiMessage msg = RemoteOSGiMessage.parse(TCPChannel.this.input);
                        if (RemoteOSGiServiceImpl.MSG_DEBUG) {
                            RemoteOSGiServiceImpl.log.log(4, "{TCP Channel} received " + msg);
                        }
                        TCPChannel.this.endpoint.receivedMessage(msg);
                    }
                    catch (IOException iOException) {
                        TCPChannel.this.connected = false;
                        try {
                            TCPChannel.this.socket.close();
                        }
                        catch (IOException iOException2) {}
                        TCPChannel.this.endpoint.receivedMessage(null);
                        return;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
    }

    private final class TCPThread
    extends Thread {
        private ServerSocket socket;

        TCPThread() throws IOException {
            int e = 0;
            while (true) {
                try {
                    this.socket = new ServerSocket(RemoteOSGiServiceImpl.R_OSGI_PORT + e);
                    if (e != 0) {
                        System.err.println("Port " + RemoteOSGiServiceImpl.R_OSGI_PORT + " already in use. This instance of R-OSGi is running on port " + (RemoteOSGiServiceImpl.R_OSGI_PORT + e));
                    }
                    return;
                }
                catch (BindException bindException) {
                    ++e;
                    continue;
                }
                break;
            }
        }

        public void run() {
            while (!this.isInterrupted()) {
                try {
                    TCPChannelFactory.this.remoting.createEndpoint(new TCPChannel(this.socket.accept()));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }
}

