/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provisional.docshare.menu;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.internal.docshare.Activator;
import org.eclipse.ecf.internal.docshare.Messages;
import org.eclipse.ecf.internal.provisional.docshare.DocShare;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.ui.menu.AbstractRosterMenuHandler;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class DocShareRosterMenuHandler
extends AbstractRosterMenuHandler {
    static /* synthetic */ Class class$0;

    public DocShareRosterMenuHandler(IRosterEntry entry) {
        super(entry);
    }

    protected ITextEditor getTextEditor() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow ww = workbench.getActiveWorkbenchWindow();
        if (ww == null) {
            return null;
        }
        IWorkbenchPage wp = ww.getActivePage();
        if (wp == null) {
            return null;
        }
        IEditorPart ep = wp.getActiveEditor();
        if (ep instanceof ITextEditor) {
            return (ITextEditor)ep;
        }
        return null;
    }

    private String getFileName(IEditorPart editorPart) {
        IEditorInput input = editorPart.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fei = (IFileEditorInput)input;
            return fei.getName();
        }
        return null;
    }

    public Object execute(ExecutionEvent arg0) throws ExecutionException {
        IContainer container;
        IPresenceContainerAdapter iPresenceContainerAdapter = this.getRosterEntry().getRoster().getPresenceContainerAdapter();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.core.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((container = (IContainer)iPresenceContainerAdapter.getAdapter((Class)clazz)).getConnectedID() == null) {
            throw new ExecutionException(Messages.DocShareRosterMenuHandler_ERROR_NOT_CONNECTED);
        }
        DocShare sender = Activator.getDefault().getDocShare(container.getID());
        if (sender == null) {
            throw new ExecutionException(Messages.DocShareRosterMenuHandler_ERROR_NO_SENDER);
        }
        if (sender.isSharing()) {
            throw new ExecutionException(Messages.DocShareRosterMenuHandler_ERROR_EDITOR_ALREADY_SHARING);
        }
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            throw new ExecutionException(Messages.DocShareRosterMenuHandler_EXCEPTION_EDITOR_NOT_TEXT);
        }
        String fileName = this.getFileName((IEditorPart)textEditor);
        if (fileName == null) {
            throw new ExecutionException(Messages.DocShareRosterMenuHandler_NO_FILENAME_WITH_CONTENT);
        }
        IUser user = this.getRosterEntry().getRoster().getUser();
        sender.startShare(user.getID(), user.getName(), this.getRosterEntry().getUser().getID(), fileName, textEditor);
        return null;
    }
}

