/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui;

import org.eclipse.ecf.example.collab.share.User;
import org.eclipse.ecf.internal.example.collab.ui.ChatComposite;
import org.eclipse.ecf.internal.example.collab.ui.ChatDropTarget;
import org.eclipse.ecf.internal.example.collab.ui.LineChatClientView;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

class TreeDropTarget
extends ChatDropTarget {
    public TreeDropTarget(LineChatClientView view, Control control, ChatComposite comp) {
        super(view, control, comp);
    }

    protected Object getData(DropTargetEvent event) {
        Widget item = event.item;
        if (item != null) {
            return item.getData();
        }
        return null;
    }

    public void dragEnter(DropTargetEvent event) {
        Object item;
        if (event.detail == 16) {
            event.detail = (event.operations & 1) != 0 ? 1 : 0;
        }
        if ((item = this.getData(event)) == null) {
            event.detail = 0;
            return;
        }
        if (!(item instanceof User)) {
            event.detail = 0;
            return;
        }
        this.selectedUser = (User)item;
        int i = 0;
        while (i < event.dataTypes.length) {
            if (this.fileTransfer.isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                if (event.detail == 1) break;
                event.detail = 0;
                this.selectedUser = null;
                break;
            }
            ++i;
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = (event.operations & 1) != 0 ? 1 : 0;
        Object item = this.getData(event);
        if (item == null) {
            event.detail = 0;
        } else if (item instanceof User) {
            this.selectedUser = (User)item;
        } else {
            event.detail = 0;
        }
    }
}

