/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.browse;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.ObjectCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.IURLConnectionModifier;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.browse.AbstractFileSystemBrowser;
import org.eclipse.ecf.provider.filetransfer.browse.URLRemoteFile;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;

public class URLFileSystemBrowser
extends AbstractFileSystemBrowser {
    private static final String USERNAME_PREFIX = Messages.UrlConnectionRetrieveFileTransfer_USERNAME_PROMPT;
    URL directoryOrFile;
    IConnectContext connectContext;
    Proxy proxy;
    private JREProxyHelper proxyHelper = null;
    protected String username = null;
    protected String password = null;

    public URLFileSystemBrowser(IFileID directoryOrFileID, IRemoteFileSystemListener listener, URL directoryOrFileURL, IConnectContext connectContext, Proxy proxy) {
        super(directoryOrFileID, listener);
        this.directoryOrFile = directoryOrFileURL;
        this.connectContext = connectContext;
        this.proxy = proxy;
        this.proxyHelper = new JREProxyHelper();
    }

    protected void runRequest() throws Exception {
        this.setupProxies();
        this.setupAuthentication();
        URLConnection urlConnection = this.directoryOrFile.openConnection();
        IURLConnectionModifier connectionModifier = Activator.getDefault().getURLConnectionModifier();
        if (connectionModifier != null) {
            connectionModifier.setSocketFactoryForConnection(urlConnection);
        }
        InputStream ins = urlConnection.getInputStream();
        ins.close();
        this.remoteFiles = new IRemoteFile[1];
        this.remoteFiles[0] = new URLRemoteFile(urlConnection, this.fileID);
    }

    protected void setupAuthentication() throws IOException, UnsupportedCallbackException {
        if (this.connectContext == null) {
            return;
        }
        CallbackHandler callbackHandler = this.connectContext.getCallbackHandler();
        if (callbackHandler == null) {
            return;
        }
        NameCallback usernameCallback = new NameCallback(USERNAME_PREFIX);
        ObjectCallback passwordCallback = new ObjectCallback();
        callbackHandler.handle(new Callback[]{usernameCallback, passwordCallback});
        this.username = usernameCallback.getName();
        Object o = passwordCallback.getObject();
        if (!(o instanceof String)) {
            throw new UnsupportedCallbackException((Callback)passwordCallback, Messages.UrlConnectionRetrieveFileTransfer_UnsupportedCallbackException);
        }
        this.password = (String)passwordCallback.getObject();
        Authenticator.setDefault(new UrlConnectionAuthenticator());
    }

    protected void setupProxy(Proxy proxy2) {
        this.proxyHelper.setupProxy(proxy2);
    }

    protected IProxyData selectProxyFromProxies(String protocol, IProxyData[] proxies) {
        block7: {
            block6: {
                if (proxies == null || proxies.length == 0) {
                    return null;
                }
                if (proxies.length == 1) {
                    return proxies[0];
                }
                if (!protocol.equalsIgnoreCase("http")) break block6;
                int i = 0;
                while (i < proxies.length) {
                    if (proxies[i].getType().equals("HTTP")) {
                        return proxies[i];
                    }
                    ++i;
                }
                break block7;
            }
            if (!protocol.equalsIgnoreCase("https")) break block7;
            int i = 0;
            while (i < proxies.length) {
                if (proxies[i].getType().equals("HTTPS")) {
                    return proxies[i];
                }
                ++i;
            }
        }
        return proxies[0];
    }

    protected void setupProxies() {
        if (this.proxy == null) {
            try {
                IProxyService proxyService = Activator.getDefault().getProxyService();
                if (proxyService != null) {
                    URL target = this.directoryOrFile;
                    IProxyData[] proxies = proxyService.getProxyDataForHost(target.getHost());
                    IProxyData selectedProxy = this.selectProxyFromProxies(target.getProtocol(), proxies);
                    if (selectedProxy != null) {
                        this.proxy = new Proxy(selectedProxy.getType().equalsIgnoreCase("SOCKS") ? Proxy.Type.SOCKS : Proxy.Type.HTTP, new ProxyAddress(selectedProxy.getHost(), selectedProxy.getPort()), selectedProxy.getUserId(), selectedProxy.getPassword());
                    }
                }
            }
            catch (Exception e) {
                Activator.logNoProxyWarning(e);
            }
            catch (NoClassDefFoundError e) {
                Activator.logNoProxyWarning(e);
            }
        }
        if (this.proxy != null) {
            this.setupProxy(this.proxy);
        }
    }

    class UrlConnectionAuthenticator
    extends Authenticator {
        UrlConnectionAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(URLFileSystemBrowser.this.username, URLFileSystemBrowser.this.password.toCharArray());
        }
    }
}

