/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.impl;

import ch.ethz.iks.r_osgi.RemoteOSGiException;
import ch.ethz.iks.r_osgi.RemoteOSGiService;
import ch.ethz.iks.r_osgi.RemoteServiceEvent;
import ch.ethz.iks.r_osgi.RemoteServiceListener;
import ch.ethz.iks.r_osgi.RemoteServiceReference;
import ch.ethz.iks.r_osgi.Remoting;
import ch.ethz.iks.r_osgi.URI;
import ch.ethz.iks.r_osgi.channels.ChannelEndpoint;
import ch.ethz.iks.r_osgi.channels.ChannelEndpointManager;
import ch.ethz.iks.r_osgi.channels.NetworkChannel;
import ch.ethz.iks.r_osgi.channels.NetworkChannelFactory;
import ch.ethz.iks.r_osgi.impl.ChannelEndpointImpl;
import ch.ethz.iks.r_osgi.impl.ChannelEndpointMultiplexer;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiActivator;
import ch.ethz.iks.r_osgi.impl.RemoteServiceReferenceImpl;
import ch.ethz.iks.r_osgi.impl.RemoteServiceRegistration;
import ch.ethz.iks.r_osgi.messages.LeaseUpdateMessage;
import ch.ethz.iks.r_osgi.service_discovery.ServiceDiscoveryHandler;
import ch.ethz.iks.util.CollectionUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

final class RemoteOSGiServiceImpl
implements RemoteOSGiService,
Remoting {
    static boolean IS_5 = false;
    static int R_OSGI_PORT;
    static final String R_OSGi_PORT_PROPERTY = "ch.ethz.iks.r_osgi.port";
    static final String REGISTER_DEFAULT_TCP_CHANNEL = "ch.ethz.iks.r_osgi.registerDefaultChannel";
    static final String PROXY_DEBUG_PROPERTY = "ch.ethz.iks.r_osgi.debug.proxyGeneration";
    static final String MSG_DEBUG_PROPERTY = "ch.ethz.iks.r_osgi.debug.messages";
    static final String DEBUG_PROPERTY = "ch.ethz.iks.r_osgi.debug.internal";
    static final String R_OSGi_INTERNAL = "internal";
    static boolean PROXY_DEBUG;
    static boolean MSG_DEBUG;
    static boolean DEBUG;
    static String MY_ADDRESS;
    private static Map serviceRegistrations;
    private static short nextXid;
    static LogService log;
    static ServiceTracker eventAdminTracker;
    private static ServiceTracker eventHandlerTracker;
    private static ServiceTracker remoteServiceTracker;
    private static ServiceTracker remoteServiceListenerTracker;
    private static ServiceTracker networkChannelFactoryTracker;
    private static ServiceTracker serviceDiscoveryHandlerTracker;
    private static Map channels;
    private static Map multiplexers;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        String verString = System.getProperty("java.class.version");
        if (verString != null && Float.parseFloat(verString) >= 49.0f) {
            IS_5 = true;
        }
        R_OSGI_PORT = 9278;
        serviceRegistrations = new HashMap(1);
        channels = new HashMap(0);
        multiplexers = new HashMap(0);
    }

    RemoteOSGiServiceImpl() throws IOException {
        MY_ADDRESS = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())[0].getHostAddress();
        String prop = RemoteOSGiActivator.context.getProperty(PROXY_DEBUG_PROPERTY);
        PROXY_DEBUG = prop != null ? Boolean.valueOf(prop) : false;
        prop = RemoteOSGiActivator.context.getProperty(MSG_DEBUG_PROPERTY);
        MSG_DEBUG = prop != null ? Boolean.valueOf(prop) : false;
        prop = RemoteOSGiActivator.context.getProperty(DEBUG_PROPERTY);
        boolean bl = DEBUG = prop != null ? Boolean.valueOf(prop) : false;
        if (log != null) {
            if (PROXY_DEBUG) {
                log.log(3, "PROXY DEBUG OUTPUTS ENABLED");
            }
            if (MSG_DEBUG) {
                log.log(3, "MESSAGE DEBUG OUTPUTS ENABLED");
            }
            if (DEBUG) {
                log.log(3, "INTERNAL DEBUG OUTPUTS ENABLED");
            }
        } else if (PROXY_DEBUG || MSG_DEBUG || DEBUG) {
            System.err.println("NO LOG SERVICE PRESENT, DEBUG PROPERTIES HAVE NO EFFECT ...");
            PROXY_DEBUG = false;
            MSG_DEBUG = false;
            DEBUG = false;
        }
        R_OSGI_PORT = (prop = RemoteOSGiActivator.context.getProperty(R_OSGi_PORT_PROPERTY)) != null ? Integer.parseInt(prop) : 9278;
        nextXid = (short)Math.round(Math.random() * 32767.0);
        this.setupTrackers();
    }

    private void setupTrackers() throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.event.EventAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        eventAdminTracker = new ServiceTracker(RemoteOSGiActivator.context, clazz.getName(), null);
        eventAdminTracker.open();
        if (eventAdminTracker.getTrackingCount() == 0 && log != null) {
            log.log(2, "NO EVENT ADMIN FOUND. REMOTE EVENT DELIVERY TEMPORARILY DISABLED.");
        }
        try {
            Class<?> clazz2;
            StringBuffer stringBuffer = new StringBuffer("(&(objectClass=");
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.osgi.service.event.EventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            eventHandlerTracker = new ServiceTracker(RemoteOSGiActivator.context, RemoteOSGiActivator.context.createFilter(stringBuffer.append(clazz3.getName()).append(")(!(").append(R_OSGi_INTERNAL).append("=*)))").toString()), new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    String[] theTopics = (String[])reference.getProperty("event.topics");
                    LeaseUpdateMessage lu = new LeaseUpdateMessage();
                    lu.setType((short)0);
                    lu.setServiceID("");
                    Object[] objectArray = new Object[2];
                    objectArray[0] = theTopics;
                    lu.setPayload(objectArray);
                    RemoteOSGiServiceImpl.updateLeases(lu);
                    return Arrays.asList(theTopics);
                }

                public void modifiedService(ServiceReference reference, Object oldTopics) {
                    List oldTopicList = (List)oldTopics;
                    List<String> newTopicList = Arrays.asList((String[])reference.getProperty("event.topics"));
                    Collection removed = CollectionUtils.rightDifference(newTopicList, oldTopicList);
                    Collection added = CollectionUtils.leftDifference(newTopicList, oldTopicList);
                    String[] addedTopics = added.toArray(new String[removed.size()]);
                    String[] removedTopics = removed.toArray(addedTopics);
                    oldTopicList.removeAll(removed);
                    oldTopicList.addAll(added);
                    LeaseUpdateMessage lu = new LeaseUpdateMessage();
                    lu.setType((short)0);
                    lu.setServiceID("");
                    lu.setPayload(new Object[]{addedTopics, removedTopics});
                    RemoteOSGiServiceImpl.updateLeases(lu);
                }

                public void removedService(ServiceReference reference, Object oldTopics) {
                    List oldTopicsList = (List)oldTopics;
                    String[] removedTopics = oldTopicsList.toArray(new String[oldTopicsList.size()]);
                    LeaseUpdateMessage lu = new LeaseUpdateMessage();
                    lu.setType((short)0);
                    lu.setServiceID("");
                    Object[] objectArray = new Object[2];
                    objectArray[1] = removedTopics;
                    lu.setPayload(objectArray);
                    RemoteOSGiServiceImpl.updateLeases(lu);
                }
            });
            eventHandlerTracker.open();
            if (DEBUG) {
                log.log(4, "Local topic space " + Arrays.asList(RemoteOSGiServiceImpl.getTopics()));
            }
            if ((clazz2 = class$2) == null) {
                try {
                    clazz2 = class$2 = Class.forName("ch.ethz.iks.r_osgi.RemoteServiceListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            remoteServiceListenerTracker = new ServiceTracker(RemoteOSGiActivator.context, clazz2.getName(), null);
            remoteServiceListenerTracker.open();
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("ch.ethz.iks.r_osgi.service_discovery.ServiceDiscoveryHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            serviceDiscoveryHandlerTracker = new ServiceTracker(RemoteOSGiActivator.context, clazz4.getName(), new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    ServiceDiscoveryHandler handler = (ServiceDiscoveryHandler)RemoteOSGiActivator.context.getService(reference);
                    RemoteServiceRegistration[] regs = serviceRegistrations.values().toArray(new RemoteServiceRegistration[serviceRegistrations.size()]);
                    int i = 0;
                    while (i < regs.length) {
                        handler.registerService(regs[i].getReference(), regs[i].getProperties(), URI.create("r-osgi://" + MY_ADDRESS + ":" + R_OSGI_PORT + "#" + regs[i].getServiceID()));
                        ++i;
                    }
                    return handler;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                }

                public void removedService(ServiceReference reference, Object service) {
                }
            });
            serviceDiscoveryHandlerTracker.open();
            remoteServiceTracker = new ServiceTracker(RemoteOSGiActivator.context, RemoteOSGiActivator.context.createFilter("(service.remote.registration=*)"), new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    List<String> list = Arrays.asList((String[])reference.getProperty("objectClass"));
                    Class<?> clazz = class$4;
                    if (clazz == null) {
                        try {
                            clazz = class$4 = Class.forName("ch.ethz.iks.r_osgi.SurrogateRegistration");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ServiceReference service = list.contains(clazz.getName()) ? (ServiceReference)reference.getProperty("legacy.service.reference") : reference;
                    try {
                        RemoteServiceRegistration reg = new RemoteServiceRegistration(reference, service);
                        if (log != null) {
                            log.log(3, "REGISTERING " + reference + " AS PROXIED SERVICES");
                        }
                        serviceRegistrations.put(service, reg);
                        RemoteOSGiServiceImpl.this.registerWithServiceDiscovery(reg);
                        LeaseUpdateMessage lu = new LeaseUpdateMessage();
                        lu.setType((short)1);
                        lu.setServiceID(String.valueOf(reg.getServiceID()));
                        lu.setPayload(new Object[]{reg.getInterfaceNames(), reg.getProperties()});
                        RemoteOSGiServiceImpl.updateLeases(lu);
                        return service;
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        throw new RemoteOSGiException("Cannot find class " + service, e);
                    }
                }

                public void modifiedService(ServiceReference reference, Object service) {
                    if (reference.getProperty("service.remote.registration") == null) {
                        this.removedService(reference, service);
                        return;
                    }
                    RemoteServiceRegistration reg = (RemoteServiceRegistration)serviceRegistrations.get(reference);
                    RemoteOSGiServiceImpl.this.registerWithServiceDiscovery(reg);
                    LeaseUpdateMessage lu = new LeaseUpdateMessage();
                    lu.setType((short)2);
                    lu.setServiceID(String.valueOf(reg.getServiceID()));
                    Object[] objectArray = new Object[2];
                    objectArray[1] = reg.getProperties();
                    lu.setPayload(objectArray);
                    RemoteOSGiServiceImpl.updateLeases(lu);
                }

                public void removedService(ServiceReference reference, Object service) {
                    List<String> list = Arrays.asList((String[])reference.getProperty("objectClass"));
                    Class<?> clazz = class$4;
                    if (clazz == null) {
                        try {
                            clazz = class$4 = Class.forName("ch.ethz.iks.r_osgi.SurrogateRegistration");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ServiceReference sref = list.contains(clazz.getName()) ? (ServiceReference)reference.getProperty("legacy.service.reference") : reference;
                    RemoteServiceRegistration reg = (RemoteServiceRegistration)serviceRegistrations.remove(sref);
                    RemoteOSGiServiceImpl.this.unregisterFromServiceDiscovery(reg);
                    LeaseUpdateMessage lu = new LeaseUpdateMessage();
                    lu.setType((short)3);
                    lu.setServiceID(String.valueOf(reg.getServiceID()));
                    lu.setPayload(new Object[2]);
                    RemoteOSGiServiceImpl.updateLeases(lu);
                }
            });
            remoteServiceTracker.open();
            StringBuffer stringBuffer2 = new StringBuffer("(objectClass=");
            Class<?> clazz5 = class$5;
            if (clazz5 == null) {
                try {
                    clazz5 = class$5 = Class.forName("ch.ethz.iks.r_osgi.channels.NetworkChannelFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            networkChannelFactoryTracker = new ServiceTracker(RemoteOSGiActivator.context, RemoteOSGiActivator.context.createFilter(stringBuffer2.append(clazz5.getName()).append(")").toString()), new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    NetworkChannelFactory factory;
                    block2: {
                        factory = (NetworkChannelFactory)RemoteOSGiActivator.context.getService(reference);
                        try {
                            factory.activate(RemoteOSGiServiceImpl.this);
                        }
                        catch (IOException ioe) {
                            if (log == null) break block2;
                            log.log(1, ioe.getMessage(), (Throwable)ioe);
                        }
                    }
                    return factory;
                }

                public void modifiedService(ServiceReference reference, Object factory) {
                }

                public void removedService(ServiceReference reference, Object factory) {
                }
            });
            networkChannelFactoryTracker.open();
        }
        catch (InvalidSyntaxException ise) {
            ise.printStackTrace();
        }
    }

    public RemoteServiceReference[] connect(URI uri) throws RemoteOSGiException, IOException {
        URI endpoint = URI.create(RemoteOSGiServiceImpl.getChannelURI(uri));
        ChannelEndpointImpl test = (ChannelEndpointImpl)channels.get(endpoint.toString());
        if (test != null) {
            ++test.usageCounter;
            return test.getAllRemoteReferences(null);
        }
        try {
            String protocol = endpoint.getScheme();
            Filter filter = RemoteOSGiActivator.context.createFilter("(protocol=" + protocol + ")");
            ServiceReference[] refs = networkChannelFactoryTracker.getServiceReferences();
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    if (filter.match(refs[i])) {
                        NetworkChannelFactory factory = (NetworkChannelFactory)networkChannelFactoryTracker.getService(refs[i]);
                        ChannelEndpointImpl channel = new ChannelEndpointImpl(factory, endpoint);
                        return channel.sendLease(RemoteOSGiServiceImpl.getServices(), RemoteOSGiServiceImpl.getTopics());
                    }
                    ++i;
                }
            }
            throw new RemoteOSGiException("No NetworkChannelFactory for " + protocol + " found.");
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void disconnect(URI endpoint) throws RemoteOSGiException {
        String channelURI = RemoteOSGiServiceImpl.getChannelURI(endpoint).toString();
        ChannelEndpointImpl channel = (ChannelEndpointImpl)channels.get(channelURI);
        if (channel != null) {
            if (channel.usageCounter == 1) {
                channel.dispose();
                multiplexers.remove(channelURI);
            } else {
                --channel.usageCounter;
            }
        }
    }

    public RemoteServiceReference getRemoteServiceReference(URI serviceURI) {
        String uri = RemoteOSGiServiceImpl.getChannelURI(serviceURI);
        ChannelEndpointImpl channel = (ChannelEndpointImpl)channels.get(RemoteOSGiServiceImpl.getChannelURI(serviceURI));
        if (channel == null) {
            try {
                this.connect(serviceURI);
                channel = (ChannelEndpointImpl)channels.get(uri);
            }
            catch (IOException iOException) {
                throw new RemoteOSGiException("Cannot connect to " + uri);
            }
        }
        return channel.getRemoteReference(serviceURI.toString());
    }

    public RemoteServiceReference[] getRemoteServiceReferences(URI service, String clazz, Filter filter) {
        String uri = RemoteOSGiServiceImpl.getChannelURI(service);
        ChannelEndpointImpl channel = (ChannelEndpointImpl)channels.get(uri);
        if (channel == null) {
            try {
                this.connect(service);
                channel = (ChannelEndpointImpl)channels.get(uri);
            }
            catch (IOException iOException) {
                throw new RemoteOSGiException("Cannot connect to " + uri);
            }
        }
        if (clazz == null) {
            return channel.getAllRemoteReferences(null);
        }
        try {
            return channel.getAllRemoteReferences(RemoteOSGiActivator.context.createFilter(filter != null ? "(&" + filter + "(" + "objectClass" + "=" + clazz + "))" : "(objectClass=" + clazz + ")"));
        }
        catch (InvalidSyntaxException ise) {
            ise.printStackTrace();
            return null;
        }
    }

    public Object getRemoteService(RemoteServiceReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Remote Reference is null.");
        }
        ServiceReference sref = this.getFetchedServiceReference(ref);
        if (sref == null) {
            this.fetchService(ref);
            sref = this.getFetchedServiceReference(ref);
        }
        return sref == null ? null : RemoteOSGiActivator.context.getService(sref);
    }

    private ServiceReference getFetchedServiceReference(RemoteServiceReference ref) {
        try {
            ServiceReference[] refs = RemoteOSGiActivator.context.getServiceReferences(ref.getServiceInterfaces()[0], "(service.uri=" + ref.getURI() + ")");
            if (refs != null) {
                return refs[0];
            }
        }
        catch (InvalidSyntaxException doesNotHappen) {
            doesNotHappen.printStackTrace();
        }
        return null;
    }

    private void fetchService(RemoteServiceReference ref) throws RemoteOSGiException {
        try {
            ChannelEndpointImpl channel = ((RemoteServiceReferenceImpl)ref).getChannel();
            channel.fetchService(ref);
        }
        catch (UnknownHostException e) {
            throw new RemoteOSGiException("Cannot resolve host " + ref.getURI(), e);
        }
        catch (IOException ioe) {
            throw new RemoteOSGiException("Proxy generation error", ioe);
        }
    }

    static ChannelEndpoint getChannel(URI uri) {
        return (ChannelEndpoint)channels.get(RemoteOSGiServiceImpl.getChannelURI(uri));
    }

    public ChannelEndpoint getEndpoint(String uri) {
        return this.getMultiplexer(uri);
    }

    public ChannelEndpointManager getEndpointManager(URI remoteEndpointAddress) {
        return this.getMultiplexer(remoteEndpointAddress.toString());
    }

    private ChannelEndpointMultiplexer getMultiplexer(String uri) {
        String channel = RemoteOSGiServiceImpl.getChannelURI(URI.create(uri));
        ChannelEndpointMultiplexer multiplexer = (ChannelEndpointMultiplexer)multiplexers.get(channel);
        if (multiplexer == null) {
            multiplexer = new ChannelEndpointMultiplexer((ChannelEndpointImpl)channels.get(channel));
            multiplexers.put(channel, multiplexer);
        }
        return multiplexer;
    }

    private static String getChannelURI(URI serviceURI) {
        return URI.create(String.valueOf(serviceURI.getScheme()) + "://" + serviceURI.getHost() + ":" + serviceURI.getPort()).toString();
    }

    void cleanup() {
        ChannelEndpoint[] c = channels.values().toArray(new ChannelEndpoint[channels.size()]);
        channels.clear();
        int i = 0;
        while (i < c.length) {
            c[i].dispose();
            ++i;
        }
        Object[] factories = networkChannelFactoryTracker.getServices();
        int i2 = 0;
        while (i2 < factories.length) {
            block4: {
                try {
                    ((NetworkChannelFactory)factories[i2]).deactivate(this);
                }
                catch (IOException ioe) {
                    if (log == null) break block4;
                    log.log(1, ioe.getMessage(), (Throwable)ioe);
                }
            }
            ++i2;
        }
        eventAdminTracker.close();
        remoteServiceTracker.close();
        serviceDiscoveryHandlerTracker.close();
        remoteServiceListenerTracker.close();
        networkChannelFactoryTracker.close();
    }

    static RemoteServiceRegistration[] getServices() {
        return serviceRegistrations.values().toArray(new RemoteServiceRegistration[serviceRegistrations.size()]);
    }

    static RemoteServiceRegistration getServiceRegistration(String serviceID) {
        ServiceReference[] refs;
        block4: {
            String filter = "".equals(serviceID) ? null : "(service.id=" + serviceID + ")";
            try {
                refs = RemoteOSGiActivator.context.getServiceReferences(null, filter);
                if (refs != null) break block4;
                if (log != null) {
                    log.log(2, "COULD NOT FIND " + filter);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
        return (RemoteServiceRegistration)serviceRegistrations.get(refs[0]);
    }

    static String[] getTopics() {
        Object[] topicLists = eventHandlerTracker.getServices();
        ArrayList topics = new ArrayList();
        if (topicLists != null) {
            int i = 0;
            while (i < topicLists.length) {
                topics.addAll((List)topicLists[i]);
                ++i;
            }
        }
        return topics.toArray(new String[topics.size()]);
    }

    static synchronized short nextXid() {
        if (nextXid == -1) {
            nextXid = 0;
        }
        nextXid = (short)(nextXid + 1);
        return nextXid;
    }

    static void registerChannelEndpoint(ChannelEndpoint channel) {
        channels.put(channel.getRemoteAddress().toString(), channel);
    }

    static void unregisterChannelEndpoint(String channelURI) {
        channels.remove(channelURI);
    }

    static void updateLeases(LeaseUpdateMessage msg) {
        ChannelEndpointImpl[] endpoints = channels.values().toArray(new ChannelEndpointImpl[channels.size()]);
        int i = 0;
        while (i < endpoints.length) {
            endpoints[i].sendLeaseUpdate(msg);
            ++i;
        }
    }

    static void notifyRemoteServiceListeners(RemoteServiceEvent event) {
        ServiceReference[] refs = remoteServiceListenerTracker.getServiceReferences();
        if (refs == null) {
            return;
        }
        HashSet<String> serviceIfaces = new HashSet<String>(Arrays.asList(event.getRemoteReference().getServiceInterfaces()));
        int i = 0;
        while (i < refs.length) {
            String[] ifaces = (String[])refs[i].getProperty("listener.service_interfaces");
            if (ifaces == null) {
                RemoteOSGiServiceImpl.match(refs[i], event);
            } else {
                int j = 0;
                while (j < ifaces.length) {
                    if (serviceIfaces.contains(ifaces[j])) {
                        RemoteOSGiServiceImpl.match(refs[i], event);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static void match(ServiceReference ref, RemoteServiceEvent event) {
        RemoteServiceListener listener;
        Filter filter = (Filter)ref.getProperty("listener.filter");
        if ((filter == null || filter.match(((RemoteServiceReferenceImpl)event.getRemoteReference()).getProperties())) && (listener = (RemoteServiceListener)remoteServiceListenerTracker.getService(ref)) != null) {
            listener.remoteServiceEvent(event);
        }
    }

    private void registerWithServiceDiscovery(RemoteServiceRegistration reg) {
        Dictionary props = reg.getProperties();
        Object[] handler = serviceDiscoveryHandlerTracker.getServices();
        if (handler != null) {
            int i = 0;
            while (i < handler.length) {
                ((ServiceDiscoveryHandler)handler[i]).registerService(reg.getReference(), props, URI.create("r-osgi://" + MY_ADDRESS + ":" + R_OSGI_PORT + "#" + reg.getServiceID()));
                ++i;
            }
        }
    }

    private void unregisterFromServiceDiscovery(RemoteServiceRegistration reg) {
        Object[] handler = serviceDiscoveryHandlerTracker.getServices();
        if (handler != null) {
            int i = 0;
            while (i < handler.length) {
                ((ServiceDiscoveryHandler)handler[i]).unregisterService(reg.getReference());
                ++i;
            }
        }
    }

    public void createEndpoint(NetworkChannel channel) {
        new ChannelEndpointImpl(channel);
    }

    public void ungetRemoteService(RemoteServiceReference remoteServiceReference) {
        ((RemoteServiceReferenceImpl)remoteServiceReference).getChannel().ungetRemoteService(remoteServiceReference.getURI());
    }
}

