/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ui.deprecated.views;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.ui.Activator;
import org.eclipse.ecf.internal.ui.deprecated.views.ChatLine;
import org.eclipse.ecf.internal.ui.deprecated.views.IChatRoomViewCloseListener;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomInfo;
import org.eclipse.ecf.presence.chatroom.IChatRoomInvitationListener;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageSender;
import org.eclipse.ecf.presence.im.IChatID;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ChatRoomView
extends ViewPart
implements IChatRoomInvitationListener {
    public static final String VIEW_ID = "org.eclipse.ecf.ui.views.ChatRoomView";
    private static final String USERNAME_HOST_DELIMETER = "@";
    private static final int RATIO_WRITE_PANE = 2;
    private static final int RATIO_READ_PANE = 7;
    private static final int RATIO_READ_WRITE_PANE = 85;
    private static final int RATIO_PRESENCE_PANE = 15;
    protected static final String DEFAULT_ME_COLOR = "0,255,0";
    protected static final String DEFAULT_OTHER_COLOR = "0,0,0";
    protected static final String DEFAULT_SYSTEM_COLOR = "0,0,255";
    protected static final String DEFAULT_DATE_COLOR = "0,0,0";
    protected static final String VIEW_PREFIX = "Chat: ";
    protected static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    protected static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    protected static final int DEFAULT_INPUT_HEIGHT = 25;
    protected static final int DEFAULT_INPUT_SEPARATOR = 5;
    private Composite mainComp = null;
    private IChatRoomInfo roomInfo = null;
    private Text writeText = null;
    private StyledText readText = null;
    private ListViewer memberViewer = null;
    IChatRoomViewCloseListener closeListener = null;
    IChatRoomMessageSender messageSender = null;
    IChatRoomContainer chatRoomContainer = null;
    String viewID = null;
    private Color meColor = null;
    private Color otherColor = null;
    private Color systemColor = null;
    private Color dateColor = null;
    private IUser localUser = null;
    private List otherUsers = Collections.synchronizedList(new ArrayList());
    Action outputClear = null;
    Action outputCopy = null;
    Action outputPaste = null;
    Action outputSelectAll = null;
    boolean disposed = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private Color colorFromRGBString(String rgb) {
        Color color = null;
        if (rgb == null || rgb.equals("")) {
            color = new Color((Device)this.getViewSite().getShell().getDisplay(), 0, 0, 0);
            return color;
        }
        if (color != null) {
            color.dispose();
        }
        StringTokenizer st = new StringTokenizer(rgb, ",");
        String[] vals = new String[3];
        int i = 0;
        while (i < 3) {
            vals[i] = st.nextToken();
            ++i;
        }
        color = new Color((Device)this.getViewSite().getShell().getDisplay(), Integer.parseInt(vals[0]), Integer.parseInt(vals[1]), Integer.parseInt(vals[2]));
        return color;
    }

    public void createPartControl(Composite parent) {
        this.meColor = this.colorFromRGBString(DEFAULT_ME_COLOR);
        this.otherColor = this.colorFromRGBString("0,0,0");
        this.systemColor = this.colorFromRGBString(DEFAULT_SYSTEM_COLOR);
        this.dateColor = this.colorFromRGBString("0,0,0");
        this.mainComp = new Composite(parent, 0);
        this.mainComp.setLayout((Layout)new FillLayout());
        SashForm form = new SashForm(this.mainComp, 256);
        form.setLayout((Layout)new FillLayout());
        Composite memberComp = new Composite((Composite)form, 0);
        memberComp.setLayout((Layout)new FillLayout());
        this.memberViewer = new ListViewer(memberComp, 2816);
        Composite rightComp = new Composite((Composite)form, 0);
        rightComp.setLayout((Layout)new FillLayout());
        SashForm rightSash = new SashForm(rightComp, 512);
        rightSash.setLayout((Layout)new FillLayout());
        Composite readComp = new Composite((Composite)rightSash, 2048);
        readComp.setLayout((Layout)new FillLayout());
        Composite readInlayComp = new Composite(readComp, 0);
        readInlayComp.setLayout((Layout)new GridLayout());
        readInlayComp.setLayoutData((Object)new GridData(1808));
        readInlayComp.setBackground(this.memberViewer.getList().getBackground());
        this.readText = this.createStyledTextWidget(readInlayComp);
        this.readText.setEditable(false);
        this.readText.setLayoutData((Object)new GridData(1808));
        Composite writeComp = new Composite((Composite)rightSash, 0);
        writeComp.setLayout((Layout)new FillLayout());
        this.writeText = new Text(writeComp, 2626);
        this.writeText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent evt) {
                ChatRoomView.this.handleKeyPressed(evt);
            }

            public void keyReleased(KeyEvent evt) {
                ChatRoomView.this.handleKeyReleased(evt);
            }
        });
        form.setWeights(new int[]{15, 85});
        rightSash.setWeights(new int[]{7, 2});
        this.setEnabled(false);
        this.makeActions();
        this.hookContextMenu();
    }

    private StyledText createStyledTextWidget(Composite parent) {
        try {
            SourceViewer result = new SourceViewer(parent, null, null, true, 2634);
            result.configure((SourceViewerConfiguration)new TextSourceViewerConfiguration(EditorsUI.getPreferenceStore()));
            result.setDocument((IDocument)new Document());
            return result.getTextWidget();
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.ui", 2, "Source viewer not available.  Hyperlinking will be disabled.", (Throwable)e));
            return new StyledText(parent, 2634);
        }
        catch (NoClassDefFoundError e) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.ui", 2, "Source viewer not available.  Hyperlinking will be disabled.", (Throwable)e));
            return new StyledText(parent, 2634);
        }
    }

    protected void setEnabled(boolean enabled) {
        if (!this.writeText.isDisposed()) {
            this.writeText.setEnabled(enabled);
        }
    }

    protected void clearInput() {
        this.writeText.setText("");
    }

    protected void handleTextInput(String text) {
        if (this.messageSender == null) {
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Not connect", (String)"Not connected to chat room");
            return;
        }
        try {
            this.messageSender.sendMessage(text);
        }
        catch (ECFException eCFException) {
            this.removeLocalUser();
        }
    }

    protected void handleEnter() {
        if (this.writeText.getText().trim().length() > 0) {
            this.handleTextInput(this.writeText.getText());
        }
        this.clearInput();
    }

    protected void handleKeyPressed(KeyEvent evt) {
        if (evt.character == '\r') {
            this.handleEnter();
            evt.doit = false;
        }
    }

    protected void handleKeyReleased(KeyEvent evt) {
    }

    public void setFocus() {
        this.writeText.setFocus();
    }

    public IChatRoomInfo getRoomInfo() {
        return this.roomInfo;
    }

    public void initialize(final IChatRoomViewCloseListener parent, final String secondaryID, final IChatRoomContainer container, final IChatRoomInfo info, final IChatRoomMessageSender sender) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ChatRoomView.this.removeAllParticipants();
                ChatRoomView.this.otherUsers.clear();
                ChatRoomView.this.localUser = null;
                ChatRoomView.this.viewID = secondaryID;
                ChatRoomView.this.closeListener = parent;
                ChatRoomView.this.chatRoomContainer = container;
                ChatRoomView.this.messageSender = sender;
                ChatRoomView.this.roomInfo = info;
                ID roomID = info.getRoomID();
                ChatRoomView.this.setPartName(ChatRoomView.VIEW_PREFIX + ChatRoomView.this.roomInfo.getName());
                ChatRoomView.this.setTitleToolTip("Room ID: " + roomID.getName() + ", Description: " + ChatRoomView.this.roomInfo.getDescription());
                ChatRoomView.this.setEnabled(true);
            }
        });
    }

    public void dispose() {
        this.disposed = true;
        this.cleanUp();
        super.dispose();
    }

    protected String getMessageString(ID fromID, String text) {
        return String.valueOf(fromID.getName()) + ": " + text + "\n";
    }

    public void handleMessage(final ID fromID, final String messageBody) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ChatRoomView.this.disposed) {
                    return;
                }
                ChatRoomView.this.appendText(new ChatLine(messageBody, new Participant(fromID)));
            }
        });
    }

    private String trimUserID(ID userID) {
        IChatID chatID;
        URI aURI = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.presence.im.IChatID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((chatID = (IChatID)userID.getAdapter((Class)clazz)) != null) {
            return chatID.getUsername();
        }
        try {
            aURI = new URI(userID.getName());
        }
        catch (URISyntaxException uRISyntaxException) {
            aURI = null;
        }
        if (aURI != null) {
            String user = aURI.getUserInfo();
            if (user != null) {
                return user;
            }
            return userID.getName();
        }
        String userathost = userID.getName();
        int atIndex = userathost.lastIndexOf(USERNAME_HOST_DELIMETER);
        if (atIndex != -1) {
            userathost = userathost.substring(0, atIndex);
        }
        return userathost;
    }

    protected String getCurrentDate(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        String res = sdf.format(new Date());
        return res;
    }

    protected String getDateTime() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getCurrentDate(DEFAULT_DATE_FORMAT)).append(" ").append(this.getCurrentDate(DEFAULT_TIME_FORMAT));
        return buf.toString();
    }

    protected void addParticipant(IUser p) {
        ID id;
        if (p != null && (id = p.getID()) != null) {
            this.appendText(new ChatLine("(" + this.getDateTime() + ") " + this.trimUserID(id) + " entered", null));
            this.memberViewer.add((Object)p);
        }
    }

    protected boolean isLocalUser(ID id) {
        if (this.localUser == null) {
            return false;
        }
        return this.localUser.getID().equals((Object)id);
    }

    protected void cleanUp() {
        if (this.closeListener != null) {
            this.closeListener.chatRoomViewClosing(this.viewID);
            this.closeListener = null;
            this.viewID = null;
            this.chatRoomContainer = null;
            this.messageSender = null;
            this.roomInfo = null;
        }
        this.otherUsers.clear();
        this.localUser = null;
    }

    protected void removeLocalUser() {
        String title = this.getPartName();
        this.setPartName("(" + title + ")");
        this.removeAllParticipants();
        this.cleanUp();
        this.setEnabled(false);
    }

    protected void removeParticipant(IUser p) {
        ID id;
        if (p != null && (id = p.getID()) != null) {
            this.appendText(new ChatLine("(" + this.getDateTime() + ") " + this.trimUserID(id) + " left", null));
            this.memberViewer.remove((Object)p);
            if (this.isLocalUser(id)) {
                this.removeLocalUser();
            }
        }
    }

    protected void removeAllParticipants() {
        org.eclipse.swt.widgets.List l = this.memberViewer.getList();
        int i = 0;
        while (i < l.getItemCount()) {
            Object o = this.memberViewer.getElementAt(i);
            if (o != null) {
                this.memberViewer.remove(o);
            }
            ++i;
        }
    }

    public void handlePresence(final ID fromID, final IPresence presence) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (ChatRoomView.this.disposed) {
                    return;
                }
                boolean isAdd = presence.getType().equals((Object)IPresence.Type.AVAILABLE);
                Participant p = new Participant(fromID);
                if (isAdd) {
                    if (ChatRoomView.this.localUser == null && !ChatRoomView.this.otherUsers.contains(fromID)) {
                        ChatRoomView.this.localUser = p;
                    }
                    ChatRoomView.this.addParticipant(p);
                } else {
                    ChatRoomView.this.removeParticipant(p);
                    if (ChatRoomView.this.isLocalUser(fromID)) {
                        ChatRoomView.this.removeLocalUser();
                    }
                }
            }
        });
    }

    public void handleInvitationReceived(ID roomID, ID from, String subject, String body) {
        System.out.println("invitation room=" + roomID + ",from=" + from + ",subject=" + subject + ",body=" + body);
    }

    protected void appendText(ChatLine text) {
        String t;
        StyleRange sr;
        StyledText st = this.readText;
        if (text == null || this.readText == null || st == null) {
            return;
        }
        int startRange = st.getText().length();
        StringBuffer sb = new StringBuffer();
        if (text.getOriginator() != null) {
            sb.append("(").append(this.getCurrentDate(DEFAULT_TIME_FORMAT)).append(") ");
            StyleRange dateStyle = new StyleRange();
            dateStyle.start = startRange;
            dateStyle.length = sb.length();
            dateStyle.foreground = this.dateColor;
            dateStyle.fontStyle = 0;
            st.append(sb.toString());
            st.setStyleRange(dateStyle);
            sb = new StringBuffer();
            sb.append(text.getOriginator().getName()).append(": ");
            sr = new StyleRange();
            sr.start = startRange + dateStyle.length;
            sr.length = sb.length();
            sr.fontStyle = 1;
            sr.foreground = this.localUser != null && this.localUser.getID().equals((Object)text.getOriginator().getID()) ? this.meColor : this.otherColor;
            st.append(sb.toString());
            st.setStyleRange(sr);
        }
        int beforeMessageIndex = st.getText().length();
        st.append(text.getText());
        if (text.getOriginator() == null) {
            sr = new StyleRange();
            sr.start = beforeMessageIndex;
            sr.length = text.getText().length();
            sr.foreground = this.systemColor;
            sr.fontStyle = 1;
            st.setStyleRange(sr);
        }
        if (!text.isNoCRLF()) {
            st.append("\n");
        }
        if ((t = st.getText()) == null) {
            return;
        }
        st.setSelection(t.length());
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWorkbenchSiteProgressService pservice = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getAdapter((Class)clazz);
        pservice.warnOfContentChange();
    }

    protected void outputClear() {
        if (MessageDialog.openConfirm(null, (String)"Confirm Clear Text Output", (String)"Are you sure you want to clear output?")) {
            this.readText.setText("");
        }
    }

    protected void outputCopy() {
        String t = this.readText.getSelectionText();
        if (t == null || t.length() == 0) {
            this.readText.selectAll();
        }
        this.readText.copy();
        this.readText.setSelection(this.readText.getText().length());
    }

    protected void outputPaste() {
        this.writeText.paste();
    }

    public void handleJoin(IUser user) {
        if (this.disposed) {
            return;
        }
        this.otherUsers.add(user.getID());
    }

    public void handleLeave(IUser user) {
        if (this.disposed) {
            return;
        }
        this.otherUsers.remove(user.getID());
    }

    public void handleUpdated(IUser user) {
    }

    protected void outputSelectAll() {
        this.readText.selectAll();
    }

    protected void makeActions() {
        this.outputSelectAll = new Action(){

            public void run() {
                ChatRoomView.this.outputSelectAll();
            }
        };
        this.outputSelectAll.setText("Select All");
        this.outputSelectAll.setToolTipText("Select All");
        this.outputSelectAll.setAccelerator(262209);
        this.outputCopy = new Action(){

            public void run() {
                ChatRoomView.this.outputCopy();
            }
        };
        this.outputCopy.setText("Copy");
        this.outputCopy.setToolTipText("Copy Selected");
        this.outputCopy.setAccelerator(262211);
        this.outputCopy.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"));
        this.outputClear = new Action(){

            public void run() {
                ChatRoomView.this.outputClear();
            }
        };
        this.outputClear.setText("Clear");
        this.outputClear.setToolTipText("Clear output window");
        this.outputPaste = new Action(){

            public void run() {
                ChatRoomView.this.outputPaste();
            }
        };
        this.outputPaste.setText("Paste");
        this.outputPaste.setToolTipText("Paste");
        this.outputPaste.setAccelerator(262230);
        this.outputPaste.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.outputCopy);
        manager.add((IAction)this.outputPaste);
        manager.add((IAction)this.outputClear);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.outputSelectAll);
        manager.add((IContributionItem)new Separator("Additions"));
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ChatRoomView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.readText);
        this.readText.setMenu(menu);
        ISelectionProvider selectionProvider = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                TextSelection selection = new TextSelection(((ChatRoomView)ChatRoomView.this).readText.getSelectionRange().x, ((ChatRoomView)ChatRoomView.this).readText.getSelectionRange().y);
                return selection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
                if (selection instanceof ITextSelection) {
                    ITextSelection textSelection = (ITextSelection)selection;
                    ChatRoomView.this.readText.setSelection(textSelection.getOffset(), textSelection.getOffset() + textSelection.getLength());
                }
            }
        };
        this.getSite().registerContextMenu(menuMgr, selectionProvider);
    }

    class Participant
    implements IUser {
        private static final long serialVersionUID = 2008114088656711572L;
        ID id;

        public Participant(ID id) {
            this.id = id;
        }

        public ID getID() {
            return this.id;
        }

        public String getName() {
            return this.toString();
        }

        public boolean equals(Object other) {
            if (!(other instanceof Participant)) {
                return false;
            }
            Participant o = (Participant)other;
            return this.id.equals((Object)o.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return ChatRoomView.this.trimUserID(this.id);
        }

        public Map getProperties() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public String getNickname() {
            return this.getName();
        }
    }
}

