/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ConnectionDialog
extends TitleAreaDialog {
    private static final int PROVIDER_TABLE_HEIGHT = 200;
    private static final int PROVIDER_TABLE_WIDTH = 150;
    protected static final String CLASSNAME;
    protected static final String USER_NAME_SYSTEM_PROPERTY = "user.name";
    protected static final String ISSERVER_PROP_NAME;
    protected static final String DEFAULTGROUPID_PROP_NAME;
    protected static final String EXAMPLEGROUPID_PROP_NAME;
    protected static final String USEPASSWORD_PROP_NAME;
    protected static final String USENICKNAME_PROP_NAME;
    protected static final String URLPREFIX_NAME;
    protected static final String GROUPIDLABEL_PROP_NAME;
    protected static final String NAMESPACE_PROP_NAME;
    protected static final String PAGE_DESCRIPTION;
    protected static final String JOINGROUP_FIELDNAME;
    protected static final String NICKNAME_FIELDNAME;
    protected static final String ECF_DEFAULT_URL = "ecftcp://localhost:3282/server";
    protected static final String ECF_TEMPLATE_URL;
    protected static final String PAGE_TITLE;
    protected static final String DEFAULT_CLIENT = "ecf.generic.client";
    private static final String DIALOG_SETTINGS;
    private Composite paramComp;
    private Text joingroup_text;
    private String joinGroup = "";
    private Text nickname_text;
    private String nickname = "";
    private Text password_text;
    private String password = "";
    private String urlPrefix;
    private String namespace = null;
    private String containerType = "";
    private TableViewer viewer;
    private IDialogSettings dialogSettings;
    private final GlobalModifyListener listener = new GlobalModifyListener();
    private Button autoLogin = null;
    private boolean autoLoginFlag = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.internal.example.collab.ui.JoinGroupWizardPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASSNAME = clazz.getName();
        ISSERVER_PROP_NAME = String.valueOf(CLASSNAME) + ".isServer";
        DEFAULTGROUPID_PROP_NAME = String.valueOf(CLASSNAME) + ".defaultgroupid";
        EXAMPLEGROUPID_PROP_NAME = String.valueOf(CLASSNAME) + ".examplegroupid";
        USEPASSWORD_PROP_NAME = String.valueOf(CLASSNAME) + ".usepassword";
        USENICKNAME_PROP_NAME = String.valueOf(CLASSNAME) + ".usenickname";
        URLPREFIX_NAME = String.valueOf(CLASSNAME) + ".urlprefix";
        GROUPIDLABEL_PROP_NAME = String.valueOf(CLASSNAME) + ".groupIDLabel";
        NAMESPACE_PROP_NAME = String.valueOf(CLASSNAME) + ".namespace";
        PAGE_DESCRIPTION = Messages.ConnectionDialog_SELECT_PROVIDER_DESCRIPTION;
        JOINGROUP_FIELDNAME = Messages.ConnectionDialog_JOIN_GROUP_FIELD_TEXT;
        NICKNAME_FIELDNAME = Messages.ConnectionDialog_NICKNAME_TEXT;
        ECF_TEMPLATE_URL = Messages.ConnectionDialog_TEMPLATE_URL;
        PAGE_TITLE = Messages.ConnectionDialog_CONNECT_PAGE_TITLE;
        DIALOG_SETTINGS = CLASSNAME;
    }

    public ConnectionDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(2160);
    }

    protected Control createDialogArea(Composite parent) {
        Composite main = new Composite((Composite)super.createDialogArea(parent), 0);
        main.setLayout((Layout)new GridLayout());
        main.setLayoutData((Object)new GridData(1808));
        Label providerLabel = new Label(main, 0);
        providerLabel.setText(Messages.ConnectionDialog_PROTOCOL_TEXT);
        Composite providerComp = new Composite(main, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        providerComp.setLayout((Layout)layout);
        providerComp.setLayoutData((Object)new GridData(1808));
        this.viewer = new TableViewer(providerComp, 67584);
        this.viewer.setContentProvider((IContentProvider)new ECFProviderContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ECFProviderLabelProvider());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new ProviderSelector());
        Table table = this.viewer.getTable();
        GridData gData = new GridData(1040);
        gData.widthHint = 150;
        gData.heightHint = 200;
        table.setLayoutData((Object)gData);
        this.viewer.setInput((Object)ContainerFactory.getDefault().getDescriptions());
        this.paramComp = new Composite(providerComp, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginTop = 0;
        glayout.marginBottom = 0;
        this.paramComp.setLayout((Layout)glayout);
        this.paramComp.setLayoutData((Object)new GridData(1808));
        this.autoLogin = new Button(main, 32);
        this.autoLogin.setText(Messages.ConnectionDialog_AUTOLOGIN_TEXT);
        this.autoLogin.setLayoutData((Object)new GridData(128));
        this.autoLogin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionDialog.this.autoLoginFlag = ConnectionDialog.this.autoLogin.getSelection();
            }
        });
        new Label(main, 0);
        Label sep = new Label(main, 258);
        sep.setLayoutData((Object)new GridData(768));
        this.setTitle(Messages.ConnectionDialog_CONNECTION_TITLE);
        this.setMessage(Messages.ConnectionDialog_CHOOSE_PROVIDER_MESSAGE);
        this.getShell().setText(Messages.ConnectionDialog_CONNECT_TEXT);
        return parent;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        try {
            this.restoreDialogSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return control;
    }

    protected Point getInitialSize() {
        return new Point(500, 400);
    }

    public String getJoinGroupText() {
        String textValue = this.joinGroup.trim();
        String namespace = this.getNamespace();
        if (namespace != null) {
            return textValue;
        }
        if (!this.urlPrefix.equals("") && !textValue.startsWith(this.urlPrefix)) {
            textValue = String.valueOf(this.urlPrefix) + textValue;
        }
        return textValue;
    }

    public String getNicknameText() {
        return this.nickname;
    }

    public String getPasswordText() {
        return this.password;
    }

    public String getContainerType() {
        return this.containerType;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean getAutoLoginFlag() {
        return this.autoLoginFlag;
    }

    private void restoreDialogSettings() throws IOException {
        IDialogSettings pageSettings;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && (pageSettings = dialogSettings.getSection(DIALOG_SETTINGS)) != null) {
            int intVal = pageSettings.getInt("provider");
            this.viewer.getTable().setSelection(intVal);
            this.viewer.setSelection(this.viewer.getSelection());
            String strVal = pageSettings.get("url");
            if (strVal != null && this.joingroup_text != null) {
                this.joingroup_text.setText(strVal);
            }
            if ((strVal = pageSettings.get("nickname")) != null && this.nickname_text != null) {
                this.nickname_text.setText(strVal);
            }
            if (this.savePassword() && (strVal = pageSettings.get("password")) != null && this.password_text != null) {
                this.password_text.setText(strVal);
            }
            this.listener.modifyText(null);
        }
    }

    private void saveDialogSettings() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            IDialogSettings pageSettings = dialogSettings.getSection(DIALOG_SETTINGS);
            if (pageSettings == null) {
                pageSettings = dialogSettings.addNewSection(DIALOG_SETTINGS);
            }
            pageSettings.put("url", this.getJoinGroupText());
            pageSettings.put("nickname", this.getNicknameText());
            pageSettings.put("password", this.getPasswordText());
            int i = this.viewer.getTable().getSelectionIndex();
            if (i >= 0) {
                pageSettings.put("provider", i);
            }
        }
    }

    private boolean savePassword() {
        return ClientPlugin.getDefault().getPluginPreferences().getBoolean("storePassword");
    }

    protected void okPressed() {
        this.saveDialogSettings();
        super.okPressed();
    }

    private IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.dialogSettings = ClientPlugin.getDefault().getDialogSettings();
        }
        return this.dialogSettings;
    }

    private class ECFProviderContentProvider
    implements IStructuredContentProvider {
        private ECFProviderContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            List rawDescriptions = (List)inputElement;
            ArrayList<ContainerTypeDescription> elements = new ArrayList<ContainerTypeDescription>();
            Iterator i = rawDescriptions.iterator();
            while (i.hasNext()) {
                ContainerTypeDescription desc = (ContainerTypeDescription)i.next();
                if (desc.isServer() || desc.isHidden()) continue;
                elements.add(desc);
            }
            return elements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ECFProviderLabelProvider
    implements ITableLabelProvider {
        private ECFProviderLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ContainerTypeDescription desc = (ContainerTypeDescription)element;
            switch (columnIndex) {
                case 0: {
                    return desc.getDescription();
                }
                case 1: {
                    return desc.getName();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class GlobalModifyListener
    implements ModifyListener {
        private GlobalModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ConnectionDialog.this.password_text != null && !ConnectionDialog.this.password_text.isDisposed()) {
                ConnectionDialog.this.password = ConnectionDialog.this.password_text.getText();
            }
            if (ConnectionDialog.this.nickname_text != null && !ConnectionDialog.this.nickname_text.isDisposed()) {
                ConnectionDialog.this.nickname = ConnectionDialog.this.nickname_text.getText();
            }
            if (ConnectionDialog.this.joingroup_text != null && !ConnectionDialog.this.joingroup_text.isDisposed()) {
                ConnectionDialog.this.joinGroup = ConnectionDialog.this.joingroup_text.getText();
            }
        }
    }

    private class ProviderSelector
    implements ISelectionChangedListener {
        private ProviderSelector() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            ContainerTypeDescription desc = (ContainerTypeDescription)selection.getFirstElement();
            if (desc != null) {
                ConnectionDialog.this.containerType = desc.getName();
                this.createPropertyComposite(ConnectionDialog.this.paramComp, null);
            }
        }

        protected void createPropertyComposite(Composite parent, Map properties) {
            if (properties != null) {
                String usePassword = (String)properties.get(USEPASSWORD_PROP_NAME);
                String examplegroupid = (String)properties.get(EXAMPLEGROUPID_PROP_NAME);
                String useNickname = (String)properties.get(USENICKNAME_PROP_NAME);
                ConnectionDialog.this.urlPrefix = (String)properties.get(URLPREFIX_NAME);
                ConnectionDialog.this.namespace = (String)properties.get(NAMESPACE_PROP_NAME);
                if (ConnectionDialog.this.urlPrefix == null) {
                    ConnectionDialog.this.urlPrefix = "";
                }
                this.removeChildren(parent);
                String groupLabel = (String)properties.get(GROUPIDLABEL_PROP_NAME);
                Label groupIDLabel = new Label(parent, 0);
                if (groupLabel != null) {
                    groupIDLabel.setText(groupLabel);
                } else {
                    groupIDLabel.setText(JOINGROUP_FIELDNAME);
                }
                ConnectionDialog.this.joingroup_text = new Text(parent, 2048);
                ConnectionDialog.this.joingroup_text.setLayoutData((Object)new GridData(768));
                ConnectionDialog.this.joingroup_text.addModifyListener((ModifyListener)ConnectionDialog.this.listener);
                if (examplegroupid != null) {
                    Label example_label = new Label(parent, 0);
                    example_label.setText(examplegroupid != null ? examplegroupid : "");
                    example_label.setLayoutData((Object)new GridData(128));
                }
                if (usePassword != null) {
                    Label password_label = new Label(parent, 0);
                    password_label.setText(Messages.ConnectionDialog_PASSWORD_TEXT);
                    ConnectionDialog.this.password_text = new Text(parent, 2048);
                    ConnectionDialog.this.password_text.setLayoutData((Object)new GridData(768));
                    ConnectionDialog.this.password_text.setEchoChar('*');
                    ConnectionDialog.this.password_text.addModifyListener((ModifyListener)ConnectionDialog.this.listener);
                }
                if (useNickname != null) {
                    Label nickname_label = new Label(parent, 0);
                    nickname_label.setText(NICKNAME_FIELDNAME);
                    ConnectionDialog.this.nickname_text = new Text(parent, 2048);
                    ConnectionDialog.this.nickname_text.setLayoutData((Object)new GridData(768));
                    ConnectionDialog.this.nickname_text.addModifyListener((ModifyListener)ConnectionDialog.this.listener);
                }
                ConnectionDialog.this.autoLogin.setSelection(false);
                parent.layout();
            }
        }

        private void removeChildren(Composite composite) {
            if (composite != null && composite.getChildren() != null) {
                while (composite.getChildren().length > 0) {
                    Control child = composite.getChildren()[0];
                    if (child instanceof Composite) {
                        this.removeChildren((Composite)child);
                    }
                    child.dispose();
                }
            }
        }
    }
}

