/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.provider.xmpp.XMPPContainerPresenceHelper;
import org.eclipse.ecf.internal.provider.xmpp.XmppPlugin;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.history.IHistory;
import org.eclipse.ecf.presence.history.IHistoryManager;
import org.eclipse.ecf.presence.im.ChatMessage;
import org.eclipse.ecf.presence.im.ChatMessageEvent;
import org.eclipse.ecf.presence.im.IChat;
import org.eclipse.ecf.presence.im.IChatManager;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.ecf.presence.im.ITypingMessage;
import org.eclipse.ecf.presence.im.ITypingMessageSender;
import org.eclipse.ecf.presence.im.IXHTMLChatMessage;
import org.eclipse.ecf.presence.im.TypingMessageEvent;
import org.eclipse.ecf.presence.im.XHTMLChatMessage;
import org.eclipse.ecf.presence.im.XHTMLChatMessageEvent;
import org.jivesoftware.smack.packet.Message;

public class XMPPChatManager
implements IChatManager {
    private final List messageListeners = new ArrayList();
    private final XMPPContainerPresenceHelper presenceHelper;
    private final IChatMessageSender chatMessageSender = new IChatMessageSender(){

        public void sendChatMessage(ID toID, ID threadID, IChatMessage.Type type, String subject, String body, Map properties) throws ECFException {
            if (toID == null) {
                throw new ECFException("receiver cannot be null");
            }
            try {
                XMPPChatManager.this.presenceHelper.getConnectionOrThrowIfNull().sendMessage(toID, threadID, XMPPChatManager.this.createMessageType(type), subject, body, properties);
            }
            catch (Exception e) {
                throw new ECFException("sendChatMessage exception", (Throwable)e);
            }
        }

        public void sendChatMessage(ID toID, String body) throws ECFException {
            this.sendChatMessage(toID, null, IChatMessage.Type.CHAT, null, body, null);
        }
    };
    protected ITypingMessageSender typingMessageSender = new ITypingMessageSender(){

        public void sendTypingMessage(ID toID, boolean isTyping, String body) throws ECFException {
            if (toID == null) {
                throw new ECFException("receiver cannot be null");
            }
            try {
                XMPPChatManager.this.presenceHelper.sendTypingMessage(toID, isTyping, body);
            }
            catch (Exception e) {
                throw new ECFException("sendChatMessage exception", (Throwable)e);
            }
        }
    };
    protected IHistoryManager historyManager = new IHistoryManager(){

        public IHistory getHistory(ID partnerID, Map options) {
            return null;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == null) {
                return null;
            }
            if (adapter.isInstance(this)) {
                return this;
            }
            IAdapterManager adapterManager = XmppPlugin.getDefault().getAdapterManager();
            return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
        }

        public boolean isActive() {
            return false;
        }

        public void setActive(boolean active) {
        }
    };

    public XMPPChatManager(XMPPContainerPresenceHelper presenceHelper) {
        this.presenceHelper = presenceHelper;
    }

    protected IChatMessage.Type createMessageType(Message.Type type) {
        if (type == null) {
            return IChatMessage.Type.CHAT;
        }
        if (type == Message.Type.CHAT) {
            return IChatMessage.Type.CHAT;
        }
        if (type == Message.Type.HEADLINE) {
            return IChatMessage.Type.SYSTEM;
        }
        return IChatMessage.Type.CHAT;
    }

    protected Message.Type createMessageType(IChatMessage.Type type) {
        if (type == null) {
            return Message.Type.NORMAL;
        }
        if (type == IChatMessage.Type.CHAT) {
            return Message.Type.CHAT;
        }
        if (type == IChatMessage.Type.SYSTEM) {
            return Message.Type.HEADLINE;
        }
        return Message.Type.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(IIMMessageListener listener) {
        List list = this.messageListeners;
        synchronized (list) {
            this.messageListeners.add(listener);
        }
    }

    public IChatMessageSender getChatMessageSender() {
        return this.chatMessageSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(IIMMessageListener listener) {
        List list = this.messageListeners;
        synchronized (list) {
            this.messageListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageEvent(IIMMessageEvent event) {
        ArrayList toNotify = null;
        List list = this.messageListeners;
        synchronized (list) {
            toNotify = new ArrayList(this.messageListeners);
        }
        Iterator i = toNotify.iterator();
        while (i.hasNext()) {
            IIMMessageListener l = (IIMMessageListener)i.next();
            l.handleMessageEvent(event);
        }
    }

    protected void fireChatMessage(ID fromID, ID threadID, Message.Type type, String subject, String body, Map properties) {
        this.fireMessageEvent((IIMMessageEvent)new ChatMessageEvent(fromID, (IChatMessage)new ChatMessage(fromID, threadID, this.createMessageType(type), subject, body, properties)));
    }

    protected void fireTypingMessage(ID fromID, ITypingMessage typingMessage) {
        this.fireMessageEvent((IIMMessageEvent)new TypingMessageEvent(fromID, typingMessage));
    }

    public ITypingMessageSender getTypingMessageSender() {
        return this.typingMessageSender;
    }

    protected void fireXHTMLChatMessage(ID fromID, ID threadID, Message.Type type, String subject, String body, Map properties, List xhtmlbodylist) {
        this.fireMessageEvent((IIMMessageEvent)new XHTMLChatMessageEvent(fromID, (IXHTMLChatMessage)new XHTMLChatMessage(fromID, threadID, this.createMessageType(type), subject, body, properties, xhtmlbodylist)));
    }

    public IHistoryManager getHistoryManager() {
        return this.historyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        List list = this.messageListeners;
        synchronized (list) {
            this.messageListeners.clear();
        }
    }

    public IChat createChat(ID targetUser, IIMMessageListener messageListener) throws ECFException {
        return null;
    }
}

