/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.xmpp.filetransfer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IOutgoingFileTransfer;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferResponseEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferSendDataEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferSendDoneEvent;
import org.eclipse.ecf.internal.provider.xmpp.XmppPlugin;
import org.eclipse.ecf.provider.xmpp.identity.XMPPID;
import org.eclipse.osgi.util.NLS;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.filetransfer.FileTransfer;
import org.jivesoftware.smackx.filetransfer.FileTransferManager;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;

public class XMPPOutgoingFileTransfer
implements IOutgoingFileTransfer {
    private static final int BUFFER_SIZE = 4096;
    private final ID sessionID;
    private final XMPPID remoteTarget;
    private final IFileTransferListener listener;
    private File localFile;
    private long fileSize;
    private final OutgoingFileTransfer outgoingFileTransfer;
    private long amountWritten = 0L;
    private FileTransfer.Status status;
    private Exception exception;
    private int originalOutputRequestTimeout = -1;
    private boolean localCancelled = false;

    public XMPPOutgoingFileTransfer(FileTransferManager manager, XMPPID remoteTarget, IFileTransferInfo fileTransferInfo, IFileTransferListener listener, int outgoingRequestTimeout) {
        this.remoteTarget = remoteTarget;
        this.listener = listener;
        this.sessionID = this.createSessionID();
        String fullyQualifiedName = remoteTarget.getFQName();
        if (outgoingRequestTimeout != -1) {
            this.originalOutputRequestTimeout = OutgoingFileTransfer.getResponseTimeout();
            OutgoingFileTransfer.setResponseTimeout((int)outgoingRequestTimeout);
        }
        this.outgoingFileTransfer = manager.createOutgoingFileTransfer(fullyQualifiedName);
    }

    private ID createSessionID() {
        try {
            return IDFactory.getDefault().createGUID();
        }
        catch (IDCreateException iDCreateException) {
            throw new NullPointerException("cannot create id for XMPPOutgoingFileTransfer");
        }
    }

    public synchronized ID getRemoteTargetID() {
        return this.remoteTarget;
    }

    public ID getID() {
        return this.sessionID;
    }

    private void fireTransferListenerEvent(IFileTransferEvent event) {
        this.listener.handleTransferEvent(event);
    }

    private void setStatus(FileTransfer.Status s) {
        this.status = s;
    }

    private void setException(Exception e) {
        this.exception = e;
    }

    private FileTransfer.Status getStatus() {
        return this.status;
    }

    private void setErrorStatus(Exception e) {
        this.setStatus(FileTransfer.Status.ERROR);
        this.setException(e);
    }

    public synchronized void startSend(File localFile, String description) throws XMPPException {
        this.localFile = localFile;
        this.fileSize = localFile.length();
        this.setStatus(FileTransfer.Status.INITIAL);
        final OutgoingFileTransfer.NegotiationProgress progress = new OutgoingFileTransfer.NegotiationProgress();
        this.outgoingFileTransfer.sendFile(localFile.getAbsolutePath(), this.fileSize, description, progress);
        Thread transferThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                XMPPOutgoingFileTransfer.access$1(XMPPOutgoingFileTransfer.this, XMPPOutgoingFileTransfer.access$0(XMPPOutgoingFileTransfer.this).getStatus());
                negotiation = true;
                try {
                    try {
                        while (true) {
                            block13: {
                                if (negotiation && !XMPPOutgoingFileTransfer.access$4(XMPPOutgoingFileTransfer.this)) break block13;
                                if (!XMPPOutgoingFileTransfer.access$4(XMPPOutgoingFileTransfer.this)) break;
                                XMPPOutgoingFileTransfer.access$5(XMPPOutgoingFileTransfer.this, (Exception)new UserCancelledException("Transfer cancelled by sender"));
                                ** GOTO lbl17
                            }
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e) {
                                XMPPOutgoingFileTransfer.access$5(XMPPOutgoingFileTransfer.this, e);
lbl17:
                                // 3 sources

                                while (true) {
                                    var4_6 = null;
                                    if (XMPPOutgoingFileTransfer.access$2(XMPPOutgoingFileTransfer.this) != -1) {
                                        OutgoingFileTransfer.setResponseTimeout((int)XMPPOutgoingFileTransfer.access$2(XMPPOutgoingFileTransfer.this));
                                    }
                                    XMPPOutgoingFileTransfer.access$3(XMPPOutgoingFileTransfer.this, (IFileTransferEvent)new IOutgoingFileTransferSendDoneEvent(this){
                                        private static final long serialVersionUID = -6315336868737148845L;
                                        final /* synthetic */ 1 this$1;
                                        {
                                            this.this$1 = var1_1;
                                        }

                                        public IOutgoingFileTransfer getSource() {
                                            return 1.access$0(this.this$1);
                                        }

                                        public String toString() {
                                            StringBuffer buf = new StringBuffer("IOutgoingFileTransferSendDoneEvent[");
                                            buf.append("isDone=" + this.getSource().isDone());
                                            buf.append(";bytesSent=").append(this.getSource().getBytesSent());
                                            buf.append(";exception=").append(1.access$0(this.this$1).getException()).append("]");
                                            return buf.toString();
                                        }
                                    });
                                    return;
                                }
                            }
                            s = progress.getStatus();
                            XMPPOutgoingFileTransfer.access$1(XMPPOutgoingFileTransfer.this, s);
                            negotiated = XMPPOutgoingFileTransfer.access$6(XMPPOutgoingFileTransfer.this).equals(FileTransfer.Status.NEGOTIATED);
                            if (!s.equals(FileTransfer.Status.NEGOTIATED) && !s.equals(FileTransfer.Status.CANCLED) && !s.equals(FileTransfer.Status.COMPLETE) && !s.equals(FileTransfer.Status.ERROR) && !s.equals(FileTransfer.Status.REFUSED)) continue;
                            XMPPOutgoingFileTransfer.access$3(XMPPOutgoingFileTransfer.this, (IFileTransferEvent)new IOutgoingFileTransferResponseEvent(this, negotiated){
                                private static final long serialVersionUID = -5940612388464073240L;
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ boolean val$negotiated;
                                {
                                    this.this$1 = var1_1;
                                    this.val$negotiated = bl;
                                }

                                public boolean requestAccepted() {
                                    return this.val$negotiated;
                                }

                                public IOutgoingFileTransfer getSource() {
                                    return 1.access$0(this.this$1);
                                }

                                public String toString() {
                                    StringBuffer buf = new StringBuffer("OutgoingFileTransferResponseEvent[");
                                    buf.append("requestAccepted=").append(this.requestAccepted()).append("]");
                                    return buf.toString();
                                }

                                public void setFileTransferJob(FileTransferJob job) {
                                }
                            });
                            negotiation = false;
                        }
                        outs = progress.getOutputStream();
                        if (outs == null) {
                            XMPPOutgoingFileTransfer.access$5(XMPPOutgoingFileTransfer.this, new IOException("No output stream available"));
                            ** continue;
                        }
                        XMPPOutgoingFileTransfer.this.writeToStream(new FileInputStream(XMPPOutgoingFileTransfer.access$7(XMPPOutgoingFileTransfer.this)), outs);
                        XMPPOutgoingFileTransfer.access$1(XMPPOutgoingFileTransfer.this, FileTransfer.Status.COMPLETE);
                    }
                    catch (Exception e) {
                        XMPPOutgoingFileTransfer.access$1(XMPPOutgoingFileTransfer.this, FileTransfer.Status.ERROR);
                        XMPPOutgoingFileTransfer.access$8(XMPPOutgoingFileTransfer.this, e);
                    }
                }
                catch (Throwable var5_9) {
                    var4_7 = null;
                    if (XMPPOutgoingFileTransfer.access$2(XMPPOutgoingFileTransfer.this) != -1) {
                        OutgoingFileTransfer.setResponseTimeout((int)XMPPOutgoingFileTransfer.access$2(XMPPOutgoingFileTransfer.this));
                    }
                    XMPPOutgoingFileTransfer.access$3(XMPPOutgoingFileTransfer.this, (IFileTransferEvent)new /* invalid duplicate definition of identical inner class */);
                    throw var5_9;
                }
                {
                    var4_8 = null;
                }
                if (XMPPOutgoingFileTransfer.access$2(XMPPOutgoingFileTransfer.this) != -1) {
                    OutgoingFileTransfer.setResponseTimeout((int)XMPPOutgoingFileTransfer.access$2(XMPPOutgoingFileTransfer.this));
                }
                XMPPOutgoingFileTransfer.access$3(XMPPOutgoingFileTransfer.this, (IFileTransferEvent)new /* invalid duplicate definition of identical inner class */);
            }

            static /* synthetic */ XMPPOutgoingFileTransfer access$0(1 var0) {
                return var0.XMPPOutgoingFileTransfer.this;
            }
        }, NLS.bind((String)"XMPP send {0}", (Object)this.remoteTarget.toExternalForm()));
        transferThread.start();
    }

    public synchronized void cancel() {
        this.localCancelled = true;
    }

    public synchronized File getLocalFile() {
        return this.localFile;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = XmppPlugin.getDefault().getAdapterManager();
        return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    public long getBytesSent() {
        return this.amountWritten;
    }

    public Exception getException() {
        return this.exception;
    }

    public double getPercentComplete() {
        return this.fileSize <= 0L ? 1.0 : (double)this.amountWritten / (double)this.fileSize;
    }

    public boolean isDone() {
        return this.status == FileTransfer.Status.CANCLED || this.status == FileTransfer.Status.ERROR || this.status == FileTransfer.Status.COMPLETE;
    }

    public ID getSessionID() {
        return this.sessionID;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeToStream(InputStream in, OutputStream out) throws XMPPException, IOException, UserCancelledException {
        byte[] b = new byte[4096];
        int count = 0;
        this.amountWritten = 0L;
        try {
            do {
                if (this.localCancelled) {
                    throw new UserCancelledException("Transfer cancelled by sender");
                }
                out.write(b, 0, count);
                this.amountWritten += (long)count;
                if (count <= 0) continue;
                this.fireTransferListenerEvent((IFileTransferEvent)new IOutgoingFileTransferSendDataEvent(){
                    private static final long serialVersionUID = 2327297070577249812L;

                    public IOutgoingFileTransfer getSource() {
                        return XMPPOutgoingFileTransfer.this;
                    }

                    public String toString() {
                        StringBuffer buf = new StringBuffer("IOutgoingFileTransferSendDataEvent[");
                        buf.append("bytesSent=").append(this.getSource().getBytesSent());
                        buf.append(";percentComplete=").append(this.getSource().getPercentComplete()).append("]");
                        return buf.toString();
                    }
                });
            } while ((count = in.read(b)) != -1 && !this.getStatus().equals(FileTransfer.Status.CANCLED));
            if (!this.getStatus().equals(FileTransfer.Status.CANCLED) && this.amountWritten != this.fileSize) {
                this.setStatus(FileTransfer.Status.ERROR);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            out.flush();
            out.close();
            in.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        out.flush();
        out.close();
        in.close();
    }

    public long getFileLength() {
        return this.fileSize;
    }

    static /* synthetic */ OutgoingFileTransfer access$0(XMPPOutgoingFileTransfer xMPPOutgoingFileTransfer) {
        return xMPPOutgoingFileTransfer.outgoingFileTransfer;
    }

    static /* synthetic */ void access$1(XMPPOutgoingFileTransfer xMPPOutgoingFileTransfer, FileTransfer.Status status) {
        xMPPOutgoingFileTransfer.setStatus(status);
    }

    static /* synthetic */ int access$2(XMPPOutgoingFileTransfer xMPPOutgoingFileTransfer) {
        return xMPPOutgoingFileTransfer.originalOutputRequestTimeout;
    }

    static /* synthetic */ void access$3(XMPPOutgoingFileTransfer xMPPOutgoingFileTransfer, IFileTransferEvent iFileTransferEvent) {
        xMPPOutgoingFileTransfer.fireTransferListenerEvent(iFileTransferEvent);
    }

    static /* synthetic */ boolean access$4(XMPPOutgoingFileTransfer xMPPOutgoingFileTransfer) {
        return xMPPOutgoingFileTransfer.localCancelled;
    }

    static /* synthetic */ void access$5(XMPPOutgoingFileTransfer xMPPOutgoingFileTransfer, Exception exception) {
        xMPPOutgoingFileTransfer.setErrorStatus(exception);
    }

    static /* synthetic */ FileTransfer.Status access$6(XMPPOutgoingFileTransfer xMPPOutgoingFileTransfer) {
        return xMPPOutgoingFileTransfer.getStatus();
    }

    static /* synthetic */ File access$7(XMPPOutgoingFileTransfer xMPPOutgoingFileTransfer) {
        return xMPPOutgoingFileTransfer.localFile;
    }

    static /* synthetic */ void access$8(XMPPOutgoingFileTransfer xMPPOutgoingFileTransfer, Exception exception) {
        xMPPOutgoingFileTransfer.setException(exception);
    }
}

