/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ui.wizards;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter2;

public class WorkbenchLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private IPropertyListener editorRegistryListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 1) {
                WorkbenchLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)WorkbenchLabelProvider.this));
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static ILabelProvider getDecoratingWorkbenchLabelProvider() {
        return new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
    }

    public WorkbenchLabelProvider() {
        PlatformUI.getWorkbench().getEditorRegistry().addPropertyListener(this.editorRegistryListener);
    }

    protected ImageDescriptor decorateImage(ImageDescriptor input, Object element) {
        return input;
    }

    protected String decorateText(String input, Object element) {
        return input;
    }

    public void dispose() {
        PlatformUI.getWorkbench().getEditorRegistry().removePropertyListener(this.editorRegistryListener);
        super.dispose();
    }

    protected static final Object getAdapterUtil(Object sourceObject, Class adapterType) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        Assert.isNotNull((Object)adapterType);
        if (sourceObject == null) {
            return null;
        }
        if (adapterType.isInstance(sourceObject)) {
            return sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType)) != null) {
            Assert.isTrue((boolean)adapterType.isInstance(result2));
            return result2;
        }
        if (!(sourceObject instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(sourceObject, adapterType)) != null) {
            return result;
        }
        return null;
    }

    protected final IWorkbenchAdapter getAdapter(Object o) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IWorkbenchAdapter)WorkbenchLabelProvider.getAdapterUtil(o, clazz);
    }

    protected final IWorkbenchAdapter2 getAdapter2(Object o) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IWorkbenchAdapter2)WorkbenchLabelProvider.getAdapterUtil(o, clazz);
    }

    public final Image getImage(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter == null) {
            return null;
        }
        ImageDescriptor descriptor = adapter.getImageDescriptor(element);
        if (descriptor == null) {
            return null;
        }
        descriptor = this.decorateImage(descriptor, element);
        Image image = descriptor.createImage();
        return image;
    }

    public final String getText(Object element) {
        IWorkbenchAdapter adapter = this.getAdapter(element);
        if (adapter == null) {
            return "";
        }
        String label = adapter.getLabel(element);
        return this.decorateText(label, element);
    }

    public Color getForeground(Object element) {
        return this.getColor(element, true);
    }

    public Color getBackground(Object element) {
        return this.getColor(element, false);
    }

    public Font getFont(Object element) {
        IWorkbenchAdapter2 adapter = this.getAdapter2(element);
        if (adapter == null) {
            return null;
        }
        FontData descriptor = adapter.getFont(element);
        if (descriptor == null) {
            return null;
        }
        Font font = new Font((Device)Display.getCurrent(), descriptor);
        return font;
    }

    private Color getColor(Object element, boolean forground) {
        RGB descriptor;
        IWorkbenchAdapter2 adapter = this.getAdapter2(element);
        if (adapter == null) {
            return null;
        }
        RGB rGB = descriptor = forground ? adapter.getForeground(element) : adapter.getBackground(element);
        if (descriptor == null) {
            return null;
        }
        Color color = new Color((Device)Display.getCurrent(), descriptor);
        return color;
    }
}

