/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.share.io;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.eclipse.ecf.example.collab.share.io.FileTransferListener;

public class FileTransferParams
implements Serializable {
    private static final long serialVersionUID = -2871056005778727843L;
    protected static int DEFAULT_CHUNK_SIZE = 1024;
    protected static int DEFAULT_WAIT_TIME = 1000;
    protected static int DEFAULT_FILE_LENGTH = -1;
    protected static boolean DEFAULT_INCLUDE_SERVER = false;
    protected File remoteFile;
    protected int chunkSize;
    protected int waitTime;
    protected Date startDate;
    protected boolean includeServer;
    protected long length;
    protected float rate;
    protected FileTransferListener progressListener;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.example.collab.share.io.FileTransferParams");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String str = System.getProperty(String.valueOf(clazz.getName()) + ".FILECHUNKSIZE", "" + DEFAULT_CHUNK_SIZE);
            DEFAULT_CHUNK_SIZE = Integer.parseInt(str);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.ecf.example.collab.share.io.FileTransferParams");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            str = System.getProperty(String.valueOf(clazz2.getName()) + ".FILEWAITTIME", String.valueOf(DEFAULT_WAIT_TIME));
            DEFAULT_WAIT_TIME = Integer.parseInt(str);
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.ecf.example.collab.share.io.FileTransferParams");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            str = System.getProperty(String.valueOf(clazz3.getName()) + ".FILELENGTH", String.valueOf(DEFAULT_FILE_LENGTH));
            DEFAULT_FILE_LENGTH = Integer.parseInt(str);
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("org.eclipse.ecf.example.collab.share.io.FileTransferParams");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            str = System.getProperty(String.valueOf(clazz4.getName()) + ".FILEINCLUDESERVER", "false");
            DEFAULT_INCLUDE_SERVER = Boolean.getBoolean(str);
        }
        catch (Exception exception) {}
    }

    public FileTransferParams(File aFile, int chunkSize, int waitTime, Date startDate, boolean includeServer, long length, FileTransferListener listener) {
        this.remoteFile = aFile;
        this.chunkSize = chunkSize == -1 ? DEFAULT_CHUNK_SIZE : chunkSize;
        this.waitTime = waitTime;
        this.waitTime = waitTime == -1 ? DEFAULT_WAIT_TIME : waitTime;
        this.startDate = startDate;
        this.includeServer = includeServer;
        this.length = length;
        this.rate = (float)(chunkSize * 8) / ((float)waitTime / 1000.0f);
        this.progressListener = listener;
    }

    public FileTransferParams() {
        this(null, DEFAULT_CHUNK_SIZE, DEFAULT_WAIT_TIME, null, DEFAULT_INCLUDE_SERVER, DEFAULT_FILE_LENGTH, null);
    }

    public File getRemoteFile() {
        return this.remoteFile;
    }

    public void setRemoteFile(File aFile) {
        this.remoteFile = aFile;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int size) {
        this.chunkSize = size;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int wait) {
        this.waitTime = wait;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date aDate) {
        this.startDate = aDate;
    }

    public boolean getIncludeServer() {
        return this.includeServer;
    }

    public void setIncludeServer(boolean include) {
        this.includeServer = include;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long len) {
        this.length = len;
    }

    public float getRate() {
        return this.rate;
    }

    protected FileTransferListener getProgressListener() {
        return this.progressListener;
    }

    protected void setProgressListener(FileTransferListener list) {
        this.progressListener = list;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FileTransferParams[");
        sb.append(this.remoteFile).append(";").append(this.chunkSize).append(";");
        sb.append(this.waitTime).append(";");
        sb.append(this.startDate).append(";").append(this.includeServer).append(";");
        sb.append(this.length).append(";").append(this.rate).append(";");
        sb.append(this.progressListener).append("]");
        return sb.toString();
    }
}

