/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservices.ui;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.internal.remoteservices.ui.Messages;
import org.eclipse.ecf.remoteservices.ui.RemoteMethod;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public final class MethodInvocationDialog
extends Dialog {
    public static final int ASYNC_LISTENER = 0;
    public static final int ASYNC_FUTURE_RESULT = 1;
    public static final int ASYNC_FIRE_AND_GO = 2;
    public static final int OSGI_SERVICE_PROXY = 3;
    public static final int REMOTE_SERVICE_PROXY = 4;
    public static final int SYNCHRONOUS = 5;
    private static final String[] COLUMN_PROPERTIES = new String[]{"Parameter", "Argument"};
    private static final String DEFAULT_TIMEOUT_VALUE = "30000";
    private TableViewer methodsViewer;
    private TableViewer parametersViewer;
    private Text timeoutText;
    private Combo invocationCombo;
    private final RemoteMethod[] methods;
    private Method method;
    private Object[] methodArguments;
    private int timeout;
    private int invocationType;

    public MethodInvocationDialog(IShellProvider parentShell, Class cls) {
        super(parentShell);
        Assert.isNotNull((Object)cls);
        Method[] methods = cls.getMethods();
        ArrayList<Method> validMethods = new ArrayList<Method>();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] parameters = methods[i].getParameterTypes();
            String[] types = new String[parameters.length];
            if (types.length == 0) {
                validMethods.add(methods[i]);
            } else {
                boolean match = true;
                int j = 0;
                while (j < types.length) {
                    String name = parameters[j].getName();
                    if (!(name.equals("char") || name.equals("boolean") || name.equals("int") || name.equals("double") || name.equals("float") || name.equals("long") || name.equals("short") || name.equals("byte") || name.equals("java.lang.String"))) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (match) {
                    validMethods.add(methods[i]);
                }
            }
            ++i;
        }
        methods = validMethods.toArray(new Method[validMethods.size()]);
        this.methods = new RemoteMethod[methods.length];
        i = 0;
        while (i < methods.length) {
            this.methods[i] = new RemoteMethod(methods[i]);
            ++i;
        }
    }

    public MethodInvocationDialog(Shell parentShell, Class cls) {
        this((IShellProvider)new SameShellProvider((Control)parentShell), cls);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.MethodInvocationDialog_ShellTitle);
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(2, true));
        Label label = new Label(composite, 16384);
        label.setText(Messages.MethodInvocationDialog_AvailableMethodsLabel);
        label = new Label(composite, 16384);
        label.setText(Messages.MethodInvocationDialog_ArgumentsLabel);
        this.methodsViewer = new TableViewer(composite, 2816);
        this.methodsViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.methodsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.methodsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection iss = (IStructuredSelection)e.getSelection();
                Object element = iss.getFirstElement();
                if (element != null) {
                    MethodInvocationDialog.this.getButton(0).setEnabled(!MethodInvocationDialog.this.timeoutText.getText().equals(""));
                    RemoteMethod method = (RemoteMethod)element;
                    MethodInvocationDialog.this.parametersViewer.setInput((Object)method.getParameters());
                }
            }
        });
        this.methodsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                RemoteMethod method = (RemoteMethod)element;
                return String.valueOf(method.getReturnType()) + ' ' + method.getSignature();
            }
        });
        this.parametersViewer = new TableViewer(composite, 2816);
        this.parametersViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.parametersViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.parametersViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                RemoteMethod.Parameter p = (RemoteMethod.Parameter)element;
                if (columnIndex == 0) {
                    String name = p.getParameter().getName();
                    if (name.charAt(0) == 'j') {
                        return "String";
                    }
                    return name;
                }
                return p.getArgument();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor((Composite)this.parametersViewer.getTable());
        this.parametersViewer.setCellEditors(cellEditorArray);
        this.parametersViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return property.equals(COLUMN_PROPERTIES[1]);
            }

            public Object getValue(Object element, String property) {
                return ((RemoteMethod.Parameter)element).getArgument();
            }

            public void modify(Object element, String property, Object value) {
                if (property.equals(COLUMN_PROPERTIES[1]) && element instanceof TableItem) {
                    TableItem item = (TableItem)element;
                    RemoteMethod.Parameter p = (RemoteMethod.Parameter)item.getData();
                    String argument = (String)value;
                    p.setArgument(argument);
                    item.setText(1, argument);
                }
            }
        });
        this.parametersViewer.setColumnProperties(COLUMN_PROPERTIES);
        Table table = this.parametersViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 16384);
        column.setWidth(150);
        column.setText(Messages.MethodInvocationDialog_ParameterColumn);
        column = new TableColumn(table, 16384);
        column.setWidth(150);
        column.setText(Messages.MethodInvocationDialog_ValueColumn);
        this.methodsViewer.setInput((Object)this.methods);
        Composite bottomComposite = new Composite(composite, 0);
        bottomComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        bottomComposite.setLayout((Layout)layout);
        label = new Label(bottomComposite, 16384);
        label.setText(Messages.MethodInvocationDialog_TimeoutLabel);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.timeoutText = new Text(bottomComposite, 2048);
        this.timeoutText.setText(DEFAULT_TIMEOUT_VALUE);
        this.timeoutText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                switch (e.text.length()) {
                    case 0: {
                        e.doit = true;
                        break;
                    }
                    case 1: {
                        e.doit = Character.isDigit(e.text.charAt(0));
                        break;
                    }
                    default: {
                        e.doit = false;
                    }
                }
            }
        });
        this.timeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MethodInvocationDialog.this.getButton(0).setEnabled(!MethodInvocationDialog.this.timeoutText.getText().equals("") && !MethodInvocationDialog.this.methodsViewer.getSelection().isEmpty());
            }
        });
        this.timeoutText.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label = new Label(bottomComposite, 16384);
        label.setText(Messages.MethodInvocationDialog_InvocationTypeLabel);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        this.invocationCombo = new Combo(bottomComposite, 8);
        this.invocationCombo.setItems(new String[]{Messages.MethodInvocationDialog_InvocationTypeAsyncListener, Messages.MethodInvocationDialog_InvocationTypeAsyncFutureResult, Messages.MethodInvocationDialog_InvocationTypeAsyncFireAndGo, Messages.MethodInvocationDialog_InvocationTypeOSGiServiceProxy, Messages.MethodInvocationDialog_InvocationTypeRemoteServiceProxy, Messages.MethodInvocationDialog_InvocationTypeSynchronous});
        this.invocationCombo.select(0);
        bottomComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return parent;
    }

    public void create() {
        super.create();
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
        okButton.setText(Messages.MethodInvocationDialog_BUTTON_INVOKE_TEXT);
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.methodsViewer.getSelection();
        RemoteMethod remoteMethod = (RemoteMethod)selection.getFirstElement();
        this.method = remoteMethod.getMethod();
        RemoteMethod.Parameter[] p = remoteMethod.getParameters();
        this.methodArguments = new Object[p.length];
        int i = 0;
        while (i < p.length) {
            String name = p[i].getParameter().getName();
            String arg = p[i].getArgument();
            this.methodArguments[i] = name.equals("char") ? new Character(arg.charAt(0)) : (name.equals("boolean") ? Boolean.valueOf(arg) : (name.equals("int") ? Integer.valueOf(arg) : (name.equals("double") ? Double.valueOf(arg) : (name.equals("float") ? Float.valueOf(arg) : (name.equals("long") ? Long.valueOf(arg) : (name.equals("short") ? Short.valueOf(arg) : (name.equals("byte") ? Byte.valueOf(arg) : arg)))))));
            ++i;
        }
        this.timeout = Integer.parseInt(this.timeoutText.getText());
        this.invocationType = this.invocationCombo.getSelectionIndex();
        super.okPressed();
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getMethodArguments() {
        return this.methodArguments;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getInvocationType() {
        return this.invocationType;
    }
}

