/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.examples.remoteservices.client;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.ServiceUnavailableException;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.IAsyncResult;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.ui.views.AbstractRemoteServiceAccessHandler;
import org.eclipse.ecf.examples.remoteservices.common.IRemoteEnvironmentInfo;
import org.eclipse.ecf.internal.examples.remoteservices.client.Activator;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;
import org.eclipse.ecf.remoteservices.ui.MethodInvocationDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class RemoteEnvironmentInfoServiceAccessHandler
extends AbstractRemoteServiceAccessHandler {
    static Map remoteEnvironmentContainers = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected IContributionItem[] getContributionsForMatchingService() {
        IContainer container = null;
        try {
            IRemoteServiceContainerAdapter adapter;
            container = this.findContainerForService(this.getServiceInfo().getServiceID());
            if (container == null) {
                return EMPTY_CONTRIBUTION;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IRemoteServiceContainerAdapter)container.getAdapter((Class)clazz)) == null) {
                return EMPTY_CONTRIBUTION;
            }
            if (container.getConnectedID() == null) {
                return this.getContributionItemsForConnect(container, this.createConnectID());
            }
            return this.getContributionItemsForConnectedContainer(container, adapter);
        }
        catch (ECFException eCFException) {
            return EMPTY_CONTRIBUTION;
        }
    }

    protected IContributionItem[] getContributionItemsForRemoteServiceAdapter(IRemoteServiceContainerAdapter adapter) {
        try {
            IRemoteServiceReference[] references = this.getRemoteServiceReferencesForRemoteServiceAdapter(adapter);
            if (references == null) {
                return NOT_AVAILABLE_CONTRIBUTION;
            }
            IRemoteService remoteService = adapter.getRemoteService(references[0]);
            IContributionItem[] iContributionItemArray = new IContributionItem[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ecf.examples.remoteservices.common.IRemoteEnvironmentInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iContributionItemArray[0] = this.createDialogContributionItem(clazz, remoteService);
            return iContributionItemArray;
        }
        catch (Exception exception) {
            return NOT_AVAILABLE_CONTRIBUTION;
        }
    }

    private IContributionItem createDialogContributionItem(final Class interfaceClass, final IRemoteService remoteService) {
        Action action = new Action(){

            public void run() {
                MethodInvocationDialog mid;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ecf.examples.remoteservices.common.IRemoteEnvironmentInfo");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((mid = new MethodInvocationDialog(null, (Class)clazz)).open() == 0) {
                    int timeout = mid.getTimeout() > 0 ? mid.getTimeout() : 30000;
                    String methodName = mid.getMethod().getName();
                    Object[] methodArgs = mid.getMethodArguments();
                    IRemoteCall remoteCall = new IRemoteCall(this, methodName, methodArgs, timeout){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ String val$methodName;
                        private final /* synthetic */ Object[] val$methodArgs;
                        private final /* synthetic */ int val$timeout;
                        {
                            this.this$1 = var1_1;
                            this.val$methodName = string;
                            this.val$methodArgs = objectArray;
                            this.val$timeout = n;
                        }

                        public String getMethod() {
                            return this.val$methodName;
                        }

                        public Object[] getParameters() {
                            return this.val$methodArgs;
                        }

                        public long getTimeout() {
                            return this.val$timeout;
                        }
                    };
                    int invokeType = mid.getInvocationType();
                    try {
                        switch (invokeType) {
                            case 2: {
                                RemoteEnvironmentInfoServiceAccessHandler.this.invokeAsyncFire(interfaceClass, remoteService, remoteCall);
                                break;
                            }
                            case 1: {
                                RemoteEnvironmentInfoServiceAccessHandler.this.invokeFuture(interfaceClass, remoteService, remoteCall);
                                break;
                            }
                            case 0: {
                                RemoteEnvironmentInfoServiceAccessHandler.this.invokeAsyncListener(interfaceClass, remoteService, remoteCall);
                                break;
                            }
                            case 3: {
                                RemoteEnvironmentInfoServiceAccessHandler.this.invokeOSGiProxy(interfaceClass, remoteCall);
                                break;
                            }
                            case 4: {
                                RemoteEnvironmentInfoServiceAccessHandler.this.invokeProxy(interfaceClass, remoteService, remoteCall);
                                break;
                            }
                            case 5: {
                                RemoteEnvironmentInfoServiceAccessHandler.this.invokeSync(interfaceClass, remoteService, remoteCall);
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        RemoteEnvironmentInfoServiceAccessHandler.this.showException(e);
                    }
                }
            }
        };
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.examples.remoteservices.common.IRemoteEnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        action.setText(NLS.bind((String)"Invoke method on IRemoteEnvironmentInfo service...", (Object)clazz.getName()));
        return new ActionContributionItem((IAction)action);
    }

    protected void invokeProxy(Class interfaceClass, IRemoteService remoteService, IRemoteCall remoteCall) throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.examples.remoteservices.common.IRemoteEnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (interfaceClass.equals(clazz)) {
            this.invokeRemoteEnvironmentInfoProxy(remoteService, remoteCall);
        }
    }

    protected void invokeOSGiProxy(Class interfaceClass, IRemoteCall remoteCall) throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.examples.remoteservices.common.IRemoteEnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (interfaceClass.equals(clazz)) {
            this.invokeOSGiRemoteEnvironmentInfoProxy(remoteCall);
        }
    }

    private void invokeAsyncListener(final Class interfaceClass, IRemoteService remoteService, final IRemoteCall remoteCall) {
        remoteService.callAsynch(remoteCall, new IRemoteCallListener(){

            public void handleEvent(IRemoteCallEvent event) {
                if (event instanceof IRemoteCallCompleteEvent) {
                    IRemoteCallCompleteEvent complete = (IRemoteCallCompleteEvent)event;
                    if (complete.hadException()) {
                        RemoteEnvironmentInfoServiceAccessHandler.this.showException(complete.getException());
                    } else {
                        RemoteEnvironmentInfoServiceAccessHandler.this.showResult(interfaceClass.getName(), remoteCall, complete.getResponse());
                    }
                }
            }
        });
    }

    private void invokeAsyncFire(Class interfaceClass, IRemoteService remoteService, IRemoteCall remoteCall) {
        remoteService.callAsynch(remoteCall);
    }

    private void invokeSync(Class interfaceClass, IRemoteService remoteService, IRemoteCall remoteCall) throws ECFException {
        Object result = remoteService.callSynch(remoteCall);
        this.showResult(interfaceClass.getName(), remoteCall, result);
    }

    private void invokeFuture(Class interfaceClass, IRemoteService remoteService, IRemoteCall remoteCall) throws InvocationTargetException, InterruptedException {
        IAsyncResult asyncResult = remoteService.callAsynch(remoteCall);
        this.showResult(interfaceClass.getName(), remoteCall, asyncResult.get());
    }

    private void invokeRemoteEnvironmentInfo(IRemoteCall remoteCall, IRemoteEnvironmentInfo proxy) throws Exception {
        Class<?> clazz;
        Object result = null;
        if (remoteCall.getMethod().equals("getCommandLineArgs")) {
            result = proxy.getCommandLineArgs();
        } else if (remoteCall.getMethod().equals("getFrameworkArgs")) {
            result = proxy.getFrameworkArgs();
        } else if (remoteCall.getMethod().equals("getNL")) {
            result = proxy.getNL();
        } else if (remoteCall.getMethod().equals("getNonFrameworkArgs")) {
            result = proxy.getNonFrameworkArgs();
        } else if (remoteCall.getMethod().equals("getOS")) {
            result = proxy.getOS();
        } else if (remoteCall.getMethod().equals("getOSArch")) {
            result = proxy.getOSArch();
        } else if (remoteCall.getMethod().equals("getWS")) {
            result = proxy.getWS();
        } else {
            this.showException(new Exception("Invalid method selected"));
            return;
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.examples.remoteservices.common.IRemoteEnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.showResult(clazz.getName(), remoteCall, result);
    }

    private void invokeRemoteEnvironmentInfoProxy(IRemoteService remoteService, IRemoteCall remoteCall) throws Exception {
        this.invokeRemoteEnvironmentInfo(remoteCall, (IRemoteEnvironmentInfo)remoteService.getProxy());
    }

    private void invokeOSGiRemoteEnvironmentInfoProxy(IRemoteCall remoteCall) throws Exception {
        BundleContext bundleContext = Activator.getDefault().getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.examples.remoteservices.common.IRemoteEnvironmentInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServiceTracker st = new ServiceTracker(bundleContext, clazz.getName(), null);
        st.open();
        IRemoteEnvironmentInfo proxy = (IRemoteEnvironmentInfo)st.getService();
        st.close();
        if (proxy == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ecf.examples.remoteservices.common.IRemoteEnvironmentInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.showException(new ServiceUnavailableException(NLS.bind((String)"{0} remote service not available", (Object)clazz2.getName())));
            return;
        }
        this.invokeRemoteEnvironmentInfo(remoteCall, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IContainer findContainerForService(IServiceID serviceID) throws ContainerCreateException {
        IContainer result = null;
        Map map = remoteEnvironmentContainers;
        synchronized (map) {
            result = (IContainer)remoteEnvironmentContainers.get(serviceID);
            if (result == null) {
                result = this.createContainer();
                remoteEnvironmentContainers.put(serviceID, result);
            }
        }
        return result;
    }

    private IContributionItem[] getContributionItemsForConnect(final IContainer container, final ID targetID) {
        Action action = new Action(){

            public void run() {
                try {
                    RemoteEnvironmentInfoServiceAccessHandler.this.connectContainer(container, targetID, null);
                }
                catch (ContainerConnectException e) {
                    RemoteEnvironmentInfoServiceAccessHandler.this.showException(e);
                }
            }
        };
        action.setText(NLS.bind((String)"Connect to {0}", (Object)targetID.getName()));
        return new IContributionItem[]{new ActionContributionItem((IAction)action)};
    }
}

