/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.discovery;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.AbstractDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.DiscoveryContainerConfig;
import org.eclipse.ecf.discovery.IDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.IServiceTypeEvent;
import org.eclipse.ecf.discovery.IServiceTypeListener;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.discovery.service.IDiscoveryService;

public class CompositeDiscoveryContainer
extends AbstractDiscoveryContainerAdapter
implements IDiscoveryService {
    public static final String NAME = "ecf.discovery.composite";
    private static final String METHODS_CATCHING = "org.eclipse.ecf.provider.discovery/debug/methods/catching";
    private static final String METHODS_TRACING = "org.eclipse.ecf.provider.discovery/debug/methods/tracing";
    protected final CompositeContainerServiceListener ccsl;
    protected final CompositeContainerServiceTypeListener ccstl;
    protected final List containers;
    static /* synthetic */ Class class$0;

    public CompositeDiscoveryContainer(List containers) throws IDCreateException {
        IIDFactory iIDFactory = IDFactory.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.discovery.CompositeDiscoveryContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super("ecf.namespace.composite", new DiscoveryContainerConfig(iIDFactory.createStringID(clazz.getName())));
        this.ccsl = new CompositeContainerServiceListener();
        this.ccstl = new CompositeContainerServiceTypeListener();
        this.containers = containers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ID targetID, IConnectContext connectContext) throws ContainerConnectException {
        List list = this.containers;
        synchronized (list) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IContainer container = (IContainer)itr.next();
                if (container.getConnectedID() == null) {
                    container.connect(targetID, connectContext);
                }
                IDiscoveryContainerAdapter idca = (IDiscoveryContainerAdapter)container;
                idca.addServiceListener((IServiceListener)this.ccsl);
                idca.addServiceTypeListener((IServiceTypeListener)this.ccstl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectingEvent(this.getID(), this.getConnectedID()));
        List list = this.containers;
        synchronized (list) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IContainer container = (IContainer)itr.next();
                container.disconnect();
            }
        }
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), this.getConnectedID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.disconnect();
        List list = this.containers;
        synchronized (list) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IContainer container = (IContainer)itr.next();
                container.dispose();
            }
        }
        super.dispose();
    }

    public ID getConnectedID() {
        return this.getID();
    }

    public Namespace getConnectNamespace() {
        throw new UnsupportedOperationException("CompositeDiscoveryContainer#getConnectNamespace not yet implemented");
    }

    private IServiceID getServiceIDForDiscoveryContainer(IServiceID service, IDiscoveryContainerAdapter dca) {
        Namespace connectNamespace = dca.getServicesNamespace();
        if (!connectNamespace.equals((Object)service.getNamespace())) {
            try {
                return ServiceIDFactory.getDefault().createServiceID(connectNamespace, service.getServiceTypeID().getName(), service.getName());
            }
            catch (IDCreateException e) {
                Trace.catching((String)"org.eclipse.ecf.provider.discovery", (String)METHODS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getServiceTypeIDForDiscoveryContainer", (Throwable)e);
            }
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo getServiceInfo(IServiceID aService) {
        List list = this.containers;
        synchronized (list) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IServiceID isi;
                IDiscoveryContainerAdapter idca = (IDiscoveryContainerAdapter)itr.next();
                IServiceInfo service = idca.getServiceInfo(isi = this.getServiceIDForDiscoveryContainer(aService, idca));
                if (service == null) continue;
                return service;
            }
        }
        return null;
    }

    private IServiceInfo getServiceInfoForDiscoveryContainer(IServiceInfo aSi, IDiscoveryContainerAdapter idca) {
        IServiceID serviceID = this.getServiceIDForDiscoveryContainer(aSi.getServiceID(), idca);
        return new ServiceInfo(aSi.getLocation(), serviceID, aSi.getPriority(), aSi.getWeight(), aSi.getServiceProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo[] getServices() {
        HashSet<IServiceInfo> set = new HashSet<IServiceInfo>();
        List list = this.containers;
        synchronized (list) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IDiscoveryContainerAdapter idca = (IDiscoveryContainerAdapter)itr.next();
                IServiceInfo[] services = idca.getServices();
                set.addAll(Arrays.asList(services));
            }
        }
        return set.toArray(new IServiceInfo[set.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo[] getServices(IServiceTypeID type) {
        HashSet<IServiceInfo> set = new HashSet<IServiceInfo>();
        List list = this.containers;
        synchronized (list) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IDiscoveryContainerAdapter idca = (IDiscoveryContainerAdapter)itr.next();
                IServiceTypeID isti = this.getServiceTypeIDForDiscoveryContainer(type, idca);
                IServiceInfo[] services = idca.getServices(isti);
                set.addAll(Arrays.asList(services));
            }
        }
        return set.toArray(new IServiceInfo[set.size()]);
    }

    private IServiceTypeID getServiceTypeIDForDiscoveryContainer(IServiceTypeID type, IDiscoveryContainerAdapter dca) {
        Namespace connectNamespace = dca.getServicesNamespace();
        if (!connectNamespace.equals((Object)type.getNamespace())) {
            try {
                return (IServiceTypeID)connectNamespace.createInstance(new Object[]{type});
            }
            catch (IDCreateException e) {
                Trace.catching((String)"org.eclipse.ecf.provider.discovery", (String)METHODS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getServiceTypeIDForDiscoveryContainer", (Throwable)e);
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceTypeID[] getServiceTypes() {
        HashSet<IServiceTypeID> set = new HashSet<IServiceTypeID>();
        List list = this.containers;
        synchronized (list) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IDiscoveryContainerAdapter idca = (IDiscoveryContainerAdapter)itr.next();
                IServiceTypeID[] services = idca.getServiceTypes();
                set.addAll(Arrays.asList(services));
            }
        }
        return set.toArray(new IServiceTypeID[set.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(IServiceInfo serviceInfo) throws ECFException {
        List list = this.containers;
        synchronized (list) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IDiscoveryContainerAdapter dca = (IDiscoveryContainerAdapter)itr.next();
                IServiceInfo isi = this.getServiceInfoForDiscoveryContainer(serviceInfo, dca);
                dca.registerService(isi);
                Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)METHODS_TRACING, ((Object)((Object)this)).getClass(), (String)"registerService", (String)("registeredService " + serviceInfo.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(IServiceInfo serviceInfo) throws ECFException {
        List list = this.containers;
        synchronized (list) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IDiscoveryContainerAdapter idca = (IDiscoveryContainerAdapter)itr.next();
                IServiceInfo isi = this.getServiceInfoForDiscoveryContainer(serviceInfo, idca);
                idca.unregisterService(isi);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addContainer(Object object) {
        List list = this.containers;
        synchronized (list) {
            Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)METHODS_TRACING, ((Object)((Object)this)).getClass(), (String)"addContainer(Object)", (String)("addContainer " + object.toString()));
            return this.containers.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeContainer(Object object) {
        List list = this.containers;
        synchronized (list) {
            Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)METHODS_TRACING, ((Object)((Object)this)).getClass(), (String)"removeContainer(Object)", (String)("removeContainer " + object.toString()));
            return this.containers.remove(object);
        }
    }

    protected class CompositeContainerServiceListener
    implements IServiceListener {
        protected CompositeContainerServiceListener() {
        }

        public void serviceDiscovered(IServiceEvent event) {
            Collection col = CompositeDiscoveryContainer.this.getListeners(event.getServiceInfo().getServiceID().getServiceTypeID());
            if (!col.isEmpty()) {
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    IServiceListener isl = (IServiceListener)itr.next();
                    isl.serviceDiscovered(event);
                    Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)CompositeDiscoveryContainer.METHODS_TRACING, this.getClass(), (String)"serviceDiscovered", (String)("serviceResolved fired for listener " + isl.toString() + " with event: " + event.toString()));
                }
            } else {
                Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)CompositeDiscoveryContainer.METHODS_TRACING, this.getClass(), (String)"serviceDiscovered", (String)"serviceResolved fired without any listeners present");
            }
        }

        public void serviceUndiscovered(IServiceEvent event) {
            Collection col = CompositeDiscoveryContainer.this.getListeners(event.getServiceInfo().getServiceID().getServiceTypeID());
            if (!col.isEmpty()) {
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    IServiceListener isl = (IServiceListener)itr.next();
                    isl.serviceUndiscovered(event);
                    Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)CompositeDiscoveryContainer.METHODS_TRACING, this.getClass(), (String)"serviceUndiscovered", (String)("serviceRemoved fired for listener " + isl.toString() + " with event: " + event.toString()));
                }
            } else {
                Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)CompositeDiscoveryContainer.METHODS_TRACING, this.getClass(), (String)"serviceUndiscovered", (String)"serviceRemoved fired without any listeners present");
            }
        }
    }

    protected class CompositeContainerServiceTypeListener
    implements IServiceTypeListener {
        protected CompositeContainerServiceTypeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void serviceTypeDiscovered(IServiceTypeEvent event) {
            Collection collection = CompositeDiscoveryContainer.this.serviceTypeListeners;
            synchronized (collection) {
                Iterator itr = CompositeDiscoveryContainer.this.serviceTypeListeners.iterator();
                while (itr.hasNext()) {
                    IServiceTypeListener listener = (IServiceTypeListener)itr.next();
                    listener.serviceTypeDiscovered(event);
                    Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)CompositeDiscoveryContainer.METHODS_TRACING, this.getClass(), (String)"serviceTypeDiscovered", (String)("serviceTypeDiscovered fired for listener " + listener.toString() + " with event: " + event.toString()));
                }
            }
            IServiceTypeID istid = event.getServiceTypeID();
            List list = CompositeDiscoveryContainer.this.containers;
            synchronized (list) {
                Iterator itr = CompositeDiscoveryContainer.this.containers.iterator();
                while (itr.hasNext()) {
                    IDiscoveryContainerAdapter idca = (IDiscoveryContainerAdapter)itr.next();
                    idca.addServiceListener(istid, (IServiceListener)CompositeDiscoveryContainer.this.ccsl);
                }
            }
        }
    }
}

