/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.ISharedObjectConnector;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectEvent;
import org.eclipse.ecf.core.sharedobject.events.SharedObjectCallEvent;
import org.eclipse.ecf.core.sharedobject.util.IQueueEnqueue;
import org.eclipse.ecf.core.sharedobject.util.QueueException;
import org.eclipse.ecf.core.util.AsyncResult;
import org.eclipse.ecf.core.util.Event;
import org.eclipse.ecf.core.util.IAsyncResult;

public class SOConnector
implements ISharedObjectConnector {
    ID sender;
    Hashtable receiverQueues = new Hashtable();

    public SOConnector(ID sender, ID[] recv, IQueueEnqueue[] queues) {
        int i = 0;
        while (i < recv.length) {
            this.receiverQueues.put(recv[i], queues[i]);
            ++i;
        }
    }

    protected void fireEvent(ISharedObjectEvent event) throws QueueException {
        Enumeration e = this.receiverQueues.elements();
        while (e.hasMoreElements()) {
            IQueueEnqueue queue = (IQueueEnqueue)e.nextElement();
            queue.enqueue((Event)event);
        }
    }

    protected void fireEvents(ISharedObjectEvent[] event) throws QueueException {
        Enumeration e = this.receiverQueues.elements();
        while (e.hasMoreElements()) {
            IQueueEnqueue queue = (IQueueEnqueue)e.nextElement();
            if (queue == null) continue;
            queue.enqueue((Event[])event);
        }
    }

    protected IAsyncResult[] fireCallEvent(ISharedObjectEvent event) throws QueueException {
        IAsyncResult[] results = new IAsyncResult[this.receiverQueues.size()];
        int i = 0;
        Enumeration e = this.receiverQueues.elements();
        while (e.hasMoreElements()) {
            IQueueEnqueue queue = (IQueueEnqueue)e.nextElement();
            results[i] = new AsyncResult();
            queue.enqueue((Event)new SharedObjectCallEvent(event.getSenderSharedObjectID(), (Event)event, results[i]));
        }
        return results;
    }

    public ID getSenderID() {
        return this.sender;
    }

    public ID[] getReceiverIDs() {
        return this.receiverQueues.keySet().toArray(new ID[this.receiverQueues.size()]);
    }

    public void enqueue(ISharedObjectEvent event) throws QueueException {
        this.fireEvent(event);
    }

    public void enqueue(ISharedObjectEvent[] events) throws QueueException {
        this.fireEvents(events);
    }

    public IAsyncResult[] callAsynch(ISharedObjectEvent arg) throws Exception {
        return this.fireCallEvent(arg);
    }

    public void dispose() {
        if (this.receiverQueues != null) {
            this.receiverQueues.clear();
            this.receiverQueues = null;
        }
        this.sender = null;
    }
}

