/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provisional.docshare.cola;

import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provisional.docshare.cola.ColaUpdateMessage;
import org.eclipse.ecf.internal.provisional.docshare.cola.TransformationStrategy;
import org.eclipse.ecf.internal.provisional.docshare.messages.UpdateMessage;

public class ColaInsertion
implements TransformationStrategy {
    private static final long serialVersionUID = 5192625383622519749L;
    private static ColaInsertion INSTANCE;

    private ColaInsertion() {
    }

    public static TransformationStrategy getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ColaInsertion();
        }
        return INSTANCE;
    }

    public ColaUpdateMessage getOperationalTransform(ColaUpdateMessage remoteIncomingMsg, ColaUpdateMessage localAppliedMsg, boolean localMsgHighPrio) {
        Trace.entering((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/entering", this.getClass(), (String)"getOperationalTransform", (Object[])new Object[]{remoteIncomingMsg, localAppliedMsg, new Boolean(localMsgHighPrio)});
        ColaUpdateMessage remoteTransformedMsg = remoteIncomingMsg;
        if (localAppliedMsg.isInsertion()) {
            if (remoteTransformedMsg.getOffset() < localAppliedMsg.getOffset()) {
                localAppliedMsg.setOffset(localAppliedMsg.getOffset() + remoteTransformedMsg.getOffset());
            } else if (remoteTransformedMsg.getOffset() == localAppliedMsg.getOffset()) {
                if (localMsgHighPrio) {
                    remoteTransformedMsg.setOffset(remoteTransformedMsg.getOffset() + localAppliedMsg.getText().length());
                } else {
                    localAppliedMsg.setOffset(localAppliedMsg.getOffset() + remoteTransformedMsg.getText().length());
                }
            } else if (remoteTransformedMsg.getOffset() > localAppliedMsg.getOffset()) {
                remoteTransformedMsg.setOffset(remoteTransformedMsg.getOffset() + localAppliedMsg.getText().length());
            }
        } else if (localAppliedMsg.isDeletion()) {
            if (remoteTransformedMsg.getOffset() <= localAppliedMsg.getOffset()) {
                localAppliedMsg.setOffset(localAppliedMsg.getOffset() + remoteTransformedMsg.getLengthOfInsertedText());
            } else if (remoteTransformedMsg.getOffset() > localAppliedMsg.getOffset()) {
                if (remoteTransformedMsg.getOffset() > localAppliedMsg.getOffset() + localAppliedMsg.getLengthOfReplacedText()) {
                    remoteTransformedMsg.setOffset(remoteTransformedMsg.getOffset() - localAppliedMsg.getLengthOfReplacedText());
                } else if (remoteTransformedMsg.getOffset() <= localAppliedMsg.getOffset() + localAppliedMsg.getLengthOfReplacedText()) {
                    UpdateMessage deletionFirstMessage = new UpdateMessage(localAppliedMsg.getOffset(), remoteTransformedMsg.getOffset() - localAppliedMsg.getOffset(), localAppliedMsg.getText());
                    ColaUpdateMessage deletionFirstPart = new ColaUpdateMessage(deletionFirstMessage, localAppliedMsg.getLocalOperationsCount(), localAppliedMsg.getRemoteOperationsCount());
                    localAppliedMsg.addToSplitUpRepresentation(deletionFirstPart);
                    UpdateMessage deletionSecondMessage = new UpdateMessage(localAppliedMsg.getOffset() + remoteTransformedMsg.getLengthOfInsertedText(), localAppliedMsg.getLengthOfReplacedText() - deletionFirstPart.getLengthOfReplacedText(), localAppliedMsg.getText());
                    ColaUpdateMessage deletionSecondPart = new ColaUpdateMessage(deletionSecondMessage, localAppliedMsg.getLocalOperationsCount(), localAppliedMsg.getRemoteOperationsCount());
                    localAppliedMsg.addToSplitUpRepresentation(deletionSecondPart);
                    localAppliedMsg.setSplitUp(true);
                    remoteTransformedMsg.setOffset(localAppliedMsg.getOffset());
                }
            }
        }
        Trace.exiting((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/exiting", this.getClass(), (String)"getOperationalTransform", (Object)remoteTransformedMsg);
        return remoteTransformedMsg;
    }
}

