/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.protocol.bittorrent.internal.net;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.ecf.protocol.bittorrent.IHashCheckListener;
import org.eclipse.ecf.protocol.bittorrent.IPieceProgressListener;
import org.eclipse.ecf.protocol.bittorrent.ITorrentErrorListener;
import org.eclipse.ecf.protocol.bittorrent.ITorrentProgressListener;
import org.eclipse.ecf.protocol.bittorrent.ITorrentStateListener;
import org.eclipse.ecf.protocol.bittorrent.TorrentConfiguration;
import org.eclipse.ecf.protocol.bittorrent.TorrentFile;
import org.eclipse.ecf.protocol.bittorrent.TorrentServer;
import org.eclipse.ecf.protocol.bittorrent.internal.encode.BEncodedDictionary;
import org.eclipse.ecf.protocol.bittorrent.internal.encode.Decode;
import org.eclipse.ecf.protocol.bittorrent.internal.encode.Encode;
import org.eclipse.ecf.protocol.bittorrent.internal.net.ConnectionPool;
import org.eclipse.ecf.protocol.bittorrent.internal.torrent.DataFile;
import org.eclipse.ecf.protocol.bittorrent.internal.torrent.Piece;
import org.eclipse.ecf.protocol.bittorrent.internal.torrent.PieceState;

public class TorrentManager {
    private static final String DOWN_SPEED_KEY = "down.speed";
    private static final String UP_SPEED_KEY = "up.speed";
    private static MessageDigest shaDigest;
    private static File statePath;
    private final ConnectionPool connectionPool;
    private final DataFile[] files;
    private final Vector stateListeners;
    private final Vector progressListeners;
    private final Vector errorListeners;
    private final Vector pieceListeners;
    private final Vector hashCheckListeners;
    private final TorrentFile torrent;
    private final Properties properties;
    private final File propertiesFile;
    private final File targetFile;
    private final File torrentState;
    private final Vector pieces;
    private final Vector incompletePieces;
    private final int[] pieceAvailability;
    private final byte[] bitfield;
    private final boolean[] hasPiece;
    private final boolean[] priorityPieces;
    private final boolean[] interestedPieces;
    private final boolean[] uninterestedPieces;
    private final String infoHash;
    private final String tracker;
    private final String peerID = "E088----" + TorrentManager.createPeerID();
    private final String hexHash;
    private final char key = TorrentManager.createKey();
    private final long total;
    private final int pieceLength;
    private TrackerThread trackerThread;
    private SpeedMonitoringThread speedMonitoringThread;
    private HashCheckThread hashCheckThread;
    private PieceState[] states;
    private String trackerID;
    private long downloaded = 0L;
    private long uploaded = 0L;
    private long downSpeed = 0L;
    private long upSpeed = 0L;
    private long maxDownSpeed = -1L;
    private long maxUpSpeed = -1L;
    private long requestDownSpeed = -1L;
    private long requestUpSpeed = -1L;
    private long discarded = 0L;
    private long remaining;
    private int request = 50;
    private int seeders = -1;
    private int peers = -1;
    private int timeout = 1800000;
    private int completedPieces = 0;
    private int state = 2;
    private boolean running = false;
    private boolean isCompleted = false;
    private boolean isSelective = false;
    private boolean isPrioritizing = false;
    private boolean isWaitingToStart = false;
    private boolean isHashChecking = false;

    static {
        try {
            shaDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStatePath(File path) {
        statePath = path;
    }

    private static String createPeerID() {
        char[] numbers = new char[12];
        int i = 0;
        while (i < 12) {
            numbers[i] = (char)(48 + ConnectionPool.RANDOM.nextInt(10));
            ++i;
        }
        return new String(numbers);
    }

    private static char createKey() {
        char key = (char)(ConnectionPool.RANDOM.nextInt(75) + 48);
        while (!Character.isDigit(key) && !Character.isLetter(key)) {
            key = (char)(ConnectionPool.RANDOM.nextInt(75) + 48);
        }
        return key;
    }

    public TorrentManager(TorrentFile torrent, Properties properties) throws IOException {
        this.torrent = torrent;
        this.targetFile = torrent.getTargetFile();
        this.connectionPool = new ConnectionPool(this);
        this.tracker = torrent.getTracker();
        this.pieceLength = torrent.getPieceLength();
        this.infoHash = torrent.getInfoHash();
        this.hexHash = torrent.getHexHash();
        this.torrentState = new File(statePath, this.hexHash);
        this.total = torrent.getTotalLength();
        torrent.save(new File(statePath, String.valueOf(this.hexHash) + ".torrent"));
        int numPieces = torrent.getNumPieces();
        this.pieces = new Vector(numPieces);
        this.trackerThread = new TrackerThread();
        this.states = PieceState.createStates(numPieces);
        int i = 0;
        while (i < numPieces) {
            this.pieces.add(new Piece(this.states[i], i));
            ++i;
        }
        this.bitfield = new byte[numPieces % 8 != 0 ? numPieces / 8 + 1 : numPieces / 8];
        this.hasPiece = new boolean[numPieces];
        this.pieceAvailability = new int[numPieces];
        this.priorityPieces = new boolean[numPieces];
        this.interestedPieces = new boolean[numPieces];
        this.uninterestedPieces = new boolean[numPieces];
        this.incompletePieces = new Vector();
        this.stateListeners = new Vector();
        this.errorListeners = new Vector();
        this.pieceListeners = new Vector();
        this.progressListeners = new Vector();
        this.hashCheckListeners = new Vector();
        this.propertiesFile = new File(statePath, String.valueOf(this.hexHash) + ".properties");
        if (!this.propertiesFile.exists()) {
            properties = new Properties();
            properties.setProperty("target", this.targetFile.getAbsolutePath());
        } else if (properties == null) {
            properties = new Properties();
            properties.load(new FileInputStream(this.propertiesFile));
            this.restore(properties);
        } else {
            this.restore(properties);
        }
        this.properties = properties;
        this.store();
        String[] filenames = torrent.getFilenames();
        if (filenames.length != 1 && !this.targetFile.exists() && !this.targetFile.mkdirs()) {
            throw new IOException("The folders needed by this torrent could not be created");
        }
        this.files = new DataFile[filenames.length];
        this.fileInitialization(filenames, this.targetFile);
        int i2 = 0;
        while (i2 < numPieces) {
            Piece piece = (Piece)this.pieces.get(i2);
            piece.setLength(this.pieceLength);
            ++i2;
        }
        ((Piece)this.pieces.get(numPieces - 1)).setLength((int)(this.total % (long)this.pieceLength));
        this.checkFile();
        this.setPieces();
    }

    private void checkFile() {
        block8: {
            if (this.torrentState.exists()) {
                int count = 0;
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(this.torrentState));
                    String input = reader.readLine();
                    if (input != null && Long.parseLong(input) == this.targetFile.lastModified()) {
                        input = reader.readLine();
                        PieceState[] states = PieceState.createStates(this.torrent.getNumPieces());
                        while (input != null) {
                            states[count++].parse(input);
                            input = reader.readLine();
                        }
                        if (count != states.length) {
                            this.startHashCheck();
                        } else {
                            this.setPieces(states);
                        }
                        break block8;
                    }
                    this.startHashCheck();
                }
                catch (IOException iOException) {
                    this.startHashCheck();
                }
            } else {
                this.startHashCheck();
            }
        }
    }

    public boolean performHashCheck() {
        switch (this.state) {
            case 2: {
                this.startHashCheck();
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    private void startHashCheck() {
        if (this.hashCheckThread == null || !this.hashCheckThread.isAlive()) {
            this.hashCheckThread = new HashCheckThread();
            this.hashCheckThread.start();
            this.isHashChecking = true;
            this.fireStateChangedEvent(4);
        }
    }

    private void fileInitialization(String[] filenames, File targetFile) throws IOException {
        if (this.files.length == 1) {
            long length = this.torrent.getLengths()[0];
            this.files[0] = new DataFile(targetFile, length);
            int[] pieces = new int[this.torrent.getPieces().length];
            int i = 0;
            while (i < pieces.length) {
                pieces[i] = i;
                ++i;
            }
            this.files[0].setPieces(pieces, this.pieceLength, this.pieceLength);
            this.remaining = length;
        } else {
            int count = 0;
            int piece = 0;
            int currentLength = this.pieceLength;
            int i = 0;
            while (i < filenames.length) {
                File file = new File(targetFile + File.separator + filenames[i]);
                if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                    throw new IOException("The folders needed by this torrent could not be created");
                }
                long fileLength = this.torrent.getLengths()[i];
                this.files[i] = new DataFile(file, fileLength);
                if ((long)currentLength > fileLength) {
                    this.files[i].setPieces(new int[]{count}, (int)fileLength, (int)fileLength);
                    currentLength = (int)((long)currentLength - fileLength);
                } else if ((long)currentLength == fileLength) {
                    this.files[i].setPieces(new int[]{count++}, (int)fileLength, (int)fileLength);
                    currentLength = this.pieceLength;
                    ++piece;
                } else {
                    if (currentLength != this.pieceLength && (long)currentLength < fileLength) {
                        fileLength -= (long)currentLength;
                        ++count;
                    }
                    while (fileLength >= (long)this.pieceLength) {
                        ++count;
                        fileLength -= (long)this.pieceLength;
                    }
                    int[] pieces = new int[++count - piece];
                    int j = piece;
                    while (j < count) {
                        pieces[j - piece] = j;
                        ++j;
                    }
                    if (fileLength == 0L) {
                        this.files[i].setPieces(pieces, this.pieceLength, this.pieceLength);
                    } else {
                        this.files[i].setPieces(pieces, currentLength, this.pieceLength);
                        currentLength = (int)((long)this.pieceLength - fileLength);
                    }
                    piece = --count;
                }
                ++i;
            }
            this.remaining = this.total;
        }
    }

    private void setPieces() {
        int count = 0;
        int pieceLen = this.pieceLength;
        int i = 0;
        while (i < this.files.length) {
            long length = this.files[i].length();
            if (pieceLen == 0) {
                pieceLen = this.pieceLength;
            }
            while ((long)pieceLen < length) {
                Piece piece = (Piece)this.pieces.get(count);
                piece.addFile(this.files[i], pieceLen);
                ++count;
                length -= (long)pieceLen;
                if (pieceLen >= this.pieceLength) continue;
                pieceLen = this.pieceLength;
            }
            pieceLen = (int)((long)pieceLen - length);
            ((Piece)this.pieces.get(count)).addFile(this.files[i], (int)length);
            ++i;
        }
    }

    private void restore(Properties properties) {
        String value = properties.getProperty(DOWN_SPEED_KEY);
        this.requestDownSpeed = value != null ? Long.parseLong(value) : -1L;
        value = properties.getProperty(UP_SPEED_KEY);
        this.requestUpSpeed = value != null ? Long.parseLong(value) : -1L;
    }

    private void store() throws IOException {
        this.properties.setProperty(DOWN_SPEED_KEY, Long.toString(this.requestDownSpeed));
        this.properties.setProperty(UP_SPEED_KEY, Long.toString(this.requestUpSpeed));
        this.properties.store(new FileOutputStream(this.propertiesFile), null);
    }

    private void updateBitfield() {
        int count = 0;
        int size = this.hasPiece.length;
        char[] bits = new char[8];
        int i = 0;
        while (i < size) {
            Arrays.fill(bits, '0');
            int j = i;
            while (j < i + 8 && j < size) {
                if (this.hasPiece[j]) {
                    bits[j - i] = 49;
                }
                ++j;
            }
            this.bitfield[count] = Encode.encodeForBitfield(bits);
            ++count;
            i += 8;
        }
    }

    private void updateBitfield(int piece) {
        int offset = piece / 8;
        char[] bits = new char[8];
        Arrays.fill(bits, '0');
        int i = offset;
        while (i < offset + 8 && i < this.hasPiece.length) {
            if (this.hasPiece[i]) {
                bits[i - offset] = 49;
            }
            ++i;
        }
        this.bitfield[offset] = Encode.encodeForBitfield(bits);
    }

    public void start() throws IOException {
        if (this.hashCheckThread != null && this.hashCheckThread.isAlive() && this.isHashChecking) {
            this.isWaitingToStart = true;
            return;
        }
        if (!this.torrentState.exists()) {
            this.startHashCheck();
            this.isWaitingToStart = true;
            return;
        }
        if (this.running) {
            return;
        }
        this.isWaitingToStart = false;
        this.running = true;
        this.speedMonitoringThread = new SpeedMonitoringThread();
        this.trackerThread = new TrackerThread();
        this.speedMonitoringThread.start();
        this.trackerThread.start();
        this.fireStateChangedEvent(0);
        this.queryTracker("started");
        this.fireStateChangedEvent(1);
    }

    public void stop() throws IOException {
        this.isWaitingToStart = false;
        if (this.hashCheckThread != null && this.hashCheckThread.isAlive()) {
            this.hashCheckThread.interrupt();
            this.isHashChecking = false;
            this.hashCheckThread = null;
            this.fireStateChangedEvent(2);
            return;
        }
        if (!this.running) {
            return;
        }
        this.state = 2;
        this.trackerThread.interrupt();
        this.speedMonitoringThread.interrupt();
        this.trackerThread = null;
        this.speedMonitoringThread = null;
        this.running = false;
        this.connectionPool.close();
        this.queryTracker("stopped");
        this.fireStateChangedEvent(2);
        this.store();
    }

    public void remove() {
        try {
            this.stop();
        }
        catch (IOException iOException) {}
        File[] files = statePath.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().startsWith(this.hexHash)) {
                files[i].delete();
            }
            ++i;
        }
        this.remaining = this.total;
        this.seeders = -1;
        this.peers = -1;
        Arrays.fill(this.priorityPieces, false);
        Arrays.fill(this.interestedPieces, false);
        Arrays.fill(this.uninterestedPieces, false);
        i = 0;
        while (i < this.pieces.size()) {
            ((Piece)this.pieces.get(i)).reset();
            ++i;
        }
    }

    public boolean delete() {
        this.remove();
        return this.targetFile.delete();
    }

    private void queryTracker(String event) throws IOException {
        Long number;
        String link = String.valueOf(this.tracker) + "?info_hash=" + URLEncoder.encode(this.infoHash, "ISO-8859-1").replaceAll("\\+", "%20") + "&peer_id=" + URLEncoder.encode(this.peerID, "ISO-8859-1").replaceAll("\\+", "%20") + "&port=" + TorrentServer.getPort() + "&uploaded=" + this.uploaded + "&downloaded=" + this.downloaded + "&left=" + this.remaining + (event == null ? "" : "&event=" + event) + "&numwant=" + this.request + "&compact=1" + "&key=" + this.key + (this.trackerID != null ? "&trackerid=" + this.trackerID : "");
        TorrentConfiguration.debug("Querying the tracker at " + link);
        URL url = new URL(link);
        BEncodedDictionary dictionary = Decode.bDecode(url.openStream());
        if (event != null && event.equals("stopped")) {
            return;
        }
        String failure = (String)dictionary.get("failure reason");
        if (failure != null) {
            this.fireTrackerErrorEvent(failure);
            TorrentConfiguration.debug("The client could not connect to the tracker, the reason provided was - " + failure);
            return;
        }
        this.timeout = ((Long)dictionary.get("interval")).intValue() * 1000;
        if (this.trackerID == null) {
            this.trackerID = (String)dictionary.get("tracker id");
        }
        this.seeders = (number = (Long)dictionary.get("completed")) != null ? number.intValue() : -1;
        number = (Long)dictionary.get("incompleted");
        this.peers = number != null ? number.intValue() : -1;
        Object peersList = dictionary.get("peers");
        if (peersList instanceof List) {
            TorrentConfiguration.debug("No peers were returned");
            return;
        }
        String string = (String)peersList;
        byte[] bytes = string.getBytes("ISO-8859-1");
        int i = 0;
        while (i < string.length()) {
            String ip = String.valueOf(bytes[i] & 0xFF) + "." + (bytes[i + 1] & 0xFF) + "." + (bytes[i + 2] & 0xFF) + "." + (bytes[i + 3] & 0xFF);
            int port = Integer.parseInt(String.valueOf(Integer.toHexString(bytes[i + 4] & 0xFF)) + Integer.toHexString(bytes[i + 5] & 0xFF), 16);
            this.connectionPool.connectTo(ip, port);
            i += 6;
        }
    }

    public void connectTo(SocketChannel channel) throws UnsupportedEncodingException {
        this.connectionPool.connectTo(channel);
    }

    private byte[] getPiece(int piece) throws IOException {
        if (piece < 0) {
            throw new IllegalArgumentException("The piece number cannot be negative");
        }
        if (piece >= this.hasPiece.length) {
            throw new IllegalArgumentException("The piece number " + piece + " does not exist");
        }
        byte[][] data = new byte[this.files.length][0];
        Arrays.fill((Object[])data, null);
        int i = 0;
        while (i < this.files.length) {
            if (this.files[i].containsPiece(piece)) {
                data[i] = this.files[i].getData(piece);
            }
            ++i;
        }
        boolean empty = true;
        int i2 = 0;
        while (i2 < data.length) {
            if (data[i2] != null && data[i2].length != 0) {
                empty = false;
                break;
            }
            ++i2;
        }
        if (empty) {
            return null;
        }
        byte[] bytes = new byte[((Piece)this.pieces.get(piece)).getLength()];
        int offset = 0;
        int i3 = 0;
        while (i3 < data.length) {
            if (data[i3] != null) {
                System.arraycopy(data[i3], 0, bytes, offset, data[i3].length);
                offset += data[i3].length;
            }
            ++i3;
        }
        return bytes;
    }

    byte[] getPieceData(int number, int offset, int length) throws IllegalArgumentException, IOException {
        byte[] piece = this.getPiece(number);
        if (piece == null) {
            return null;
        }
        if (offset + length > piece.length) {
            throw new IllegalArgumentException("The block of data that is being requested goes beyond the range of the requested piece");
        }
        byte[] block = new byte[length];
        System.arraycopy(piece, offset, block, 0, length);
        return block;
    }

    private boolean hashCheck(int piece) throws IllegalArgumentException, IOException {
        byte[] data = this.getPiece(piece);
        return data == null ? false : this.torrent.getPieces()[piece].equals(new String(shaDigest.digest(data), "ISO-8859-1"));
    }

    private void saveState() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.torrentState, false));
        writer.write(Long.toString(this.targetFile.lastModified()));
        writer.newLine();
        int i = 0;
        while (i < this.states.length) {
            writer.write(this.states[i].toString());
            writer.newLine();
            ++i;
        }
        writer.flush();
    }

    synchronized void write(int number, int index, byte[] data, int offset, int length) throws IOException {
        Piece piece = (Piece)this.pieces.get(number);
        if (!this.hasPiece[number] && piece.write(index, data, offset, length)) {
            this.remaining -= (long)length;
            this.downloaded += (long)length;
            this.saveState();
            this.fireBlockDownloadedEvent(number, index, length);
            if (!this.incompletePieces.contains(piece)) {
                this.incompletePieces.add(piece);
            }
            if (piece.isComplete()) {
                this.incompletePieces.remove(piece);
                this.checkCompletedPiece(piece, number);
            }
        }
    }

    private void checkCompletedPiece(Piece piece, int number) throws IOException {
        if (this.hashCheck(number)) {
            TorrentConfiguration.debug("Piece " + number + " passed hash check");
            this.hasPiece[number] = true;
            this.updateBitfield(number);
            this.firePieceCompletedEvent(++this.completedPieces);
            this.connectionPool.queueHaveMessage(number);
            int i = 0;
            while (i < this.hasPiece.length) {
                if (!this.hasPiece[i]) {
                    return;
                }
                ++i;
            }
            this.isCompleted = true;
            this.fireStateChangedEvent(3);
            this.connectionPool.disconnectSeeds();
            this.queryTracker("completed");
        } else {
            TorrentConfiguration.debug("Piece " + number + " has failed the hash check");
            piece.reset();
            int pieceLength = piece.getLength();
            this.discarded += (long)pieceLength;
            this.remaining += (long)(this.remaining == this.total ? 0 : pieceLength);
            this.firePieceDiscardEvent(number, pieceLength);
        }
    }

    synchronized Piece request(boolean[] peerPieces) {
        if (this.isCompleted) {
            return null;
        }
        Piece request = null;
        if (!this.isSelective) {
            request = this.request(this.hasPiece, peerPieces);
        } else if (this.isPrioritizing) {
            request = this.request(this.priorityPieces, peerPieces);
            if (request == null) {
                request = this.request(this.interestedPieces, peerPieces);
            }
        } else {
            request = this.request(this.interestedPieces, peerPieces);
        }
        return request;
    }

    private Piece request(boolean[] compare, boolean[] peerPieces) {
        int i;
        boolean isInterested = false;
        if (compare == this.hasPiece) {
            i = 0;
            while (i < peerPieces.length) {
                if (!this.hasPiece[i] && peerPieces[i]) {
                    isInterested = true;
                    break;
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < peerPieces.length) {
                if (compare[i] && peerPieces[i]) {
                    isInterested = true;
                    break;
                }
                ++i;
            }
        }
        if (!isInterested) {
            return null;
        }
        boolean hasIncompletePiece = false;
        int i2 = 0;
        while (i2 < this.incompletePieces.size()) {
            Piece piece = (Piece)this.incompletePieces.get(i2);
            if (peerPieces[piece.getNumber()]) {
                hasIncompletePiece = true;
                break;
            }
            ++i2;
        }
        if (hasIncompletePiece) {
            if (this.incompletePieces.size() == 0) {
                return this.hasPiece == compare ? this.getRarePiece(peerPieces) : this.getRarePiece(compare, peerPieces);
            }
            Piece piece = (Piece)this.incompletePieces.get(ConnectionPool.RANDOM.nextInt(this.incompletePieces.size()));
            while (!peerPieces[piece.getNumber()]) {
                if (this.isCompleted) {
                    return null;
                }
                if (this.incompletePieces.size() == 0) {
                    return this.hasPiece == compare ? this.getRarePiece(peerPieces) : this.getRarePiece(compare, peerPieces);
                }
                piece = (Piece)this.incompletePieces.get(ConnectionPool.RANDOM.nextInt(this.incompletePieces.size()));
            }
            return piece;
        }
        return this.hasPiece == compare ? this.getRarePiece(peerPieces) : this.getRarePiece(compare, peerPieces);
    }

    private Piece getRarePiece(boolean[] peerPieces) {
        int min = this.pieceAvailability[0];
        int i = 1;
        while (i < peerPieces.length) {
            if (!this.hasPiece[i] && peerPieces[i] && min > this.pieceAvailability[i]) {
                min = this.pieceAvailability[i];
            }
            ++i;
        }
        int size = this.pieces.size();
        int pieceNumber = ConnectionPool.RANDOM.nextInt(size);
        while (this.hasPiece[pieceNumber] || this.pieceAvailability[pieceNumber] != min || !peerPieces[pieceNumber]) {
            if (this.isCompleted) {
                return null;
            }
            pieceNumber = ConnectionPool.RANDOM.nextInt(size);
        }
        return (Piece)this.pieces.get(pieceNumber);
    }

    private Piece getRarePiece(boolean[] compare, boolean[] peerPieces) {
        int min = this.pieceAvailability[0];
        int i = 1;
        while (i < peerPieces.length) {
            if (!this.hasPiece[i] && compare[i] && peerPieces[i] && min > this.pieceAvailability[i]) {
                min = this.pieceAvailability[i];
            }
            ++i;
        }
        int size = this.pieces.size();
        int pieceNumber = ConnectionPool.RANDOM.nextInt(size);
        while (this.hasPiece[pieceNumber] || this.pieceAvailability[pieceNumber] != min || !compare[pieceNumber] || !peerPieces[pieceNumber]) {
            if (this.isCompleted) {
                return null;
            }
            pieceNumber = ConnectionPool.RANDOM.nextInt(size);
        }
        return (Piece)this.pieces.get(pieceNumber);
    }

    String getPeerID() {
        return this.peerID;
    }

    byte[] getBitfield() {
        return this.bitfield;
    }

    void updatePieceAvailability(int piece) {
        int n = piece;
        this.pieceAvailability[n] = this.pieceAvailability[n] + 1;
    }

    void addPieceAvailability(boolean[] peerPieces) {
        if (peerPieces.length != this.pieceAvailability.length) {
            throw new IllegalArgumentException("The length of the array is not " + this.pieceAvailability.length);
        }
        int i = 0;
        while (i < this.pieceAvailability.length) {
            if (peerPieces[i]) {
                int n = i;
                this.pieceAvailability[n] = this.pieceAvailability[n] + 1;
            }
            ++i;
        }
    }

    void removePieceAvailability(boolean[] peerPieces) {
        if (peerPieces.length != this.pieceAvailability.length) {
            throw new IllegalArgumentException("The length of the array is not " + this.pieceAvailability.length);
        }
        int i = 0;
        while (i < this.pieceAvailability.length) {
            if (peerPieces[i]) {
                int n = i;
                this.pieceAvailability[n] = this.pieceAvailability[n] - 1;
            }
            ++i;
        }
    }

    void addToUploaded(long length) {
        this.uploaded += length;
    }

    public void setMaxConnections(int maxConnections) {
        this.connectionPool.setMaxConnections(maxConnections);
    }

    public synchronized void setFilesToDownload(int[] downloadChoices) {
        if (this.files.length != downloadChoices.length) {
            throw new IllegalArgumentException("The provided array should be of length " + this.files.length);
        }
        int i = 0;
        while (i < downloadChoices.length) {
            int[] pieces = this.files[i].getPieces();
            int j = 0;
            while (j < pieces.length) {
                if (downloadChoices[i] > 0) {
                    this.priorityPieces[j] = true;
                } else if (downloadChoices[i] == 0) {
                    this.interestedPieces[j] = true;
                } else {
                    this.uninterestedPieces[j] = this.uninterestedPieces[j];
                }
                ++j;
            }
            ++i;
        }
        if (this.isSelective) {
            return;
        }
        i = 0;
        while (i < downloadChoices.length) {
            if (downloadChoices[i] > 0) {
                this.isPrioritizing = true;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < downloadChoices.length) {
            int j = i + 1;
            while (j < downloadChoices.length) {
                if (downloadChoices[i] != downloadChoices[j]) {
                    this.isSelective = true;
                    return;
                }
                ++j;
            }
            ++i;
        }
        this.isSelective = false;
    }

    public synchronized void setFilesToDownload(boolean[] files) {
    }

    public synchronized void setDownloadingPriorities(boolean[] files) {
    }

    public void setMaxDownloadSpeed(long maximum) {
        if (maximum < 1L) {
            this.maxDownSpeed = -1L;
            this.requestDownSpeed = -1L;
        } else {
            this.maxDownSpeed = maximum;
            this.requestDownSpeed = maximum;
        }
    }

    public void setMaxUploadSpeed(long maximum) {
        if (maximum < 1L) {
            this.maxUpSpeed = -1L;
            this.requestDownSpeed = -1L;
        } else {
            this.maxUpSpeed = maximum;
            this.requestUpSpeed = maximum;
        }
    }

    long getMaxDownloadSpeed() {
        return this.maxDownSpeed;
    }

    long getMaxUploadSpeed() {
        return this.maxUpSpeed;
    }

    long getDownloadRequestSpeed() {
        return this.requestDownSpeed;
    }

    long getUploadRequestSpeed() {
        return this.requestUpSpeed;
    }

    void updateDownloadRequestSpeed(int amount) {
        if (this.requestDownSpeed == -1L) {
            return;
        }
        this.requestDownSpeed -= this.requestDownSpeed > (long)amount ? (long)amount : this.requestDownSpeed;
    }

    void updateUploadRequestSpeed(int amount) {
        if (this.requestUpSpeed == -1L) {
            return;
        }
        this.requestUpSpeed -= this.requestUpSpeed > (long)amount ? (long)amount : this.requestUpSpeed;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public long getRemaining() {
        return this.remaining;
    }

    public long getDownSpeed() {
        return this.downSpeed;
    }

    public long getUpSpeed() {
        return this.upSpeed;
    }

    public long getTimeRemaining() {
        return this.isCompleted ? 0 : (this.downSpeed == 0L ? -1 : Math.round(this.remaining / this.downSpeed));
    }

    public long getDiscarded() {
        return this.discarded;
    }

    public int getConnectedPeers() {
        return this.connectionPool.getConnected();
    }

    public int getSeeds() {
        return this.seeders;
    }

    public int getPeers() {
        return this.peers;
    }

    public TorrentFile getTorrentFile() {
        return this.torrent;
    }

    public int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTorrentStateListener(ITorrentStateListener listener) throws IllegalArgumentException {
        Vector vector = this.stateListeners;
        synchronized (vector) {
            if (!this.stateListeners.contains(listener)) {
                this.stateListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTorrentProgressListener(ITorrentProgressListener listener) throws IllegalArgumentException {
        Vector vector = this.progressListeners;
        synchronized (vector) {
            if (!this.progressListeners.contains(listener)) {
                this.progressListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPieceProgressListener(IPieceProgressListener listener) throws IllegalArgumentException {
        Vector vector = this.pieceListeners;
        synchronized (vector) {
            if (!this.pieceListeners.contains(listener)) {
                this.pieceListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTorrentErrorListener(ITorrentErrorListener listener) throws IllegalArgumentException {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            if (!this.errorListeners.contains(listener)) {
                this.errorListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHashCheckListener(IHashCheckListener listener) {
        Vector vector = this.hashCheckListeners;
        synchronized (vector) {
            if (!this.hashCheckListeners.contains(listener)) {
                this.hashCheckListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTorrentStateListener(ITorrentStateListener listener) {
        Vector vector = this.stateListeners;
        synchronized (vector) {
            return this.stateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTorrentProgressListener(ITorrentProgressListener listener) {
        Vector vector = this.progressListeners;
        synchronized (vector) {
            return this.progressListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePieceProgressListener(IPieceProgressListener listener) {
        Vector vector = this.pieceListeners;
        synchronized (vector) {
            return this.pieceListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTorrentErrorListener(ITorrentErrorListener listener) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            return this.errorListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHashCheckListener(IHashCheckListener listener) {
        Vector vector = this.hashCheckListeners;
        synchronized (vector) {
            return this.hashCheckListeners.remove(listener);
        }
    }

    private synchronized void fireStateChangedEvent(int state) {
        this.state = state;
        int i = 0;
        while (i < this.stateListeners.size()) {
            ((ITorrentStateListener)this.stateListeners.get(i)).stateChanged(state);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBlockDownloadedEvent(int piece, int index, int blockLength) {
        Vector vector = this.pieceListeners;
        synchronized (vector) {
            int i = 0;
            while (i < this.pieceListeners.size()) {
                ((IPieceProgressListener)this.pieceListeners.get(i)).blockDownloaded(piece, index, blockLength);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePieceCompletedEvent(int completed) {
        Vector vector = this.progressListeners;
        synchronized (vector) {
            int i = 0;
            while (i < this.progressListeners.size()) {
                ((ITorrentProgressListener)this.progressListeners.get(i)).pieceCompleted(completed);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTrackerErrorEvent(String message) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            int i = 0;
            while (i < this.errorListeners.size()) {
                ((ITorrentErrorListener)this.errorListeners.get(i)).trackerError(message);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePieceDiscardEvent(int piece, int pieceLength) {
        Vector vector = this.errorListeners;
        synchronized (vector) {
            int i = 0;
            while (i < this.errorListeners.size()) {
                ((ITorrentErrorListener)this.errorListeners.get(i)).pieceDiscarded(piece, pieceLength);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHashCheckedEvent(int piece) {
        Vector vector = this.hashCheckListeners;
        synchronized (vector) {
            int i = 0;
            while (i < this.hashCheckListeners.size()) {
                ((IHashCheckListener)this.hashCheckListeners.get(i)).hashChecked(piece);
                ++i;
            }
        }
    }

    private void setPieces(PieceState[] states) {
        if (this.states.length != states.length) {
            throw new IllegalArgumentException("The array's size should be " + this.states.length);
        }
        this.states = states;
        int i = 0;
        while (i < states.length) {
            Piece piece = (Piece)this.pieces.get(i);
            if (piece.isComplete()) {
                --this.completedPieces;
                this.hasPiece[i] = false;
            }
            this.remaining += (long)piece.getWritten();
            piece.setState(states[i]);
            int written = piece.getWritten();
            this.remaining -= (long)written;
            if (written == piece.getLength()) {
                ++this.completedPieces;
                this.hasPiece[i] = true;
                this.incompletePieces.remove(piece);
            } else if (written != 0 && !this.incompletePieces.contains(piece)) {
                this.incompletePieces.add(piece);
            }
            ++i;
        }
        this.updateBitfield();
        i = 0;
        while (i < this.hasPiece.length) {
            if (!this.hasPiece[i]) {
                return;
            }
            ++i;
        }
        this.isCompleted = true;
    }

    private class HashCheckThread
    extends Thread {
        private HashCheckThread() {
            super("Hash Check Thread - " + TorrentManager.this.torrent.getName());
        }

        private void cleanup() {
            TorrentManager.this.isHashChecking = false;
            TorrentManager.this.fireStateChangedEvent(2);
        }

        public void run() {
            block19: {
                try {
                    int read = 0;
                    int count = 0;
                    ByteBuffer buffer = ByteBuffer.allocate(TorrentManager.this.pieceLength);
                    int i = 0;
                    while (i < TorrentManager.this.files.length) {
                        FileChannel channel = TorrentManager.this.files[i].getChannel();
                        while ((read += channel.read(buffer)) == TorrentManager.this.pieceLength) {
                            if (this.isInterrupted()) {
                                this.cleanup();
                                return;
                            }
                            Piece piece = (Piece)TorrentManager.this.pieces.get(count);
                            if (piece.isComplete()) {
                                TorrentManager torrentManager = TorrentManager.this;
                                torrentManager.completedPieces = torrentManager.completedPieces - 1;
                                ((TorrentManager)TorrentManager.this).hasPiece[i] = false;
                            }
                            TorrentManager torrentManager = TorrentManager.this;
                            torrentManager.remaining = torrentManager.remaining + (long)piece.getWritten();
                            buffer.rewind();
                            if (TorrentManager.this.torrent.getPieces()[count].equals(new String(shaDigest.digest(buffer.array()), "ISO-8859-1"))) {
                                piece.setAsCompleted();
                                ((TorrentManager)TorrentManager.this).hasPiece[count] = true;
                                TorrentManager torrentManager2 = TorrentManager.this;
                                torrentManager2.completedPieces = torrentManager2.completedPieces + 1;
                                TorrentManager torrentManager3 = TorrentManager.this;
                                torrentManager3.remaining = torrentManager3.remaining - (long)piece.getLength();
                            } else {
                                piece.reset();
                            }
                            TorrentManager.this.incompletePieces.remove(piece);
                            TorrentManager.this.fireHashCheckedEvent(count);
                            ++count;
                            read = 0;
                        }
                        ++i;
                    }
                    if (read > 0) {
                        if (this.isInterrupted()) {
                            this.cleanup();
                            return;
                        }
                        Piece piece = (Piece)TorrentManager.this.pieces.get(count);
                        if (piece.isComplete()) {
                            TorrentManager torrentManager = TorrentManager.this;
                            torrentManager.completedPieces = torrentManager.completedPieces - 1;
                            ((TorrentManager)TorrentManager.this).hasPiece[count] = false;
                        }
                        TorrentManager torrentManager = TorrentManager.this;
                        torrentManager.remaining = torrentManager.remaining + (long)piece.getWritten();
                        buffer.rewind();
                        shaDigest.update(buffer.array(), 0, read);
                        if (TorrentManager.this.torrent.getPieces()[count].equals(new String(shaDigest.digest(), "ISO-8859-1"))) {
                            ((TorrentManager)TorrentManager.this).hasPiece[count] = true;
                            piece.setAsCompleted();
                            TorrentManager torrentManager4 = TorrentManager.this;
                            torrentManager4.completedPieces = torrentManager4.completedPieces + 1;
                            TorrentManager torrentManager5 = TorrentManager.this;
                            torrentManager5.remaining = torrentManager5.remaining - (long)piece.getLength();
                        } else {
                            piece.reset();
                        }
                        TorrentManager.this.incompletePieces.remove(piece);
                        TorrentManager.this.fireHashCheckedEvent(count);
                    }
                    TorrentManager.this.updateBitfield();
                    TorrentManager.this.saveState();
                    if (this.isInterrupted()) {
                        this.cleanup();
                        return;
                    }
                    TorrentManager.this.isHashChecking = false;
                    if (!TorrentManager.this.isWaitingToStart) break block19;
                    try {
                        TorrentManager.this.start();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                catch (ClosedByInterruptException closedByInterruptException) {
                    this.cleanup();
                    try {
                        TorrentManager.this.saveState();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                catch (IOException e) {
                    this.cleanup();
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class SpeedMonitoringThread
    extends Thread {
        private SpeedMonitoringThread() {
            super("Speed Monitoring Thread - " + TorrentManager.this.torrent.getName());
        }

        public void run() {
            long lastDownloaded = TorrentManager.this.downloaded;
            long lastUploaded = TorrentManager.this.uploaded;
            long[] downloads = new long[20];
            long[] uploads = new long[20];
            block2: while (true) {
                int i = 0;
                while (true) {
                    if (i >= 20) continue block2;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    downloads[i] = TorrentManager.this.downloaded - lastDownloaded;
                    uploads[i] = TorrentManager.this.uploaded - lastUploaded;
                    long totalDown = 0L;
                    long totalUp = 0L;
                    int j = 0;
                    while (j < 20) {
                        totalDown += downloads[j];
                        totalUp += uploads[j];
                        ++j;
                    }
                    TorrentManager.this.downSpeed = totalDown / 20L;
                    TorrentManager.this.upSpeed = totalUp / 20L;
                    lastDownloaded = TorrentManager.this.downloaded;
                    lastUploaded = TorrentManager.this.uploaded;
                    TorrentManager.this.requestDownSpeed = TorrentManager.this.maxDownSpeed;
                    TorrentManager.this.requestUpSpeed = TorrentManager.this.maxUpSpeed;
                    ++i;
                }
                break;
            }
        }
    }

    private class TrackerThread
    extends Thread {
        private TrackerThread() {
            super("Tracker Thread - " + TorrentManager.this.torrent.getName());
        }

        public void run() {
            try {
                while (true) {
                    Thread.sleep(TorrentManager.this.timeout);
                    TorrentManager.this.queryTracker(null);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

