/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ui.deprecated.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.internal.ui.deprecated.views.ChatLine;
import org.eclipse.ecf.internal.ui.deprecated.views.ILocalInputHandler;
import org.eclipse.ecf.internal.ui.deprecated.views.TextChatComposite;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageEvent;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class ChatWindow
extends ApplicationWindow
implements IIMMessageListener {
    private static final long FLASH_INTERVAL = 600L;
    private String initText;
    private TextChatComposite chat;
    private Image image;
    private Image blank;
    private String titleBarText;
    protected ViewPart view;
    protected IUser localUser;
    protected IUser remoteUser;
    protected boolean disposed = false;
    private UIJob flasher;
    private boolean hasFocus = false;
    private int openResult = 0;
    static /* synthetic */ Class class$0;

    public IUser getLocalUser() {
        return this.localUser;
    }

    protected IUser getRemoteUser() {
        return this.remoteUser;
    }

    public ChatWindow(ViewPart view, String titleBarText, String initOutputText, IUser localUser, IUser remoteUser) {
        super(null);
        this.view = view;
        this.titleBarText = titleBarText;
        this.initText = initOutputText;
        this.localUser = localUser;
        this.remoteUser = remoteUser;
        this.addStatusLine();
    }

    public void setStatus(final String status) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ChatWindow.super.setStatus(status);
            }
        });
    }

    protected String getShellName() {
        return this.chat.getShellName();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.titleBarText);
        this.image = SharedImages.getImage("IMG_USER_AVAILABLE");
        newShell.setImage(this.image);
        RGB[] colors = new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)};
        ImageData data = new ImageData(16, 16, 1, new PaletteData(colors));
        data.transparentPixel = 0;
        this.blank = new Image((Device)newShell.getDisplay(), data);
        this.flasher = new UIJob("Chat View Icon Flasher"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                Shell shell = ChatWindow.this.getShell();
                if (shell.getImage() == ChatWindow.this.image) {
                    shell.setImage(ChatWindow.this.blank);
                } else {
                    shell.setImage(ChatWindow.this.image);
                }
                this.schedule(600L);
                return Status.OK_STATUS;
            }

            public boolean shouldRun() {
                return !ChatWindow.this.getShell().isDisposed();
            }
        };
        this.flasher.setSystem(true);
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ChatWindow.this.flasher.cancel();
                if (ChatWindow.this.image != null) {
                    ChatWindow.this.image.dispose();
                }
                if (ChatWindow.this.blank != null) {
                    ChatWindow.this.blank.dispose();
                }
            }
        });
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                ChatWindow.this.stopFlashing();
                if (!ChatWindow.this.chat.isDisposed()) {
                    ((ChatWindow)ChatWindow.this).chat.textinput.setFocus();
                }
            }
        });
    }

    protected Point getInitialSize() {
        return new Point(320, 240);
    }

    protected Control createContents(Composite parent) {
        Object obj;
        if (this.view == null) {
            throw new NullPointerException("view cannot be null");
        }
        ILocalInputHandler inputHandler = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.internal.ui.deprecated.views.ILocalInputHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((obj = this.view.getAdapter((Class)clazz)) == null) {
            throw new NullPointerException("view " + this.view + " did not provide ILocalInputHandler adapter");
        }
        if (obj instanceof ILocalInputHandler) {
            inputHandler = (ILocalInputHandler)obj;
        }
        this.chat = new TextChatComposite(this.view, parent, 0, this.initText, inputHandler, this.getLocalUser(), this.getRemoteUser());
        this.chat.setLayoutData(new GridData(1808));
        this.chat.setFont(parent.getFont());
        return this.chat;
    }

    public void setLocalUser(IUser localUser) {
        this.localUser = localUser;
        this.chat.setLocalUser(localUser);
    }

    public void setRemoteUser(IUser remoteUser) {
        this.remoteUser = remoteUser;
        this.chat.setRemoteUser(remoteUser);
    }

    protected TextChatComposite getTextChatComposite() {
        return this.chat;
    }

    public int open() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ChatWindow.this.openResult = ChatWindow.super.open();
            }
        });
        return this.openResult;
    }

    public void create() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ChatWindow.super.create();
            }
        });
    }

    public boolean hasFocus() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (ChatWindow.this.getShell().isDisposed()) {
                    ChatWindow.this.hasFocus = false;
                } else {
                    ChatWindow.this.hasFocus = ChatWindow.this.hasFocus((Composite)ChatWindow.this.getShell());
                }
            }
        });
        return this.hasFocus;
    }

    private boolean hasFocus(Composite composite) {
        if (composite.isFocusControl()) {
            return true;
        }
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Composite && this.hasFocus((Composite)children[i])) {
                return true;
            }
            if (children[i].isFocusControl()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void flash() {
        this.flasher.schedule();
    }

    private void stopFlashing() {
        this.flasher.cancel();
        if (this.getShell().getImage() != this.image) {
            this.getShell().setImage(this.image);
        }
    }

    public void setDisposed(final String message) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ChatWindow.this.disposed = true;
                if (ChatWindow.this.chat != null) {
                    ChatWindow.this.chat.setDisposed();
                }
                if (!ChatWindow.this.getShell().isDisposed()) {
                    ChatWindow.this.getShell().setText(String.valueOf(ChatWindow.this.getShell().getText()) + " (inactive)");
                }
                ChatWindow.this.setStatus(message);
            }
        });
    }

    public void openAndFlash() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ChatWindow.this.flash();
                if (!ChatWindow.this.getShell().isVisible()) {
                    ChatWindow.this.open();
                }
            }
        });
    }

    protected void handleShellCloseEvent() {
        if (!this.getShell().isDisposed()) {
            if (this.disposed) {
                this.chat.dispose();
                this.chat = null;
                this.getShell().dispose();
            } else {
                this.getShell().setVisible(false);
            }
        }
    }

    public void handleMessageEvent(IIMMessageEvent messageEvent) {
        if (messageEvent instanceof IChatMessageEvent) {
            final IChatMessage m = ((IChatMessageEvent)messageEvent).getChatMessage();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (!ChatWindow.this.disposed && ChatWindow.this.chat != null) {
                        ChatWindow.this.chat.appendText(new ChatLine(m.getBody(), ChatWindow.this.getRemoteUser()));
                    }
                }
            });
        }
    }
}

