/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ui.deprecated.views;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.sharedobject.ISharedObject;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainer;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.user.User;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransferRequestListener;
import org.eclipse.ecf.filetransfer.ISendFileTransferContainerAdapter;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IFileTransferRequestEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IOutgoingFileTransferResponseEvent;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.ui.Activator;
import org.eclipse.ecf.internal.ui.Messages;
import org.eclipse.ecf.internal.ui.deprecated.views.AddBuddyDialog;
import org.eclipse.ecf.internal.ui.deprecated.views.ChangePasswordDialog;
import org.eclipse.ecf.internal.ui.deprecated.views.ChatRoomSelectionDialog;
import org.eclipse.ecf.internal.ui.deprecated.views.ChatRoomView;
import org.eclipse.ecf.internal.ui.deprecated.views.ChatWindow;
import org.eclipse.ecf.internal.ui.deprecated.views.IChatRoomViewCloseListener;
import org.eclipse.ecf.internal.ui.deprecated.views.ILocalInputHandler;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterAccount;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterBuddy;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterGroup;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterObject;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterParent;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterUserAccount;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterView;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterViewContentProvider;
import org.eclipse.ecf.internal.ui.deprecated.views.RosterViewLabelProvider;
import org.eclipse.ecf.presence.IAccountManager;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomInfo;
import org.eclipse.ecf.presence.chatroom.IChatRoomManager;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessage;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageEvent;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageSender;
import org.eclipse.ecf.presence.chatroom.IChatRoomParticipantListener;
import org.eclipse.ecf.presence.im.IChatID;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class RosterView
extends ViewPart
implements IIMMessageListener,
IChatRoomViewCloseListener {
    public static final String VIEW_ID = "org.eclipse.ecf.ui.view.rosterview";
    private static final String CHAT_ROOM_VIEW_CLASS = "org.eclipse.ecf.ui.views.ChatRoomView";
    public static final String UNFILED_GROUP_NAME = "Buddies";
    protected static final int TREE_EXPANSION_LEVELS = 3;
    private TreeViewer viewer;
    private Action selectedChatAction;
    private Action selectedDoubleClickAction;
    private Action disconnectAction;
    private Action disconnectAccountAction;
    private Action openChatRoomAction;
    private Action openChatRoomAccountAction;
    private Action fileSendAction;
    protected Hashtable chatThreads = new Hashtable();
    protected Hashtable accounts = new Hashtable();
    protected Hashtable chatRooms = new Hashtable();
    protected IIncomingFileTransferRequestListener requestListener = new IIncomingFileTransferRequestListener(){

        public void handleFileTransferRequest(IFileTransferRequestEvent event) {
            Display.getDefault().asyncExec(new Runnable(this, event){
                final /* synthetic */ 1 this$1;
                private final /* synthetic */ IFileTransferRequestEvent val$event;
                {
                    this.this$1 = var1_1;
                    this.val$event = iFileTransferRequestEvent;
                }

                public void run() {
                    String username = this.val$event.getRequesterID().getName();
                    IFileTransferInfo transferInfo = this.val$event.getFileTransferInfo();
                    String fileName = transferInfo.getFile().getName();
                    Object[] bindings = new Object[]{username, fileName, transferInfo.getFileSize() == -1L ? "unknown" : String.valueOf(transferInfo.getFileSize()) + " bytes", transferInfo.getDescription() == null ? "none" : transferInfo.getDescription()};
                    if (MessageDialog.openQuestion((Shell)1.access$0(this.this$1).getSite().getShell(), (String)NLS.bind((String)Messages.RosterView_ReceiveFile_title, (Object)username), (String)NLS.bind((String)Messages.RosterView_ReceiveFile_message, (Object[])bindings))) {
                        FileDialog fd = new FileDialog(1.access$0(this.this$1).getSite().getShell(), 4096);
                        fd.setFilterPath(System.getProperty("user.home"));
                        fd.setFileName(fileName);
                        int suffixLoc = fileName.lastIndexOf(46);
                        if (suffixLoc != -1) {
                            String ext = fileName.substring(fileName.lastIndexOf(46));
                            fd.setFilterExtensions(new String[]{ext});
                        }
                        fd.setText(NLS.bind((String)Messages.RosterView_ReceiveFile_filesavetitle, (Object)username));
                        String res = fd.open();
                        if (res == null) {
                            this.val$event.reject();
                        } else {
                            try {
                                FileOutputStream fos = new FileOutputStream(new File(res));
                                this.val$event.accept((OutputStream)fos, new IFileTransferListener(this, fos){
                                    final /* synthetic */ 2 this$2;
                                    private final /* synthetic */ FileOutputStream val$fos;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$fos = fileOutputStream;
                                    }

                                    public void handleTransferEvent(IFileTransferEvent event) {
                                        if (event instanceof IIncomingFileTransferReceiveDoneEvent) {
                                            try {
                                                this.val$fos.close();
                                            }
                                            catch (IOException iOException) {}
                                        }
                                    }
                                });
                            }
                            catch (Exception e) {
                                MessageDialog.openError((Shell)1.access$0(this.this$1).getSite().getShell(), (String)Messages.RosterView_ReceiveFile_acceptexception_title, (String)NLS.bind((String)Messages.RosterView_ReceiveFile_acceptexception_message, (Object[])new Object[]{fileName, username, e.getLocalizedMessage()}));
                            }
                        }
                    } else {
                        this.val$event.reject();
                    }
                }
            });
        }

        static /* synthetic */ RosterView access$0(1 var0) {
            return var0.RosterView.this;
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected ISharedObject createAndAddSharedObjectForAccount(RosterUserAccount account) {
        return null;
    }

    protected void addAccount(RosterUserAccount account) {
        ID accountID;
        RosterViewContentProvider vcp = (RosterViewContentProvider)this.viewer.getContentProvider();
        if (vcp != null && (accountID = account.getServiceID()) != null) {
            vcp.addAccount(accountID, accountID.getName());
            ISendFileTransferContainerAdapter ft = this.getFileTransferAdapterForContainer(account.getContainer());
            if (ft != null) {
                ft.addListener(this.requestListener);
            }
            this.accounts.put(accountID, account);
            this.refreshView();
        }
    }

    protected RosterUserAccount getAccount(ID serviceID) {
        return (RosterUserAccount)this.accounts.get(serviceID);
    }

    protected ISendFileTransferContainerAdapter getFileTransferAdapterForContainer(IContainer container) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.filetransfer.ISendFileTransferContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ISendFileTransferContainerAdapter)container.getAdapter((Class)clazz);
    }

    protected ISendFileTransferContainerAdapter getFileTransferAdapterForAccount(ID accountID) {
        RosterUserAccount account = this.getAccount(accountID);
        if (account == null) {
            return null;
        }
        return this.getFileTransferAdapterForContainer(account.getContainer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAccount(ID serviceID) {
        Hashtable hashtable = this.accounts;
        synchronized (hashtable) {
            Iterator i = this.accounts.keySet().iterator();
            while (i.hasNext()) {
                ID key = (ID)i.next();
                if (!key.equals((Object)serviceID)) continue;
                i.remove();
            }
        }
    }

    protected String getUserNameFromID(ID userID) {
        if (userID == null) {
            return "";
        }
        String uname = userID.getName();
        int index = uname.lastIndexOf("@");
        String username = uname;
        if (index >= 0) {
            username = uname.substring(0, index);
        }
        return username.equals("") ? uname : username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ArrayList<ILocalInputHandler> handlers = new ArrayList<ILocalInputHandler>();
        Hashtable hashtable = this.accounts;
        synchronized (hashtable) {
            Iterator i = this.accounts.keySet().iterator();
            while (i.hasNext()) {
                RosterUserAccount account = this.getAccount((ID)i.next());
                handlers.add(account.getInputHandler());
            }
        }
        Iterator i = handlers.iterator();
        while (i.hasNext()) {
            ILocalInputHandler handler = (ILocalInputHandler)i.next();
            handler.disconnect();
        }
        super.dispose();
    }

    protected void refreshView() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    RosterView.this.viewer.refresh();
                    RosterView.this.expandAll();
                }
                catch (Exception exception) {}
            }
        });
    }

    protected void expandAll() {
        this.viewer.expandToLevel(3);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new RosterViewContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)new RosterViewLabelProvider(this));
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.setAutoExpandLevel(3);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RosterView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.disconnectAction);
        manager.add((IAction)this.openChatRoomAction);
    }

    private void sendFileToTarget(ISendFileTransferContainerAdapter fileTransfer, final ID targetID) {
        FileDialog fd = new FileDialog(this.getSite().getShell(), 4096);
        fd.setFilterPath(System.getProperty("user.home"));
        fd.setText(NLS.bind((String)Messages.RosterView_SendFile_title, (Object)targetID.getName()));
        final String res = fd.open();
        if (res != null) {
            File aFile = new File(res);
            try {
                IFileID targetFileID = FileIDFactory.getDefault().createFileID(fileTransfer.getOutgoingNamespace(), new Object[]{targetID, res});
                fileTransfer.sendOutgoingRequest(targetFileID, aFile, new IFileTransferListener(){

                    public void handleTransferEvent(IFileTransferEvent event) {
                        Display.getDefault().asyncExec(new Runnable(this, event, res, targetID){
                            final /* synthetic */ 6 this$1;
                            private final /* synthetic */ IFileTransferEvent val$event;
                            private final /* synthetic */ String val$res;
                            private final /* synthetic */ ID val$targetID;
                            {
                                this.this$1 = var1_1;
                                this.val$event = iFileTransferEvent;
                                this.val$res = string;
                                this.val$targetID = iD;
                            }

                            public void run() {
                                if (this.val$event instanceof IOutgoingFileTransferResponseEvent && !((IOutgoingFileTransferResponseEvent)this.val$event).requestAccepted()) {
                                    MessageDialog.openInformation((Shell)6.access$0(this.this$1).getSite().getShell(), (String)Messages.RosterView_SendFile_response_title, (String)NLS.bind((String)Messages.RosterView_SendFile_response_message, (Object)this.val$res, (Object)this.val$targetID.getName()));
                                }
                            }
                        });
                    }

                    static /* synthetic */ RosterView access$0(6 var0) {
                        return var0.RosterView.this;
                    }
                }, null);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.RosterView_SendFile_requestexception_title, (String)NLS.bind((String)Messages.RosterView_SendFile_requestexception_message, (Object[])new Object[]{res, e.getLocalizedMessage()}));
            }
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        RosterObject rosterObject = this.getSelectedTreeObject();
        if (rosterObject != null) {
            final ID targetID = rosterObject.getID();
            if (rosterObject instanceof RosterBuddy) {
                final RosterBuddy tb = (RosterBuddy)rosterObject;
                this.selectedChatAction = new Action(){

                    public void run() {
                        RosterView.this.openChatWindowForTarget(targetID);
                    }
                };
                this.selectedChatAction.setText(NLS.bind((String)Messages.RosterView_SendIM_menutext, (Object)rosterObject.getID().getName()));
                this.selectedChatAction.setImageDescriptor(SharedImages.getImageDescriptor("IMG_MESSAGE"));
                manager.add((IAction)this.selectedChatAction);
                manager.add((IContributionItem)new Separator());
                final ISendFileTransferContainerAdapter fileTransfer = this.getFileTransferAdapterForAccount(tb.getServiceID());
                this.fileSendAction = new Action(){

                    public void run() {
                        RosterView.this.sendFileToTarget(fileTransfer, targetID);
                    }
                };
                this.fileSendAction.setText(NLS.bind((String)Messages.RosterView_SendFile_menutext, (Object)rosterObject.getID().getName()));
                this.fileSendAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
                manager.add((IAction)this.fileSendAction);
                manager.add((IContributionItem)new Separator());
                IPresence presence = tb.getPresence();
                boolean type = presence == null ? false : presence.getType().equals((Object)IPresence.Type.AVAILABLE);
                boolean mode = presence == null ? false : presence.getMode().equals((Object)IPresence.Mode.AVAILABLE);
                this.fileSendAction.setEnabled(fileTransfer != null && type && mode);
                RosterParent parent = rosterObject.getParent();
                RosterGroup tg = null;
                if (parent != null && parent instanceof RosterGroup) {
                    tg = (RosterGroup)parent;
                }
                final RosterGroup rosterGroup = tg;
                Action removeUserAction = new Action(){

                    public void run() {
                        RosterView.this.removeUserFromGroup(tb, rosterGroup);
                    }
                };
                if (rosterGroup != null) {
                    removeUserAction.setText("Remove " + rosterObject.getName() + " from " + rosterGroup.getName() + " group");
                } else {
                    removeUserAction.setText("Remove " + rosterObject.getName());
                }
                removeUserAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
                manager.add((IAction)removeUserAction);
            } else if (rosterObject instanceof RosterAccount) {
                RosterAccount rosterAccount = (RosterAccount)rosterObject;
                final ID accountID = rosterAccount.getID();
                final RosterUserAccount ua = this.getAccount(accountID);
                if (ua != null) {
                    Action addBuddyToGroupAction = new Action(){

                        public void run() {
                            RosterView.this.sendRosterAdd(accountID, null);
                        }
                    };
                    addBuddyToGroupAction.setImageDescriptor(SharedImages.getImageDescriptor("IMG_ADD_BUDDY"));
                    addBuddyToGroupAction.setText("Add Buddy");
                    addBuddyToGroupAction.setEnabled(true);
                    manager.add((IAction)addBuddyToGroupAction);
                    this.openChatRoomAccountAction = new Action(){

                        public void run() {
                            RosterView.this.showChatRoomsForAccount(ua);
                        }
                    };
                    this.openChatRoomAccountAction.setText("Show chat rooms for account");
                    this.openChatRoomAccountAction.setEnabled(true);
                    this.openChatRoomAccountAction.setImageDescriptor(SharedImages.getImageDescriptor("IMG_ADD_CHAT"));
                    manager.add((IAction)this.openChatRoomAccountAction);
                    Action changePasswordAction = new Action(){

                        public void run() {
                            RosterView.this.changePasswordForAccount(accountID);
                        }
                    };
                    changePasswordAction.setText("Change Password");
                    changePasswordAction.setToolTipText("Change password for account");
                    changePasswordAction.setEnabled(true);
                    manager.add((IAction)changePasswordAction);
                    this.disconnectAccountAction = new Action(){

                        public void run() {
                            if (MessageDialog.openConfirm((Shell)RosterView.this.getViewSite().getShell(), (String)"Disconnect", (String)"Disconnect from account?")) {
                                ua.getInputHandler().disconnect();
                            }
                        }
                    };
                    this.disconnectAccountAction.setText("Disconnect from account");
                    this.disconnectAccountAction.setEnabled(true);
                    this.disconnectAccountAction.setImageDescriptor(SharedImages.getImageDescriptor("IMG_DISCONNECT"));
                    manager.add((IAction)this.disconnectAccountAction);
                }
            } else if (rosterObject instanceof RosterGroup) {
                RosterGroup rosterGroup = (RosterGroup)rosterObject;
                final String groupName = rosterGroup.getName();
                Action removeGroupAction = new Action(){

                    public void run() {
                        RosterView.this.removeGroup(groupName);
                    }
                };
                String accountName = rosterGroup.getID().getName();
                removeGroupAction.setText("Remove " + rosterObject.getName() + " for account " + accountName);
                removeGroupAction.setEnabled(rosterGroup.getTotalCount() == 0);
                removeGroupAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
                if (removeGroupAction.isEnabled()) {
                    manager.add((IAction)removeGroupAction);
                }
            }
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void changePasswordForAccount(ID accountID) {
        RosterUserAccount account = this.getAccount(accountID);
        if (account != null) {
            IPresenceContainerAdapter pc = account.getPresenceContainer();
            IAccountManager am = pc.getAccountManager();
            ChangePasswordDialog cpd = new ChangePasswordDialog(this.viewer.getControl().getShell());
            cpd.open();
            if (cpd.getResult() == 0) {
                try {
                    am.changePassword(cpd.getNewPassword());
                }
                catch (ECFException eCFException) {
                    MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)"Password not changed", (String)"Error changing password");
                }
            }
        }
    }

    public void sendRosterAdd(ID svcID, String groupName) {
        this.sendRosterAdd(svcID, null, groupName);
    }

    public void sendRosterAdd(ID svcID, String username, String groupName) {
        String[] groupNames = this.getAllGroupNamesForAccount(svcID);
        List<String> g = Arrays.asList(groupNames);
        int selected = groupName == null ? -1 : g.indexOf(groupName);
        AddBuddyDialog sg = new AddBuddyDialog(this.viewer.getControl().getShell(), username, groupNames, selected);
        sg.open();
        if (sg.getResult() == 0) {
            String[] stringArray;
            String group = sg.getGroup();
            String user = sg.getUser();
            String nickname = sg.getNickname();
            sg.close();
            if (group == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = group;
            }
            String[] sendGroups = stringArray;
            this.getAccount(svcID).getInputHandler().sendRosterAdd(user, nickname, sendGroups);
        }
    }

    protected void removeUserFromGroup(RosterBuddy buddy, RosterGroup group) {
        RosterUserAccount account = this.getAccount(buddy.getServiceID());
        if (account != null) {
            ILocalInputHandler handler = account.getInputHandler();
            handler.sendRosterRemove(buddy.getID());
        }
    }

    protected RosterObject getSelectedTreeObject() {
        ISelection selection = this.viewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        return (RosterObject)obj;
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.disconnectAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.openChatRoomAction);
    }

    protected ID inputIMTarget() {
        String strres;
        InputDialog dlg = new InputDialog(this.getSite().getShell(), "Send IM", "Please enter the ID of the person you would like to IM", "", null);
        dlg.setBlockOnOpen(true);
        int res = dlg.open();
        if (res == 0 && (strres = dlg.getValue()) != null && !strres.equals("")) {
            try {
                return IDFactory.getDefault().createStringID(strres);
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Error in IM target");
                return null;
            }
        }
        return null;
    }

    private String getChatRoomSecondaryID(ID roomID) {
        try {
            URI aURI = new URI(roomID.getName());
            String auth = aURI.getAuthority();
            String path = aURI.getPath();
            return String.valueOf(auth) + path;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    protected IConnectContext getChatJoinContext(final String windowText) {
        return new IConnectContext(){

            public CallbackHandler getCallbackHandler() {
                return new CallbackHandler(this, windowText){
                    final /* synthetic */ 16 this$1;
                    private final /* synthetic */ String val$windowText;
                    {
                        this.this$1 = var1_1;
                        this.val$windowText = string;
                    }

                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        if (callbacks == null) {
                            return;
                        }
                        int i = 0;
                        while (i < callbacks.length) {
                            if (callbacks[i] instanceof NameCallback) {
                                NameCallback ncb = (NameCallback)callbacks[i];
                                InputDialog id = new InputDialog(16.access$0(this.this$1).getViewSite().getShell(), this.val$windowText, ncb.getPrompt(), ncb.getDefaultName(), null);
                                id.setBlockOnOpen(true);
                                id.open();
                                if (id.getReturnCode() != 0) {
                                    throw new IOException("User cancelled");
                                }
                                ncb.setName(id.getValue());
                            }
                            ++i;
                        }
                    }
                };
            }

            static /* synthetic */ RosterView access$0(16 var0) {
                return var0.RosterView.this;
            }
        };
    }

    protected void showChatRoomsForAccount(RosterUserAccount ua) {
        IChatRoomManager manager = ua.getPresenceContainer().getChatRoomManager();
        if (manager != null) {
            this.showChatRooms(new IChatRoomManager[]{manager});
        } else {
            this.showChatRooms(new IChatRoomManager[0]);
        }
    }

    protected void showChatRooms(IChatRoomManager[] managers) {
        ChatRoomSelectionDialog dialog = new ChatRoomSelectionDialog(this.getViewSite().getShell(), managers);
        dialog.setBlockOnOpen(true);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        ChatRoomSelectionDialog.Room room = dialog.getSelectedRoom();
        IChatRoomInfo selectedInfo = room.getRoomInfo();
        if (room == null || selectedInfo == null) {
            MessageDialog.openInformation((Shell)this.getViewSite().getShell(), (String)"No room selected", (String)"Cannot connect to null room");
            return;
        }
        String secondaryID = this.getChatRoomSecondaryID(selectedInfo.getRoomID());
        if (secondaryID == null) {
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Could not get identifier for room", (String)("Could not get proper identifier for chat room " + selectedInfo.getRoomID()));
            return;
        }
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage wp = ww.getActivePage();
        RoomWithAView roomView = this.getRoomView(secondaryID);
        if (roomView != null) {
            ChatRoomView view = roomView.getView();
            wp.activate((IWorkbenchPart)view);
            return;
        }
        IChatRoomContainer chatRoom = null;
        try {
            chatRoom = selectedInfo.createChatRoomContainer();
        }
        catch (ContainerCreateException containerCreateException) {
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Could not create chat room", (String)"Could not create chat room for account");
        }
        IChatRoomMessageSender sender = chatRoom.getChatRoomMessageSender();
        IViewPart view = null;
        try {
            IViewReference ref = wp.findViewReference(CHAT_ROOM_VIEW_CLASS, secondaryID);
            view = ref == null ? wp.showView(CHAT_ROOM_VIEW_CLASS, secondaryID, 1) : ref.getView(true);
            final ChatRoomView chatroomview = (ChatRoomView)view;
            chatroomview.initialize(this, secondaryID, chatRoom, selectedInfo, sender);
            chatRoom.addMessageListener(new IIMMessageListener(){

                public void handleMessageEvent(IIMMessageEvent messageEvent) {
                    if (messageEvent instanceof IChatRoomMessageEvent) {
                        IChatRoomMessage m = ((IChatRoomMessageEvent)messageEvent).getChatRoomMessage();
                        chatroomview.handleMessage(m.getFromID(), m.getMessage());
                    }
                }
            });
            chatRoom.addChatRoomParticipantListener(new IChatRoomParticipantListener(){

                public void handlePresenceUpdated(ID fromID, IPresence presence) {
                    chatroomview.handlePresence(fromID, presence);
                }

                public void handleArrived(IUser participant) {
                    chatroomview.handleJoin(participant);
                }

                public void handleDeparted(IUser participant) {
                    chatroomview.handleLeave(participant);
                }

                public void handleUpdated(IUser updatedParticipant) {
                    chatroomview.handleUpdated(updatedParticipant);
                }
            });
        }
        catch (PartInitException e) {
            Activator.log("Exception in chat room view initialization for chat room " + selectedInfo.getRoomID(), e);
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Can't initialize chat room view", (String)("Unexpected error initializing for chat room: " + selectedInfo.getName() + ".  Please see Error Log for details"));
            return;
        }
        try {
            chatRoom.connect(selectedInfo.getRoomID(), this.getChatJoinContext("Nickname for " + selectedInfo.getName()));
        }
        catch (ContainerConnectException e1) {
            Activator.log("Exception connecting to chat room " + selectedInfo.getRoomID(), e1);
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Could not connect", (String)("Cannot connect to chat room " + selectedInfo.getName() + ", message: " + e1.getMessage()));
            return;
        }
        this.addRoomView(new RoomWithAView(chatRoom, (ChatRoomView)view, secondaryID));
    }

    public void showChatRoom(final IChatRoomInfo selectedInfo) {
        final String secondaryID = this.getChatRoomSecondaryID(selectedInfo.getRoomID());
        if (secondaryID == null) {
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)"Could not get identifier for room", (String)("Could not get proper identifier for chat room " + selectedInfo.getRoomID()));
            return;
        }
        final RoomWithAView roomView = this.getRoomView(secondaryID);
        this.getViewSite().getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage wp = ww.getActivePage();
                if (roomView != null) {
                    ChatRoomView view = roomView.getView();
                    wp.activate((IWorkbenchPart)view);
                    return;
                }
                IChatRoomContainer chatRoom = null;
                try {
                    chatRoom = selectedInfo.createChatRoomContainer();
                }
                catch (ContainerCreateException containerCreateException) {
                    MessageDialog.openError((Shell)RosterView.this.getViewSite().getShell(), (String)"Could not create chat room", (String)"Could not create chat room for account");
                }
                IChatRoomMessageSender sender = chatRoom.getChatRoomMessageSender();
                IViewPart view = null;
                try {
                    IViewReference ref = wp.findViewReference(RosterView.CHAT_ROOM_VIEW_CLASS, secondaryID);
                    view = ref == null ? wp.showView(RosterView.CHAT_ROOM_VIEW_CLASS, secondaryID, 1) : ref.getView(true);
                    ChatRoomView chatroomview = (ChatRoomView)view;
                    chatroomview.initialize(RosterView.this, secondaryID, chatRoom, selectedInfo, sender);
                    chatRoom.addMessageListener(new IIMMessageListener(this, chatroomview){
                        final /* synthetic */ 20 this$1;
                        private final /* synthetic */ ChatRoomView val$chatroomview;
                        {
                            this.this$1 = var1_1;
                            this.val$chatroomview = chatRoomView;
                        }

                        public void handleMessageEvent(IIMMessageEvent messageEvent) {
                            if (messageEvent instanceof IChatRoomMessageEvent) {
                                IChatRoomMessage m = ((IChatRoomMessageEvent)messageEvent).getChatRoomMessage();
                                this.val$chatroomview.handleMessage(m.getFromID(), m.getMessage());
                            }
                        }
                    });
                    chatRoom.addChatRoomParticipantListener(new IChatRoomParticipantListener(this, chatroomview){
                        final /* synthetic */ 20 this$1;
                        private final /* synthetic */ ChatRoomView val$chatroomview;
                        {
                            this.this$1 = var1_1;
                            this.val$chatroomview = chatRoomView;
                        }

                        public void handlePresenceUpdated(ID fromID, IPresence presence) {
                            this.val$chatroomview.handlePresence(fromID, presence);
                        }

                        public void handleArrived(IUser participant) {
                            this.val$chatroomview.handleJoin(participant);
                        }

                        public void handleUpdated(IUser updatedParticipant) {
                            this.val$chatroomview.handleUpdated(updatedParticipant);
                        }

                        public void handleDeparted(IUser participant) {
                            this.val$chatroomview.handleLeave(participant);
                        }
                    });
                }
                catch (PartInitException e) {
                    Activator.log("Exception in chat room view initialization for chat room " + selectedInfo.getRoomID(), e);
                    MessageDialog.openError((Shell)RosterView.this.getViewSite().getShell(), (String)"Can't initialize chat room view", (String)("Unexpected error initializing for chat room: " + selectedInfo.getName() + ".  Please see Error Log for details"));
                    return;
                }
                try {
                    chatRoom.connect(selectedInfo.getRoomID(), null);
                }
                catch (ContainerConnectException e1) {
                    Activator.log("Exception connecting to chat room " + selectedInfo.getRoomID(), e1);
                    MessageDialog.openError((Shell)RosterView.this.getViewSite().getShell(), (String)"Could not connect", (String)("Cannot connect to chat room " + selectedInfo.getName() + ", message: " + e1.getMessage()));
                    return;
                }
                RosterView.this.addRoomView(new RoomWithAView(chatRoom, (ChatRoomView)view, secondaryID));
            }
        });
    }

    private void makeActions() {
        this.selectedDoubleClickAction = new Action(){

            public void run() {
                RosterObject rosterObject = RosterView.this.getSelectedTreeObject();
                ID targetID = rosterObject.getID();
                if (targetID != null) {
                    RosterView.this.openChatWindowForTarget(targetID);
                }
            }
        };
        this.disconnectAction = new Action(){

            public void run() {
                if (MessageDialog.openConfirm((Shell)RosterView.this.getViewSite().getShell(), (String)"Disconnect", (String)"Disconnect all accounts?")) {
                    HashSet entrySet = new HashSet();
                    entrySet.addAll(RosterView.this.accounts.entrySet());
                    Iterator i = entrySet.iterator();
                    while (i.hasNext()) {
                        Map.Entry entry = (Map.Entry)i.next();
                        RosterUserAccount account = (RosterUserAccount)entry.getValue();
                        account.getInputHandler().disconnect();
                    }
                    RosterView.this.setToolbarEnabled(false);
                    this.setEnabled(false);
                }
            }
        };
        this.disconnectAction.setText("Disconnect");
        this.disconnectAction.setToolTipText("Disconnect from all accounts");
        this.disconnectAction.setEnabled(false);
        this.disconnectAction.setImageDescriptor(SharedImages.getImageDescriptor("IMG_DISCONNECT"));
        this.disconnectAction.setDisabledImageDescriptor(SharedImages.getImageDescriptor("IMG_DISCONNECT_DISABLED"));
        this.openChatRoomAction = new Action(){

            public void run() {
                ArrayList<IChatRoomManager> list = new ArrayList<IChatRoomManager>();
                Iterator i = RosterView.this.accounts.values().iterator();
                while (i.hasNext()) {
                    RosterUserAccount ua = (RosterUserAccount)i.next();
                    IChatRoomManager man = ua.getPresenceContainer().getChatRoomManager();
                    if (man == null) continue;
                    list.add(man);
                }
                RosterView.this.showChatRooms(list.toArray(new IChatRoomManager[0]));
            }
        };
        this.openChatRoomAction.setText("Enter Chatroom");
        this.openChatRoomAction.setToolTipText("Show chat rooms for all accounts");
        this.openChatRoomAction.setImageDescriptor(SharedImages.getImageDescriptor("IMG_ADD_CHAT"));
        this.openChatRoomAction.setEnabled(false);
    }

    protected void addRoomView(RoomWithAView roomView) {
        this.chatRooms.put(roomView.getID(), roomView);
    }

    protected void removeRoomView(RoomWithAView roomView) {
        this.chatRooms.remove(roomView.getID());
    }

    protected RoomWithAView getRoomView(String id) {
        return (RoomWithAView)this.chatRooms.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ChatWindow openChatWindowForTarget(ID targetID) {
        if (targetID == null) {
            return null;
        }
        ChatWindow window = null;
        Hashtable hashtable = this.chatThreads;
        synchronized (hashtable) {
            window = (ChatWindow)((Object)this.chatThreads.get(targetID));
            if (window == null) {
                window = this.createChatWindowForTarget(targetID);
                if (window != null) {
                    window.open();
                }
            } else if (!window.hasFocus()) {
                window.openAndFlash();
            }
            if (window != null) {
                window.setStatus("chat with " + targetID.getName());
            }
        }
        return window;
    }

    protected ChatWindow createChatWindowForTarget(ID targetID) {
        RosterUserAccount account = this.getAccountForUser(targetID);
        if (account == null) {
            return null;
        }
        ChatWindow window = new ChatWindow(this, targetID.getName(), this.getWindowInitText(targetID), account.getUser(), (IUser)new User(targetID));
        window.create();
        this.chatThreads.put(targetID, window);
        return window;
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RosterView.this.selectedDoubleClickAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    protected RosterUserAccount getAccountForUser(ID userID) {
        RosterViewContentProvider vcp = (RosterViewContentProvider)this.viewer.getContentProvider();
        if (vcp == null) {
            return null;
        }
        RosterBuddy buddy = vcp.findBuddyWithUserID(userID);
        if (buddy == null) {
            return null;
        }
        RosterUserAccount account = this.getAccount(buddy.getServiceID());
        return account;
    }

    protected ILocalInputHandler getHandlerForUser(ID userID) {
        RosterUserAccount account = this.getAccountForUser(userID);
        if (account == null) {
            return null;
        }
        return account.getInputHandler();
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2;
        if (clazz != null) {
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("org.eclipse.ecf.internal.ui.deprecated.views.ILocalInputHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz3)) {
                return new ILocalInputHandler(){

                    public void inputText(ID userID, String text) {
                        ILocalInputHandler inputHandler = RosterView.this.getHandlerForUser(userID);
                        if (inputHandler != null) {
                            inputHandler.inputText(userID, text);
                        } else {
                            System.err.println("handleTextLine(" + text + ")");
                        }
                    }

                    public void startTyping(ID userID) {
                        ILocalInputHandler inputHandler = RosterView.this.getHandlerForUser(userID);
                        if (inputHandler != null) {
                            inputHandler.startTyping(userID);
                        } else {
                            System.err.println("handleStartTyping()");
                        }
                    }

                    public void disconnect() {
                        this.disconnect();
                    }

                    public void updatePresence(ID userID, IPresence presence) {
                        ILocalInputHandler inputHandler = RosterView.this.getHandlerForUser(userID);
                        if (inputHandler != null) {
                            inputHandler.updatePresence(userID, presence);
                        } else {
                            System.err.println("updatePresence(" + userID + "," + presence + ")");
                        }
                    }

                    public void sendRosterAdd(String user, String name, String[] groups) {
                    }

                    public void sendRosterRemove(ID userID) {
                        ILocalInputHandler inputHandler = RosterView.this.getHandlerForUser(userID);
                        if (inputHandler != null) {
                            inputHandler.sendRosterRemove(userID);
                        } else {
                            System.err.println("sendRosterRemove()");
                        }
                    }
                };
            }
        }
        if ((clazz2 = class$2) == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ecf.presence.IPresenceListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this;
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.ecf.presence.IIMMessageListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz4)) {
            return this;
        }
        return null;
    }

    protected String getWindowInitText(ID targetID) {
        String result = "chat with " + targetID.getName() + " started " + this.getDateAndTime() + "\n\n";
        return result;
    }

    protected String getDateAndTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("MM:dd hh:mm:ss");
        return sdf.format(new Date());
    }

    public void handleMessageEvent(IIMMessageEvent messageEvent) {
        ChatWindow window = this.openChatWindowForTarget(messageEvent.getFromID());
        if (window != null) {
            window.handleMessageEvent(messageEvent);
            window.setStatus("last message received at " + new SimpleDateFormat("hh:mm:ss").format(new Date()));
        }
    }

    public void addAccount(ID account, IUser user, ILocalInputHandler handler, IContainer container, IPresenceContainerAdapter presenceContainer, ISharedObjectContainer soContainer) {
        this.addAccount(new RosterUserAccount(this, account, user, handler, container, presenceContainer, soContainer));
        this.setToolbarEnabled(true);
    }

    protected void setToolbarEnabled(boolean enabled) {
        this.disconnectAction.setEnabled(enabled);
        this.openChatRoomAction.setEnabled(enabled);
    }

    public void accountDisconnected(ID serviceID) {
        RosterUserAccount account = this.getAccount(serviceID);
        if (account != null) {
            this.handleAccountDisconnected(account);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeAllChatWindowsForAccount(RosterUserAccount account, String status) {
        Hashtable hashtable = this.chatThreads;
        synchronized (hashtable) {
            Iterator i = this.chatThreads.values().iterator();
            while (i.hasNext()) {
                ChatWindow window = (ChatWindow)((Object)i.next());
                ID userID = window.getLocalUser().getID();
                RosterUserAccount rosterUserAccount = this.getAccountForUser(userID);
                if (rosterUserAccount == null || !rosterUserAccount.getServiceID().equals((Object)account.getServiceID())) continue;
                window.setDisposed(status);
                i.remove();
            }
        }
    }

    protected void removeAllRosterEntriesForAccount(RosterUserAccount account) {
        RosterViewContentProvider vcp = (RosterViewContentProvider)this.viewer.getContentProvider();
        if (vcp != null) {
            vcp.removeAllEntriesForAccount(account);
            this.refreshView();
        }
    }

    public String[] getAllGroupNamesForAccount(ID accountID) {
        RosterViewContentProvider vcp = (RosterViewContentProvider)this.viewer.getContentProvider();
        if (vcp != null) {
            return vcp.getAllGroupNamesForAccount(accountID);
        }
        return new String[0];
    }

    public String getSelectedGroupName() {
        RosterObject to = this.getSelectedTreeObject();
        if (to == null) {
            return null;
        }
        if (to instanceof RosterGroup) {
            RosterGroup tg = (RosterGroup)to;
            return tg.getName();
        }
        return null;
    }

    public void addGroup(ID svcID, String name) {
        RosterViewContentProvider vcp = (RosterViewContentProvider)this.viewer.getContentProvider();
        if (vcp != null) {
            vcp.addGroup(svcID, name);
            this.refreshView();
        }
    }

    public void removeGroup(String name) {
        RosterViewContentProvider vcp = (RosterViewContentProvider)this.viewer.getContentProvider();
        if (vcp != null) {
            vcp.removeGroup(name);
            this.refreshView();
        }
    }

    public void removeRosterEntry(ID id) {
        RosterViewContentProvider vcp = (RosterViewContentProvider)this.viewer.getContentProvider();
        if (vcp != null) {
            vcp.handleRosterEntryRemove(id);
            this.refreshView();
        }
    }

    protected void handleAccountDisconnected(RosterUserAccount account) {
        this.removeAllRosterEntriesForAccount(account);
        this.disposeAllChatWindowsForAccount(account, "Disconnected from server.  Chat is inactive");
        this.removeAccount(account.getServiceID());
        if (this.accounts.size() == 0) {
            this.setToolbarEnabled(false);
        }
    }

    public void handleRosterEntryAdd(ID groupID, IRosterEntry entry) {
        if (entry == null) {
            return;
        }
        RosterViewContentProvider vcp = (RosterViewContentProvider)this.viewer.getContentProvider();
        if (vcp != null) {
            vcp.handleRosterEntryAdd(groupID, entry);
            this.refreshView();
        }
    }

    public void handlePresence(ID groupID, ID userID, IPresence presence) {
        RosterViewContentProvider vcp = (RosterViewContentProvider)this.viewer.getContentProvider();
        if (vcp != null) {
            vcp.handlePresence(groupID, userID, presence);
            this.refreshView();
        }
    }

    public void handleRosterEntryUpdate(ID groupID, IRosterEntry entry) {
        if (groupID == null || entry == null) {
            return;
        }
        RosterViewContentProvider vcp = (RosterViewContentProvider)this.viewer.getContentProvider();
        if (vcp != null) {
            vcp.handleRosterEntryUpdate(groupID, entry);
            this.refreshView();
        }
    }

    public void handleRosterEntryRemove(ID groupID, IRosterEntry entry) {
        if (groupID == null || entry == null) {
            return;
        }
        RosterViewContentProvider vcp = (RosterViewContentProvider)this.viewer.getContentProvider();
        if (vcp != null) {
            vcp.handleRosterEntryRemove(entry.getUser().getID());
        }
        this.refreshView();
    }

    public void chatRoomViewClosing(String secondaryID) {
        RoomWithAView roomView = (RoomWithAView)this.chatRooms.get(secondaryID);
        if (roomView != null) {
            roomView.getContainer().dispose();
            this.removeRoomView(roomView);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTyping(ID fromID) {
        ChatWindow window = null;
        Hashtable hashtable = this.chatThreads;
        synchronized (hashtable) {
            window = (ChatWindow)((Object)this.chatThreads.get(fromID));
        }
        if (window != null) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.ecf.presence.im.IChatID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IChatID chatID = (IChatID)fromID.getAdapter((Class)clazz);
            String name = fromID.getName();
            if (chatID != null) {
                name = chatID.getUsername();
            }
            window.setStatus(String.valueOf(name) + " is typing");
        }
    }

    class RoomWithAView {
        IChatRoomContainer container;
        ChatRoomView view;
        String secondaryID;

        RoomWithAView(IChatRoomContainer container, ChatRoomView view, String secondaryID) {
            this.container = container;
            this.view = view;
            this.secondaryID = secondaryID;
        }

        public IChatRoomContainer getContainer() {
            return this.container;
        }

        public ChatRoomView getView() {
            return this.view;
        }

        public String getID() {
            return this.secondaryID;
        }
    }
}

