/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.FaultTolerantNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IBBTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.Socks5TransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.DataForm;
import org.jivesoftware.smackx.packet.StreamInitiation;

public class FileTransferNegotiator {
    public static final String BYTE_STREAM = "http://jabber.org/protocol/bytestreams";
    public static final String INBAND_BYTE_STREAM = "http://jabber.org/protocol/ibb";
    private static final String[] NAMESPACE = new String[]{"http://jabber.org/protocol/si/profile/file-transfer", "http://jabber.org/protocol/si", "http://jabber.org/protocol/bytestreams", "http://jabber.org/protocol/ibb"};
    private static final String[] PROTOCOLS = new String[]{"http://jabber.org/protocol/bytestreams", "http://jabber.org/protocol/ibb"};
    private static final Map transferObject = new HashMap();
    private static final String STREAM_INIT_PREFIX = "jsi_";
    protected static final String STREAM_DATA_FIELD_NAME = "stream-method";
    private static final Random randomGenerator = new Random();
    public static boolean IBB_ONLY = false;
    private final XMPPConnection connection;
    private final StreamNegotiator byteStreamTransferManager;
    private final StreamNegotiator inbandTransferManager;

    public static FileTransferNegotiator getInstanceFor(XMPPConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        if (!connection.isConnected()) {
            return null;
        }
        if (transferObject.containsKey(connection)) {
            return (FileTransferNegotiator)transferObject.get(connection);
        }
        FileTransferNegotiator transfer = new FileTransferNegotiator(connection);
        FileTransferNegotiator.setServiceEnabled(connection, true);
        transferObject.put(connection, transfer);
        return transfer;
    }

    public static void setServiceEnabled(XMPPConnection connection, boolean isEnabled) {
        ServiceDiscoveryManager manager = ServiceDiscoveryManager.getInstanceFor(connection);
        int i = 0;
        while (i < NAMESPACE.length) {
            if (isEnabled) {
                manager.addFeature(NAMESPACE[i]);
            } else {
                manager.removeFeature(NAMESPACE[i]);
            }
            ++i;
        }
    }

    public static boolean isServiceEnabled(XMPPConnection connection) {
        int i = 0;
        while (i < NAMESPACE.length) {
            if (!ServiceDiscoveryManager.getInstanceFor(connection).includesFeature(NAMESPACE[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static IQ createIQ(String ID, String to, String from, IQ.Type type) {
        IQ iqPacket = new IQ(){

            public String getChildElementXML() {
                return null;
            }
        };
        iqPacket.setPacketID(ID);
        iqPacket.setTo(to);
        iqPacket.setFrom(from);
        iqPacket.setType(type);
        return iqPacket;
    }

    public static Collection getSupportedProtocols() {
        return Collections.unmodifiableList(Arrays.asList(PROTOCOLS));
    }

    private FileTransferNegotiator(XMPPConnection connection) {
        this.configureConnection(connection);
        this.connection = connection;
        this.byteStreamTransferManager = new Socks5TransferNegotiator(connection);
        this.inbandTransferManager = new IBBTransferNegotiator(connection);
    }

    private void configureConnection(final XMPPConnection connection) {
        connection.addConnectionListener(new ConnectionListener(){

            public void connectionClosed() {
                FileTransferNegotiator.this.cleanup(connection);
            }

            public void connectionClosedOnError(Exception e) {
                FileTransferNegotiator.this.cleanup(connection);
            }
        });
    }

    private void cleanup(XMPPConnection connection) {
        transferObject.remove(connection);
        this.byteStreamTransferManager.cleanup();
        this.inbandTransferManager.cleanup();
    }

    public StreamNegotiator selectStreamNegotiator(FileTransferRequest request) throws XMPPException {
        StreamNegotiator selectedStreamNegotiator;
        StreamInitiation si = request.getStreamInitiation();
        FormField streamMethodField = this.getStreamMethodField(si.getFeatureNegotiationForm());
        if (streamMethodField == null) {
            XMPPError error = new XMPPError(400);
            IQ iqPacket = FileTransferNegotiator.createIQ(si.getPacketID(), si.getFrom(), si.getTo(), IQ.Type.ERROR);
            iqPacket.setError(error);
            this.connection.sendPacket(iqPacket);
            throw new XMPPException("No stream methods contained in packet.", error);
        }
        try {
            selectedStreamNegotiator = this.getNegotiator(streamMethodField);
        }
        catch (XMPPException e) {
            IQ iqPacket = FileTransferNegotiator.createIQ(si.getPacketID(), si.getFrom(), si.getTo(), IQ.Type.ERROR);
            iqPacket.setError(e.getXMPPError());
            this.connection.sendPacket(iqPacket);
            throw e;
        }
        return selectedStreamNegotiator;
    }

    private FormField getStreamMethodField(DataForm form) {
        FormField field = null;
        Iterator it = form.getFields();
        while (it.hasNext()) {
            field = (FormField)it.next();
            if (field.getVariable().equals(STREAM_DATA_FIELD_NAME)) break;
            field = null;
        }
        return field;
    }

    private StreamNegotiator getNegotiator(FormField field) throws XMPPException {
        boolean isByteStream = false;
        boolean isIBB = false;
        Iterator it = field.getOptions();
        while (it.hasNext()) {
            String variable = ((FormField.Option)it.next()).getValue();
            if (variable.equals(BYTE_STREAM) && !IBB_ONLY) {
                isByteStream = true;
                continue;
            }
            if (!variable.equals(INBAND_BYTE_STREAM)) continue;
            isIBB = true;
        }
        if (!isByteStream && !isIBB) {
            XMPPError error = new XMPPError(400);
            throw new XMPPException("No acceptable transfer mechanism", error);
        }
        if (isByteStream && isIBB && field.getType().equals("list-multi")) {
            return new FaultTolerantNegotiator(this.connection, this.byteStreamTransferManager, this.inbandTransferManager);
        }
        if (isByteStream) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    public void rejectStream(StreamInitiation si) {
        XMPPError error = new XMPPError(403, "Offer Declined");
        IQ iqPacket = FileTransferNegotiator.createIQ(si.getPacketID(), si.getFrom(), si.getTo(), IQ.Type.ERROR);
        iqPacket.setError(error);
        this.connection.sendPacket(iqPacket);
    }

    public String getNextStreamID() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(STREAM_INIT_PREFIX);
        buffer.append(Math.abs(randomGenerator.nextLong()));
        return buffer.toString();
    }

    public StreamNegotiator negotiateOutgoingTransfer(String userID, String streamID, String fileName, long size, String desc, int responseTimeout) throws XMPPException {
        StreamInitiation si = new StreamInitiation();
        si.setSesssionID(streamID);
        si.setMimeType(URLConnection.guessContentTypeFromName(fileName));
        StreamInitiation.File siFile = new StreamInitiation.File(fileName, size);
        siFile.setDesc(desc);
        si.setFile(siFile);
        si.setFeatureNegotiationForm(this.createDefaultInitiationForm());
        si.setFrom(this.connection.getUser());
        si.setTo(userID);
        si.setType(IQ.Type.SET);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(si.getPacketID()));
        this.connection.sendPacket(si);
        Packet siResponse = collector.nextResult(responseTimeout);
        collector.cancel();
        if (siResponse instanceof IQ) {
            IQ iqResponse = (IQ)siResponse;
            if (iqResponse.getType().equals(IQ.Type.RESULT)) {
                StreamInitiation response = (StreamInitiation)siResponse;
                return this.getOutgoingNegotiator(this.getStreamMethodField(response.getFeatureNegotiationForm()));
            }
            if (iqResponse.getType().equals(IQ.Type.ERROR)) {
                throw new XMPPException(iqResponse.getError());
            }
            throw new XMPPException("File transfer response unreadable");
        }
        return null;
    }

    private StreamNegotiator getOutgoingNegotiator(FormField field) throws XMPPException {
        boolean isByteStream = false;
        boolean isIBB = false;
        Iterator it = field.getValues();
        while (it.hasNext()) {
            String variable = it.next().toString();
            if (variable.equals(BYTE_STREAM) && !IBB_ONLY) {
                isByteStream = true;
                continue;
            }
            if (!variable.equals(INBAND_BYTE_STREAM)) continue;
            isIBB = true;
        }
        if (!isByteStream && !isIBB) {
            XMPPError error = new XMPPError(400);
            throw new XMPPException("No acceptable transfer mechanism", error);
        }
        if (isByteStream && isIBB) {
            return new FaultTolerantNegotiator(this.connection, this.byteStreamTransferManager, this.inbandTransferManager);
        }
        if (isByteStream) {
            return this.byteStreamTransferManager;
        }
        return this.inbandTransferManager;
    }

    private DataForm createDefaultInitiationForm() {
        DataForm form = new DataForm("form");
        FormField field = new FormField(STREAM_DATA_FIELD_NAME);
        field.setType("list-multi");
        if (!IBB_ONLY) {
            field.addOption(new FormField.Option(BYTE_STREAM));
        }
        field.addOption(new FormField.Option(INBAND_BYTE_STREAM));
        form.addField(field);
        return form;
    }
}

