/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provisional.docshare.cola;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provisional.docshare.cola.ColaDeletion;
import org.eclipse.ecf.internal.provisional.docshare.cola.ColaInsertion;
import org.eclipse.ecf.internal.provisional.docshare.cola.ColaReplacement;
import org.eclipse.ecf.internal.provisional.docshare.cola.TransformationStrategy;
import org.eclipse.ecf.internal.provisional.docshare.messages.UpdateMessage;

public class ColaUpdateMessage
extends UpdateMessage {
    private static final long serialVersionUID = 2038025022180647210L;
    private final long localOperationsCount;
    private long remoteOperationsCount;
    private final TransformationStrategy trafoStrat;
    private boolean splitUp;
    private List splitUpRepresentation;

    public ColaUpdateMessage(UpdateMessage msg, long localOperationsCount, long remoteOperationsCount) {
        super(msg.getOffset(), msg.getLengthOfReplacedText(), msg.getText());
        this.localOperationsCount = localOperationsCount;
        this.remoteOperationsCount = remoteOperationsCount;
        this.splitUp = false;
        this.splitUpRepresentation = new LinkedList();
        this.trafoStrat = super.getLengthOfReplacedText() == 0 ? ColaInsertion.getInstance() : (super.getText().length() == 0 ? ColaDeletion.getInstance() : ColaReplacement.getInstance());
    }

    public boolean isInsertion() {
        return this.trafoStrat instanceof ColaInsertion;
    }

    public boolean isDeletion() {
        return this.trafoStrat instanceof ColaDeletion;
    }

    public boolean isReplacement() {
        return this.trafoStrat instanceof ColaReplacement;
    }

    public long getLocalOperationsCount() {
        return this.localOperationsCount;
    }

    public long getRemoteOperationsCount() {
        return this.remoteOperationsCount;
    }

    public ColaUpdateMessage transformAgainst(ColaUpdateMessage localMsg, boolean localMsgHighPrio) {
        Trace.entering((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/entering", this.getClass(), (String)"transformAgainst", (Object)localMsg);
        ColaUpdateMessage transformedMsg = this.trafoStrat.getOperationalTransform(this, localMsg, localMsgHighPrio);
        Trace.entering((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/exiting", this.getClass(), (String)"transformAgainst", (Object)transformedMsg);
        return transformedMsg;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ColaUpdateMessage[");
        buf.append("text=").append(this.getText()).append(";offset=").append(this.getOffset());
        buf.append(";length=").append(this.getLengthOfReplacedText()).append("]");
        buf.append(";operationsCount[local=").append(this.getLocalOperationsCount());
        buf.append(";remote=").append(this.getRemoteOperationsCount()).append("]]");
        return buf.toString();
    }

    public void setSplitUp(boolean toBeSplitUp) {
        this.splitUp = toBeSplitUp;
    }

    public boolean isSplitUp() {
        return this.splitUp;
    }

    public void setSplitUpRepresentation(List splitUpRepresentation) {
        this.splitUpRepresentation = splitUpRepresentation;
    }

    public List getSplitUpRepresentation() {
        return this.splitUpRepresentation;
    }

    public void addToSplitUpRepresentation(ColaUpdateMessage splitUpRepresentationPart) {
        this.splitUpRepresentation.add(splitUpRepresentationPart);
    }
}

