/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.httpclient;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.ProxyClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.provider.filetransfer.httpclient.HttpClientSslTrustManager;

public class HttpClientSslProtocolSocketFactory
implements ProtocolSocketFactory {
    public static final String DEFAULT_SSL_PROTOCOL = "https.protocols";
    private SSLContext sslContext = null;
    private String defaultProtocolNames = System.getProperty("https.protocols");
    private Proxy proxy;

    public HttpClientSslProtocolSocketFactory(Proxy proxy) {
        this.proxy = proxy;
    }

    private SSLSocketFactory getSSLSocketFactory() throws IOException {
        if (this.sslContext == null) {
            try {
                this.sslContext = this.getSSLContext(this.defaultProtocolNames);
            }
            catch (Exception e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        return this.sslContext == null ? (SSLSocketFactory)SSLSocketFactory.getDefault() : this.sslContext.getSocketFactory();
    }

    public SSLContext getSSLContext(String protocols) {
        SSLContext rtvContext = null;
        if (protocols != null) {
            String[] protocolNames = protocols.split(",");
            int i = 0;
            while (i < protocolNames.length) {
                try {
                    rtvContext = SSLContext.getInstance(protocolNames[i]);
                    this.sslContext.init(null, new TrustManager[]{new HttpClientSslTrustManager()}, null);
                    break;
                }
                catch (Exception exception) {
                    ++i;
                }
            }
        }
        return rtvContext;
    }

    public Socket createSocket(String remoteHost, int remotePort) throws IOException, UnknownHostException {
        return this.getSSLSocketFactory().createSocket(remoteHost, remotePort);
    }

    public Socket createSocket(String remoteHost, int remotePort, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this.getSSLSocketFactory().createSocket(remoteHost, remotePort, clientHost, clientPort);
    }

    public Socket createSocket(String remoteHost, int remotePort, InetAddress clientHost, int clientPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null || params.getConnectionTimeout() == 0) {
            return this.getSSLSocketFactory().createSocket(remoteHost, remotePort, clientHost, clientPort);
        }
        if (this.proxy != null && !Proxy.NO_PROXY.equals((Object)this.proxy)) {
            ProxyClient.ConnectResponse response;
            ProxyClient proxyClient = new ProxyClient();
            ProxyAddress address = this.proxy.getAddress();
            proxyClient.getHostConfiguration().setProxy(address.getHostName(), address.getPort());
            proxyClient.getHostConfiguration().setHost(remoteHost, remotePort);
            String proxyUsername = this.proxy.getUsername();
            String proxyPassword = this.proxy.getPassword();
            if (proxyUsername != null && !proxyUsername.equals("")) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                AuthScope proxyAuthScope = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM);
                proxyClient.getState().setProxyCredentials(proxyAuthScope, (Credentials)credentials);
            }
            if ((response = proxyClient.connect()).getSocket() != null) {
                Socket sslsocket = this.getSSLSocketFactory().createSocket(response.getSocket(), remoteHost, remotePort, true);
                return sslsocket;
            }
        }
        Socket socket = this.getSSLSocketFactory().createSocket();
        socket.bind(new InetSocketAddress(clientHost, clientPort));
        socket.connect(new InetSocketAddress(remoteHost, remotePort), params.getConnectionTimeout());
        return socket;
    }
}

