/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.packet.VCard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class VCardProvider
implements IQProvider {
    public IQ parseIQ(XmlPullParser parser) throws Exception {
        StringBuffer sb = new StringBuffer();
        try {
            int event = parser.getEventType();
            while (true) {
                switch (event) {
                    case 4: {
                        sb.append(StringUtils.escapeForXML(parser.getText()));
                        break;
                    }
                    case 2: {
                        sb.append('<').append(parser.getName()).append('>');
                        break;
                    }
                    case 3: {
                        sb.append("</").append(parser.getName()).append('>');
                    }
                }
                if (event != 3 || !"vCard".equals(parser.getName())) {
                    event = parser.next();
                    continue;
                }
                break;
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String xmlText = sb.toString();
        return VCardProvider._createVCardFromXml(xmlText);
    }

    public static VCard _createVCardFromXml(String xmlText) {
        VCard vCard = new VCard();
        try {
            byte[] bytes;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                bytes = xmlText.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = xmlText.getBytes();
            }
            Document document = documentBuilder.parse(new ByteArrayInputStream(bytes));
            new VCardReader(vCard, document).initializeFields();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return vCard;
    }

    private static class VCardReader {
        private final VCard vCard;
        private final Document document;

        VCardReader(VCard vCard, Document document) {
            this.vCard = vCard;
            this.document = document;
        }

        public void initializeFields() {
            this.vCard.setFirstName(this.getTagContents("GIVEN"));
            this.vCard.setLastName(this.getTagContents("FAMILY"));
            this.vCard.setMiddleName(this.getTagContents("MIDDLE"));
            this.vCard.setEncodedImage(this.getTagContents("BINVAL"));
            this.setupEmails();
            this.vCard.setOrganization(this.getTagContents("ORGNAME"));
            this.vCard.setOrganizationUnit(this.getTagContents("ORGUNIT"));
            this.setupSimpleFields();
            this.setupPhones();
            this.setupAddresses();
        }

        private void setupEmails() {
            NodeList nodes = this.document.getElementsByTagName("USERID");
            if (nodes == null) {
                return;
            }
            int i = 0;
            while (i < nodes.getLength()) {
                Element element = (Element)nodes.item(i);
                if ("HOME".equals(element.getParentNode().getFirstChild().getNodeName())) {
                    this.vCard.setEmailHome(this.getTextContent(element));
                } else {
                    this.vCard.setEmailWork(this.getTextContent(element));
                }
                ++i;
            }
        }

        private void setupPhones() {
            NodeList allPhones = this.document.getElementsByTagName("TEL");
            if (allPhones == null) {
                return;
            }
            int i = 0;
            while (i < allPhones.getLength()) {
                NodeList nodes = allPhones.item(i).getChildNodes();
                String type = null;
                String code = null;
                String value = null;
                int j = 0;
                while (j < nodes.getLength()) {
                    Node node = nodes.item(j);
                    if (node.getNodeType() == 1) {
                        String nodeName = node.getNodeName();
                        if ("NUMBER".equals(nodeName)) {
                            value = this.getTextContent(node);
                        } else if (this.isWorkHome(nodeName)) {
                            type = nodeName;
                        } else {
                            code = nodeName;
                        }
                    }
                    ++j;
                }
                if (code != null && value != null) {
                    if ("HOME".equals(type)) {
                        this.vCard.setPhoneHome(code, value);
                    } else {
                        this.vCard.setPhoneWork(code, value);
                    }
                }
                ++i;
            }
        }

        private boolean isWorkHome(String nodeName) {
            return "HOME".equals(nodeName) || "WORK".equals(nodeName);
        }

        private void setupAddresses() {
            NodeList allAddresses = this.document.getElementsByTagName("ADR");
            if (allAddresses == null) {
                return;
            }
            int i = 0;
            while (i < allAddresses.getLength()) {
                Element addressNode = (Element)allAddresses.item(i);
                String type = null;
                ArrayList<String> code = new ArrayList<String>();
                ArrayList<String> value = new ArrayList<String>();
                NodeList childNodes = addressNode.getChildNodes();
                int j = 0;
                while (j < childNodes.getLength()) {
                    Node node = childNodes.item(j);
                    if (node.getNodeType() == 1) {
                        String nodeName = node.getNodeName();
                        if (this.isWorkHome(nodeName)) {
                            type = nodeName;
                        } else {
                            code.add(nodeName);
                            value.add(this.getTextContent(node));
                        }
                    }
                    ++j;
                }
                j = 0;
                while (j < value.size()) {
                    if ("HOME".equals(type)) {
                        this.vCard.setAddressFieldHome((String)code.get(j), (String)value.get(j));
                    } else {
                        this.vCard.setAddressFieldWork((String)code.get(j), (String)value.get(j));
                    }
                    ++j;
                }
                ++i;
            }
        }

        private String getTagContents(String tag) {
            NodeList nodes = this.document.getElementsByTagName(tag);
            if (nodes != null && nodes.getLength() == 1) {
                return this.getTextContent(nodes.item(0));
            }
            return null;
        }

        private void setupSimpleFields() {
            NodeList childNodes = this.document.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node node = childNodes.item(i);
                if (node instanceof Element) {
                    Element element = (Element)node;
                    String field = element.getNodeName();
                    if (element.getChildNodes().getLength() == 0) {
                        this.vCard.setField(field, "");
                    } else if (element.getChildNodes().getLength() == 1 && element.getChildNodes().item(0) instanceof Text) {
                        this.vCard.setField(field, this.getTextContent(element));
                    }
                }
                ++i;
            }
        }

        private String getTextContent(Node node) {
            StringBuffer result = new StringBuffer();
            this.appendText(result, node);
            return result.toString();
        }

        private void appendText(StringBuffer result, Node node) {
            NodeList childNodes = node.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node nd = childNodes.item(i);
                String nodeValue = nd.getNodeValue();
                if (nodeValue != null) {
                    result.append(nodeValue);
                }
                this.appendText(result, nd);
                ++i;
            }
        }
    }
}

