/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.ui.screencapture;

import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.ui.Messages;
import org.eclipse.ecf.ui.screencapture.IImageSender;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ScreenCaptureConfirmationDialog
extends Dialog {
    final Image image;
    private final int width;
    private final int height;
    private final IImageSender imageSender;
    private final ID targetID;
    private final String nickName;

    public ScreenCaptureConfirmationDialog(Shell shell, ID targetID, String nickName, Image image, int width, int height, IImageSender imageSender) {
        super(shell);
        this.targetID = targetID;
        this.nickName = nickName;
        this.image = image;
        this.width = width;
        this.height = height;
        this.imageSender = imageSender;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.imageSender.sendImage(this.targetID, this.image.getImageData());
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NLS.bind((String)Messages.ScreenCaptureScreenCaptureConfirmationDialog, (Object)this.nickName));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(this.width, this.height));
        composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.drawImage(ScreenCaptureConfirmationDialog.this.image, 0, 0);
            }
        });
        return composite;
    }

    public boolean close() {
        this.image.dispose();
        return super.close();
    }
}

