/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.AdapterContainerFilter;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.ui.views.IServiceAccessHandler;
import org.eclipse.ecf.internal.discovery.ui.Activator;
import org.eclipse.ecf.internal.discovery.ui.Messages;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.InvalidSyntaxException;

public abstract class AbstractRemoteServiceAccessHandler
implements IServiceAccessHandler {
    protected static final IContributionItem[] EMPTY_CONTRIBUTION = new IContributionItem[0];
    protected static IContributionItem[] NOT_AVAILABLE_CONTRIBUTION;
    protected final AdapterContainerFilter containerFilter;
    protected IServiceInfo serviceInfo;
    static /* synthetic */ Class class$0;

    public AbstractRemoteServiceAccessHandler() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.containerFilter = new AdapterContainerFilter((Class)clazz);
        Action containerNotAvailableAction = new Action(){

            public void run() {
            }
        };
        containerNotAvailableAction.setText(Messages.AbstractRemoteServiceAccessHandler_NOT_AVAILABLE_MENU_TEXT);
        containerNotAvailableAction.setEnabled(false);
        NOT_AVAILABLE_CONTRIBUTION = new IContributionItem[]{new ActionContributionItem((IAction)containerNotAvailableAction)};
    }

    private IContainerManager getContainerManager() {
        return Activator.getDefault().getContainerManager();
    }

    protected IServiceInfo getServiceInfo() {
        return this.serviceInfo;
    }

    protected boolean isConnected(IContainer container) {
        if (container == null) {
            return false;
        }
        return container.getConnectedID() == null;
    }

    protected boolean matchTargetNamespace(IContainer container, String targetNamespace) {
        Namespace containerNamespace = container.getConnectNamespace();
        if (containerNamespace == null && targetNamespace == null) {
            return true;
        }
        return containerNamespace.getName().equals(targetNamespace);
    }

    protected boolean matchServiceType(String service) {
        return Arrays.asList(this.serviceInfo.getServiceID().getServiceTypeID().getServices()).contains(service);
    }

    protected List getRemoteServiceContainerAdapters() {
        ArrayList<Object> remoteServicesContainerAdapters = new ArrayList<Object>();
        IContainerManager containerManager = this.getContainerManager();
        if (containerManager == null) {
            return remoteServicesContainerAdapters;
        }
        IContainer[] containers = containerManager.getAllContainers();
        int i = 0;
        while (i < containers.length) {
            if (this.containerFilter.match(containers[i]) && this.matchTargetNamespace(containers[i], this.getConnectNamespace())) {
                remoteServicesContainerAdapters.add(this.containerFilter.getMatchResult());
            }
            ++i;
        }
        return remoteServicesContainerAdapters;
    }

    protected String getContainerFactory() {
        return this.serviceInfo.getServiceProperties().getPropertyString("cft");
    }

    protected String getRemoteServiceClass() {
        return this.serviceInfo.getServiceProperties().getPropertyString("cls");
    }

    protected String getConnectNamespace() {
        return this.serviceInfo.getServiceProperties().getPropertyString("cns");
    }

    protected String getConnectID() {
        return this.serviceInfo.getServiceProperties().getPropertyString("cid");
    }

    protected String getServiceNamespace() {
        return this.serviceInfo.getServiceProperties().getPropertyString("sns");
    }

    protected String getServiceID() {
        return this.serviceInfo.getServiceProperties().getPropertyString("sid");
    }

    protected String getFilter() {
        return this.serviceInfo.getServiceProperties().getPropertyString("fltr");
    }

    protected ID createID(String namespace, String value) throws IDCreateException {
        return IDFactory.getDefault().createID(namespace, value);
    }

    protected ID createConnectID() throws IDCreateException {
        return this.createID(this.getConnectNamespace(), this.getConnectID());
    }

    protected abstract IContributionItem[] getContributionsForMatchingService();

    public IContributionItem[] getContributionsForService(IServiceInfo svcInfo) {
        if (svcInfo == null) {
            return EMPTY_CONTRIBUTION;
        }
        this.serviceInfo = svcInfo;
        if (this.matchServiceType("remotesvcs")) {
            return this.getContributionsForMatchingService();
        }
        return EMPTY_CONTRIBUTION;
    }

    protected IRemoteServiceReference[] getRemoteServiceReferencesForRemoteServiceAdapter(IRemoteServiceContainerAdapter adapter) throws InvalidSyntaxException, IDCreateException {
        ID[] iDArray;
        ID serviceID = null;
        String serviceNamespace = this.getServiceNamespace();
        String serviceid = this.getServiceID();
        if (serviceNamespace != null && serviceid != null) {
            serviceID = this.createID(serviceNamespace, serviceid);
        }
        if (serviceID == null) {
            iDArray = null;
        } else {
            ID[] iDArray2 = new ID[1];
            iDArray = iDArray2;
            iDArray2[0] = serviceID;
        }
        ID[] targets = iDArray;
        return adapter.getRemoteServiceReferences(targets, this.getRemoteServiceClass(), this.getFilter());
    }

    protected IContainer createContainer() throws ContainerCreateException {
        return ContainerFactory.getDefault().createContainer(this.getContainerFactory());
    }

    protected void connectContainer(IContainer container, ID connectTargetID, IConnectContext connectContext) throws ContainerConnectException {
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)connectTargetID);
        container.connect(connectTargetID, connectContext);
    }

    protected abstract IContributionItem[] getContributionItemsForRemoteServiceAdapter(IRemoteServiceContainerAdapter var1);

    protected IContributionItem[] getContributionItemsForConnectedContainer(final IContainer container, IRemoteServiceContainerAdapter adapter) {
        ArrayList<Object> results = new ArrayList<Object>();
        IContributionItem[] serviceItem = this.getContributionItemsForRemoteServiceAdapter(adapter);
        if (serviceItem != null) {
            int i = 0;
            while (i < serviceItem.length) {
                results.add(serviceItem[i]);
                ++i;
            }
        } else {
            return EMPTY_CONTRIBUTION;
        }
        results.add(new Separator());
        Action disconnectAction = new Action(){

            public void run() {
                container.disconnect();
            }
        };
        disconnectAction.setText(Messages.AbstractRemoteServiceAccessHandler_DISCONNECT_MENU_TEXT);
        results.add(new ActionContributionItem((IAction)disconnectAction));
        return results.toArray(new IContributionItem[0]);
    }

    protected void showResult(String serviceInterface, IRemoteCall remoteCall, Object result) {
        List<Object> display = result != null && result.getClass().isArray() ? Arrays.asList((Object[])result) : result;
        final Object[] bindings = new Object[]{serviceInterface, remoteCall.getMethod(), Arrays.asList(remoteCall.getParameters()), display};
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation(null, (String)Messages.AbstractRemoteServiceAccessHandler_MSG_BOX_RECEIVED_RESP_TITLE, (String)NLS.bind((String)Messages.AbstractRemoteServiceAccessHandler_MSG_BOX_RECEIVED_RESP_TEXT, (Object[])bindings));
            }
        });
    }

    protected void showException(final Throwable t) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                String msg = t.toString();
                if (t.getCause() != null) {
                    msg = String.valueOf(msg) + t.getCause().toString();
                }
                MessageDialog.openInformation(null, (String)Messages.AbstractRemoteServiceAccessHandler_MSG_BOX_RECEIVED_EXCEPTION_TITLE, (String)NLS.bind((String)Messages.AbstractRemoteServiceAccessHandler_MSG_BOX_RECEIVED_EXCEPTION_TEXT, (Object)msg));
            }
        });
    }

    protected void showInformation(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation(null, (String)title, (String)message);
            }
        });
    }
}

