/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.discovery.ui;

import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.ui.views.DiscoveryView;
import org.eclipse.ecf.internal.discovery.ui.Messages;
import org.eclipse.ecf.internal.discovery.ui.ViewTreeObject;
import org.eclipse.ecf.internal.discovery.ui.ViewTreeService;
import org.eclipse.ecf.internal.discovery.ui.ViewTreeType;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private final DiscoveryView discoveryView;
    protected ViewTreeService root;

    public ViewContentProvider(DiscoveryView discoveryView) {
        this.discoveryView = discoveryView;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent.equals(this.discoveryView.getViewSite())) {
            if (this.root == null) {
                this.initialize();
            }
            return this.getChildren(this.root);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof ViewTreeObject) {
            return ((ViewTreeObject)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ViewTreeService) {
            return ((ViewTreeService)parent).getChildren();
        }
        if (parent instanceof ViewTreeType) {
            return ((ViewTreeType)parent).getChildren();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof ViewTreeService) {
            return ((ViewTreeService)parent).hasChildren();
        }
        if (parent instanceof ViewTreeType) {
            return ((ViewTreeType)parent).hasChildren();
        }
        return false;
    }

    private void initialize() {
        this.root = new ViewTreeService(null, Messages.DiscoveryView_Services, null);
    }

    public void clear() {
        if (this.root != null) {
            this.root.clearChildren();
        }
    }

    public boolean isRoot(ViewTreeService tp) {
        return tp != null && tp == this.root;
    }

    void replaceOrAdd(ViewTreeType top, ViewTreeService newEntry) {
        ViewTreeObject[] childs = top.getChildren();
        int i = 0;
        while (i < childs.length) {
            IServiceID childID;
            if (childs[i] instanceof ViewTreeService && (childID = ((ViewTreeService)childs[i]).getID()).equals((Object)newEntry.getID())) {
                top.removeChild(childs[i]);
            }
            ++i;
        }
        top.addChild(newEntry);
    }

    private ViewTreeType findServiceTypeNode(IServiceTypeID typeID) {
        ViewTreeType vtt = new ViewTreeType(typeID);
        ViewTreeObject[] types = this.root.getChildren();
        int i = 0;
        while (i < types.length) {
            ViewTreeType existing;
            if (types[i] instanceof ViewTreeType && vtt.equals(existing = (ViewTreeType)types[i])) {
                return existing;
            }
            ++i;
        }
        return null;
    }

    public void addServiceInfo(IServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return;
        }
        IServiceID svcID = serviceInfo.getServiceID();
        ViewTreeType typenode = this.findServiceTypeNode(svcID.getServiceTypeID());
        if (typenode == null) {
            typenode = new ViewTreeType(svcID.getServiceTypeID());
            this.root.addChild(typenode);
        }
        this.replaceOrAdd(typenode, new ViewTreeService(svcID, svcID.getServiceName(), serviceInfo));
    }

    public void removeServiceInfo(IServiceInfo serviceInfo) {
        if (serviceInfo == null) {
            return;
        }
        IServiceID svcID = serviceInfo.getServiceID();
        ViewTreeType typenode = this.findServiceTypeNode(svcID.getServiceTypeID());
        if (typenode == null) {
            return;
        }
        ViewTreeObject[] childs = typenode.getChildren();
        int i = 0;
        while (i < childs.length) {
            ViewTreeService parent;
            if (childs[i] instanceof ViewTreeService && (parent = (ViewTreeService)childs[i]).getID().equals((Object)svcID)) {
                typenode.removeChild(parent);
            }
            ++i;
        }
        if (typenode.getChildren().length == 0) {
            this.root.removeChild(typenode);
        }
    }
}

