/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.discovery.ui;

import java.util.ArrayList;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.internal.discovery.ui.ViewTreeObject;

public class ViewTreeType
extends ViewTreeObject {
    private final ArrayList children;
    private final IServiceTypeID typeID;

    public ViewTreeType(String name) {
        super(name);
        this.typeID = null;
        this.children = new ArrayList();
    }

    public ViewTreeType(IServiceTypeID typeID) {
        super(null);
        this.typeID = typeID;
        this.children = new ArrayList();
    }

    public String getName() {
        String superName = super.getName();
        if (superName != null) {
            return superName;
        }
        String[] services = this.typeID.getServices();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < services.length) {
            buffer.append(services[i]).append(':');
            ++i;
        }
        buffer.deleteCharAt(buffer.length() - 1);
        return buffer.toString();
    }

    public void addChild(ViewTreeObject child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(ViewTreeObject child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public ViewTreeObject[] getChildren() {
        return this.children.toArray(new ViewTreeObject[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public void clearChildren() {
        this.children.clear();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.typeID == null ? 0 : this.typeID.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewTreeType other = (ViewTreeType)obj;
        return !(this.typeID == null ? other.typeID != null : !this.typeID.equals((Object)other.typeID));
    }
}

