/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.efs;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.provider.filetransfer.retrieve.AbstractRetrieveFileTransfer;
import org.eclipse.ecf.provider.filetransfer.util.JREProxyHelper;

public class RetrieveFileTransfer
extends AbstractRetrieveFileTransfer {
    JREProxyHelper proxyHelper = new JREProxyHelper();
    String fileName;

    public String getRemoteFileName() {
        return this.fileName;
    }

    protected void hardClose() {
        super.hardClose();
        if (this.proxyHelper != null) {
            this.proxyHelper.dispose();
            this.proxyHelper = null;
        }
    }

    protected void openStreams() throws IncomingFileTransferException {
        try {
            IFileStore fileStore = EFS.getStore((URI)new URI(this.getRemoteFileURL().getPath()));
            IFileInfo info = fileStore.fetchInfo();
            this.setFileLength(info.getLength());
            this.setInputStream(fileStore.openInputStream(0, null));
            this.setLastModifiedTime(info.getLastModified());
            this.fileName = info.getName();
            this.listener.handleTransferEvent((IFileTransferEvent)new IIncomingFileTransferReceiveStartEvent(){
                private static final long serialVersionUID = 590077256618427122L;

                public IIncomingFileTransfer getSource() {
                    return RetrieveFileTransfer.this;
                }

                public IFileID getFileID() {
                    return RetrieveFileTransfer.this.remoteFileID;
                }

                public IIncomingFileTransfer receive(File localFileToSave) throws IOException {
                    return this.receive(localFileToSave, null);
                }

                public IIncomingFileTransfer receive(File localFileToSave, FileTransferJob fileTransferJob) throws IOException {
                    RetrieveFileTransfer.this.setOutputStream(new BufferedOutputStream(new FileOutputStream(localFileToSave)));
                    RetrieveFileTransfer.this.setupAndScheduleJob(fileTransferJob);
                    return RetrieveFileTransfer.this;
                }

                public String toString() {
                    StringBuffer sb = new StringBuffer("IIncomingFileTransferReceiveStartEvent[");
                    sb.append("isdone=").append(RetrieveFileTransfer.this.done).append(";");
                    sb.append("bytesReceived=").append(RetrieveFileTransfer.this.bytesReceived).append("]");
                    return sb.toString();
                }

                public void cancel() {
                    RetrieveFileTransfer.this.hardClose();
                }

                public IIncomingFileTransfer receive(OutputStream streamToStore) throws IOException {
                    return this.receive(streamToStore, null);
                }

                public IIncomingFileTransfer receive(OutputStream streamToStore, FileTransferJob fileTransferJob) throws IOException {
                    RetrieveFileTransfer.this.setOutputStream(streamToStore);
                    RetrieveFileTransfer.this.setCloseOutputStream(false);
                    RetrieveFileTransfer.this.setupAndScheduleJob(fileTransferJob);
                    return RetrieveFileTransfer.this;
                }
            });
        }
        catch (Exception e) {
            throw new IncomingFileTransferException((Throwable)e);
        }
    }

    protected boolean doPause() {
        return false;
    }

    protected boolean doResume() {
        return false;
    }

    protected void setupProxy(Proxy proxy) {
        this.proxyHelper.setupProxy(proxy);
    }
}

