/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.messages;

import ch.ethz.iks.r_osgi.messages.RemoteOSGiMessage;
import ch.ethz.iks.util.SmartSerializer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class MethodResultMessage
extends RemoteOSGiMessage {
    private byte errorFlag;
    private Object result;
    private Throwable exception;

    public MethodResultMessage() {
        super((short)6);
    }

    MethodResultMessage(ObjectInputStream input) throws IOException {
        super((short)6);
        this.errorFlag = input.readByte();
        if (this.errorFlag == 0) {
            this.result = SmartSerializer.deserialize(input);
            this.exception = null;
        } else {
            this.exception = (Throwable)SmartSerializer.deserialize(input);
            this.result = null;
        }
    }

    public void writeBody(ObjectOutputStream out) throws IOException {
        if (this.exception == null) {
            out.writeByte(0);
            SmartSerializer.serialize(this.result, out);
        } else {
            out.writeByte(1);
            SmartSerializer.serialize(this.exception, out);
        }
    }

    public boolean causedException() {
        return this.errorFlag == 1;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
        this.errorFlag = 0;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable t) {
        this.exception = t;
        this.errorFlag = 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[METHOD_RESULT] - XID: ");
        buffer.append(this.xid);
        buffer.append(", errorFlag: ");
        buffer.append(this.errorFlag);
        if (this.causedException()) {
            buffer.append(", exception: ");
            buffer.append(this.exception.getMessage());
        } else {
            buffer.append(", result: ");
            buffer.append(this.result);
        }
        return buffer.toString();
    }
}

