/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.ui.model.resource;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.IDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.ui.model.IHost;
import org.eclipse.ecf.discovery.ui.model.INetwork;
import org.eclipse.ecf.discovery.ui.model.IServiceID;
import org.eclipse.ecf.discovery.ui.model.IServiceTypeID;
import org.eclipse.ecf.discovery.ui.model.ModelFactory;
import org.eclipse.ecf.discovery.ui.model.ModelPlugin;
import org.eclipse.ecf.discovery.ui.model.resource.Messages;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ServiceResource
extends ResourceImpl
implements Resource {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ServiceResource(URI uri) {
        super(uri);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void load(Map options) throws IOException {
        block6: {
            if (this.isLoaded) return;
            Notification notification = this.setLoaded(true);
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            try {
                INetwork network = ModelFactory.eINSTANCE.createINetwork();
                this.getContents().add((Object)network);
                this.setModified(true);
                Job job = new Job("ServiceDiscoveryListener"){

                    protected IStatus run(IProgressMonitor monitor) {
                        ServiceDiscoveryListener sdl = new ServiceDiscoveryListener();
                        sdl.connect();
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.isLoading = false;
                if (notification != null) {
                    this.eNotify(notification);
                }
                this.setModified(false);
                throw throwable;
            }
            {
                Object var5_7 = null;
                this.isLoading = false;
                if (notification == null) break block6;
            }
            this.eNotify(notification);
        }
        this.setModified(false);
    }

    private class ServiceDiscoveryListener
    implements IServiceListener {
        private volatile Lock lock = new ReentrantLock(true);
        public static final String DISCOVERY_CONTAINER = "ecf.singleton.discovery";
        private IContainer container;
        private IDiscoveryContainerAdapter discovery;
        private Comparator aComparator = new ECFServiceInfoComparator();

        private ServiceDiscoveryListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void connect() {
            this.lock.lock();
            try {
                try {
                    this.container = ContainerFactory.getDefault().createContainer(DISCOVERY_CONTAINER, new Object[]{"ecf.discovery.*"});
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("org.eclipse.ecf.discovery.IDiscoveryContainerAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz2;
                    }
                    this.discovery = (IDiscoveryContainerAdapter)this.container.getAdapter((Class)clazz);
                    if (this.discovery != null) {
                        this.discovery.addServiceListener((IServiceListener)this);
                        this.container.connect(null, null);
                        IServiceInfo[] services = this.discovery.getServices();
                        int i = 0;
                        while (i < services.length) {
                            this.serviceDiscovered(services[i]);
                            Class<?> clazz3 = class$1;
                            if (clazz3 == null) {
                                try {
                                    clazz3 = Class.forName("org.eclipse.ecf.discovery.ui.model.resource.ServiceResource");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Trace.trace((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/tracing", clazz3, (String)"connect", (String)("serviceResolved: " + services[i].toString()));
                            ++i;
                        }
                    } else {
                        ModelPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.discovery.model", Messages.ServiceResource_NO_DISCOVERY_CONTAINER_AVAILABLE));
                    }
                }
                catch (ContainerCreateException e1) {
                    this.container = null;
                    this.discovery = null;
                    ModelPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ecf.discovery.model", Messages.ServiceResource_NO_DISCOVERY_CONTAINER_AVAILABLE, (Throwable)e1));
                    Object var3_5 = null;
                    this.lock.unlock();
                    return;
                }
                catch (ContainerConnectException e) {
                    ModelPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.discovery.model", e.getMessage(), (Throwable)e));
                }
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.lock.unlock();
                throw throwable;
            }
            {
                Object var3_7 = null;
                this.lock.unlock();
                return;
            }
        }

        private void createEMFIServiceInfo(IServiceInfo ecfServiceInfo, org.eclipse.ecf.discovery.ui.model.IServiceInfo emfIServiceInfo) {
            emfIServiceInfo.setEcfServiceInfo(ecfServiceInfo);
            emfIServiceInfo.setEcfName(ecfServiceInfo.getServiceID().getName());
            emfIServiceInfo.setEcfLocation(ecfServiceInfo.getLocation());
            emfIServiceInfo.setEcfPriority(ecfServiceInfo.getPriority());
            emfIServiceInfo.setEcfWeight(ecfServiceInfo.getWeight());
            org.eclipse.ecf.discovery.identity.IServiceID ecfServiceID = ecfServiceInfo.getServiceID();
            IServiceID emfIServiceID = ModelFactory.eINSTANCE.createIServiceID();
            emfIServiceID.setEcfServiceID(ecfServiceID);
            emfIServiceID.setEcfServiceName(ecfServiceID.getServiceName());
            emfIServiceInfo.setServiceID(emfIServiceID);
            org.eclipse.ecf.discovery.identity.IServiceTypeID ecfServiceTypeID = ecfServiceID.getServiceTypeID();
            IServiceTypeID emfIServiceTypeID = ModelFactory.eINSTANCE.createIServiceTypeID();
            emfIServiceTypeID.setEcfNamingAuthority(ecfServiceTypeID.getNamingAuthority());
            emfIServiceTypeID.setEcfServiceName(ecfServiceTypeID.getName());
            emfIServiceTypeID.setEcfServiceTypeID(ecfServiceTypeID);
            emfIServiceTypeID.getEcfScopes().addAll(Arrays.asList(ecfServiceTypeID.getScopes()));
            emfIServiceTypeID.getEcfServices().addAll(Arrays.asList(ecfServiceTypeID.getServices()));
            emfIServiceTypeID.getEcfProtocols().addAll(Arrays.asList(ecfServiceTypeID.getProtocols()));
            emfIServiceID.setServiceTypeID(emfIServiceTypeID);
        }

        private IHost getIHost(InetAddress anAddress) {
            IHost host = ModelFactory.eINSTANCE.createIHost();
            host.setAddress(anAddress);
            host.setName(anAddress.getCanonicalHostName());
            return host;
        }

        private org.eclipse.ecf.discovery.ui.model.IServiceInfo getIServiceInfo(IServiceInfo ecfServiceInfo) {
            Class<?> clazz;
            org.eclipse.ecf.discovery.ui.model.IServiceInfo emfIServiceInfo;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ecf.discovery.ui.model.resource.ServiceResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.entering((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/entering", (Class)clazz2, (String)"getIServiceInfo", (Object)ecfServiceInfo);
            try {
                emfIServiceInfo = (org.eclipse.ecf.discovery.ui.model.IServiceInfo)ServiceResource.this.resourceSet.getEObject(this.convertToURI(ecfServiceInfo), true);
                this.createEMFIServiceInfo(ecfServiceInfo, emfIServiceInfo);
            }
            catch (RuntimeException e) {
                ModelPlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.ecf.discovery.model", e.getMessage()));
                emfIServiceInfo = ModelFactory.eINSTANCE.createIServiceInfo();
                this.createEMFIServiceInfo(ecfServiceInfo, emfIServiceInfo);
            }
            if ((clazz = class$1) == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ecf.discovery.ui.model.resource.ServiceResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.exiting((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/exiting", (Class)clazz, (String)"getIServiceInfo", (Object)ecfServiceInfo);
            return emfIServiceInfo;
        }

        private URI convertToURI(IServiceInfo anIServiceInfo) {
            String name = anIServiceInfo.getServiceID().getServiceTypeID().getName().substring(1);
            name = name.replaceAll("._", "/");
            name = name.replaceFirst("\\.", "/");
            name = "ecf://" + name;
            URIConverterImpl uriConverter = new URIConverterImpl();
            URI uri = uriConverter.normalize(URI.createURI((String)name));
            uri = URI.createHierarchicalURI((String)uri.scheme(), (String)(String.valueOf(anIServiceInfo.getLocation().getHost()) + ":" + anIServiceInfo.getLocation().getPort()), null, (String[])uri.segments(), null, null);
            return uri;
        }

        public void disconnect() {
            this.container.dispose();
        }

        private IHost findIHost(InetAddress anAddress) {
            INetwork network = (INetwork)ServiceResource.this.getContents().get(0);
            Iterator itr = network.getHosts().iterator();
            while (itr.hasNext()) {
                IHost host = (IHost)itr.next();
                if (!host.getAddress().equals(anAddress)) continue;
                return host;
            }
            return null;
        }

        private org.eclipse.ecf.discovery.ui.model.IServiceInfo findIServiceInfo(IServiceInfo ecfServiceInfo) {
            IHost host = this.findIHost(this.getInetAddress(ecfServiceInfo.getLocation()));
            if (host != null) {
                Iterator itr = host.getServices().iterator();
                while (itr.hasNext()) {
                    org.eclipse.ecf.discovery.ui.model.IServiceInfo emfIServiceInfo = (org.eclipse.ecf.discovery.ui.model.IServiceInfo)itr.next();
                    if (this.aComparator.compare(ecfServiceInfo, emfIServiceInfo.getEcfServiceInfo()) != 0) continue;
                    return emfIServiceInfo;
                }
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void serviceUndiscovered(IServiceEvent ecfEvent) {
            this.lock.lock();
            try {
                Class<?> clazz;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.ecf.discovery.ui.model.resource.ServiceResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Trace.entering((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/entering", (Class)clazz2, (String)"serviceRemoved", (Object)ecfEvent);
                IServiceInfo ecfServiceInfo = ecfEvent.getServiceInfo();
                org.eclipse.ecf.discovery.ui.model.IServiceInfo emfIServiceInfo = this.findIServiceInfo(ecfServiceInfo);
                Assert.isNotNull((Object)emfIServiceInfo);
                EcoreUtil.remove((EObject)emfIServiceInfo);
                HashSet<Resource> resources = new HashSet<Resource>();
                TreeIterator iter = EcoreUtil.getAllContents((EObject)emfIServiceInfo, (boolean)false);
                while (iter.hasNext()) {
                    resources.add(((EObject)iter.next()).eResource());
                }
                ServiceResource.this.getResourceSet().getResources().removeAll(resources);
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("org.eclipse.ecf.discovery.ui.model.resource.ServiceResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Trace.trace((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/tracing", clazz3, (String)"serviceRemoved", (String)("Removed service " + emfIServiceInfo));
                IHost host = this.findIHost(this.getInetAddress(ecfServiceInfo.getLocation()));
                if (host != null && host.getServices().size() < 1) {
                    EcoreUtil.remove((EObject)host);
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$1 = Class.forName("org.eclipse.ecf.discovery.ui.model.resource.ServiceResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Trace.trace((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/tracing", clazz4, (String)"serviceRemoved", (String)("Removed host " + host));
                }
                if ((clazz = class$1) == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ecf.discovery.ui.model.resource.ServiceResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Trace.exiting((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/exiting", (Class)clazz, (String)"serviceRemoved", (Object)ecfEvent);
                Object var7_9 = null;
                this.lock.unlock();
                return;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.lock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void serviceDiscovered(IServiceEvent ecfEvent) {
            this.lock.lock();
            try {
                this.serviceDiscovered(ecfEvent.getServiceInfo());
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.lock.unlock();
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.lock.unlock();
                return;
            }
        }

        private void serviceDiscovered(IServiceInfo ecfServiceInfo) {
            Class<?> clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ecf.discovery.ui.model.resource.ServiceResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.entering((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/entering", (Class)clazz2, (String)"serviceResolved", (Object)ecfServiceInfo);
            String hostname = ecfServiceInfo.getLocation().getHost();
            if (hostname != null && this.findIServiceInfo(ecfServiceInfo) == null) {
                org.eclipse.ecf.discovery.ui.model.IServiceInfo emfIServiceInfo = this.getIServiceInfo(ecfServiceInfo);
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("org.eclipse.ecf.discovery.ui.model.resource.ServiceResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Trace.trace((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/tracing", clazz3, (String)"serviceResolved", (String)("Service created " + emfIServiceInfo));
                InetAddress inetAddress = this.getInetAddress(ecfServiceInfo.getLocation());
                IHost host = this.findIHost(inetAddress);
                if (host == null) {
                    host = this.getIHost(inetAddress);
                    INetwork network = (INetwork)ServiceResource.this.getContents().get(0);
                    network.getHosts().add((Object)host);
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$1 = Class.forName("org.eclipse.ecf.discovery.ui.model.resource.ServiceResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Trace.trace((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/tracing", clazz4, (String)"serviceResolved", (String)("Host created " + emfIServiceInfo));
                }
                host.getServices().add((Object)emfIServiceInfo);
            }
            if ((clazz = class$1) == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ecf.discovery.ui.model.resource.ServiceResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Trace.exiting((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/exiting", (Class)clazz, (String)"serviceResolved", (Object)ecfServiceInfo);
        }

        private InetAddress getInetAddress(java.net.URI anURI) {
            String host = anURI.getHost();
            if (host != null) {
                try {
                    return InetAddress.getByName(host);
                }
                catch (UnknownHostException e) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.ecf.discovery.ui.model.resource.ServiceResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Trace.catching((String)"org.eclipse.ecf.discovery.model", (String)"org.eclipse.ecf.discovery.model/methods/catching", (Class)clazz, (String)"getInetAddress", (Throwable)e);
                }
            }
            return null;
        }

        private class ECFServiceInfoComparator
        implements Comparator {
            private ECFServiceInfoComparator() {
            }

            public int compare(Object anObj1, Object anObj2) {
                if (anObj1 == anObj2) {
                    return 0;
                }
                IServiceInfo si1 = (IServiceInfo)anObj1;
                IServiceInfo si2 = (IServiceInfo)anObj2;
                org.eclipse.ecf.discovery.identity.IServiceTypeID stId1 = si1.getServiceID().getServiceTypeID();
                org.eclipse.ecf.discovery.identity.IServiceTypeID stId2 = si2.getServiceID().getServiceTypeID();
                java.net.URI uri1 = si1.getLocation();
                java.net.URI uri2 = si2.getLocation();
                String scheme1 = uri1.getScheme();
                String scheme2 = uri2.getScheme();
                InetAddress address1 = ServiceDiscoveryListener.this.getInetAddress(uri1);
                InetAddress address2 = ServiceDiscoveryListener.this.getInetAddress(uri2);
                if (scheme1.equals(scheme2) && uri1.getPort() == uri2.getPort() && address1 != null && address1.equals(address2) && stId1.equals((Object)stId2)) {
                    return 0;
                }
                return -1;
            }
        }
    }
}

