/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.docshare;

import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.datashare.AbstractShare;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.datashare.events.IChannelDisconnectEvent;
import org.eclipse.ecf.docshare.DocShareEditorInput;
import org.eclipse.ecf.docshare.messages.Message;
import org.eclipse.ecf.docshare.messages.StartMessage;
import org.eclipse.ecf.docshare.messages.StopMessage;
import org.eclipse.ecf.internal.docshare.Activator;
import org.eclipse.ecf.internal.docshare.Messages;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.IRosterListener;
import org.eclipse.ecf.presence.roster.IRosterManager;
import org.eclipse.ecf.sync.IModelChange;
import org.eclipse.ecf.sync.IModelChangeMessage;
import org.eclipse.ecf.sync.IModelSynchronizationStrategy;
import org.eclipse.ecf.sync.doc.DocumentChangeMessage;
import org.eclipse.ecf.sync.doc.IDocumentSynchronizationStrategyFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class DocShare
extends AbstractShare {
    private ID initiatorID;
    private ID receiverID;
    private ID ourID;
    private ITextEditor editor;
    String startContent = null;
    Object stateLock = new Object();
    IModelSynchronizationStrategy syncStrategy;
    IDocumentSynchronizationStrategyFactory factory;
    IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            ITextEditor textEditor = DocShare.this.getTextEditor();
            if (textEditor != null && part.equals(textEditor.getSite().getPart())) {
                DocShare.this.stopShare();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    IRosterManager rosterManager;
    IRosterListener rosterListener = new IRosterListener(){

        public void handleRosterEntryAdd(IRosterEntry entry) {
        }

        public void handleRosterEntryRemove(IRosterEntry entry) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRosterUpdate(IRoster roster, IRosterItem changedValue) {
            if (changedValue instanceof IRosterEntry) {
                ID changedID = ((IRosterEntry)changedValue).getUser().getID();
                ID oID = null;
                ID otherID = null;
                Shell shell = null;
                Object object = DocShare.this.stateLock;
                synchronized (object) {
                    oID = DocShare.this.getOurID();
                    otherID = DocShare.this.getOtherID();
                    IWorkbenchPartSite wps = DocShare.this.getTextEditor().getSite();
                    shell = wps.getShell();
                }
                if (oID != null && changedID.equals((Object)oID)) {
                    DocShare.this.localStopShare();
                    DocShare.this.showStopShareMessage(shell, Messages.DocShare_STOP_SHARED_EDITOR_US);
                } else if (otherID != null && changedID.equals((Object)otherID)) {
                    DocShare.this.localStopShare();
                    DocShare.this.showStopShareMessage(shell, Messages.DocShare_STOP_SHARED_EDITOR_REMOTE);
                }
            }
        }
    };
    IDocumentListener documentListener = new IDocumentListener(){

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (DocShare.this.getChannel() == null || !Activator.getDefault().isListenerActive() || !DocShare.this.isSharing()) {
                return;
            }
            if (!Activator.getDefault().isListenerActive()) {
                return;
            }
            Trace.trace((String)"org.eclipse.ecf.internal.provisional.docshare", (String)NLS.bind((String)"{0}.documentChanged[{1}]", (Object)((Object)DocShare.this), (Object)event));
            IModelChangeMessage[] changeMessages = DocShare.this.syncStrategy.registerLocalChange((IModelChange)new DocumentChangeMessage(event.getOffset(), event.getLength(), event.getText()));
            int i = 0;
            while (i < changeMessages.length) {
                try {
                    DocShare.this.sendMessage(DocShare.this.getOtherID(), changeMessages[i].serialize());
                }
                catch (Exception e) {
                    DocShare.this.logError(Messages.DocShare_EXCEPTION_SEND_MESSAGE, e);
                }
                ++i;
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public DocShare(IChannelContainerAdapter adapter) throws ECFException {
        super(adapter);
        this.factory = Activator.getDefault().getColaSynchronizationStrategyFactory();
    }

    public void startShare(final ID our, String fromName, final ID toID, final String fileName, final ITextEditor editorPart) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.docshare.DocShare");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.entering((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/entering", clazz, (String)"startShare", (Object[])new Object[]{our, fromName, toID, fileName, editorPart});
        Assert.isNotNull((Object)our);
        final String fName = fromName == null ? our.getName() : fromName;
        Assert.isNotNull((Object)toID);
        Assert.isNotNull((Object)fName);
        Assert.isNotNull((Object)editorPart);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    DocShare.this.syncStrategy = DocShare.this.createSynchronizationStrategy(true);
                    Assert.isNotNull((Object)DocShare.this.syncStrategy);
                    String content = editorPart.getDocumentProvider().getDocument((Object)editorPart.getEditorInput()).get();
                    DocShare.this.sendMessage(toID, new StartMessage(our, fName, toID, content, fileName).serialize());
                    DocShare.this.localStartShare(DocShare.this.getLocalRosterManager(), our, our, toID, editorPart);
                }
                catch (Exception e) {
                    DocShare.this.logError(Messages.DocShare_ERROR_STARTING_EDITOR_TITLE, e);
                    DocShare.this.showErrorToUser(Messages.DocShare_ERROR_STARTING_EDITOR_TITLE, NLS.bind((String)Messages.DocShare_ERROR_STARTING_EDITOR_MESSAGE, (Object)e.getLocalizedMessage()));
                }
            }
        });
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ecf.docshare.DocShare");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Trace.exiting((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/entering", (Class)clazz2, (String)"startShare");
    }

    public void stopShare() {
        Trace.entering((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/entering", ((Object)((Object)this)).getClass(), (String)"stopShare");
        if (this.isSharing()) {
            this.sendStopMessage();
            this.syncStrategy = null;
        }
        this.localStopShare();
        Trace.exiting((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/exiting", ((Object)((Object)this)).getClass(), (String)"stopShare");
    }

    protected void handleMessage(ID fromContainerID, byte[] data) {
        block5: {
            try {
                IModelChangeMessage message = Message.deserialize(data);
                Assert.isNotNull((Object)message);
                if (message instanceof DocumentChangeMessage) {
                    this.handleUpdateMessage((DocumentChangeMessage)message);
                    break block5;
                }
                if (message instanceof StartMessage) {
                    this.handleStartMessage((StartMessage)message);
                    break block5;
                }
                if (message instanceof StopMessage) {
                    this.handleStopMessage((StopMessage)message);
                    break block5;
                }
                throw new InvalidObjectException(NLS.bind((String)Messages.DocShare_EXCEPTION_INVALID_MESSAGE, (Object)message.getClass().getName()));
            }
            catch (Exception e) {
                this.logError(Messages.DocShare_EXCEPTION_HANDLE_MESSAGE, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleStartMessage(StartMessage message) throws IDCreateException {
        final ID senderID = message.getSenderID();
        Assert.isNotNull((Object)senderID);
        final String senderUsername = message.getSenderUsername();
        Assert.isNotNull((Object)senderUsername);
        final ID our = message.getReceiverID();
        Assert.isNotNull((Object)our);
        final String filename = message.getFilename();
        Assert.isNotNull((Object)filename);
        String documentContent = message.getDocumentContent();
        Assert.isNotNull((Object)documentContent);
        this.syncStrategy = this.createSynchronizationStrategy(false);
        Assert.isNotNull((Object)this.syncStrategy);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isSharing() || this.startContent != null) {
                this.sendStopMessage(senderID);
                return;
            }
            this.startContent = documentContent;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (DocShare.this.openReceiverDialog(senderID, senderUsername, filename)) {
                        DocShareEditorInput dsei = new DocShareEditorInput(DocShare.this.getTempFileStore(senderUsername, filename, DocShare.this.startContent), senderUsername, filename);
                        ITextEditor ep = (ITextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)dsei, DocShare.this.getEditorIdForFileName(filename));
                        DocShare.this.localStartShare(DocShare.this.getLocalRosterManager(), our, senderID, our, ep);
                    } else {
                        DocShare.this.sendStopMessage();
                        DocShare.this.localStopShare();
                    }
                }
                catch (Exception e) {
                    DocShare.this.logError(Messages.DocShare_EXCEPTION_RECEIVING_MESSAGE_TITLE, e);
                    DocShare.this.showErrorToUser(Messages.DocShare_EXCEPTION_RECEIVING_MESSAGE_TITLE, NLS.bind((String)Messages.DocShare_EXCEPTION_RECEIVING_MESSAGE_MESSAGE, (Object)e.getLocalizedMessage()));
                }
            }
        });
    }

    IRosterManager getLocalRosterManager() {
        IContainer container;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ecf.core.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((container = (IContainer)this.adapter.getAdapter((Class)clazz)) != null) {
            IPresenceContainerAdapter presenceContainerAdapter;
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.eclipse.ecf.presence.IPresenceContainerAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((presenceContainerAdapter = (IPresenceContainerAdapter)container.getAdapter((Class)clazz2)) != null) {
                return presenceContainerAdapter.getRosterManager();
            }
        }
        return null;
    }

    void modifyStartContent(int offset, int length, String text) {
        StringBuffer result = new StringBuffer(this.startContent.substring(0, offset));
        result.append(text);
        result.append(this.startContent.substring(offset + length));
        this.startContent = result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleUpdateMessage(final DocumentChangeMessage documentChangeMessage) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.startContent != null) {
                this.modifyStartContent(documentChangeMessage.getOffset(), documentChangeMessage.getLengthOfReplacedText(), documentChangeMessage.getText());
                return;
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {
                        Trace.entering((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/entering", this.getClass(), (String)"handleUpdateMessage", (Object)documentChangeMessage);
                        IDocument document = DocShare.this.getDocumentFromEditor();
                        if (document != null) {
                            Trace.trace((String)"org.eclipse.ecf.internal.provisional.docshare", (String)NLS.bind((String)"{0}.handleUpdateMessage calling transformIncomingMessage", (Object)((Object)DocShare.this)));
                            IModelChange[] modelChanges = DocShare.this.syncStrategy.transformRemoteChange((IModelChange)documentChangeMessage);
                            DocShare.this.setEditorToRefuseInput();
                            int i = 0;
                            while (i < modelChanges.length) {
                                modelChanges[i].applyToModel((Object)document);
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        DocShare.this.logError(Messages.DocShare_EXCEPTION_RECEIVING_MESSAGE_TITLE, e);
                        DocShare.this.showErrorToUser(Messages.DocShare_EXCEPTION_RECEIVING_MESSAGE_TITLE, NLS.bind((String)Messages.DocShare_EXCEPTION_RECEIVING_MESSAGE_MESSAGE, (Object)e.getLocalizedMessage()));
                    }
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    DocShare.this.setEditorToAcceptInput();
                    Trace.exiting((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/exiting", this.getClass(), (String)"handleUpdateMessage");
                    throw throwable;
                }
                {
                    Object var4_7 = null;
                    DocShare.this.setEditorToAcceptInput();
                }
                Trace.exiting((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/methods/exiting", this.getClass(), (String)"handleUpdateMessage");
            }
        });
    }

    protected void handleStopMessage(StopMessage message) {
        if (this.isSharing()) {
            Shell s = this.editor.getSite().getShell();
            this.localStopShare();
            this.syncStrategy = null;
            this.showStopShareMessage(s, Messages.DocShare_REMOTE_USER_STOPPED);
        }
    }

    void setEditorToRefuseInput() {
        this.setEditorEditable(false);
        Activator.getDefault().setListenerActive(false);
    }

    void setEditorToAcceptInput() {
        this.setEditorEditable(true);
        Activator.getDefault().setListenerActive(true);
    }

    ITextEditor getEditor() {
        return this.editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IEditorInput getEditorInput() {
        Object object = this.stateLock;
        synchronized (object) {
            block4: {
                if (this.editor != null) break block4;
                return null;
            }
            return this.editor.getEditorInput();
        }
    }

    boolean openReceiverDialog(ID fromID, String fromUsername, String fileName) {
        return MessageDialog.openQuestion(null, (String)Messages.DocShare_EDITOR_SHARE_POPUP_TITLE, (String)NLS.bind((String)Messages.DocShare_EDITOR_SHARE_POPUP_MESSAGE, (Object)fromUsername, (Object)fileName));
    }

    protected void handleDisconnectEvent(IChannelDisconnectEvent cde) {
        boolean weDisconnected = this.ourID != null && this.ourID.equals((Object)cde.getTargetID());
        Shell shell = null;
        if (this.isSharing()) {
            shell = this.editor.getSite().getShell();
        }
        this.localStopShare();
        if (shell != null) {
            if (weDisconnected) {
                this.showStopShareMessage(shell, Messages.DocShare_STOP_SHARED_EDITOR_US);
            } else {
                this.showStopShareMessage(shell, Messages.DocShare_STOP_SHARED_EDITOR_REMOTE);
            }
        }
    }

    void showStopShareMessage(final Shell shell, final String message) {
        Display display = shell.getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)shell, (String)Messages.DocShare_STOP_SHARED_EDITOR_TITLE, (String)message);
            }
        });
    }

    IFileStore getTempFileStore(String fromUsername, String fileName, String content) throws IOException, CoreException {
        IFileStore fileStore = EFS.getLocalFileSystem().fromLocalFile(File.createTempFile(fromUsername, fileName));
        OutputStream outs = fileStore.openOutputStream(2, null);
        outs.write(content.getBytes());
        outs.close();
        return fileStore;
    }

    public synchronized void dispose() {
        this.localStopShare();
        super.dispose();
    }

    void logError(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    void showErrorToUser(String title, String message) {
        MessageDialog.openError(null, (String)title, (String)message);
    }

    void logError(String exceptionString, Throwable e) {
        Trace.catching((String)"org.eclipse.ecf.internal.provisional.docshare", (String)"org.eclipse.ecf.internal.provisional.docshare/debug/exceptions/catching", ((Object)((Object)this)).getClass(), (String)exceptionString, (Throwable)e);
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.internal.provisional.docshare", 4, exceptionString, e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StyledText getTextControl() {
        Object object = this.stateLock;
        synchronized (object) {
            block7: {
                if (this.editor != null) break block7;
                return null;
            }
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.swt.widgets.Control");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (StyledText)this.editor.getAdapter((Class)clazz);
        }
    }

    void setEditorEditable(final boolean editable) {
        final StyledText textControl = this.getTextControl();
        if (textControl != null && !textControl.isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    textControl.setEditable(editable);
                }
            });
        }
    }

    String getEditorIdForFileName(String fileName) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IEditorRegistry er = wb.getEditorRegistry();
        IEditorDescriptor desc = er.getDefaultEditor(fileName);
        if (desc != null) {
            return desc.getId();
        }
        return "org.eclipse.ui.DefaultTextEditor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IDocument getDocumentFromEditor() {
        Object object = this.stateLock;
        synchronized (object) {
            IDocumentProvider documentProvider;
            ITextEditor textEditor;
            block6: {
                block5: {
                    textEditor = this.getTextEditor();
                    if (textEditor != null) break block5;
                    return null;
                }
                documentProvider = textEditor.getDocumentProvider();
                if (documentProvider != null) break block6;
                return null;
            }
            return documentProvider.getDocument((Object)textEditor.getEditorInput());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void localStartShare(IRosterManager rm, ID our, ID initiator, ID receiver, ITextEditor edt) {
        Object object = this.stateLock;
        synchronized (object) {
            this.localStopShare();
            this.rosterManager = rm;
            if (this.rosterManager != null) {
                this.rosterManager.addRosterListener(this.rosterListener);
            }
            this.ourID = our;
            this.initiatorID = initiator;
            this.receiverID = receiver;
            this.editor = edt;
            this.editor.getSite().getPage().addPartListener(this.partListener);
            IDocument doc = this.getDocumentFromEditor();
            if (doc != null) {
                doc.addDocumentListener(this.documentListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void localStopShare() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.rosterManager != null) {
                this.rosterManager.removeRosterListener(this.rosterListener);
            }
            this.rosterManager = null;
            this.ourID = null;
            this.initiatorID = null;
            this.receiverID = null;
            this.startContent = null;
            IDocument doc = this.getDocumentFromEditor();
            if (doc != null) {
                doc.removeDocumentListener(this.documentListener);
            }
            if (this.editor != null) {
                this.editor.getSite().getPage().removePartListener(this.partListener);
            }
            this.editor = null;
        }
    }

    void sendStopMessage() {
        this.sendStopMessage(this.getOtherID());
    }

    void sendStopMessage(ID other) {
        if (this.isSharing()) {
            try {
                super.sendMessage(other, new StopMessage().serialize());
            }
            catch (Exception e) {
                this.logError(Messages.DocShare_EXCEPTION_SEND_MESSAGE, e);
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("DocShare[");
        buf.append("ourID=").append(this.ourID).append(";initiatorID=").append(this.initiatorID).append(";receiverID=").append(this.receiverID);
        buf.append(";strategy=").append(this.syncStrategy).append("]");
        return buf.toString();
    }

    IModelSynchronizationStrategy createSynchronizationStrategy(boolean isInitiator) {
        Assert.isNotNull((Object)this.factory);
        return this.factory.createDocumentSynchronizationStrategy(this.getChannel().getID(), isInitiator);
    }

    public ID getInitiatorID() {
        return this.initiatorID;
    }

    public ID getReceiverID() {
        return this.receiverID;
    }

    public ID getOurID() {
        return this.ourID;
    }

    public ITextEditor getTextEditor() {
        return this.editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSharing() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.editor != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ID getOtherID() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isInitiator()) {
                return this.receiverID;
            }
            return this.initiatorID;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitiator() {
        Object object = this.stateLock;
        synchronized (object) {
            block4: {
                if (this.ourID != null && this.initiatorID != null && this.receiverID != null) break block4;
                return false;
            }
            return this.ourID.equals((Object)this.initiatorID);
        }
    }
}

