/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.clients.applications;

import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.example.clients.IMessageReceiver;
import org.eclipse.ecf.example.clients.XMPPChatRoomClient;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessage;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageEvent;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageSender;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class ChatRoomRobotApplication
implements IApplication,
IMessageReceiver,
IIMMessageListener {
    private IChatRoomMessageSender sender;
    private boolean running = false;
    private String userName;

    public Object start(IApplicationContext context) throws Exception {
        Object[] args = context.getArguments().values().toArray();
        while (args[0] instanceof Object[]) {
            args = (Object[])args[0];
        }
        Object[] arguments = args;
        int l = arguments.length;
        if (arguments[l - 1] instanceof String && arguments[l - 2] instanceof String && arguments[l - 3] instanceof String && arguments[l - 4] instanceof String) {
            this.userName = (String)arguments[l - 4];
            String hostName = (String)arguments[l - 3];
            String password = (String)arguments[l - 2];
            String roomName = (String)arguments[l - 1];
            this.runRobot(hostName, password, roomName);
            return new Integer(0);
        }
        System.out.println("Usage: pass in four arguments (username, hostname, password, roomname)");
        return new Integer(-1);
    }

    public void stop() {
    }

    private synchronized void runRobot(String hostName, String password, String roomName) throws ECFException, Exception, InterruptedException {
        XMPPChatRoomClient client = new XMPPChatRoomClient(this);
        String connectTarget = String.valueOf(this.userName) + "@" + hostName;
        client.connect(connectTarget, password);
        IChatRoomContainer room = client.createChatRoom(roomName);
        room.connect(client.getChatRoomInfo().getRoomID(), null);
        client.createSharedObject();
        System.out.println("ECF chat room robot (" + connectTarget + ").  Connected to room: " + client.getChatRoomInfo().getRoomID().getName());
        room.addMessageListener((IIMMessageListener)this);
        this.sender = room.getChatRoomMessageSender();
        this.running = true;
        this.sender.sendMessage("Hi, I'm a robot. To get rid of me, send me a direct message.");
        while (this.running) {
            this.wait();
        }
    }

    public synchronized void handleMessage(IChatMessage chatMessage) {
        try {
            this.sender.sendMessage("gotta run");
        }
        catch (ECFException e) {
            e.printStackTrace();
        }
        this.running = false;
        this.notifyAll();
    }

    public void handleChatRoomMessage(ID fromID, String messageBody) {
        if (fromID.getName().startsWith(String.valueOf(this.userName) + "@")) {
            return;
        }
        try {
            if (messageBody.indexOf("e") != -1) {
                this.sender.sendMessage("kewl");
            } else if (messageBody.indexOf("s") != -1) {
                this.sender.sendMessage(";-)");
            } else {
                this.sender.sendMessage("'s up?");
            }
        }
        catch (ECFException e) {
            e.printStackTrace();
        }
    }

    public void handleMessageEvent(IIMMessageEvent messageEvent) {
        if (messageEvent instanceof IChatRoomMessageEvent) {
            IChatRoomMessage m = ((IChatRoomMessageEvent)messageEvent).getChatRoomMessage();
            this.handleChatRoomMessage(m.getFromID(), m.getMessage());
        }
    }
}

