/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.share;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ReplicaSharedObjectDescription;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.example.collab.share.GenericSharedObject;
import org.eclipse.ecf.example.collab.share.RosterListener;
import org.eclipse.ecf.example.collab.share.SharedObjectEventListener;
import org.eclipse.ecf.example.collab.share.SharedObjectMsg;
import org.eclipse.ecf.example.collab.share.io.EclipseFileTransfer;
import org.eclipse.ecf.example.collab.share.io.FileTransferParams;
import org.eclipse.ecf.internal.example.collab.ClientPlugin;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ecf.internal.example.collab.presence.PresenceContainer;
import org.eclipse.ecf.internal.example.collab.ui.ChatLine;
import org.eclipse.ecf.internal.example.collab.ui.EditorHelper;
import org.eclipse.ecf.internal.example.collab.ui.FileReceiverUI;
import org.eclipse.ecf.internal.example.collab.ui.LineChatClientView;
import org.eclipse.ecf.internal.example.collab.ui.LineChatView;
import org.eclipse.ecf.internal.example.collab.ui.hyperlink.EclipseCollabHyperlinkDetector;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.Presence;
import org.eclipse.ecf.presence.im.ChatMessage;
import org.eclipse.ecf.presence.im.ChatMessageEvent;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.ecf.presence.im.IChatMessageEvent;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.ecf.presence.im.ITypingMessageSender;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.IRosterListener;
import org.eclipse.ecf.presence.roster.Roster;
import org.eclipse.ecf.presence.roster.RosterEntry;
import org.eclipse.ecf.presence.ui.MessagesView;
import org.eclipse.ecf.ui.screencapture.ImageWrapper;
import org.eclipse.ecf.ui.screencapture.ScreenCaptureUtil;
import org.eclipse.ecf.ui.screencapture.ShowImageShell;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class EclipseCollabSharedObject
extends GenericSharedObject {
    private static final int MAX_MESSAGE_SIZE = 8096;
    private static final String HANDLE_SHOW_VIEW_MSG = "handleShowView";
    private static final String HANDLE_SHOW_VIEW_WITH_ID_MSG = "handleShowViewWithID";
    private static final String HANDLE_LAUNCH_EDITOR_FOR_FILE_MSG = "handleLaunchEditorForFile";
    private static final String HANDLE_OPEN_AND_SELECT_FOR_FILE_MSG = "handleOpenAndSelectForFile";
    private static final String HANDLE_ADD_MARKER_FOR_FILE_MSG = "handleAddMarkerForFile";
    private static final String HANDLE_USER_UPDATE_MSG = "handleUserUpdate";
    private static final String HANDLE_UNREGISTER_PROXY_MSG = "handleUnregisterProxy";
    private static final String HANDLE_SHOW_TEXT_MSG = "handleShowTextMsg";
    private static final String HANDLE_USER_MSG = "handleUserMessage";
    private static final String HANDLE_REQUEST_USER_UPDATE_MSG = "handleRequestUserUpdate";
    private static final String HANDLE_REGISTER_PROXY_MSG = "handleRegisterProxy";
    private static final String HANDLE_SHOW_PRIVATE_TEXT_MSG = "handleShowPrivateTextMsg";
    private static final String HANDLE_NOTIFY_USER_ADDED_MSG = "handleNotifyUserAdded";
    private static final String HANDLE_STARTED_TYPING_MSG = "handleStartedTyping";
    public static final String SHARED_MARKER_TYPE = "org.eclipse.ecf.example.collab.sharedmarker";
    public static final String ID = "chat";
    private static final String DEFAULT_WINDOW_TITLE = Messages.EclipseCollabSharedObject_WINDOW_TITLE;
    private static final String HANDLE_SHOW_IMAGE_START_MSG = "handleShowImageStart";
    private static final String HANDLE_SHOW_IMAGE_DATA_MSG = "handleShowImageData";
    private String windowTitle = DEFAULT_WINDOW_TITLE;
    private String downloadDirectory = "";
    private LineChatClientView localGUI = null;
    private IResource localResource = null;
    private IUser localUser = null;
    private String localVersion = "";
    private ID serverID = null;
    private ID containerID;
    private SharedObjectEventListener sharedObjectEventListener = null;
    private PresenceContainer presenceContainer;
    Map shells = new HashMap();
    static /* synthetic */ Class class$0;

    public EclipseCollabSharedObject() {
    }

    public EclipseCollabSharedObject(IContainer container, IResource proj, IUser user, String downloaddir) {
        this.localResource = proj;
        this.localUser = user;
        this.downloadDirectory = downloaddir;
        this.containerID = container.getID();
        this.presenceContainer = new PresenceContainer(this, container, this.localUser);
        this.presenceContainer.addMessageListener(new IIMMessageListener(){

            public void handleMessageEvent(IIMMessageEvent messageEvent) {
                if (messageEvent instanceof IChatMessageEvent) {
                    EclipseCollabSharedObject.this.handleChatMessageEvent((IChatMessageEvent)messageEvent);
                }
            }
        });
        this.createOutputView();
        Assert.isNotNull((Object)this.localGUI, (String)"Local GUI cannot be created...exiting");
    }

    public ID getContainerID() {
        return this.containerID;
    }

    void handleChatMessageEvent(final IChatMessageEvent event) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                EclipseCollabSharedObject.this.appendMessage(EclipseCollabSharedObject.this.presenceContainer.getChatMessageSender(), EclipseCollabSharedObject.this.presenceContainer.getTypingMessageSender(), event.getChatMessage());
            }
        });
    }

    public MessagesView findMessagesView() {
        IWorkbenchPage page;
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            MessagesView view;
            page = windows[i].getActivePage();
            if (page != null && (view = (MessagesView)page.findView("org.eclipse.ecf.presence.ui.MessagesView")) != null) {
                return view;
            }
            ++i;
        }
        i = 0;
        while (i < windows.length) {
            page = windows[i].getActivePage();
            if (page != null) {
                try {
                    return (MessagesView)page.showView("org.eclipse.ecf.presence.ui.MessagesView");
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return null;
    }

    void appendMessage(IChatMessageSender chatMessageSender, ITypingMessageSender typingMessageSender, IChatMessage message) {
        MessagesView view;
        IWorkbenchPage page;
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            page = windows[i].getActivePage();
            if (page != null && (view = (MessagesView)page.findView("org.eclipse.ecf.presence.ui.MessagesView")) != null) {
                view.openTab(chatMessageSender, typingMessageSender, this.containerID, message.getFromID());
                view.showMessage(message);
                if (!page.isPartVisible((IWorkbenchPart)view)) {
                    IWorkbenchSiteProgressService service;
                    IWorkbenchPartSite iWorkbenchPartSite = view.getSite();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((service = (IWorkbenchSiteProgressService)iWorkbenchPartSite.getService((Class)clazz)) != null) {
                        service.warnOfContentChange();
                    }
                }
                return;
            }
            ++i;
        }
        i = 0;
        while (i < windows.length) {
            page = windows[i].getActivePage();
            if (page != null) {
                try {
                    view = (MessagesView)page.showView("org.eclipse.ecf.presence.ui.MessagesView");
                    view.openTab(chatMessageSender, typingMessageSender, this.containerID, message.getFromID());
                    view.showMessage(message);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                break;
            }
            ++i;
        }
    }

    public IPresenceContainerAdapter getPresenceContainer() {
        return this.presenceContainer;
    }

    public void activated(ID[] others) {
        super.activated(others);
        if (this.localGUI == null && !this.getContext().isGroupManager()) {
            this.destroySelfLocal();
        }
    }

    public void chatException(Exception e, String text) {
        this.log(text, e);
    }

    public void chatGUIDestroy() {
        if (this.sharedObjectEventListener != null) {
            this.sharedObjectEventListener.windowClosing();
            this.sharedObjectEventListener = null;
        }
        this.destroySelf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivated() {
        super.deactivated();
        EclipseCollabSharedObject eclipseCollabSharedObject = this;
        synchronized (eclipseCollabSharedObject) {
            if (this.localGUI != null) {
                this.localGUI.disposeClient();
                this.localGUI = null;
            }
        }
        this.shells.clear();
        if (this.sharedObjectEventListener != null) {
            this.sharedObjectEventListener = null;
        }
        if (this.localResource != null) {
            this.localResource = null;
        }
    }

    public void destroySelf() {
        this.presenceContainer.unregister();
        try {
            if (this.isHost()) {
                this.disconnect();
            }
        }
        catch (Exception e) {
            this.log("Exception in destroySelf", e);
        }
        super.destroySelfLocal();
    }

    public String getDownloadDirectory(String dir) {
        return this.downloadDirectory;
    }

    public SharedObjectEventListener getSharedObjectEventListener() {
        return this.sharedObjectEventListener;
    }

    public String getLocalFullProjectPath() {
        String eclipseDir = null;
        try {
            eclipseDir = Platform.getLocation().toOSString();
        }
        catch (IllegalStateException e) {
            this.log("Exception getting local resource path", e);
        }
        if (eclipseDir == null) {
            eclipseDir = ".";
        }
        String projectDir = this.getResource() == null ? this.downloadDirectory : this.getResource().getFullPath().toOSString();
        return new File(eclipseDir, projectDir).getAbsolutePath();
    }

    public String getLocalFullDownloadPath() {
        return new File(this.getLocalFullProjectPath(), this.downloadDirectory).getAbsolutePath();
    }

    protected void createOutputView() {
        final String projectName = this.localResource == null || this.localResource.getName().trim().equals("") ? Messages.EclipseCollabSharedObject_WORKSPACE_RESOURCE_NAME : this.localResource.getName();
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage wp = ww.getActivePage();
                    wp.showView("org.eclipse.ecf.internal.example.collab.ui.LineChatView");
                    EclipseCollabSharedObject.this.windowTitle = NLS.bind((String)Messages.EclipseCollabSharedObject_TITLE_BAR, (Object)EclipseCollabSharedObject.this.localUser.getNickname());
                    LineChatView.setViewName(EclipseCollabSharedObject.this.windowTitle);
                    EclipseCollabSharedObject.this.localGUI = LineChatView.createClientView(EclipseCollabSharedObject.this, projectName, NLS.bind((String)Messages.EclipseCollabSharedObject_PROJECT_NAME, (Object)projectName), EclipseCollabSharedObject.this.getLocalFullDownloadPath());
                    EclipseCollabSharedObject.this.presenceContainer.getRosterManager().addRosterListener((IRosterListener)new RosterListener(EclipseCollabSharedObject.this, EclipseCollabSharedObject.this.localGUI));
                }
                catch (Exception e) {
                    EclipseCollabSharedObject.this.log("Exception creating LineChatView", e);
                }
            }
        });
    }

    public IResource getResource() {
        return this.localResource;
    }

    protected ReplicaSharedObjectDescription getReplicaDescription(ID remoteID) {
        return null;
    }

    public ID getServerID() {
        return this.serverID;
    }

    public String getTreeTopLabel() {
        return Messages.EclipseCollabSharedObject_TREE_TOP_LABEL;
    }

    public IUser getUser() {
        return this.localUser;
    }

    public IUser getUserForID(ID user) {
        return this.localGUI != null ? this.localGUI.getUser(user) : null;
    }

    public String getUserName() {
        return this.localUser.getNickname();
    }

    public String getVersionString() {
        return this.localVersion;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    protected void handleCreateObject(ReplicaSharedObjectDescription cons) {
        try {
            this.createObject(null, cons);
        }
        catch (Exception e) {
            this.log("Exception creating local object", e);
        }
    }

    public void handleNotifyUserAdded(IUser user) {
        boolean add = false;
        try {
            ID[] members = this.getContext().getGroupMemberIDs();
            int i = 0;
            while (i < members.length) {
                if (members[i].equals((Object)user.getID())) {
                    add = true;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.log("Exception checking for membership", e);
        }
        if (add) {
            Roster roster = (Roster)this.presenceContainer.getRosterManager().getRoster();
            boolean contains = false;
            Iterator it = roster.getItems().iterator();
            while (it.hasNext()) {
                IRosterEntry entry = (IRosterEntry)it.next();
                if (!entry.getUser().getID().equals((Object)user.getID())) continue;
                contains = true;
                break;
            }
            if (!contains) {
                roster.addItem((IRosterItem)new RosterEntry((IRosterItem)roster, user, (IPresence)new Presence()));
            }
        }
    }

    protected void handleRequestUserUpdate(ID requestor) {
        this.sendUserUpdate(requestor);
    }

    protected void handleShowPrivateTextMsg(IUser remote, String aString) {
        ChatMessageEvent messageEvent = new ChatMessageEvent(remote.getID(), (IChatMessage)new ChatMessage(remote.getID(), aString));
        this.presenceContainer.fireMessageEvent((IIMMessageEvent)messageEvent);
    }

    protected void handleShowTextMsg(ID remote, String aString) {
        this.showLineOnGUI(remote, aString);
    }

    protected void handleUserUpdate(final IUser ud) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (EclipseCollabSharedObject.this.localGUI != null) {
                        EclipseCollabSharedObject.this.localGUI.changeUser(ud);
                    }
                }
                catch (Exception e) {
                    EclipseCollabSharedObject.this.log("Exception in showLineOnGUI", e);
                }
            }
        });
    }

    protected void handleUserMessage(final IUser sender, String msg) {
        final String message = msg;
        if (sender == null) {
            return;
        }
        if (this.localGUI != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    Display.getDefault().beep();
                    Shell[] shells = Display.getDefault().getShells();
                    if (shells != null && shells.length > 0) {
                        shells[0].setActive();
                    }
                    MessageDialog.openInformation(null, (String)NLS.bind((String)Messages.EclipseCollabSharedObject_PRIVATE_MESSAGE_TEXT, (Object)sender.getNickname()), (String)message);
                }
            });
        }
    }

    protected synchronized void handleStartedTyping(IUser user) {
        if (this.localGUI != null) {
            this.localGUI.startedTyping(user);
        }
    }

    public void sendStartedTyping() {
        try {
            this.forwardMsgTo(null, SharedObjectMsg.createMsg(null, HANDLE_STARTED_TYPING_MSG, this.localUser));
        }
        catch (Exception e) {
            this.log("Exception on sendStartedTyping to remote clients", e);
        }
    }

    public void inputText(String aString) {
        this.sendShowTextMsg(aString);
    }

    public void disconnect() {
        this.getContext().disconnect();
    }

    public Object getObject(ID obj) {
        return this.getContext().getSharedObjectManager().getSharedObject(obj);
    }

    public void memberAdded(ID member) {
        if (this.sharedObjectEventListener != null) {
            this.sharedObjectEventListener.memberAdded(member);
        }
        super.memberAdded(member);
        this.sendNotifyUserAdded();
    }

    public void memberRemoved(ID member) {
        if (this.sharedObjectEventListener != null) {
            this.sharedObjectEventListener.memberRemoved(member);
        }
        super.memberRemoved(member);
        Roster roster = (Roster)this.presenceContainer.getRosterManager().getRoster();
        IRosterEntry itemToRemove = null;
        Iterator it = roster.getItems().iterator();
        while (it.hasNext()) {
            IRosterEntry entry = (IRosterEntry)it.next();
            if (!entry.getUser().getID().equals((Object)member)) continue;
            itemToRemove = entry;
            break;
        }
        if (itemToRemove != null) {
            roster.removeItem(itemToRemove);
        }
    }

    public void messageProxyObject(ID target, String classname, String meth, Object[] args) {
        SharedObjectMsg m = SharedObjectMsg.createMsg(null, classname, meth, args);
        try {
            this.forwardMsgTo(target, m);
            if (target == null) {
                this.sendSelf(m);
            }
        }
        catch (Exception e) {
            this.log("Exception sending message to proxy object", e);
        }
    }

    public void otherActivated(ID object) {
        if (this.sharedObjectEventListener != null) {
            this.sharedObjectEventListener.otherActivated(object);
        }
        super.otherActivated(object);
    }

    public void otherDeactivated(ID object) {
        if (this.sharedObjectEventListener != null) {
            this.sharedObjectEventListener.otherDeactivated(object);
        }
        super.otherDeactivated(object);
    }

    public void refreshProject() {
        if (this.localResource != null) {
            try {
                this.localResource.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                this.log("Exception refreshing resource " + this.localResource.getName(), e);
            }
        }
    }

    public void sendNotifyUserAdded() {
        try {
            this.forwardMsgTo(null, SharedObjectMsg.createMsg(null, HANDLE_NOTIFY_USER_ADDED_MSG, this.localUser));
        }
        catch (Exception e) {
            this.log("Exception on sendNotifyUserAdded to remote clients", e);
        }
    }

    public void sendPrivateMessageToUser(ID toId, String msg) {
        try {
            this.forwardMsgTo(toId, SharedObjectMsg.createMsg(null, HANDLE_SHOW_PRIVATE_TEXT_MSG, this.localUser, msg));
        }
        catch (Exception e) {
            this.log("Exception on sendShowPrivateTextMsg to remote clients", e);
        }
    }

    public void sendPrivateMessageToUser(IUser touser, String msg) {
        this.sendPrivateMessageToUser(touser.getID(), msg);
    }

    public void sendRegisterProxy(ID toID, String proxyClass, String name) {
        try {
            this.forwardMsgTo(toID, SharedObjectMsg.createMsg(null, HANDLE_REGISTER_PROXY_MSG, this.localUser, proxyClass, name));
        }
        catch (IOException e) {
            this.log("Exception sendRegisterProxy", e);
        }
    }

    public void sendRequestUserUpdate(ID requestTarget) {
        try {
            this.forwardMsgTo(requestTarget, SharedObjectMsg.createMsg(null, HANDLE_REQUEST_USER_UPDATE_MSG, this.localContainerID));
        }
        catch (Exception e) {
            this.log("Exception on sendRequestUserUpdate to remote clients", e);
        }
    }

    public void sendRingMessageToUser(IUser user, String msg) {
        ID receiver = null;
        if (user != null) {
            receiver = user.getID();
        }
        try {
            SharedObjectMsg m = SharedObjectMsg.createMsg(null, HANDLE_USER_MSG, this.localUser, msg);
            this.forwardMsgTo(receiver, m);
            if (receiver == null) {
                this.sendSelf(m);
            }
        }
        catch (Exception e) {
            this.log("Exception on sendMessageToUser to " + user, e);
        }
    }

    public void sendImage(ID toID, ImageData imageData) {
        try {
            this.forwardMsgTo(toID, SharedObjectMsg.createMsg(null, HANDLE_SHOW_IMAGE_START_MSG, this.localContainerID, this.localUser.getNickname(), new ImageWrapper(imageData)));
            byte[] compressedData = ScreenCaptureUtil.compress((byte[])imageData.data);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(8096);
            int startPos = 0;
            while (startPos <= compressedData.length) {
                bos.reset();
                int length = Math.min(compressedData.length - startPos, 8096);
                bos.write(compressedData, startPos, length);
                bos.flush();
                Boolean done = new Boolean(compressedData.length - (startPos += 8096) < 0);
                this.forwardMsgTo(toID, SharedObjectMsg.createMsg(null, HANDLE_SHOW_IMAGE_DATA_MSG, this.localContainerID, bos.toByteArray(), done));
            }
        }
        catch (Exception e) {
            this.log("Exception on sendImage", e);
        }
    }

    protected void handleShowImageStart(final ID id, final String fromUser, final ImageWrapper imageWrapper) {
        final Display display = this.localGUI.getTextControl().getDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                ShowImageShell showImageShell = (ShowImageShell)EclipseCollabSharedObject.this.shells.get(id);
                if (showImageShell == null) {
                    showImageShell = new ShowImageShell(display, id, new DisposeListener(this, id){
                        final /* synthetic */ 6 this$1;
                        private final /* synthetic */ ID val$id;
                        {
                            this.this$1 = var1_1;
                            this.val$id = iD;
                        }

                        public void widgetDisposed(DisposeEvent e) {
                            6.access$0(this.this$1).shells.remove(this.val$id);
                        }
                    });
                    EclipseCollabSharedObject.this.shells.put(id, showImageShell);
                }
                showImageShell.initialize(String.valueOf(Messages.EclipseCollabSharedObject_SCREEN_CAPTURE_FROM) + fromUser, imageWrapper);
                showImageShell.open();
            }

            static /* synthetic */ EclipseCollabSharedObject access$0(6 var0) {
                return var0.EclipseCollabSharedObject.this;
            }
        });
    }

    protected void handleShowImageData(ID id, final byte[] data, final Boolean done) {
        Display display;
        final ShowImageShell showImageShell = (ShowImageShell)this.shells.get(id);
        if (showImageShell != null && (display = showImageShell.getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    showImageShell.addData(data);
                    if (done.booleanValue()) {
                        showImageShell.showImage();
                    }
                }
            });
        }
    }

    public void sendShowTextMsg(String msg) {
        try {
            this.forwardMsgTo(null, SharedObjectMsg.createMsg(null, HANDLE_SHOW_TEXT_MSG, this.localContainerID, msg));
        }
        catch (Exception e) {
            this.log("Exception on sendShowTextMsg to remote clients", e);
        }
    }

    public void sendUnregisterProxy(ID toID, String proxyClass) {
        try {
            this.forwardMsgTo(toID, SharedObjectMsg.createMsg(null, HANDLE_UNREGISTER_PROXY_MSG, this.localUser, proxyClass));
        }
        catch (IOException e) {
            this.log("Exception sendRegisterProxy", e);
        }
    }

    public void sendUserUpdate(ID target) {
        try {
            this.forwardMsgTo(target, SharedObjectMsg.createMsg(null, HANDLE_USER_UPDATE_MSG, this.localUser));
        }
        catch (Exception e) {
            this.log("Exception on sendUserUpdate to remote clients", e);
        }
    }

    public void setListener(SharedObjectEventListener l) {
        this.sharedObjectEventListener = l;
    }

    public void setServerID(ID server) {
        this.serverID = server;
    }

    public void setVersionString(String ver) {
        this.localVersion = ver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowTitle(String title) {
        this.windowTitle = title;
        EclipseCollabSharedObject eclipseCollabSharedObject = this;
        synchronized (eclipseCollabSharedObject) {
            if (this.localGUI != null) {
                this.localGUI.setTitle(this.windowTitle);
            }
        }
    }

    protected void activateView() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (EclipseCollabSharedObject.this.localGUI != null) {
                    IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage wp = ww.getActivePage();
                    wp.activate((IWorkbenchPart)EclipseCollabSharedObject.this.localGUI.getView());
                }
            }
        });
    }

    public void showLineOnGUI(final ID remote, final String line) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (EclipseCollabSharedObject.this.localGUI != null) {
                        EclipseCollabSharedObject.this.localGUI.showLine(new ChatLine(line, EclipseCollabSharedObject.this.getUserForID(remote)));
                    }
                }
                catch (Exception e) {
                    EclipseCollabSharedObject.this.log("Exception in showLineOnGUI", e);
                }
            }
        });
    }

    public void showRawLine(final ID sender, final String line, final Runnable onClick) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (EclipseCollabSharedObject.this.localGUI != null) {
                        ChatLine rawLine = new ChatLine(line, EclipseCollabSharedObject.this.getUserForID(sender), onClick);
                        rawLine.setRaw(true);
                        EclipseCollabSharedObject.this.localGUI.showLine(rawLine);
                    }
                }
                catch (Exception e) {
                    EclipseCollabSharedObject.this.log("Exception in showLineOnGUI", e);
                }
            }
        });
    }

    public void sendAddMarkerForFile(IUser touser, String resourceName, int offset, int length) {
        ID receiver = null;
        if (touser != null) {
            receiver = touser.getID();
        }
        try {
            SharedObjectMsg m = SharedObjectMsg.createMsg(null, HANDLE_ADD_MARKER_FOR_FILE_MSG, this.getUser(), resourceName, new SharedMarker(Messages.EclipseCollabSharedObject_MARKER_NAME, new Integer(offset), new Integer(length)));
            this.forwardMsgTo(receiver, m);
            if (receiver == null) {
                this.sendSelf(m);
            }
        }
        catch (Exception e) {
            this.log("Exception on sendAddMarkerForFile to " + touser, e);
        }
    }

    public void sendOpenAndSelectForFile(IUser touser, String resourceName, int offset, int length) {
        ID receiver = null;
        if (touser != null) {
            receiver = touser.getID();
        }
        try {
            SharedObjectMsg m = SharedObjectMsg.createMsg(null, HANDLE_OPEN_AND_SELECT_FOR_FILE_MSG, this.getUser(), resourceName, new SharedMarker(Messages.EclipseCollabSharedObject_MARKER_NAME, new Integer(offset), new Integer(length)));
            this.forwardMsgTo(receiver, m);
            if (receiver == null) {
                this.sendSelf(m);
            }
        }
        catch (Exception e) {
            this.log("sendOpenAndSelectForFile", e);
        }
    }

    public void sendLaunchEditorForFile(IUser touser, String resourceName) {
        ID receiver = null;
        if (touser != null) {
            receiver = touser.getID();
        }
        try {
            SharedObjectMsg m = SharedObjectMsg.createMsg(null, HANDLE_LAUNCH_EDITOR_FOR_FILE_MSG, this.getUser(), resourceName);
            this.forwardMsgTo(receiver, m);
            if (receiver == null) {
                this.sendSelf(m);
            }
        }
        catch (Exception e) {
            this.log("Exception on sendLaunchEditorForFile to " + touser, e);
        }
    }

    protected Runnable createOpenEditorAndSelectForFileRunnable(final String resourceName, SharedMarker marker) {
        final Integer offset = marker.getOffset();
        final Integer length = marker.getLength();
        return new Runnable(){

            public void run() {
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow ww = wb.getActiveWorkbenchWindow();
                IFile file = EclipseCollabSharedObject.this.getIFileForResource(ww, resourceName);
                if (file != null) {
                    EditorHelper eh = new EditorHelper(ww);
                    try {
                        eh.openAndSelectForFile(file, offset == null ? 0 : offset, length == null ? 0 : length);
                    }
                    catch (Exception e) {
                        EclipseCollabSharedObject.this.log("Exception in openEditorAndSelectForFile", e);
                    }
                }
            }
        };
    }

    protected IFile getIFileForResource(IWorkbenchWindow ww, String resourceName) {
        IFile file = this.getLocalFileForRemote(resourceName);
        if (file == null || !file.exists()) {
            MessageDialog.openInformation((Shell)ww.getShell(), (String)Messages.EclipseCollabSharedObject_CANNOT_OPEN_EDITOR_TITLE, (String)NLS.bind((String)Messages.EclipseCollabSharedObject_CANNOT_OPEN_EDITOR_MESSAGE, (Object)resourceName));
            return null;
        }
        return file;
    }

    protected Runnable createOpenEditorForFileRunnable(final String resourceName) {
        return new Runnable(){

            public void run() {
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow ww = wb.getActiveWorkbenchWindow();
                IFile file = EclipseCollabSharedObject.this.getIFileForResource(ww, resourceName);
                if (file != null) {
                    EditorHelper eh = new EditorHelper(ww);
                    try {
                        eh.openEditorForFile(file);
                    }
                    catch (Exception e) {
                        EclipseCollabSharedObject.this.log("Exception in openEditorAndSelectForFile", e);
                    }
                }
            }
        };
    }

    protected void addMarkerForFile(final IFile file, final SharedMarker marker) {
        if (file == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow ww = wb.getActiveWorkbenchWindow();
                EditorHelper eh = new EditorHelper(ww);
                try {
                    eh.openAndAddMarkerForFile(file, marker);
                }
                catch (Exception e) {
                    EclipseCollabSharedObject.this.log("Exception in addMarkerForFile", e);
                }
            }
        });
    }

    protected void handleAddMarkerForFile(IUser fromuser, String resourceName, SharedMarker marker) {
        this.addMarkerForFile(this.getLocalFileForRemote(resourceName), marker);
    }

    protected void handleOpenAndSelectForFile(IUser fromuser, String resourceName, SharedMarker marker) {
        IUser local = this.getUserForID(fromuser.getID());
        if (local != null) {
            Runnable runnable = this.createOpenEditorAndSelectForFileRunnable(resourceName, marker);
            this.showEventInChatOutput(fromuser, resourceName, marker, runnable);
            this.verifyAndOpenEditorLocally(fromuser, resourceName, runnable);
        }
    }

    protected boolean isLocalUser(IUser fromuser) {
        return fromuser != null && fromuser.getID().equals((Object)this.getUser().getID());
    }

    protected void verifyAndOpenEditorLocally(final IUser fromuser, final String resourceName, final Runnable runnable) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (EclipseCollabSharedObject.this.isLocalUser(fromuser)) {
                    runnable.run();
                } else if (EclipseCollabSharedObject.this.showSharedEditorEventsImmediately() && (!EclipseCollabSharedObject.this.askUserToDisplaySharedEditorEvents() || MessageDialog.openQuestion(null, (String)Messages.EclipseCollabSharedObject_DIALOG_OPEN_SHARED_EDITOR_TEXT, (String)NLS.bind((String)Messages.EclipseCollabSharedObject_OPEN_SHARED_EDITOR_QUESTION, (Object)resourceName, (Object)fromuser.getNickname())))) {
                    runnable.run();
                }
            }
        });
    }

    protected void handleLaunchEditorForFile(IUser fromuser, String resourceName) {
        IUser local = this.getUserForID(fromuser.getID());
        if (local != null) {
            Runnable runnable = this.createOpenEditorForFileRunnable(resourceName);
            this.showEventInChatOutput(fromuser, resourceName, null, runnable);
            this.verifyAndOpenEditorLocally(fromuser, resourceName, runnable);
        }
    }

    protected boolean showSharedEditorEventsImmediately() {
        return ClientPlugin.getDefault().getPreferenceStore().getBoolean("sharedEditorShowEvents");
    }

    protected boolean askUserToDisplaySharedEditorEvents() {
        return ClientPlugin.getDefault().getPreferenceStore().getBoolean("sharedEditorAskReceiver");
    }

    protected void showEventInChatOutput(IUser fromuser, String resourceName, SharedMarker marker, Runnable runnable) {
        if (this.localGUI != null) {
            this.showRawLine(fromuser.getID(), this.createDisplayStringForEditorOpen(resourceName, marker), runnable);
        }
    }

    protected String createDisplayStringForEditorOpen(String resourceName, SharedMarker marker) {
        return EclipseCollabHyperlinkDetector.createDisplayStringForEditorOpen(resourceName, marker);
    }

    protected IFile getLocalFileForRemote(String file) {
        IResource res = this.getResource();
        if (res instanceof IWorkspaceRoot) {
            return ((IWorkspaceRoot)res).getFile((IPath)new Path(file));
        }
        IFile aFile = null;
        IProject proj = res.getProject();
        if (proj == null) {
            IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            aFile = myWorkspaceRoot.getFile((IPath)new Path(file));
        } else {
            aFile = proj.getFile(file);
        }
        return aFile;
    }

    public void sendShowViewWithID(IUser touser, String id, String secID, Integer mode) {
        ID receiver = null;
        if (touser != null) {
            receiver = touser.getID();
        }
        try {
            SharedObjectMsg m = SharedObjectMsg.createMsg(null, HANDLE_SHOW_VIEW_WITH_ID_MSG, this.getUser(), id, secID, mode);
            this.forwardMsgTo(receiver, m);
            if (receiver == null) {
                this.sendSelf(m);
            }
        }
        catch (Exception e) {
            this.log("Exception on handleShowViewWithID to " + touser, e);
        }
    }

    public void sendShowView(IUser touser, String id) {
        ID receiver = null;
        if (touser != null) {
            receiver = touser.getID();
        }
        try {
            SharedObjectMsg m = SharedObjectMsg.createMsg(null, HANDLE_SHOW_VIEW_MSG, this.getUser(), id);
            this.forwardMsgTo(receiver, m);
            if (receiver == null) {
                this.sendSelf(m);
            }
        }
        catch (Exception e) {
            this.log("Exception on sendShowView to " + touser, e);
        }
    }

    protected void handleShowViewWithID(IUser fromUser, final String id, final String secID, final Integer mode) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    EclipseCollabSharedObject.this.showViewWithID(id, secID, mode);
                }
                catch (Exception e) {
                    EclipseCollabSharedObject.this.log("Exception in showing view id=" + id + ";secID=" + secID + ";mode=" + mode, e);
                }
            }
        });
    }

    protected void handleShowView(IUser fromUser, final String id) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    EclipseCollabSharedObject.this.showView(id);
                }
                catch (Exception e) {
                    EclipseCollabSharedObject.this.log("Exception in showing view id=" + id, e);
                }
            }
        });
    }

    protected IViewPart showViewWithID(String id, String secID, int mode) throws PartInitException {
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage wp = ww.getActivePage();
        if (wp == null) {
            throw new PartInitException("workbench page is null");
        }
        return wp.showView(id, secID, mode);
    }

    protected IViewPart showView(String id) throws PartInitException {
        IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage wp = ww.getActivePage();
        if (wp == null) {
            throw new PartInitException("workbench page is null");
        }
        return wp.showView(id);
    }

    public FileReceiverUI getFileReceiverUI(EclipseFileTransfer transfer, FileTransferParams params) {
        return new FileReceiverUI(){

            public void receiveStart(ID from, File aFile, long length, float rate) {
                IUser user = EclipseCollabSharedObject.this.getUserForID(from);
                String nick = Messages.EclipseCollabSharedObject_UNKNOWN_USERNAME;
                if (user != null) {
                    nick = user.getNickname();
                }
                EclipseCollabSharedObject.this.showRawLine(from, NLS.bind((String)Messages.EclipseCollabSharedObject_FILE_TRANSFER_RECEIVING, (Object)nick, (Object)aFile.getName()), null);
            }

            public void receiveData(ID from, File aFile, int dataLength) {
            }

            public void receiveDone(ID from, File aFile, Exception e) {
                IUser user = EclipseCollabSharedObject.this.getUserForID(from);
                String nick = Messages.EclipseCollabSharedObject_UNKNOWN_USERNAME;
                if (user != null) {
                    nick = user.getNickname();
                }
                EclipseCollabSharedObject.this.showRawLine(from, NLS.bind((String)Messages.EclipseCollabSharedObject_FILE_TRANSFER_RECEIVED, (Object[])new Object[]{aFile.getName(), nick, EclipseCollabSharedObject.this.getLocalFullDownloadPath()}), null);
                EclipseCollabSharedObject.this.refreshProject();
            }
        };
    }

    public ViewPart getViewPart() {
        if (this.localGUI == null) {
            return null;
        }
        return this.localGUI.getView();
    }

    public ID createObject(ID target, String classname, Map map) throws Exception {
        return this.createObject(target, new ReplicaSharedObjectDescription(Class.forName(classname), IDFactory.getDefault().createGUID(), this.config.getHomeContainerID(), map));
    }

    public static class SharedMarker
    implements Serializable {
        private static final long serialVersionUID = 7419507867486828728L;
        String message = null;
        Integer offset = null;
        Integer length = null;

        public SharedMarker(String message, Integer offset, Integer length) {
            this.message = message;
            this.offset = offset;
            this.length = length;
        }

        public String getMessage() {
            return this.message;
        }

        public Integer getOffset() {
            return this.offset;
        }

        public Integer getLength() {
            return this.length;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("SharedMarker[");
            buf.append("message=").append(this.message).append(";");
            buf.append("offset=").append(this.offset).append(";");
            buf.append("length=").append(this.length).append("]");
            return buf.toString();
        }
    }
}

