/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.presence.ui.Activator;
import org.eclipse.ecf.internal.presence.ui.Messages;
import org.eclipse.ecf.internal.presence.ui.dialogs.AddContactDialog;
import org.eclipse.ecf.internal.presence.ui.dialogs.ChangePasswordDialog;
import org.eclipse.ecf.internal.presence.ui.dialogs.ChatRoomSelectionDialog;
import org.eclipse.ecf.presence.IAccountManager;
import org.eclipse.ecf.presence.IFQID;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.IPresenceListener;
import org.eclipse.ecf.presence.Presence;
import org.eclipse.ecf.presence.chatroom.IChatRoomInfo;
import org.eclipse.ecf.presence.im.IChatManager;
import org.eclipse.ecf.presence.im.IChatMessageSender;
import org.eclipse.ecf.presence.im.ITypingMessageSender;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterGroup;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.IRosterManager;
import org.eclipse.ecf.presence.roster.IRosterSubscriptionSender;
import org.eclipse.ecf.presence.service.IPresenceService;
import org.eclipse.ecf.presence.ui.IMultiRosterViewPart;
import org.eclipse.ecf.presence.ui.MessagesView;
import org.eclipse.ecf.presence.ui.MultiRosterAccount;
import org.eclipse.ecf.presence.ui.MultiRosterContentProvider;
import org.eclipse.ecf.presence.ui.MultiRosterLabelProvider;
import org.eclipse.ecf.presence.ui.chatroom.ChatRoomManagerView;
import org.eclipse.ecf.presence.ui.chatroom.IChatRoomCommandListener;
import org.eclipse.ecf.presence.ui.chatroom.IChatRoomViewCloseListener;
import org.eclipse.ecf.presence.ui.dnd.IRosterViewerDropTarget;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.ecf.ui.dialogs.ContainerConnectErrorDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ViewPart;

public class MultiRosterView
extends ViewPart
implements IMultiRosterViewPart {
    public static final String VIEW_ID = "org.eclipse.ecf.presence.ui.MultiRosterView";
    protected static final int DEFAULT_EXPAND_LEVEL = 3;
    private static final String ROSTER_VIEWER_DROP_TARGET_EPOINT = "org.eclipse.ecf.presence.ui.rosterViewerDropTarget";
    private static final String ROSTER_VIEWER_DROP_TARGET_CLASS_ATTR = "class";
    private static final Transfer[] dndTransferTypes = new Transfer[]{EditorInputTransfer.getInstance(), FileTransfer.getInstance(), HTMLTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), PluginTransfer.getInstance(), RTFTransfer.getInstance(), TextTransfer.getInstance()};
    private static final int dndOperations = 7;
    protected TreeViewer treeViewer;
    protected List rosterAccounts = new ArrayList();
    private Hashtable chatRooms = new Hashtable();
    private IMenuManager setStatusMenu;
    private IAction imAction;
    private IAction removeAction;
    private IAction setAvailableAction;
    private IAction setAwayAction;
    private IAction setDNDAction;
    private IAction setInvisibleAction;
    private IAction setOfflineAction;
    private IAction showOfflineAction;
    private IAction showEmptyGroupsAction;
    private IAction addContactAction;
    private IAction openChatRoomAction;
    private IAction openAccountChatRoomAction;
    private IAction changePasswordAction;
    private IAction disconnectAllAccountsAction;
    private IAction disconnectAccountAction;
    private IPresenceListener presenceListener;
    private RosterViewerDropAdapter dropAdapter;
    private PageBook pageBook;
    private Label helpMessageLabel;
    private ViewerFilter hideOfflineFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IRosterEntry) {
                IRosterEntry entry = (IRosterEntry)element;
                IPresence presence = entry.getPresence();
                if (presence != null) {
                    return presence.getType() != IPresence.Type.UNAVAILABLE;
                }
                return true;
            }
            return true;
        }
    };
    private ViewerFilter hideEmptyGroupsFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IRosterGroup) {
                return !((IRosterGroup)element).getEntries().isEmpty();
            }
            return true;
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void createPartControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.createHelpMessage((Composite)this.pageBook);
        this.setupTreeViewer((Composite)this.pageBook);
        if (this.rosterAccounts.size() == 0) {
            this.pageBook.showPage((Control)this.helpMessageLabel);
        }
    }

    private void createHelpMessage(Composite parent) {
        if (!parent.isDisposed()) {
            this.helpMessageLabel = new Label(parent, 16576);
            this.helpMessageLabel.setText(Messages.MultiRosterView_HELP_MESSAGE);
        }
    }

    protected void setupTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2564);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.presenceListener = new PresenceListener();
        this.treeViewer.setContentProvider((IContentProvider)new MultiRosterContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new MultiRosterLabelProvider());
        this.treeViewer.addFilter(this.hideOfflineFilter);
        this.treeViewer.addFilter(this.hideEmptyGroupsFilter);
        this.treeViewer.setInput((Object)this.rosterAccounts);
        this.treeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent e) {
                MultiRosterView.this.message((IStructuredSelection)e.getSelection());
            }
        });
        ViewerToolTip toolTip = new ViewerToolTip(this.treeViewer.getControl());
        toolTip.setHideOnMouseDown(false);
        toolTip.setPopupDelay(200);
        toolTip.setShift(new Point(5, 5));
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.hookDropSupport();
        this.retrieveServices();
        this.treeViewer.expandToLevel(3);
    }

    private void hookDropSupport() {
        IExtensionRegistry reg = Activator.getDefault().getExtensionRegistry();
        if (reg != null) {
            IExtensionPoint extensionPoint = reg.getExtensionPoint(ROSTER_VIEWER_DROP_TARGET_EPOINT);
            if (extensionPoint == null) {
                return;
            }
            IConfigurationElement[] configurationElements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < configurationElements.length) {
                try {
                    IRosterViewerDropTarget rosterDropTarget = (IRosterViewerDropTarget)configurationElements[i].createExecutableExtension(ROSTER_VIEWER_DROP_TARGET_CLASS_ATTR);
                    if (this.dropAdapter == null) {
                        this.dropAdapter = new RosterViewerDropAdapter(this.treeViewer, rosterDropTarget);
                        this.treeViewer.addDropSupport(7, dndTransferTypes, (DropTargetListener)this.dropAdapter);
                    } else {
                        this.dropAdapter.addRosterDropTarget(rosterDropTarget);
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.presence.ui", 4, Messages.MultiRosterView_ROSTER_VIEW_EXT_POINT_ERROR_MESSAGE, (Throwable)e));
                }
                ++i;
            }
        }
    }

    private void retrieveServices() {
        IPresenceService[] services = Activator.getDefault().getPresenceServices();
        int i = 0;
        while (i < services.length) {
            IContainer container;
            IPresenceService iPresenceService = services[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.ecf.core.IContainer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((container = (IContainer)iPresenceService.getAdapter((Class)clazz)) != null && container.getConnectedID() != null) {
                this.addContainer(container);
            }
            ++i;
        }
    }

    protected IChatRoomCommandListener createChatRoomCommandListener() {
        return null;
    }

    protected IChatRoomViewCloseListener createChatRoomViewCloseListener(final ID connectedID) {
        return new IChatRoomViewCloseListener(){

            public void chatRoomViewClosing() {
                MultiRosterView.this.chatRooms.remove(connectedID);
            }
        };
    }

    protected void joinChatRoom(IContainer container, IChatRoomInfo roomInfo, String password) throws ECFException {
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)roomInfo);
        ID connectedID = container.getConnectedID();
        if (connectedID == null) {
            throw new ECFException(Messages.MultiRosterView_EXCEPTION_JOIN_ROOM_NOT_CONNECTED);
        }
        if (this.findAccountForContainer(container) == null) {
            throw new ECFException(Messages.MultiRosterView_EXCEPTION_JOIN_ROOM_INVALID_ACCOUNT);
        }
        IWorkbenchWindow ww = this.getViewSite().getPage().getWorkbenchWindow();
        IWorkbenchPage wp = ww.getActivePage();
        RoomWithAView roomView = (RoomWithAView)this.chatRooms.get(connectedID);
        if (roomView != null) {
            ChatRoomManagerView chatroommanagerview = roomView.getView();
            wp.activate((IWorkbenchPart)chatroommanagerview);
            chatroommanagerview.joinRoom(roomInfo, password);
            return;
        }
        try {
            IViewReference ref = wp.findViewReference("org.eclipse.ecf.presence.ui.chatroom.ChatRoomManagerView", connectedID.getName());
            ChatRoomManagerView chatroommanagerview = (ChatRoomManagerView)(ref == null ? wp.showView("org.eclipse.ecf.presence.ui.chatroom.ChatRoomManagerView", connectedID.getName(), 1) : ref.getView(true));
            chatroommanagerview.initializeWithoutManager(ChatRoomManagerView.getUsernameFromID(connectedID), ChatRoomManagerView.getHostnameFromID(connectedID), this.createChatRoomCommandListener(), this.createChatRoomViewCloseListener(connectedID));
            chatroommanagerview.joinRoom(roomInfo, password);
            roomView = new RoomWithAView(chatroommanagerview, connectedID);
            this.chatRooms.put(roomView.getID(), roomView);
        }
        catch (Exception e1) {
            throw new ECFException((Throwable)e1);
        }
    }

    private void selectAndJoinChatRoomForAccounts(MultiRosterAccount[] accounts) {
        ChatRoomSelectionDialog dialog = new ChatRoomSelectionDialog(this.getViewSite().getShell(), accounts);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        IChatRoomInfo selectedInfo = dialog.getSelectedRoom().getRoomInfo();
        MultiRosterAccount account = dialog.getSelectedRoom().getAccount();
        IContainer container = account.getContainer();
        ID connectedID = container.getConnectedID();
        if (connectedID == null) {
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)Messages.MultiRosterView_NO_IDENTIFIER_FOR_ROOM_TITLE, (String)NLS.bind((String)Messages.MultiRosterView_NO_IDENTIFIER_FOR_ROOM_MESSAGE, (Object)selectedInfo.getRoomID()));
            return;
        }
        try {
            this.joinChatRoom(container, selectedInfo, null);
        }
        catch (ECFException e) {
            Throwable e1 = e.getStatus().getException();
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ecf.presence.ui", 4, Messages.MultiRosterView_EXCEPTION_LOG_JOIN_ROOM, e1));
            ContainerConnectErrorDialog ed = new ContainerConnectErrorDialog(this.getViewSite().getShell(), selectedInfo.getRoomID().getName(), e1);
            ed.open();
        }
    }

    private void makeActions() {
        this.imAction = new Action(){

            public void run() {
                MultiRosterView.this.message((IStructuredSelection)MultiRosterView.this.treeViewer.getSelection());
            }
        };
        this.imAction.setImageDescriptor(SharedImages.getImageDescriptor((String)"IMG_MESSAGE"));
        this.removeAction = new Action(){

            public void run() {
                IStructuredSelection iss = (IStructuredSelection)MultiRosterView.this.treeViewer.getSelection();
                MultiRosterView.this.remove((IRosterEntry)iss.getFirstElement());
            }
        };
        this.removeAction.setText(Messages.MultiRosterView_Remove);
        this.removeAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.setAvailableAction = new Action(Messages.MultiRosterView_SetAvailable, 8){

            public void run() {
                if (this.isChecked()) {
                    MultiRosterView.this.sendPresence(IPresence.Mode.AVAILABLE);
                }
            }
        };
        this.setAwayAction = new Action(Messages.MultiRosterView_SetAway, 8){

            public void run() {
                if (this.isChecked()) {
                    MultiRosterView.this.sendPresence(IPresence.Mode.AWAY);
                }
            }
        };
        this.setDNDAction = new Action(Messages.MultiRosterView_SetDoNotDisturb, 8){

            public void run() {
                if (this.isChecked()) {
                    MultiRosterView.this.sendPresence(IPresence.Mode.DND);
                }
            }
        };
        this.setInvisibleAction = new Action(Messages.MultiRosterView_SetInvisible, 8){

            public void run() {
                if (this.isChecked()) {
                    MultiRosterView.this.sendPresence(IPresence.Mode.INVISIBLE);
                }
            }
        };
        this.setOfflineAction = new Action(Messages.MultiRosterView_SetOffline, 8){

            public void run() {
                if (this.isChecked()) {
                    int i = 0;
                    while (i < MultiRosterView.this.rosterAccounts.size()) {
                        MultiRosterAccount account = (MultiRosterAccount)MultiRosterView.this.rosterAccounts.get(i);
                        MultiRosterView.this.treeViewer.remove((Object)account);
                        ++i;
                    }
                    MultiRosterView.this.rosterAccounts.clear();
                    MultiRosterView.this.refreshTreeViewer(null, false);
                    MultiRosterView.this.setStatusMenu.setVisible(false);
                    MultiRosterView.this.getViewSite().getActionBars().getMenuManager().update(false);
                }
            }
        };
        this.setOfflineAction.setChecked(true);
        this.showOfflineAction = new Action(Messages.MultiRosterView_ShowOffline, 2){

            public void run() {
                if (this.isChecked()) {
                    MultiRosterView.this.treeViewer.removeFilter(MultiRosterView.this.hideOfflineFilter);
                } else {
                    MultiRosterView.this.treeViewer.addFilter(MultiRosterView.this.hideOfflineFilter);
                }
            }
        };
        this.showEmptyGroupsAction = new Action(Messages.MultiRosterView_ShowEmptyGroups, 2){

            public void run() {
                if (this.isChecked()) {
                    MultiRosterView.this.treeViewer.removeFilter(MultiRosterView.this.hideEmptyGroupsFilter);
                } else {
                    MultiRosterView.this.treeViewer.addFilter(MultiRosterView.this.hideEmptyGroupsFilter);
                }
            }
        };
        this.addContactAction = new Action(Messages.MultiRosterView_AddContact, SharedImages.getImageDescriptor((String)"IMG_ADD_BUDDY")){

            public void run() {
                AddContactDialog dialog = new AddContactDialog(MultiRosterView.this.treeViewer.getControl().getShell());
                IStructuredSelection iss = (IStructuredSelection)MultiRosterView.this.treeViewer.getSelection();
                IRoster roster = (IRoster)iss.getFirstElement();
                MultiRosterAccount account = MultiRosterView.this.findAccountForUser(roster.getUser().getID());
                dialog.setInput(MultiRosterView.this.rosterAccounts);
                dialog.setDefaultRosterAccount(account);
                if (dialog.open() == 0) {
                    IPresenceContainerAdapter ipca = dialog.getSelection();
                    IRosterSubscriptionSender sender = ipca.getRosterManager().getRosterSubscriptionSender();
                    try {
                        sender.sendRosterAdd(dialog.getAccountID(), dialog.getAlias(), null);
                    }
                    catch (ECFException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                    }
                }
            }
        };
        this.openChatRoomAction = new Action(){

            public void run() {
                MultiRosterView.this.selectAndJoinChatRoomForAccounts(MultiRosterView.this.rosterAccounts.toArray(new MultiRosterAccount[0]));
            }
        };
        this.openChatRoomAction.setText(Messages.MultiRosterView_ENTER_CHATROOM_ACTION_TEXT);
        this.openChatRoomAction.setToolTipText(Messages.MultiRosterView_ENTER_CHATROOM_TOOLTIP_TEXT);
        this.openChatRoomAction.setImageDescriptor(SharedImages.getImageDescriptor((String)"IMG_ADD_CHAT"));
        this.openChatRoomAction.setEnabled(true);
        this.openAccountChatRoomAction = new Action(){

            public void run() {
                IStructuredSelection iss = (IStructuredSelection)MultiRosterView.this.treeViewer.getSelection();
                IRoster roster = (IRoster)iss.getFirstElement();
                MultiRosterAccount account = MultiRosterView.this.findAccountForUser(roster.getUser().getID());
                if (account != null) {
                    MultiRosterView.this.selectAndJoinChatRoomForAccounts(new MultiRosterAccount[]{account});
                }
            }
        };
        this.openAccountChatRoomAction.setText(Messages.MultiRosterView_SHOW_CHAT_ROOMS_FOR_ACCOUNT_ACTION_TEXT);
        this.openAccountChatRoomAction.setEnabled(true);
        this.openAccountChatRoomAction.setImageDescriptor(SharedImages.getImageDescriptor((String)"IMG_ADD_CHAT"));
        this.changePasswordAction = new Action(){

            public void run() {
                IStructuredSelection iss = (IStructuredSelection)MultiRosterView.this.treeViewer.getSelection();
                IRoster roster = (IRoster)iss.getFirstElement();
                MultiRosterAccount account = MultiRosterView.this.findAccountForUser(roster.getUser().getID());
                if (account != null) {
                    MultiRosterView.this.changePasswordForAccount(account);
                }
            }
        };
        this.changePasswordAction.setText(Messages.MultiRosterView_CHANGE_PASSWORD_MENU);
        this.changePasswordAction.setEnabled(true);
        this.disconnectAllAccountsAction = new Action(){

            public void run() {
                if (MessageDialog.openQuestion((Shell)MultiRosterView.this.getViewSite().getShell(), (String)Messages.MultiRosterView_DISCONNECT_QUESTION_TITLE, (String)Messages.MultiRosterView_DISCONNECT_ALL_ACCOUNTS_QUESTION_MESSAGE)) {
                    MultiRosterView.this.disconnectAccounts(MultiRosterView.this.rosterAccounts.toArray(new MultiRosterAccount[0]));
                }
            }
        };
        this.disconnectAllAccountsAction.setText(Messages.MultiRosterView_DISCONNECT_ALL_ACCOUNTS_ACTION_TEXT);
        this.disconnectAllAccountsAction.setEnabled(true);
        this.disconnectAllAccountsAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.disconnectAccountAction = new Action(){

            public void run() {
                IStructuredSelection iss = (IStructuredSelection)MultiRosterView.this.treeViewer.getSelection();
                IRoster roster = (IRoster)iss.getFirstElement();
                MultiRosterAccount account = MultiRosterView.this.findAccountForUser(roster.getUser().getID());
                ID connectedID = account.getContainer().getConnectedID();
                if (account != null && connectedID != null && MessageDialog.openQuestion((Shell)MultiRosterView.this.getViewSite().getShell(), (String)Messages.MultiRosterView_DISCONNECT_QUESTION_TITLE, (String)NLS.bind((String)Messages.MultiRosterView_DISCONNECT_ACCOUNT_QUESTION_MESSAGE, (Object)connectedID.getName()))) {
                    MultiRosterView.this.disconnectAccounts(new MultiRosterAccount[]{account});
                }
            }
        };
        this.disconnectAccountAction.setText(Messages.MultiRosterView_DISCONNECT_ACCOUNT_ACTION_TEXT);
        this.disconnectAccountAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    protected void changePasswordForAccount(MultiRosterAccount account) {
        ChangePasswordDialog cpd = new ChangePasswordDialog(this.getViewSite().getShell(), account.getRoster().getUser().getID().getName());
        cpd.open();
        if (cpd.getResult() == 0) {
            IPresenceContainerAdapter pc = account.getPresenceContainerAdapter();
            IAccountManager am = pc.getAccountManager();
            try {
                if (am.changePassword(cpd.getNewPassword())) {
                    MessageDialog.openInformation((Shell)this.getViewSite().getShell(), (String)Messages.MultiRosterView_PASSWORD_CHANGED_DIALOG_TITLE, (String)Messages.MultiRosterView_PASSWORD_CHANGED_MESSAGE);
                } else {
                    MessageDialog.openInformation((Shell)this.getViewSite().getShell(), (String)Messages.MultiRosterView_PASSWORD_NOT_CHANGED_TITLE, (String)Messages.MultiRosterView_PASSWORD_NOT_CHANGED_MESSAGE);
                }
            }
            catch (ECFException e) {
                MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)Messages.MultiRosterView_PASSWORD_NOT_CHANGED_TITLE, (String)Messages.MultiRosterView_PASSWORD_CHANGE_ERROR);
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    protected void disconnectAccounts(MultiRosterAccount[] accounts) {
        int i = 0;
        while (i < accounts.length) {
            accounts[i].getContainer().disconnect();
            ++i;
        }
    }

    private MultiRosterAccount findAccountForUser(ID userID) {
        Iterator i = this.rosterAccounts.iterator();
        while (i.hasNext()) {
            MultiRosterAccount account = (MultiRosterAccount)i.next();
            if (!account.getRoster().getUser().getID().equals((Object)userID)) continue;
            return account;
        }
        return null;
    }

    private void sendPresence(IPresence.Mode mode) {
        try {
            Iterator i = this.rosterAccounts.iterator();
            while (i.hasNext()) {
                MultiRosterAccount account = (MultiRosterAccount)i.next();
                account.getRosterManager().getPresenceSender().sendPresenceUpdate(null, (IPresence)new Presence(IPresence.Type.AVAILABLE, null, mode));
            }
        }
        catch (ECFException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MultiRosterView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection iss = (IStructuredSelection)this.treeViewer.getSelection();
        Object element = iss.getFirstElement();
        if (element instanceof IRosterEntry) {
            IRosterEntry entry = (IRosterEntry)element;
            manager.add(this.imAction);
            this.imAction.setText(Messages.MultiRosterView_SendIM);
            this.imAction.setEnabled(entry.getPresence().getType() == IPresence.Type.AVAILABLE);
            manager.add((IContributionItem)new Separator("additions"));
            manager.add(this.removeAction);
        } else if (element instanceof IRoster) {
            IAccountManager accountManager = ((IRoster)element).getPresenceContainerAdapter().getAccountManager();
            if (accountManager != null) {
                manager.add(this.changePasswordAction);
                manager.add((IContributionItem)new Separator());
            }
            manager.add(this.addContactAction);
            manager.add((IContributionItem)new Separator());
            manager.add(this.openAccountChatRoomAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new Separator("additions"));
            manager.add(this.disconnectAccountAction);
        } else {
            manager.add((IContributionItem)new Separator("additions"));
        }
    }

    private IRosterEntry find(Collection items, ID userID) {
        Iterator it = items.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item instanceof IRosterGroup) {
                IRosterEntry entry = this.find(((IRosterGroup)item).getEntries(), userID);
                if (entry == null) continue;
                return entry;
            }
            if (!userID.equals((Object)((IRosterEntry)item).getUser().getID())) continue;
            return (IRosterEntry)item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiRosterAccount findAccountForContainer(IContainer container) {
        if (container == null) {
            return null;
        }
        List list = this.rosterAccounts;
        synchronized (list) {
            Iterator i = this.rosterAccounts.iterator();
            while (i.hasNext()) {
                MultiRosterAccount account = (MultiRosterAccount)i.next();
                if (!account.getContainer().getID().equals((Object)container.getID())) continue;
                return account;
            }
        }
        return null;
    }

    private void remove(IRosterEntry entry) {
        try {
            IRoster roster = entry.getRoster();
            if (roster != null) {
                roster.getPresenceContainerAdapter().getRosterManager().getRosterSubscriptionSender().sendRosterRemove(entry.getUser().getID());
            }
        }
        catch (ECFException e) {
            MessageDialog.openError((Shell)this.getViewSite().getShell(), (String)Messages.MultiRosterView_ERROR_CONTACT_REMOVE_TITLE, (String)NLS.bind((String)Messages.MultiRosterView_ERROR_CONTACT_REMOVED_MESSAGE, (Object)entry.getUser().getID().getName()));
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    private void message(IStructuredSelection iss) {
        Object element = iss.getFirstElement();
        if (!(element instanceof IRosterEntry)) {
            return;
        }
        IRosterEntry entry = (IRosterEntry)element;
        IRoster roster = entry.getRoster();
        if (roster != null) {
            IChatManager manager = roster.getPresenceContainerAdapter().getChatManager();
            IChatMessageSender icms = manager.getChatMessageSender();
            ITypingMessageSender itms = manager.getTypingMessageSender();
            try {
                MessagesView view = (MessagesView)this.getSite().getWorkbenchWindow().getActivePage().showView("org.eclipse.ecf.presence.ui.MessagesView");
                view.selectTab(icms, itms, roster.getUser().getID(), entry.getUser().getID());
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
    }

    private void setLocalPullDownEnabled(boolean enabled) {
        this.setAvailableAction.setEnabled(enabled);
        this.setAwayAction.setEnabled(enabled);
        this.setDNDAction.setEnabled(enabled);
        this.setInvisibleAction.setEnabled(enabled);
        this.setOfflineAction.setEnabled(enabled);
        this.showOfflineAction.setEnabled(enabled);
        this.showEmptyGroupsAction.setEnabled(enabled);
        this.addContactAction.setEnabled(enabled);
        this.openChatRoomAction.setEnabled(enabled);
        this.disconnectAllAccountsAction.setEnabled(enabled);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        this.setStatusMenu = new MenuManager(Messages.MultiRosterView_SetStatusAs, null);
        this.setStatusMenu.add(this.setAvailableAction);
        this.setStatusMenu.add(this.setAwayAction);
        this.setStatusMenu.add(this.setDNDAction);
        this.setStatusMenu.add(this.setInvisibleAction);
        this.setStatusMenu.add(this.setOfflineAction);
        manager.add((IContributionItem)this.setStatusMenu);
        manager.add((IContributionItem)new Separator());
        manager.add(this.showOfflineAction);
        manager.add(this.showEmptyGroupsAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.addContactAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.openChatRoomAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.disconnectAllAccountsAction);
        this.setLocalPullDownEnabled(false);
    }

    public void dispose() {
        if (this.dropAdapter != null) {
            this.dropAdapter.dispose();
            this.dropAdapter = null;
        }
        this.treeViewer = null;
        Iterator i = this.rosterAccounts.iterator();
        while (i.hasNext()) {
            MultiRosterAccount account = (MultiRosterAccount)i.next();
            account.getRosterManager().removePresenceListener(this.presenceListener);
            account.dispose();
        }
        this.rosterAccounts.clear();
        super.dispose();
    }

    protected boolean containerPresent(IContainer container) {
        Iterator i = this.rosterAccounts.iterator();
        while (i.hasNext()) {
            MultiRosterAccount existingAccount = (MultiRosterAccount)i.next();
            if (!existingAccount.getContainer().getID().equals((Object)container.getID())) continue;
            return true;
        }
        return false;
    }

    protected boolean addRosterAccount(MultiRosterAccount account) {
        if (account == null) {
            return false;
        }
        boolean result = this.rosterAccounts.add(account);
        if (result) {
            this.setLocalPullDownEnabled(true);
        }
        return result;
    }

    protected void rosterAccountDisconnected(MultiRosterAccount disconnectedAccount) {
        this.removeRosterAccount(disconnectedAccount);
    }

    protected void removeRosterAccount(MultiRosterAccount account) {
        account.getRosterManager().removePresenceListener(this.presenceListener);
        if (this.treeViewer != null) {
            this.treeViewer.remove((Object)account.getRoster());
        }
        this.rosterAccounts.remove(account);
        if (this.rosterAccounts.size() == 0) {
            this.setLocalPullDownEnabled(false);
            if (!this.pageBook.isDisposed()) {
                this.pageBook.showPage((Control)this.helpMessageLabel);
            }
        }
        account.dispose();
        this.refreshTreeViewer(null, true);
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    protected void refreshTreeViewer(Object val, boolean labels) {
        Control c;
        if (this.treeViewer != null && (c = this.treeViewer.getControl()) != null && !c.isDisposed()) {
            if (val != null) {
                this.treeViewer.refresh(val, labels);
                ViewerFilter[] filters = this.treeViewer.getFilters();
                if (filters.length != 0) {
                    this.treeViewer.refresh(labels);
                }
            } else {
                this.treeViewer.refresh(labels);
            }
            this.treeViewer.expandToLevel(3);
        }
    }

    protected void addEntryToTreeViewer(IRosterEntry entry) {
        if (this.treeViewer != null) {
            this.treeViewer.add((Object)entry.getParent(), (Object)entry);
        }
    }

    protected void removeEntryFromTreeViewer(IRosterEntry entry) {
        if (this.treeViewer != null) {
            this.treeViewer.remove((Object)entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEntryFromTreeViewer(ID entryID) {
        List list = this.rosterAccounts;
        synchronized (list) {
            Iterator i = this.rosterAccounts.iterator();
            while (i.hasNext()) {
                MultiRosterAccount account = (MultiRosterAccount)i.next();
                IRosterEntry entry = this.find(account.getRoster().getItems(), entryID);
                if (entry == null) continue;
                this.treeViewer.remove((Object)entry);
            }
        }
    }

    public boolean addContainer(IContainer container) {
        IPresenceContainerAdapter containerAdapter;
        if (container == null) {
            return false;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ecf.presence.IPresenceContainerAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((containerAdapter = (IPresenceContainerAdapter)container.getAdapter((Class)clazz)) == null) {
            return false;
        }
        if (this.containerPresent(container)) {
            return false;
        }
        MultiRosterAccount account = new MultiRosterAccount(this, container, containerAdapter);
        if (!this.addRosterAccount(account)) {
            return false;
        }
        IRosterManager manager = containerAdapter.getRosterManager();
        try {
            if (this.setAvailableAction.isChecked() || this.setOfflineAction.isChecked()) {
                manager.getPresenceSender().sendPresenceUpdate(null, (IPresence)new Presence(null, null, IPresence.Mode.AVAILABLE));
                this.setOfflineAction.setChecked(false);
                this.setAvailableAction.setChecked(true);
            } else if (this.setAwayAction.isChecked()) {
                manager.getPresenceSender().sendPresenceUpdate(null, (IPresence)new Presence(null, null, IPresence.Mode.AWAY));
            } else if (this.setDNDAction.isChecked()) {
                manager.getPresenceSender().sendPresenceUpdate(null, (IPresence)new Presence(null, null, IPresence.Mode.DND));
            } else if (this.setInvisibleAction.isChecked()) {
                manager.getPresenceSender().sendPresenceUpdate(null, (IPresence)new Presence(null, null, IPresence.Mode.INVISIBLE));
            }
        }
        catch (ECFException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        containerAdapter.getRosterManager().addPresenceListener(this.presenceListener);
        this.setStatusMenu.setVisible(true);
        this.getViewSite().getActionBars().getMenuManager().update(true);
        this.treeViewer.add(this.treeViewer.getInput(), (Object)account.getRoster());
        this.pageBook.showPage(this.treeViewer.getControl());
        return true;
    }

    private class PresenceListener
    implements IPresenceListener {
        private PresenceListener() {
        }

        public void handlePresence(ID fromID, IPresence presence) {
        }
    }

    class RoomWithAView {
        ChatRoomManagerView view;
        ID secondaryID;

        RoomWithAView(ChatRoomManagerView view, ID secondaryID) {
            this.view = view;
            this.secondaryID = secondaryID;
        }

        public ChatRoomManagerView getView() {
            return this.view;
        }

        public ID getID() {
            return this.secondaryID;
        }
    }

    class RosterViewerDropAdapter
    extends ViewerDropAdapter {
        private List rosterDropTargets = new ArrayList();
        private List rosterPerformDrop = new ArrayList();

        public RosterViewerDropAdapter(TreeViewer treeViewer, IRosterViewerDropTarget dropTarget) {
            super((Viewer)treeViewer);
            Assert.isNotNull((Object)dropTarget);
            this.setFeedbackEnabled(false);
            this.addRosterDropTarget(dropTarget);
        }

        public boolean addRosterDropTarget(IRosterViewerDropTarget rosterDropTarget) {
            return this.rosterDropTargets.add(rosterDropTarget);
        }

        public boolean performDrop(Object data) {
            boolean result = false;
            Iterator i = this.rosterPerformDrop.iterator();
            while (i.hasNext()) {
                IRosterViewerDropTarget rdt = (IRosterViewerDropTarget)i.next();
                if (!rdt.performDrop(data)) continue;
                result = true;
            }
            this.rosterPerformDrop.clear();
            return result;
        }

        public void dispose() {
            this.rosterDropTargets.clear();
            this.rosterPerformDrop.clear();
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            if (target instanceof IRosterItem) {
                this.rosterPerformDrop.clear();
                boolean result = false;
                Iterator i = this.rosterDropTargets.iterator();
                while (i.hasNext()) {
                    IRosterViewerDropTarget rdt = (IRosterViewerDropTarget)i.next();
                    if (!rdt.validateDrop((IRosterItem)target, operation, transferType)) continue;
                    result = true;
                    this.rosterPerformDrop.add(rdt);
                }
                return result;
            }
            return false;
        }
    }

    private class ViewerToolTip
    extends ToolTip {
        private Image image;

        public ViewerToolTip(Control control) {
            super(control);
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            TreeItem item = MultiRosterView.this.treeViewer.getTree().getItem(new Point(event.x, event.y));
            IRosterEntry entry = (IRosterEntry)item.getData();
            FormToolkit toolkit = new FormToolkit(parent.getDisplay());
            FormColors colors = toolkit.getColors();
            Color top = colors.getColor("org.eclipse.ui.forms.H_GRADIENT_END");
            Color bot = colors.getColor("org.eclipse.ui.forms.H_GRADIENT_START");
            Form form = toolkit.createForm(parent);
            form.setText(entry.getName());
            form.setImage(SharedImages.getImage((String)"IMG_USER_AVAILABLE"));
            form.setTextBackground(new Color[]{top, bot}, new int[]{100}, true);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            form.getBody().setLayout((Layout)layout);
            FormText text = toolkit.createFormText(form.getBody(), true);
            GridData td = new GridData();
            td.horizontalSpan = 2;
            td.heightHint = 100;
            td.widthHint = 250;
            text.setLayoutData((Object)td);
            String buffer = this.getRosterEntryChildrenFromPresence(entry);
            text.setText(buffer, true, false);
            td = new GridData();
            td.horizontalSpan = 1;
            td.heightHint = 100;
            td.widthHint = 64;
            FormText formImage = toolkit.createFormText(form.getBody(), false);
            formImage.setText("<form><p><img href=\"image\"/></p></form>", true, false);
            formImage.setLayoutData((Object)td);
            byte[] data = entry.getPresence().getPictureData();
            if (data.length != 0) {
                Image originalImage = new Image((Device)parent.getDisplay(), (InputStream)new ByteArrayInputStream(data));
                this.image = this.resize(originalImage, 64, 64);
                formImage.setImage("image", this.image);
                originalImage.dispose();
            }
            return parent;
        }

        public void deactivate() {
            super.deactivate();
            if (this.image != null) {
                this.image.dispose();
            }
        }

        private Image resize(Image image1, int width, int height) {
            Image scaled = new Image((Device)Display.getDefault(), width, height);
            GC gc = new GC((Drawable)scaled);
            gc.setAntialias(1);
            gc.setInterpolation(2);
            gc.drawImage(image1, 0, 0, image1.getBounds().width, image1.getBounds().height, 0, 0, width, height);
            gc.dispose();
            return scaled;
        }

        private String getResourceName(ID id) {
            IFQID fqid;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ecf.presence.IFQID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((fqid = (IFQID)id.getAdapter((Class)clazz)) != null) {
                return fqid.getResourceName();
            }
            return null;
        }

        private String getRosterEntryChildrenFromPresence(IRosterEntry entry) {
            IPresence presence = entry.getPresence();
            Map properties = presence.getProperties();
            int fixedEntries = 4;
            String resourceName = this.getResourceName(entry.getUser().getID());
            StringBuffer buffer = new StringBuffer();
            buffer.append("<form>");
            buffer.append("<p>");
            buffer.append(NLS.bind((String)Messages.RosterWorkbenchAdapterFactory_Account, (Object)entry.getUser().getID().getName()));
            buffer.append("</p>");
            buffer.append("<p>");
            buffer.append(NLS.bind((String)Messages.RosterWorkbenchAdapterFactory_Type, (Object)presence.getType()));
            buffer.append("</p>");
            buffer.append("<p>");
            buffer.append(NLS.bind((String)Messages.RosterWorkbenchAdapterFactory_Mode, (Object)presence.getMode().toString()));
            buffer.append("</p>");
            buffer.append("<p>");
            buffer.append(NLS.bind((String)Messages.RosterWorkbenchAdapterFactory_Resource, (Object)(resourceName == null ? "" : resourceName)));
            buffer.append("</p>");
            Iterator i = properties.keySet().iterator();
            while (i.hasNext()) {
                buffer.append("<p>");
                Object key = i.next();
                buffer.append(key).append(": ").append(properties.get(key));
                buffer.append("</p>");
                ++fixedEntries;
            }
            buffer.append("</form>");
            return buffer.toString();
        }

        protected boolean shouldCreateToolTip(Event e) {
            if (super.shouldCreateToolTip(e)) {
                TreeItem item = MultiRosterView.this.treeViewer.getTree().getItem(new Point(e.x, e.y));
                return item != null && item.getData() instanceof IRosterEntry;
            }
            return false;
        }
    }
}

